/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.fxloader.jpms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.fx.osgi.fxloader.FXClassloaderConfigurator;
import org.eclipse.fx.osgi.fxloader.jpms.AddOpenExports;
import org.eclipse.fx.osgi.fxloader.jpms.AddReads;
import org.eclipse.fx.osgi.fxloader.jpms.ClassloaderWrapper;
import org.eclipse.fx.osgi.fxloader.jpms.ModuleLayerWrapper;
import org.eclipse.fx.osgi.fxloader.jpms.ModuleWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;

public class JavaModuleLayerModification {
    private final Set<AddReads> reads;
    private final Set<AddOpenExports> exports;
    private final Set<AddOpenExports> opens;
    private final Bundle[] bundles;

    public JavaModuleLayerModification(Bundle[] bundles, Set<AddReads> reads, Set<AddOpenExports> exports, Set<AddOpenExports> opens) {
        this.bundles = bundles;
        this.reads = reads;
        this.exports = exports;
        this.opens = opens;
    }

    public boolean isEmpty() {
        return this.reads.isEmpty() && this.exports.isEmpty() && this.opens.isEmpty();
    }

    public static JavaModuleLayerModification empty() {
        return new JavaModuleLayerModification(new Bundle[0], Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private static ModuleWrapper getUnnamedModule() {
        return new ClassloaderWrapper(JavaModuleLayerModification.class.getClassLoader()).getUnnamedModule();
    }

    private ModuleWrapper getBundleUnnamed(String value) {
        block5: {
            String nameVersion;
            int idx;
            block4: {
                if (!value.startsWith("BUNDLE(@")) break block4;
                String id = value.substring(8, value.length() - 1);
                long l = Long.parseLong(id);
                Bundle[] bundleArray = this.bundles;
                int n = this.bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle b = bundleArray[n2];
                    if (b.getBundleId() == l) {
                        return new ClassloaderWrapper(((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader()).getUnnamedModule();
                    }
                    ++n2;
                }
                break block5;
            }
            if (!value.startsWith("BUNDLE(") || (idx = (nameVersion = value.substring(7, value.length() - 1)).indexOf(64)) <= -1) break block5;
            String symbolicName = nameVersion.substring(0, idx);
            Version version = Version.parseVersion((String)nameVersion.substring(idx + 1));
            Bundle[] bundleArray = this.bundles;
            int n = this.bundles.length;
            int n3 = 0;
            while (n3 < n) {
                Bundle b = bundleArray[n3];
                if (b.getSymbolicName().equals(symbolicName) && version.equals((Object)b.getVersion())) {
                    return new ClassloaderWrapper(((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader()).getUnnamedModule();
                }
                ++n3;
            }
        }
        return null;
    }

    public void applyConfigurations(ModuleLayerWrapper.ControllerWrapper controller) {
        ModuleWrapper targetModule;
        ModuleWrapper sourceModule;
        HashMap<String, ModuleWrapper> map = new HashMap<String, ModuleWrapper>();
        for (AddOpenExports e : this.exports) {
            sourceModule = map.computeIfAbsent(e.source, n -> controller.layer().findModule((String)n).orElse(null));
            targetModule = null;
            targetModule = e.target.equals("ALL-UNNAMED") ? JavaModuleLayerModification.getUnnamedModule() : (e.target.startsWith("BUNDLE") ? this.getBundleUnnamed(e.target) : map.computeIfAbsent(e.target, n -> Stream.of(controller.layer(), ModuleLayerWrapper.boot()).map(l -> l.findModule((String)n).orElse(null)).findFirst().orElse(null)));
            if (sourceModule == null) {
                if (!FXClassloaderConfigurator.DEBUG) continue;
                System.err.println("JavaModuleLayerModification#applyConfigurations - Source module '" + e.source + "' is not dynamically loaded. Could not export '" + e.pn + "'.");
                continue;
            }
            if (targetModule == null) {
                if (!FXClassloaderConfigurator.DEBUG) continue;
                System.err.println("JavaModuleLayerModification#applyConfigurations - Target module '" + e.target + "' is not found. Could not export '" + e.pn + "'.");
                continue;
            }
            if (FXClassloaderConfigurator.DEBUG) {
                System.err.println("JavaModuleLayerModification#applyConfigurations - Exporting '" + e + "'");
            }
            controller.addExports(sourceModule, e.pn, targetModule);
        }
        for (AddOpenExports e : this.opens) {
            sourceModule = map.computeIfAbsent(e.source, n -> controller.layer().findModule((String)n).orElse(null));
            targetModule = null;
            targetModule = e.target.equals("ALL-UNNAMED") ? JavaModuleLayerModification.getUnnamedModule() : (e.target.startsWith("BUNDLE") ? this.getBundleUnnamed(e.target) : map.computeIfAbsent(e.target, n -> Stream.of(controller.layer(), ModuleLayerWrapper.boot()).map(l -> l.findModule((String)n).orElse(null)).findFirst().orElse(null)));
            if (sourceModule == null) {
                if (!FXClassloaderConfigurator.DEBUG) continue;
                System.err.println("JavaModuleLayerModification#applyConfigurations - Source module '" + e.source + "' is not dynamically loaded. Could not open '" + e.pn + "'.");
                continue;
            }
            if (targetModule == null) {
                if (!FXClassloaderConfigurator.DEBUG) continue;
                System.err.println("JavaModuleLayerModification#applyConfigurations - Target module '" + e.target + "' is not found. Could not open '" + e.pn + "'.");
                continue;
            }
            controller.addOpens(sourceModule, e.pn, targetModule);
        }
        for (AddReads r : this.reads) {
            sourceModule = map.computeIfAbsent(r.source, n -> controller.layer().findModule((String)n).orElse(null));
            targetModule = null;
            targetModule = r.target.equals("ALL-UNNAMED") ? JavaModuleLayerModification.getUnnamedModule() : (r.target.startsWith("BUNDLE") ? this.getBundleUnnamed(r.target) : map.computeIfAbsent(r.target, n -> Stream.of(controller.layer(), ModuleLayerWrapper.boot()).map(l -> l.findModule((String)n).orElse(null)).findFirst().orElse(null)));
            if (sourceModule == null) {
                if (!FXClassloaderConfigurator.DEBUG) continue;
                System.err.println("JavaModuleLayerModification#applyConfigurations - Source module '" + r.source + "' is not dynamically loaded. Could not add read edge.");
                continue;
            }
            if (targetModule == null) {
                if (!FXClassloaderConfigurator.DEBUG) continue;
                System.err.println("JavaModuleLayerModification#applyConfigurations - Target module '" + r.target + "' is not found. Could not add read edge.");
                continue;
            }
            controller.addReads(sourceModule, targetModule);
        }
    }
}

