/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.keybindings.generic;

import java.util.StringTokenizer;
import javafx.scene.input.KeyCode;
import org.eclipse.fx.ui.controls.JavaFXCompatUtil;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.eclipse.fx.ui.keybindings.KeyStroke;
import org.eclipse.fx.ui.keybindings.ParseException;
import org.eclipse.fx.ui.keybindings.Trigger;
import org.eclipse.fx.ui.keybindings.generic.TriggerImpl;
import org.eclipse.fx.ui.keybindings.generic.Util;
import org.eclipse.jdt.annotation.NonNull;

public class KeyStrokeImpl
extends TriggerImpl
implements KeyStroke {
    public static final String KEY_DELIMITER = "+";
    public static final String KEY_DELIMITERS = "+";
    public static final int NO_KEY = 0;
    private final int modifierKeys;
    private final int naturalKey;
    private final KeyLookup lookup;

    static final KeyStroke getInstance(KeyLookup lookup, String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("Cannot parse a null string");
        }
        int modifierKeys = 0;
        int naturalKey = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+", true);
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token == null) continue;
            if (i % 2 == 0) {
                KeyCode fxKeyCode;
                if (stringTokenizer.hasMoreTokens()) {
                    if ((token = token.toUpperCase()) != null) {
                        int modifierKey = lookup.formalModifierLookup(token);
                        if (modifierKey == 0) {
                            throw new ParseException("Cannot create key stroke with duplicate or non-existent modifier key: " + token);
                        }
                        modifierKeys |= modifierKey;
                    }
                } else if (token.length() == 1) {
                    naturalKey = token.charAt(0);
                } else if ((token = token.toUpperCase()) != null && (naturalKey = lookup.formalKeyLookup(token)) == 0 && (fxKeyCode = KeyCode.valueOf((String)token)) != null) {
                    naturalKey = JavaFXCompatUtil.getCode((KeyCode)fxKeyCode);
                }
            }
            ++i;
        }
        return new KeyStrokeImpl(lookup, modifierKeys, naturalKey);
    }

    static @NonNull KeyStrokeImpl getInstance(KeyLookup lookup, int modifierKeys, int naturalKey) {
        return new KeyStrokeImpl(lookup, modifierKeys, naturalKey);
    }

    private KeyStrokeImpl(KeyLookup lookup, int modifierKeys, int naturalKey) {
        this.modifierKeys = modifierKeys;
        this.naturalKey = naturalKey;
        this.lookup = lookup;
    }

    public final int compareTo(Trigger object) {
        KeyStrokeImpl keyStroke = (KeyStrokeImpl)object;
        int compareTo = Util.compare(this.modifierKeys, keyStroke.modifierKeys);
        if (compareTo == 0) {
            compareTo = Util.compare(this.naturalKey, keyStroke.naturalKey);
        }
        return compareTo;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof KeyStrokeImpl)) {
            return false;
        }
        KeyStrokeImpl keyStroke = (KeyStrokeImpl)object;
        if (this.modifierKeys != keyStroke.modifierKeys) {
            return false;
        }
        return this.naturalKey == keyStroke.naturalKey;
    }

    public boolean hasAltModifier() {
        return (this.modifierKeys & this.lookup.getAlt()) != 0;
    }

    public boolean hasCtrlModifier() {
        return (this.modifierKeys & this.lookup.getCtrl()) != 0;
    }

    public boolean hasShiftModifier() {
        return (this.modifierKeys & this.lookup.getShift()) != 0;
    }

    public boolean hasCommandModifier() {
        return (this.modifierKeys & this.lookup.getCommand()) != 0;
    }

    @Override
    public final int hashCode() {
        return this.modifierKeys << 4 + this.naturalKey;
    }

    public int getKeyCode() {
        return this.naturalKey;
    }

    public String toString() {
        return "Modifiers: " + this.modifierKeys + "; NatKey: " + this.naturalKey;
    }
}

