/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.reflect;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;
import org.eclipse.xtext.common.types.access.reflect.ReflectURIHelper;
import org.eclipse.xtext.common.types.impl.JvmTypeConstraintImplCustom;
import org.eclipse.xtext.util.internal.Stopwatches;

public class ReflectionTypeFactory
implements ITypeFactory<Class<?>, JvmDeclaredType> {
    private static final Logger log = Logger.getLogger(ReflectionTypeFactory.class);
    private final ReflectURIHelper uriHelper;
    private final Stopwatches.StoppedTask createTypeTask = Stopwatches.forTask((String)"ReflectionTypeFactory.createType");
    private final Map<Type, JvmType> typeProxies = new HashMap<Type, JvmType>();
    private final Map<Method, JvmOperation> operationProxies = new HashMap<Method, JvmOperation>();
    private final Map<Class<? extends Annotation>, JvmAnnotationType> annotationProxies = new HashMap<Class<? extends Annotation>, JvmAnnotationType>();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @Inject
    public ReflectionTypeFactory(ReflectURIHelper uriHelper) {
        this.uriHelper = uriHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JvmDeclaredType createType(Class<?> clazz) {
        try {
            this.createTypeTask.start();
            if (clazz.isAnonymousClass() || clazz.isSynthetic()) {
                throw new IllegalStateException("Cannot create type for anonymous or synthetic classes");
            }
            if (clazz.isAnnotation()) {
                JvmAnnotationType jvmAnnotationType = this.createAnnotationType(clazz);
                return jvmAnnotationType;
            }
            if (clazz.isEnum()) {
                JvmEnumerationType jvmEnumerationType = this.createEnumerationType(clazz);
                return jvmEnumerationType;
            }
            JvmGenericType result = TypesFactory.eINSTANCE.createJvmGenericType();
            result.setInterface(clazz.isInterface());
            result.setStrictFloatingPoint(Modifier.isStrict(clazz.getModifiers()));
            this.setTypeModifiers(clazz, result);
            this.setVisibility(clazz, result);
            result.internalSetIdentifier(clazz.getName());
            result.setSimpleName(clazz.getSimpleName());
            if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
                result.setPackageName(clazz.getPackage().getName());
            }
            this.createNestedTypes(clazz, result);
            this.createMethods(clazz, result);
            this.createConstructors(clazz, result);
            this.createFields(clazz, result);
            this.setSuperTypes(clazz, result);
            try {
                TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
                if (typeParameters.length != 0) {
                    InternalEList jvmTypeParameters = (InternalEList)result.getTypeParameters();
                    for (TypeVariable<Class<?>> variable : typeParameters) {
                        jvmTypeParameters.addUnique((Object)this.createTypeParameter(variable, result));
                    }
                }
            }
            catch (GenericSignatureFormatError error) {
                this.logSignatureFormatError(clazz);
            }
            catch (MalformedParameterizedTypeException error) {
                this.logSignatureFormatError(clazz);
            }
            this.createAnnotationValues(clazz, result);
            JvmGenericType jvmGenericType = result;
            return jvmGenericType;
        }
        finally {
            this.createTypeTask.stop();
        }
    }

    protected void logSignatureFormatError(Class<?> clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalid class file for: " + clazz.getCanonicalName()));
        }
    }

    private void logNoClassDefFoundError(NoClassDefFoundError error, Class<?> clazz, String description) {
        log.error((Object)("Incomplete " + description + " for " + clazz.getCanonicalName() + ": " + error));
        if (log.isDebugEnabled()) {
            log.debug((Object)error.getMessage(), (Throwable)error);
        }
    }

    protected void createAnnotationValues(AnnotatedElement annotated, JvmAnnotationTarget result) {
        Annotation[] declaredAnnotations = annotated.getDeclaredAnnotations();
        if (declaredAnnotations.length != 0) {
            InternalEList annotations = (InternalEList)result.getAnnotations();
            for (Annotation annotation : declaredAnnotations) {
                annotations.addUnique((Object)this.createAnnotationReference(annotation));
            }
        }
    }

    protected JvmAnnotationReference createAnnotationReference(Annotation annotation) {
        JvmAnnotationReference annotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        Class<? extends Annotation> type = annotation.annotationType();
        annotationReference.setAnnotation(this.createAnnotationProxy(type));
        Method[] declaredMethods = type.getDeclaredMethods();
        if (declaredMethods.length > 0) {
            InternalEList values = (InternalEList)annotationReference.getExplicitValues();
            for (Method method : declaredMethods) {
                try {
                    JvmAnnotationValue annotationValue;
                    Object value = method.invoke((Object)annotation, EMPTY_ARRAY);
                    Class<?> returnType = method.getReturnType();
                    if (returnType.isArray()) {
                        annotationValue = this.createArrayAnnotationValue(value, returnType);
                        values.addUnique((Object)annotationValue);
                        annotationValue.setOperation(this.createMethodProxy(method));
                        continue;
                    }
                    annotationValue = this.createAnnotationValue(value, returnType);
                    values.addUnique((Object)annotationValue);
                    annotationValue.setOperation(this.createMethodProxy(method));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return annotationReference;
    }

    protected JvmEnumerationLiteral createEnumLiteralProxy(Enum<?> e) {
        JvmEnumerationLiteral enumLiteralProxy = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        InternalEObject internalEObject = (InternalEObject)enumLiteralProxy;
        Class<?> type = e.getDeclaringClass();
        try {
            Field field = type.getDeclaredField(e.name());
            internalEObject.eSetProxyURI(this.uriHelper.getFullURI(field));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
        return enumLiteralProxy;
    }

    protected JvmAnnotationValue createArrayAnnotationValue(Object value, Class<?> type) {
        EStructuralFeature.Setting result;
        block5: {
            InternalEList values;
            int length;
            Class<?> componentType;
            block8: {
                block7: {
                    block6: {
                        if (!type.isArray()) {
                            throw new IllegalArgumentException("type is not an array type: " + type.getCanonicalName());
                        }
                        componentType = type.getComponentType();
                        result = this.createAnnotationValue(componentType);
                        length = Array.getLength(value);
                        if (length <= 0) break block5;
                        values = (InternalEList)result;
                        if (!componentType.isPrimitive() && String.class != componentType) break block6;
                        for (int i = 0; i < length; ++i) {
                            values.addUnique(Array.get(value, i));
                        }
                        break block5;
                    }
                    if (componentType != Class.class) break block7;
                    for (int i = 0; i < length; ++i) {
                        Class referencedClass = (Class)Array.get(value, i);
                        values.addUnique((Object)this.createTypeReference(referencedClass));
                    }
                    break block5;
                }
                if (!componentType.isAnnotation()) break block8;
                for (int i = 0; i < length; ++i) {
                    Annotation nestedAnnotation = (Annotation)Array.get(value, i);
                    values.addUnique((Object)this.createAnnotationReference(nestedAnnotation));
                }
                break block5;
            }
            if (!componentType.isEnum()) break block5;
            for (int i = 0; i < length; ++i) {
                Enum e = (Enum)Array.get(value, i);
                values.addUnique((Object)this.createEnumLiteralProxy(e));
            }
        }
        return (JvmAnnotationValue)result.getEObject();
    }

    protected JvmAnnotationValue createAnnotationValue(Object value, Class<?> type) {
        EStructuralFeature.Setting result = this.createAnnotationValue(type);
        InternalEList values = (InternalEList)result;
        if (type.isPrimitive() || String.class == type) {
            values.addUnique(value);
        } else if (type == Class.class) {
            Class referencedClass = (Class)value;
            JvmTypeReference reference = this.createTypeReference(referencedClass);
            values.addUnique((Object)reference);
        } else if (type.isAnnotation()) {
            Annotation nestedAnnotation = (Annotation)value;
            values.addUnique((Object)this.createAnnotationReference(nestedAnnotation));
        } else if (type.isEnum()) {
            Enum e = (Enum)value;
            JvmEnumerationLiteral proxy = this.createEnumLiteralProxy(e);
            values.addUnique((Object)proxy);
        }
        return (JvmAnnotationValue)result.getEObject();
    }

    protected EStructuralFeature.Setting createAnnotationValue(Class<?> type) {
        if (String.class == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmStringAnnotationValue().getValues();
        }
        if (Class.class == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmTypeAnnotationValue().getValues();
        }
        if (Boolean.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue().getValues();
        }
        if (Integer.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmIntAnnotationValue().getValues();
        }
        if (type.isAnnotation()) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue().getValues();
        }
        if (type.isEnum()) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmEnumAnnotationValue().getValues();
        }
        if (Long.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmLongAnnotationValue().getValues();
        }
        if (Short.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmShortAnnotationValue().getValues();
        }
        if (Float.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmFloatAnnotationValue().getValues();
        }
        if (Double.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue().getValues();
        }
        if (Character.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmCharAnnotationValue().getValues();
        }
        if (Byte.TYPE == type) {
            return (EStructuralFeature.Setting)TypesFactory.eINSTANCE.createJvmByteAnnotationValue().getValues();
        }
        throw new IllegalArgumentException("Unexpected type: " + type.getCanonicalName());
    }

    protected JvmAnnotationType createAnnotationProxy(Class<? extends Annotation> type) {
        JvmAnnotationType proxy = this.annotationProxies.get(type);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmAnnotationType();
            URI uri = this.uriHelper.getFullURI(type);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.annotationProxies.put(type, proxy);
        }
        return proxy;
    }

    protected JvmOperation createMethodProxy(Method method) {
        JvmOperation proxy = this.operationProxies.get(method);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmOperation();
            URI uri = this.uriHelper.getFullURI(method);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.operationProxies.put(method, proxy);
        }
        return proxy;
    }

    protected void setTypeModifiers(Class<?> clazz, JvmDeclaredType result) {
        int modifiers = clazz.getModifiers();
        result.setAbstract(Modifier.isAbstract(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        if (!(result instanceof JvmEnumerationType)) {
            result.setFinal(Modifier.isFinal(modifiers));
        }
    }

    protected void createNestedTypes(Class<?> clazz, JvmDeclaredType result) {
        try {
            Class<?>[] declaredClasses = clazz.getDeclaredClasses();
            if (declaredClasses.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                for (Class<?> declaredClass : declaredClasses) {
                    if (declaredClass.isAnonymousClass() || declaredClass.isSynthetic()) continue;
                    members.addUnique((Object)this.createType(declaredClass));
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "nested types");
        }
    }

    protected JvmAnnotationType createAnnotationType(Class<?> clazz) {
        JvmAnnotationType result = TypesFactory.eINSTANCE.createJvmAnnotationType();
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.setVisibility(clazz, result);
        this.setTypeModifiers(clazz, result);
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.setSuperTypes(clazz, result);
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void setSuperTypes(Class<?> clazz, JvmDeclaredType result) {
        InternalEList superTypes = (InternalEList)result.getSuperTypes();
        Class<?> superclass = null;
        try {
            superclass = clazz.getGenericSuperclass();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(clazz);
            superclass = clazz.getSuperclass();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(clazz);
            superclass = clazz.getSuperclass();
        }
        if (superclass != null) {
            superTypes.addUnique((Object)this.createTypeReference(superclass));
        }
        Type[] interfaces = null;
        try {
            interfaces = clazz.getGenericInterfaces();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(clazz);
            interfaces = clazz.getInterfaces();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(clazz);
            interfaces = clazz.getInterfaces();
        }
        for (Type type : interfaces) {
            superTypes.addUnique((Object)this.createTypeReference(type));
        }
        if (superTypes.isEmpty() && Object.class != clazz) {
            superTypes.addUnique((Object)this.createTypeReference((Type)((Object)Object.class)));
        }
    }

    protected void createFields(Class<?> clazz, JvmDeclaredType result) {
        try {
            Field[] declaredFields = clazz.getDeclaredFields();
            if (declaredFields.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                for (Field field : declaredFields) {
                    if (field.isSynthetic()) continue;
                    members.addUnique((Object)this.createField(field));
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "fields");
        }
    }

    protected void createConstructors(Class<?> clazz, JvmDeclaredType result) {
        try {
            Constructor<?>[] declaredConstructors = clazz.getDeclaredConstructors();
            if (declaredConstructors.length != 0) {
                InternalEList members = (InternalEList)result.getMembers();
                for (Constructor<?> constructor : declaredConstructors) {
                    if (constructor.isSynthetic()) continue;
                    members.addUnique((Object)this.createConstructor(constructor));
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "constructors");
        }
    }

    protected void createMethods(Class<?> clazz, JvmDeclaredType result) {
        try {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            if (declaredMethods.length != 0) {
                boolean intf = clazz.isInterface() && !clazz.isAnnotation();
                InternalEList members = (InternalEList)result.getMembers();
                for (Method method : declaredMethods) {
                    if (method.isSynthetic()) continue;
                    JvmOperation operation = this.createOperation(method);
                    if (clazz.isAnnotation()) {
                        this.setDefaultValue(operation, method);
                    } else if (intf && !operation.isAbstract() && !operation.isStatic()) {
                        operation.setDefault(true);
                    }
                    members.addUnique((Object)operation);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            this.logNoClassDefFoundError(e, clazz, "methods");
        }
    }

    private void setDefaultValue(JvmOperation operation, Method method) {
        Object defaultValue = method.getDefaultValue();
        if (defaultValue != null) {
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                JvmAnnotationValue annotationValue = this.createArrayAnnotationValue(defaultValue, returnType);
                operation.setDefaultValue(annotationValue);
                annotationValue.setOperation(operation);
            } else {
                JvmAnnotationValue annotationValue = this.createAnnotationValue(defaultValue, returnType);
                operation.setDefaultValue(annotationValue);
                annotationValue.setOperation(operation);
            }
        }
    }

    protected JvmEnumerationType createEnumerationType(Class<?> clazz) {
        JvmEnumerationType result = TypesFactory.eINSTANCE.createJvmEnumerationType();
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.setVisibility(clazz, result);
        this.setTypeModifiers(clazz, result);
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.createFields(clazz, result);
        this.createConstructors(clazz, result);
        this.setSuperTypes(clazz, result);
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void setVisibility(Class<?> clazz, JvmMember result) {
        if (Modifier.isPrivate(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PUBLIC);
        }
    }

    protected JvmTypeParameter createTypeParameter(TypeVariable<?> variable, JvmMember container) {
        JvmTypeParameter result = TypesFactory.eINSTANCE.createJvmTypeParameter();
        result.setName(variable.getName());
        Type[] bounds = variable.getBounds();
        if (bounds.length != 0) {
            InternalEList constraints = (InternalEList)result.getConstraints();
            for (Type bound : variable.getBounds()) {
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                ((JvmTypeConstraintImplCustom)((Object)upperBound)).internalSetTypeReference(this.createTypeReference(bound));
                constraints.addUnique((Object)upperBound);
            }
        }
        return result;
    }

    protected JvmTypeReference createTypeReference(Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            return this.createArrayTypeReference(componentType);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType instanceof ParameterizedType) {
                JvmTypeReference ownerTypeReference = this.createTypeReference(ownerType);
                if (ownerTypeReference instanceof JvmParameterizedTypeReference) {
                    JvmInnerTypeReference result = TypesFactory.eINSTANCE.createJvmInnerTypeReference();
                    result.setOuter((JvmParameterizedTypeReference)ownerTypeReference);
                    return this.enhanceTypeReference(parameterizedType, result);
                }
                JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
                return this.enhanceTypeReference(parameterizedType, result);
            }
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            return this.enhanceTypeReference(parameterizedType, result);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class arrayType = (Class)type;
            Class<?> componentType = arrayType.getComponentType();
            return this.createArrayTypeReference(componentType);
        }
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(this.createProxy(type));
        return result;
    }

    private JvmTypeReference enhanceTypeReference(ParameterizedType parameterizedType, JvmParameterizedTypeReference result) {
        result.setType(this.createProxy(parameterizedType.getRawType()));
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 0) {
            InternalEList arguments = (InternalEList)result.getArguments();
            for (Type actualTypeArgument : actualTypeArguments) {
                JvmTypeReference argument = this.createTypeArgument(actualTypeArgument);
                arguments.addUnique((Object)argument);
            }
        }
        return result;
    }

    protected JvmTypeReference createArrayTypeReference(Type componentType) {
        JvmTypeReference componentTypeReference = this.createTypeReference(componentType);
        JvmGenericArrayTypeReference result = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
        result.setComponentType(componentTypeReference);
        return result;
    }

    protected JvmTypeReference createTypeArgument(Type actualTypeArgument) {
        if (actualTypeArgument instanceof WildcardType) {
            Type[] lowerBounds;
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            JvmWildcardTypeReference result = TypesFactory.eINSTANCE.createJvmWildcardTypeReference();
            InternalEList constraints = (InternalEList)result.getConstraints();
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length != 0) {
                for (Type boundType : upperBounds) {
                    JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                    JvmTypeReference upperBoundType = this.createTypeReference(boundType);
                    ((JvmTypeConstraintImplCustom)((Object)upperBound)).internalSetTypeReference(upperBoundType);
                    constraints.addUnique((Object)upperBound);
                }
            }
            if ((lowerBounds = wildcardType.getLowerBounds()).length != 0) {
                for (Type boundType : lowerBounds) {
                    JvmLowerBound lowerBound = TypesFactory.eINSTANCE.createJvmLowerBound();
                    JvmTypeReference lowerBoundType = this.createTypeReference(boundType);
                    ((JvmTypeConstraintImplCustom)((Object)lowerBound)).internalSetTypeReference(lowerBoundType);
                    constraints.addUnique((Object)lowerBound);
                }
            }
            return result;
        }
        JvmTypeReference result = this.createTypeReference(actualTypeArgument);
        return result;
    }

    protected JvmType createProxy(Type type) {
        JvmType proxy = this.typeProxies.get(type);
        if (proxy == null) {
            proxy = TypesFactory.eINSTANCE.createJvmVoid();
            URI uri = this.uriHelper.getFullURI(type);
            ((InternalEObject)proxy).eSetProxyURI(uri);
            this.typeProxies.put(type, proxy);
        }
        return proxy;
    }

    protected JvmField createField(Field field) {
        int modifiers = field.getModifiers();
        JvmField result = !field.isEnumConstant() ? TypesFactory.eINSTANCE.createJvmField() : TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        String fieldName = field.getName();
        result.internalSetIdentifier(field.getDeclaringClass().getName() + "." + fieldName);
        result.setSimpleName(fieldName);
        result.setFinal(Modifier.isFinal(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        result.setTransient(Modifier.isTransient(modifiers));
        result.setVolatile(Modifier.isVolatile(modifiers));
        this.setVisibility(result, modifiers);
        Class<?> fieldType = null;
        try {
            fieldType = field.getGenericType();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(field.getDeclaringClass());
            fieldType = field.getType();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(field.getDeclaringClass());
            fieldType = field.getType();
        }
        result.setType(this.createTypeReference(fieldType));
        this.createAnnotationValues(field, result);
        return result;
    }

    protected JvmConstructor createConstructor(Constructor<?> constructor) {
        Type[] exceptionTypes;
        JvmConstructor result = TypesFactory.eINSTANCE.createJvmConstructor();
        Class<?> declaringClass = constructor.getDeclaringClass();
        int offset = 0;
        if (declaringClass.isEnum()) {
            offset = 2;
        } else if (declaringClass.isMemberClass() && !Modifier.isStatic(declaringClass.getModifiers())) {
            offset = 1;
        }
        Type[] genericParameterTypes = null;
        try {
            genericParameterTypes = constructor.getGenericParameterTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(declaringClass);
            genericParameterTypes = constructor.getParameterTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(declaringClass);
            genericParameterTypes = constructor.getParameterTypes();
        }
        if (offset != 0 && constructor.getParameterTypes().length != genericParameterTypes.length) {
            offset = 0;
        }
        this.enhanceGenericDeclaration(result, constructor);
        this.enhanceExecutable(result, (Member & GenericDeclaration)constructor, declaringClass.getSimpleName(), genericParameterTypes, constructor.getParameterAnnotations(), offset);
        result.setVarArgs(constructor.isVarArgs());
        try {
            exceptionTypes = constructor.getGenericExceptionTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(declaringClass);
            exceptionTypes = constructor.getExceptionTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(declaringClass);
            exceptionTypes = constructor.getExceptionTypes();
        }
        if (exceptionTypes.length != 0) {
            InternalEList exceptions = (InternalEList)result.getExceptions();
            for (Type exceptionType : exceptionTypes) {
                exceptions.addUnique((Object)this.createTypeReference(exceptionType));
            }
        }
        this.createAnnotationValues(constructor, result);
        return result;
    }

    protected void setVisibility(JvmMember result, int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected(modifiers)) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic(modifiers)) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(JvmVisibility.DEFAULT);
        }
    }

    protected <T extends Member & GenericDeclaration> void enhanceExecutable(JvmExecutable result, T member, String simpleName, Type[] parameterTypes, Annotation[][] annotations, int offset) {
        StringBuilder fqName = new StringBuilder(48);
        fqName.append(member.getDeclaringClass().getName());
        fqName.append('.');
        fqName.append(simpleName);
        fqName.append('(');
        InternalEList parameters = (InternalEList)result.getParameters();
        int typeIdx = offset;
        int annotationIdx = annotations.length - parameterTypes.length + offset;
        while (typeIdx < parameterTypes.length) {
            if (typeIdx != offset) {
                fqName.append(',');
            }
            Type parameterType = parameterTypes[typeIdx];
            this.uriHelper.computeTypeName(parameterType, fqName);
            parameters.addUnique((Object)this.createFormalParameter(parameterType, "arg" + (typeIdx - offset), result, member, annotations[annotationIdx]));
            ++typeIdx;
            ++annotationIdx;
        }
        fqName.append(')');
        result.internalSetIdentifier(fqName.toString());
        result.setSimpleName(simpleName);
        this.setVisibility(result, member.getModifiers());
    }

    protected void enhanceGenericDeclaration(JvmExecutable result, GenericDeclaration declaration) {
        TypeVariable<?>[] typeParameters = declaration.getTypeParameters();
        if (typeParameters.length != 0) {
            InternalEList jvmTypeParameters = (InternalEList)result.getTypeParameters();
            for (TypeVariable<?> variable : typeParameters) {
                jvmTypeParameters.addUnique((Object)this.createTypeParameter(variable, result));
            }
        }
    }

    protected JvmOperation createOperation(Method method) {
        Type[] exceptionTypes;
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        Type[] genericParameterTypes = null;
        try {
            genericParameterTypes = method.getGenericParameterTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            genericParameterTypes = method.getParameterTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            genericParameterTypes = method.getParameterTypes();
        }
        this.enhanceGenericDeclaration(result, method);
        this.enhanceExecutable(result, method, method.getName(), genericParameterTypes, method.getParameterAnnotations(), 0);
        result.setVarArgs(method.isVarArgs());
        int modifiers = method.getModifiers();
        result.setAbstract(Modifier.isAbstract(modifiers));
        result.setFinal(Modifier.isFinal(modifiers));
        result.setStatic(Modifier.isStatic(modifiers));
        result.setSynchronized(Modifier.isSynchronized(modifiers));
        result.setStrictFloatingPoint(Modifier.isStrict(modifiers));
        result.setNative(Modifier.isNative(modifiers));
        Class<?> returnType = null;
        try {
            returnType = method.getGenericReturnType();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            returnType = method.getReturnType();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            returnType = method.getReturnType();
        }
        result.setReturnType(this.createTypeReference(returnType));
        try {
            exceptionTypes = method.getGenericExceptionTypes();
        }
        catch (GenericSignatureFormatError error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            exceptionTypes = method.getExceptionTypes();
        }
        catch (MalformedParameterizedTypeException error) {
            this.logSignatureFormatError(method.getDeclaringClass());
            exceptionTypes = method.getExceptionTypes();
        }
        if (exceptionTypes.length != 0) {
            InternalEList exceptions = (InternalEList)result.getExceptions();
            for (Type exceptionType : exceptionTypes) {
                exceptions.addUnique((Object)this.createTypeReference(exceptionType));
            }
        }
        this.createAnnotationValues(method, result);
        return result;
    }

    protected JvmFormalParameter createFormalParameter(Type parameterType, String paramName, JvmMember container, GenericDeclaration member, Annotation[] annotations) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        result.setName(paramName);
        if (this.isLocal(parameterType, member)) {
            result.setParameterType(this.createLocalTypeReference(parameterType, (JvmTypeParameterDeclarator)((Object)container), member));
        } else {
            result.setParameterType(this.createTypeReference(parameterType));
        }
        if (annotations.length != 0) {
            InternalEList annotationsReferences = (InternalEList)result.getAnnotations();
            for (Annotation annotation : annotations) {
                annotationsReferences.addUnique((Object)this.createAnnotationReference(annotation));
            }
        }
        return result;
    }

    protected JvmTypeReference createLocalTypeReference(Type type, JvmTypeParameterDeclarator container, GenericDeclaration member) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            return this.createLocalArrayTypeReference(componentType, container, member);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            int idx = Arrays.asList(member.getTypeParameters()).indexOf(typeVariable);
            result.setType((JvmType)container.getTypeParameters().get(idx));
            return result;
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected JvmTypeReference createLocalArrayTypeReference(Type componentType, JvmTypeParameterDeclarator container, GenericDeclaration member) {
        JvmTypeReference componentTypeReference = this.createLocalTypeReference(componentType, container, member);
        JvmGenericArrayTypeReference result = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
        result.setComponentType(componentTypeReference);
        return result;
    }

    protected boolean isLocal(Type parameterType, GenericDeclaration member) {
        if (parameterType instanceof TypeVariable) {
            return member.equals(((TypeVariable)parameterType).getGenericDeclaration());
        }
        if (parameterType instanceof GenericArrayType) {
            return this.isLocal(((GenericArrayType)parameterType).getGenericComponentType(), member);
        }
        return false;
    }

    protected ReflectURIHelper getUriHelper() {
        return this.uriHelper;
    }
}

