/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.perspective;

import jakarta.inject.Named;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.services.dialog.LightWeightDialogService;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.perspective.LwPerspectiveSwitcherDialog;
import org.eclipse.fx.ui.workbench.fx.perspective.PerspectiveSwitcherDialog;

public class SwitchPerspectiveDialogHandler {
    @Execute
    public void switchPerspective(LightWeightDialogService dialogService, @Named(value="activeShell") Stage fxWindow, MWindow window, EModelService modelService, GraphicsLoader graphicsLoader, EPartService partService) {
        if (window.getTags().contains("efx-lightweight-dialogs")) {
            LwPerspectiveSwitcherDialog dialog = new LwPerspectiveSwitcherDialog(window, modelService, graphicsLoader, partService){
                {
                    this.setPrefSize(400.0, 400.0);
                }
            };
            dialogService.openDialog((Node)dialog, LightWeightDialogService.ModalityScope.WINDOW);
        } else {
            PerspectiveSwitcherDialog dialog = new PerspectiveSwitcherDialog((Window)fxWindow, window, modelService, graphicsLoader, partService){

                protected Point2D getInitialSize(Parent rootContainer) {
                    return new Point2D(400.0, 400.0);
                }
            };
            dialog.open();
        }
    }
}

