/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.databinding.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.DelegatingValueProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.fx.core.databinding.IJFXBeanValueProperty;
import org.eclipse.fx.core.databinding.JFXBeanProperties;
import org.eclipse.fx.core.databinding.internal.FXBeanPropertyHelper;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AnonymousFXBeanValueProperty
extends DelegatingValueProperty {
    private final @NonNull String propertyName;
    private @NonNull Map<Class<?>, IValueProperty> delegates;

    public AnonymousFXBeanValueProperty(@NonNull String propertyName, @Nullable Class<?> valueType) {
        super(valueType);
        this.propertyName = propertyName;
        this.delegates = new HashMap();
    }

    protected @Nullable IValueProperty doGetDelegate(Object source) {
        return this.getClassDelegate(source.getClass());
    }

    private IValueProperty getClassDelegate(Class<?> beanClass) {
        IJFXBeanValueProperty delegate;
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = JFXBeanProperties.value(beanClass, this.propertyName, (Class)this.getValueType());
        }
        catch (IllegalArgumentException noSuchProperty) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public IObservableValue observeDetail(IObservableValue master) {
        Object valueType = this.getValueType();
        if (valueType == null) {
            valueType = this.inferValueType(master.getValueType());
        }
        return MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)this.valueFactory(master.getRealm()), (Object)valueType);
    }

    private Object inferValueType(Object masterObservableValueType) {
        if (masterObservableValueType instanceof Class) {
            return this.getClassDelegate((Class)masterObservableValueType).getValueType();
        }
        return null;
    }

    public String toString() {
        String s = "?." + this.propertyName;
        Class valueType = (Class)this.getValueType();
        if (valueType != null) {
            s = s + "<" + FXBeanPropertyHelper.shortClassName(valueType) + ">";
        }
        return s;
    }
}

