/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;

public class NativePackageExtractionApplication
implements IApplication {
    private static final String PROP_LAUNCHER_NAME = "launcherName";
    private static final String PROP_ARCH = "arch";
    private static final String PROP_DEPENDS = "depends";
    private static final String DEFAULT_VERSION_CONSTRAINT = "ge";
    private static final String _ACTION_ID = "_action_id_";
    private static final String PROP_P2_PROFILE = "eclipse.p2.profile";
    private static final Integer EXIT_ERROR = 13;
    private static final String OPTION_TO_ANALYZE = "-toAnalyze";
    private static final String OPTION_RESULT_FILE = "-output";
    private File installation;
    private File resultFile;
    private IProvisioningAgent targetAgent;
    private String profileId;
    private Properties extractedData = new Properties();
    private Properties installCommandsProperties = new Properties();
    private boolean stackTrace = false;

    public Object start(IApplicationContext context) throws Exception {
        try {
            this.processArguments((String[])context.getArguments().get("application.args"));
            this.initializeServices();
            NativeTouchpoint.loadInstallCommandsProperties(this.installCommandsProperties, "debian");
            NativeTouchpoint.loadInstallCommandsProperties(this.installCommandsProperties, "fedora");
            NativeTouchpoint.loadInstallCommandsProperties(this.installCommandsProperties, "windows");
            this.collectData();
            this.persistInformation();
        }
        catch (CoreException e) {
            this.deeplyPrint(e.getStatus(), System.err, 0);
            return EXIT_ERROR;
        }
        return IApplication.EXIT_OK;
    }

    private void processArguments(String[] args) throws CoreException {
        if (args == null || args.length == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.NativePackageExtractionApplication_MissingParameters, (Object)OPTION_TO_ANALYZE, (Object)OPTION_RESULT_FILE)));
        }
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (OPTION_TO_ANALYZE.equals(opt)) {
                this.installation = new File(NativePackageExtractionApplication.getRequiredArgument(args, ++i));
                if (!this.installation.exists()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", Messages.NativePackageExtractionApplication_FolderNotFound + this.installation.getAbsolutePath()));
                }
            } else if (OPTION_RESULT_FILE.equals(opt)) {
                this.resultFile = new File(NativePackageExtractionApplication.getRequiredArgument(args, ++i));
            }
            ++i;
        }
    }

    private static String getRequiredArgument(String[] args, int argIdx) throws CoreException {
        String arg;
        if (argIdx < args.length && !(arg = args[argIdx]).startsWith("-")) {
            return arg;
        }
        throw new ProvisionException(NLS.bind((String)Messages.NativePackageExtractionApplication_MissingValue, (Object)args[argIdx - 1]));
    }

    private void collectData() {
        IProfileRegistry registry = (IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class);
        IProfile p = registry.getProfile(this.profileId);
        this.collectArchitecture(p);
        this.collectLauncherName(p);
        this.collectDebianDependencies(p);
    }

    private void persistInformation() throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.resultFile));){
                this.extractedData.store(os, "Data extracted from eclipse located at " + String.valueOf(this.installation));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", Messages.NativePackageExtractionApplication_PersistencePb + this.resultFile.getAbsolutePath(), (Throwable)e));
        }
    }

    private void collectLauncherName(IProfile p) {
        String launcherName = p.getProperty("eclipse.touchpoint.launcherName");
        if (launcherName == null) {
            launcherName = "";
        }
        this.extractedData.put(PROP_LAUNCHER_NAME, launcherName);
    }

    private void collectArchitecture(IProfile p) {
        String environments = p.getProperty("org.eclipse.equinox.p2.environments");
        if (environments != null) {
            StringTokenizer tokenizer = new StringTokenizer(environments, ",");
            while (tokenizer.hasMoreElements()) {
                String entry = tokenizer.nextToken();
                int i = entry.indexOf(61);
                String key = entry.substring(0, i).trim();
                String value = entry.substring(i + 1).trim();
                if (!key.equals("osgi.arch")) continue;
                if ("x86_64".equals(value)) {
                    this.extractedData.put(PROP_ARCH, "amd64");
                    return;
                }
                if (!"x86".equals(value)) continue;
                this.extractedData.put(PROP_ARCH, "x86");
                return;
            }
        }
        this.extractedData.put(PROP_ARCH, "");
    }

    private void collectDebianDependencies(IProfile p) {
        Object depends = "";
        IQueryResult allIUs = p.available(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor());
        for (IInstallableUnit iu : allIUs) {
            Collection tpdata = iu.getTouchpointData();
            for (ITouchpointData data : tpdata) {
                Map allInstructions = data.getInstructions();
                for (ITouchpointInstruction instruction : allInstructions.values()) {
                    StringTokenizer tokenizer = new StringTokenizer(instruction.getBody(), ";");
                    while (tokenizer.hasMoreTokens()) {
                        Map<String, String> parsedInstructions = this.parseInstruction(tokenizer.nextToken());
                        if (parsedInstructions == null || !parsedInstructions.get(_ACTION_ID).endsWith("checkAndPromptNativePackage") || !"debian".equals(parsedInstructions.get("distro"))) continue;
                        depends = (String)depends + this.formatAsDependsEntry(parsedInstructions.get("package"), parsedInstructions.get("version"), parsedInstructions.get("comparator")) + ",";
                    }
                }
            }
        }
        if (((String)depends).length() > 0) {
            depends = "," + ((String)depends).substring(0, ((String)depends).length() - 1);
        }
        this.extractedData.put(PROP_DEPENDS, depends);
    }

    private String formatAsDependsEntry(String packageId, String version, String versionComparator) {
        Object result = packageId;
        if (versionComparator == null) {
            versionComparator = DEFAULT_VERSION_CONSTRAINT;
        }
        if (version != null) {
            result = (String)result + "(" + this.getUserFriendlyComparator(versionComparator) + " " + version + ")";
        }
        return result;
    }

    private String getUserFriendlyComparator(String comparator) {
        return this.installCommandsProperties.getProperty(comparator, "");
    }

    private Map<String, String> parseInstruction(String statement) {
        HashMap<String, String> instructions = new HashMap<String, String>();
        int openBracket = statement.indexOf(40);
        int closeBracket = statement.lastIndexOf(41);
        if (openBracket == -1 || closeBracket == -1 || openBracket > closeBracket) {
            return null;
        }
        instructions.put(_ACTION_ID, statement.substring(0, openBracket).trim());
        String nameValuePairs = statement.substring(openBracket + 1, closeBracket);
        if (nameValuePairs.length() == 0) {
            return instructions;
        }
        StringTokenizer tokenizer = new StringTokenizer(nameValuePairs, ",");
        while (tokenizer.hasMoreTokens()) {
            String nameValuePair = tokenizer.nextToken();
            int colonIndex = nameValuePair.indexOf(":");
            if (colonIndex == -1) {
                return null;
            }
            String name = nameValuePair.substring(0, colonIndex).trim();
            String value = nameValuePair.substring(colonIndex + 1).trim();
            instructions.put(name, value);
        }
        return instructions;
    }

    private void initializeServices() throws ProvisionException {
        ServiceReference agentProviderRef = Activator.getContext().getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)Activator.getContext().getService(agentProviderRef);
        URI p2DataArea = new File(this.installation, "p2").toURI();
        this.targetAgent = provider.createAgent(p2DataArea);
        this.targetAgent.registerService("org.eclipse.equinox.p2.installer.agent", (Object)provider.createAgent(null));
        Activator.getContext().ungetService(agentProviderRef);
        if (this.profileId == null && this.installation != null) {
            File configIni = new File(this.installation, "configuration/config.ini");
            Properties ciProps = new Properties();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(configIni));){
                    ciProps.load(in);
                    this.profileId = ciProps.getProperty(PROP_P2_PROFILE);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.profileId == null) {
                this.profileId = this.installation.toString();
            }
        }
        if (this.profileId != null) {
            this.targetAgent.registerService(PROP_P2_PROFILE, (Object)this.profileId);
        }
    }

    private static void appendLevelPrefix(PrintStream strm, int level) {
        int idx = 0;
        while (idx < level) {
            strm.print(' ');
            ++idx;
        }
    }

    private void deeplyPrint(CoreException ce, PrintStream strm, int level) {
        NativePackageExtractionApplication.appendLevelPrefix(strm, level);
        if (this.stackTrace) {
            ce.printStackTrace(strm);
        }
        this.deeplyPrint(ce.getStatus(), strm, level);
    }

    private void deeplyPrint(IStatus status, PrintStream strm, int level) {
        NativePackageExtractionApplication.appendLevelPrefix(strm, level);
        String msg = status.getMessage();
        strm.println(msg);
        Throwable cause = status.getException();
        if (cause != null) {
            strm.print("Caused by: ");
            if (this.stackTrace || !msg.equals(cause.getMessage()) && !msg.equals(cause.toString())) {
                this.deeplyPrint(cause, strm, level);
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.deeplyPrint(child, strm, level + 1);
                ++n2;
            }
        }
    }

    private void deeplyPrint(Throwable t, PrintStream strm, int level) {
        if (t instanceof CoreException) {
            this.deeplyPrint((CoreException)t, strm, level);
        } else {
            NativePackageExtractionApplication.appendLevelPrefix(strm, level);
            if (this.stackTrace) {
                t.printStackTrace(strm);
            } else {
                strm.println(t.toString());
                Throwable cause = t.getCause();
                if (cause != null) {
                    strm.print("Caused by: ");
                    this.deeplyPrint(cause, strm, level);
                }
            }
        }
    }

    public void stop() {
    }
}

