/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface KeyValueStore<K, V> {
    public V get(K var1) throws IllegalArgumentException;

    public boolean contains(K var1);

    public Set<K> getKeys();

    public Collection<V> getValues();

    default public Map<K, V> toMap() {
        HashMap<K, V> map = new HashMap<K, V>();
        for (K k : this.getKeys()) {
            map.put(k, this.get(k));
        }
        return map;
    }

    public static <K, V> KeyValueStore<K, V> fromMap(final Map<K, V> map) {
        return new KeyValueStore<K, V>(){

            @Override
            public V get(K key) {
                Object v = map.get(key);
                if (v == null && !this.contains(key)) {
                    throw new IllegalArgumentException("The key '" + String.valueOf(key) + "' is not known");
                }
                return v;
            }

            @Override
            public Set<K> getKeys() {
                return map.keySet();
            }

            @Override
            public Collection<V> getValues() {
                return map.values();
            }

            @Override
            public boolean contains(K key) {
                return map.containsKey(key);
            }

            @Override
            public Map<K, V> toMap() {
                return Collections.unmodifiableMap(map);
            }
        };
    }
}

