/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonObject;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;

public final class GsonConditionImpl
implements GsonBase,
Condition {
    private final String name;

    public GsonConditionImpl(JsonObject jsonObject) {
        this.name = jsonObject.has("name") ? jsonObject.get("name").getAsString() : null;
    }

    public GsonConditionImpl(String name) {
        this.name = name;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "Condition");
        o.addProperty("name", this.getName());
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { name : " + this.name + " }";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder
    implements Condition.Builder {
        private final EditorGModel instance;
        private String name;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Condition build() {
            return new GsonConditionImpl(this.name);
        }
    }
}

