/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.index.ArtifactAvailablility;
import org.apache.maven.index.ArtifactInfoRecord;
import org.apache.maven.index.Field;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.MatchHighlight;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.IllegalArtifactCoordinateException;
import org.apache.maven.index.artifact.VersionUtils;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MavenPluginArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactInfo
extends ArtifactInfoRecord {
    private static final long serialVersionUID = 6028843453477511104L;
    public static final String ROOT_GROUPS = "rootGroups";
    public static final String ROOT_GROUPS_VALUE = "rootGroups";
    public static final String ROOT_GROUPS_LIST = "rootGroupsList";
    public static final String ALL_GROUPS = "allGroups";
    public static final String ALL_GROUPS_VALUE = "allGroups";
    public static final String ALL_GROUPS_LIST = "allGroupsList";
    public static final String UINFO = FLD_UINFO.getKey();
    public static final String DELETED = FLD_DELETED.getKey();
    public static final String GROUP_ID = MinimalArtifactInfoIndexCreator.FLD_GROUP_ID_KW.getKey();
    public static final String ARTIFACT_ID = MinimalArtifactInfoIndexCreator.FLD_ARTIFACT_ID_KW.getKey();
    public static final String VERSION = MinimalArtifactInfoIndexCreator.FLD_VERSION_KW.getKey();
    public static final String PACKAGING = MinimalArtifactInfoIndexCreator.FLD_PACKAGING.getKey();
    public static final String CLASSIFIER = MinimalArtifactInfoIndexCreator.FLD_CLASSIFIER.getKey();
    public static final String INFO = MinimalArtifactInfoIndexCreator.FLD_INFO.getKey();
    public static final String NAME = MinimalArtifactInfoIndexCreator.FLD_NAME.getKey();
    public static final String DESCRIPTION = MinimalArtifactInfoIndexCreator.FLD_DESCRIPTION.getKey();
    public static final String LAST_MODIFIED = MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey();
    public static final String SHA1 = MinimalArtifactInfoIndexCreator.FLD_SHA1.getKey();
    public static final String NAMES = JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey();
    public static final String PLUGIN_PREFIX = MavenPluginArtifactInfoIndexCreator.FLD_PLUGIN_PREFIX.getKey();
    public static final String PLUGIN_GOALS = MavenPluginArtifactInfoIndexCreator.FLD_PLUGIN_GOALS.getKey();
    public static final Comparator<ArtifactInfo> VERSION_COMPARATOR = new VersionComparator();
    public static final Comparator<ArtifactInfo> REPOSITORY_VERSION_COMPARATOR = new RepositoryVersionComparator();
    public String fname;
    public String fextension;
    public String groupId;
    public String artifactId;
    public String version;
    @Deprecated
    private transient ArtifactVersion artifactVersion;
    private transient float luceneScore;
    public String classifier;
    public String packaging;
    public String name;
    public String description;
    public long lastModified = -1L;
    public long size = -1L;
    public String md5;
    public String sha1;
    public ArtifactAvailablility sourcesExists = ArtifactAvailablility.NOT_PRESENT;
    public ArtifactAvailablility javadocExists = ArtifactAvailablility.NOT_PRESENT;
    public ArtifactAvailablility signatureExists = ArtifactAvailablility.NOT_PRESENT;
    public String classNames;
    public String repository;
    public String path;
    public String remoteUrl;
    public String context;
    public String prefix;
    public List<String> goals;
    private String uinfo = null;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<MatchHighlight> matchHighlights = new ArrayList<MatchHighlight>();
    private static final List<Field> DEFAULT_FIELDS = new ArrayList<Field>();
    private List<Field> fields;

    public ArtifactInfo() {
    }

    public ArtifactInfo(String repository, String groupId, String artifactId, String version, String classifier) {
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    @Deprecated
    public ArtifactVersion getArtifactVersion() {
        if (this.artifactVersion == null) {
            this.artifactVersion = new DefaultArtifactVersion(this.version);
        }
        return this.artifactVersion;
    }

    public float getLuceneScore() {
        return this.luceneScore;
    }

    public void setLuceneScore(float score) {
        this.luceneScore = score;
    }

    public String getUinfo() {
        if (this.uinfo == null) {
            this.uinfo = this.groupId + "|" + this.artifactId + "|" + this.version + "|" + ArtifactInfo.nvl(this.classifier) + (StringUtils.isEmpty((String)this.classifier) || StringUtils.isEmpty((String)this.packaging) ? "" : "|" + this.packaging);
        }
        return this.uinfo;
    }

    public String getRootGroup() {
        int n = this.groupId.indexOf(46);
        if (n > -1) {
            return this.groupId.substring(0, n);
        }
        return this.groupId;
    }

    public Gav calculateGav() throws IllegalArtifactCoordinateException {
        return new Gav(this.groupId, this.artifactId, this.version, this.classifier, this.fextension, null, null, this.fname, VersionUtils.isSnapshot((String)this.version), false, null, false, null);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<MatchHighlight> getMatchHighlights() {
        return this.matchHighlights;
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId + ':' + this.version + ':' + this.classifier + ':' + this.packaging;
    }

    public Collection<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>(DEFAULT_FIELDS.size());
            this.fields.addAll(DEFAULT_FIELDS);
        }
        return this.fields;
    }

    public String getFieldValue(Field field) {
        if (MAVEN.GROUP_ID.equals(field)) {
            return this.groupId;
        }
        if (MAVEN.ARTIFACT_ID.equals(field)) {
            return this.artifactId;
        }
        if (MAVEN.VERSION.equals(field)) {
            return this.version;
        }
        if (MAVEN.PACKAGING.equals(field)) {
            return this.packaging;
        }
        if (MAVEN.CLASSIFIER.equals(field)) {
            return this.classifier;
        }
        if (MAVEN.SHA1.equals(field)) {
            return this.sha1;
        }
        if (MAVEN.NAME.equals(field)) {
            return this.name;
        }
        if (MAVEN.DESCRIPTION.equals(field)) {
            return this.description;
        }
        if (MAVEN.CLASSNAMES.equals(field)) {
            return this.classNames;
        }
        if (MAVEN.REPOSITORY_ID.equals(field)) {
            return this.repository;
        }
        return null;
    }

    public ArtifactInfo setFieldValue(Field field, String value) {
        if (MAVEN.GROUP_ID.equals(field)) {
            this.groupId = value;
        } else if (MAVEN.ARTIFACT_ID.equals(field)) {
            this.artifactId = value;
        } else if (MAVEN.VERSION.equals(field)) {
            this.version = value;
        } else if (MAVEN.PACKAGING.equals(field)) {
            this.packaging = value;
        } else if (MAVEN.CLASSIFIER.equals(field)) {
            this.classifier = value;
        } else if (MAVEN.SHA1.equals(field)) {
            this.sha1 = value;
        } else if (MAVEN.NAME.equals(field)) {
            this.name = value;
        } else if (MAVEN.DESCRIPTION.equals(field)) {
            this.description = value;
        } else if (MAVEN.CLASSNAMES.equals(field)) {
            this.classNames = value;
        } else if (MAVEN.REPOSITORY_ID.equals(field)) {
            this.repository = value;
        }
        return this;
    }

    public static String nvl(String v) {
        return v == null ? "NA" : v;
    }

    public static String renvl(String v) {
        return "NA".equals(v) ? null : v;
    }

    public static String lst2str(Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append("|");
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - 1);
    }

    public static List<String> str2lst(String str) {
        return Arrays.asList(FS_PATTERN.split(str));
    }

    static {
        DEFAULT_FIELDS.add(MAVEN.GROUP_ID);
        DEFAULT_FIELDS.add(MAVEN.ARTIFACT_ID);
        DEFAULT_FIELDS.add(MAVEN.VERSION);
        DEFAULT_FIELDS.add(MAVEN.PACKAGING);
        DEFAULT_FIELDS.add(MAVEN.CLASSIFIER);
        DEFAULT_FIELDS.add(MAVEN.SHA1);
        DEFAULT_FIELDS.add(MAVEN.NAME);
        DEFAULT_FIELDS.add(MAVEN.DESCRIPTION);
        DEFAULT_FIELDS.add(MAVEN.CLASSNAMES);
        DEFAULT_FIELDS.add(MAVEN.REPOSITORY_ID);
    }

    static class RepositoryVersionComparator
    extends VersionComparator {
        RepositoryVersionComparator() {
        }

        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = super.compare(f1, f2);
            if (n != 0) {
                return n;
            }
            String r1 = f1.repository;
            String r2 = f2.repository;
            if (r1 == null) {
                return r2 == null ? 0 : -1;
            }
            return r2 == null ? 1 : r1.compareTo(r2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VersionComparator
    implements Comparator<ArtifactInfo> {
        VersionComparator() {
        }

        @Override
        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = f1.groupId.compareTo(f2.groupId);
            if (n != 0) {
                return n;
            }
            n = f1.artifactId.compareTo(f2.artifactId);
            if (n != 0) {
                return n;
            }
            n = -f1.getArtifactVersion().compareTo((Object)f2.getArtifactVersion());
            if (n != 0) {
                return n;
            }
            String c1 = f1.classifier;
            String c2 = f2.classifier;
            if (c1 == null) {
                if (c2 != null) {
                    return -1;
                }
            } else {
                if (c2 == null) {
                    return 1;
                }
                n = c1.compareTo(c2);
                if (n != 0) {
                    return n;
                }
            }
            String p1 = f1.packaging;
            String p2 = f2.packaging;
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            return p2 == null ? 1 : p1.compareTo(p2);
        }
    }
}

