/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.styledtext.events.HoverTarget;
import org.eclipse.fx.ui.controls.styledtext.internal.DebugMarker;
import org.eclipse.fx.ui.controls.styledtext.internal.LineHelper;
import org.eclipse.fx.ui.controls.styledtext.internal.NodeCachePane;
import org.eclipse.fx.ui.controls.styledtext.internal.ReuseCache;
import org.eclipse.fx.ui.controls.styledtext.internal.Segment;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNodeOriginal;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNodeSingle;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotation;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;

public class LineNode
extends StackPane {
    int leftPadding = 0;
    static final boolean debugAnimation = Boolean.getBoolean("styledtext.debuganimation");
    private DebugMarker debugUpdateText;
    DebugMarker debugUpdateAnnotations;
    DebugMarker debugUpdateSelection;
    DebugMarker debugUpdateCaret;
    private HBox debugBox;
    int index;
    LineHelper lineHelper;
    private static final String CSS_CLASS_SOURCE_SEGMENT_CONTAINER = "source-segment-container";
    private static final String CSS_CLASS_SELECTION_MARKER = "selection-marker";
    private static final String CSS_CLASS_STYLED_TEXT_LINE = "styled-text-line";
    private static final String CSS_CLASS_CURRENT_LINE = "current-line";
    private static boolean USE_SINGLE_CHARS = Boolean.getBoolean("efxclipse.styledtext.singlechars");
    final TextLayer textLayer;
    private SelectionLayer selectionLayer = new SelectionLayer();
    private CaretLayer caretLayer = new CaretLayer();
    private AnnotationLayer annotationLayer = new AnnotationLayer();
    private InsertionMarkerLayer insertionMarkerLayer = new InsertionMarkerLayer();
    boolean currentLine = false;

    private int getLineIndex() {
        return this.index;
    }

    static TextNode createNode(IntegerProperty tabCharAdvance) {
        TextNode textNode = USE_SINGLE_CHARS ? new TextNodeOriginal("", tabCharAdvance) : new TextNodeSingle("", tabCharAdvance);
        return textNode;
    }

    static Animation createCaretAnimation(Node caret) {
        FadeTransition t = new FadeTransition(Duration.millis((double)500.0), caret);
        t.setInterpolator(new Interpolator(){

            protected double curve(double t) {
                if (t < 0.5) {
                    return 0.0;
                }
                return 1.0;
            }
        });
        t.setAutoReverse(true);
        t.setFromValue(1.0);
        t.setToValue(0.0);
        t.setCycleCount(-1);
        return t;
    }

    private Node createInsertionMarker(double lineHeight) {
        double lineWidth = lineHeight / 15.0;
        double arrowSide = lineHeight / 2.0;
        double arrowHeight = arrowSide / 2.0;
        Path marker = new Path();
        marker.getElements().add((Object)new MoveTo(-arrowSide / 2.0, -arrowHeight));
        marker.getElements().add((Object)new LineTo(arrowSide / 2.0, -arrowHeight));
        marker.getElements().add((Object)new LineTo(lineWidth / 2.0, 0.0));
        marker.getElements().add((Object)new LineTo(lineWidth / 2.0, lineHeight));
        marker.getElements().add((Object)new LineTo(arrowSide / 2.0, lineHeight + arrowHeight));
        marker.getElements().add((Object)new LineTo(-arrowSide / 2.0, lineHeight + arrowHeight));
        marker.getElements().add((Object)new LineTo(-lineWidth / 2.0, lineHeight));
        marker.getElements().add((Object)new LineTo(-lineWidth / 2.0, 0.0));
        marker.getElements().add((Object)new ClosePath());
        marker.setVisible(false);
        marker.getStyleClass().add((Object)"insertion-marker");
        marker.setMouseTransparent(true);
        return marker;
    }

    public BooleanProperty caretLayerVisibleProperty() {
        return this.caretLayer.visibleProperty();
    }

    protected Range<Integer> toGlobal(Range<Integer> range) {
        int lineOffset = this.lineHelper.getOffset(this.index);
        return Range.range((Comparable)Integer.valueOf(lineOffset + (Integer)range.lowerEndpoint()), (BoundType)range.lowerBoundType(), (Comparable)Integer.valueOf(lineOffset + (Integer)range.upperEndpoint()), (BoundType)range.upperBoundType());
    }

    protected Range<Integer> toLocal(Range<Integer> range) {
        int lineOffset = -this.lineHelper.getOffset(this.index);
        return Range.range((Comparable)Integer.valueOf(lineOffset + (Integer)range.lowerEndpoint()), (BoundType)range.lowerBoundType(), (Comparable)Integer.valueOf(lineOffset + (Integer)range.upperEndpoint()), (BoundType)range.upperBoundType());
    }

    public LineNode(IntegerProperty tabCharAdvance) {
        this.textLayer = new TextLayer(tabCharAdvance);
        this.getStyleClass().add((Object)CSS_CLASS_STYLED_TEXT_LINE);
        this.setPadding(new Insets(0.0, 0.0, 0.0, (double)this.leftPadding));
        this.getChildren().setAll((Object[])new Node[]{this.insertionMarkerLayer, this.selectionLayer, this.textLayer, this.caretLayer, this.annotationLayer});
        if (debugAnimation) {
            this.debugUpdateAnnotations = new DebugMarker(Color.RED, 400L);
            this.debugUpdateText = new DebugMarker(Color.AQUAMARINE, 300L);
            this.debugUpdateSelection = new DebugMarker(Color.BLUE, 150L);
            this.debugUpdateCaret = new DebugMarker(Color.GRAY, 150L);
            this.debugUpdateAnnotations.setWidth(10.0);
            this.debugUpdateText.setWidth(10.0);
            this.debugUpdateSelection.setWidth(10.0);
            this.debugUpdateCaret.setWidth(10.0);
            this.debugBox = new HBox();
            this.debugBox.setManaged(false);
            this.debugBox.getChildren().addAll((Object[])new Node[]{this.debugUpdateAnnotations, this.debugUpdateSelection, this.debugUpdateCaret, this.debugUpdateText});
            this.getChildren().add((Object)this.debugBox);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (debugAnimation) {
            this.debugBox.resizeRelocate(0.0, 0.0, 40.0, this.getHeight());
            this.debugUpdateAnnotations.resize(this.getHeight(), this.getHeight());
            this.debugUpdateText.resize(this.getHeight(), this.getHeight());
            this.debugUpdateSelection.resize(this.getHeight(), this.getHeight());
            this.debugUpdateCaret.resize(this.getHeight(), this.getHeight());
        }
    }

    public void setLineHelper(LineHelper helper) {
        this.lineHelper = helper;
    }

    public void update(Set<TextAnnotationPresenter> presenters) {
        this.requestLayout();
        int idx = this.index;
        this.updateContent(this.lineHelper.getSegments(idx));
        this.updateSelection(this.lineHelper.getSelection(idx), this.lineHelper.isValidLineIndex(idx + 1) ? this.lineHelper.getSelection(idx + 1) : null);
        this.updateCaret(this.lineHelper.getCaret(idx));
        this.updateAnnotations(this.lineHelper.getTextAnnotations(idx), presenters);
    }

    public void updateInsertionMarkerIndex(int globalOffset) {
        int lineOffset = this.lineHelper.getOffset(this.index);
        int lineWidth = this.lineHelper.getLength(this.index);
        int localOffset = globalOffset >= lineOffset && globalOffset <= lineOffset + lineWidth ? globalOffset - lineOffset : -1;
        this.insertionMarkerLayer.updateInsertionIndex(localOffset);
    }

    public void updateSelection(Range<Integer> lineSelection, Range<Integer> nextLine) {
        if (lineSelection != null && lineSelection.isEmpty()) {
            this.selectionLayer.updateSelection(null, false);
        } else {
            this.selectionLayer.updateSelection(lineSelection, nextLine != null);
        }
    }

    public void updateCaret(int caret) {
        this.caretLayer.updateCaret(caret);
        this.updateCurrentLine(caret != -1);
    }

    public void updateCurrentLine(boolean current) {
        if (this.currentLine != current) {
            if (current) {
                this.getStyleClass().add((Object)CSS_CLASS_CURRENT_LINE);
            } else {
                this.getStyleClass().remove((Object)CSS_CLASS_CURRENT_LINE);
            }
            this.currentLine = current;
            this.requestLayout();
        }
    }

    public void updateContent(List<Segment> content) {
        boolean updated = this.textLayer.updateContent(content);
        if (updated) {
            this.applyCss();
            if (debugAnimation) {
                this.debugUpdateText.play();
            }
        }
    }

    public void updateAnnotations(Set<TextAnnotation> annotations, Set<TextAnnotationPresenter> presenters) {
        this.annotationLayer.updateAnnoations(annotations, presenters);
    }

    public int getCaretIndexAtPoint(Point2D p) {
        return this.textLayer.getCaretIndexAtPoint(p);
    }

    public int getStartOffset() {
        return this.lineHelper.getOffset(this.index);
    }

    public int getEndOffset() {
        return this.lineHelper.getOffset(this.index) + this.lineHelper.getLength(this.index);
    }

    public double getCharLocation(int charOffset) {
        return this.textLayer.getCharLocation(charOffset);
    }

    public List<HoverTarget> findHoverTargets(Point2D localLocation) {
        ArrayList<HoverTarget> results = new ArrayList<HoverTarget>();
        results.addAll(this.textLayer.findHoverTargets(localLocation));
        results.addAll(this.annotationLayer.findHoverTargets(localLocation));
        return results;
    }

    public Optional<TextNode> findTextNode(Point2D localLocation) {
        return this.textLayer.findTextNode(localLocation);
    }

    public String toString() {
        return "LineNode(idx: " + this.getLineIndex() + ")@" + ((Object)((Object)this)).hashCode();
    }

    public int getLineLength() {
        return this.lineHelper.getLength(this.index);
    }

    public void release() {
        this.index = -1;
        this.caretLayer.hideCaret();
        this.selectionLayer.selection = null;
        this.selectionLayer.selectionMarker.resize(0.0, 0.0);
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public class AnnotationLayer
    extends StackPane {
        private Set<TextAnnotation> currentAnnotations;
        private Set<TextAnnotationPresenter> currentPresenters;
        Map<TextAnnotationPresenter, AnnotationOverlay> overlays = new HashMap<TextAnnotationPresenter, AnnotationOverlay>();

        public void updateAnnoations(Set<TextAnnotation> annotations, Set<TextAnnotationPresenter> presenters) {
            if (this.currentAnnotations != null && this.currentAnnotations.equals(annotations) && this.currentPresenters != null && this.currentPresenters.equals(presenters)) {
                return;
            }
            Iterator<Map.Entry<TextAnnotationPresenter, AnnotationOverlay>> iterator = this.overlays.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TextAnnotationPresenter, AnnotationOverlay> entry = iterator.next();
                if (presenters.contains(entry.getKey())) continue;
                this.getChildren().remove((Object)entry.getValue());
                iterator.remove();
            }
            for (TextAnnotationPresenter presenter : presenters) {
                Set<TextAnnotation> applicableAnnotations = annotations.stream().filter(presenter::isApplicable).collect(Collectors.toSet());
                AnnotationOverlay overlay = this.overlays.get(presenter);
                if (overlay == null) {
                    overlay = new AnnotationOverlay(presenter);
                    this.getChildren().add((Object)overlay);
                    this.overlays.put(presenter, overlay);
                }
                overlay.prepareNodes(applicableAnnotations);
                overlay.requestLayout();
            }
            this.requestLayout();
            if (debugAnimation) {
                LineNode.this.debugUpdateAnnotations.play();
            }
            this.currentAnnotations = annotations;
            this.currentPresenters = presenters;
        }

        protected void layoutChildren() {
            super.layoutChildren();
        }

        public Collection<? extends HoverTarget> findHoverTargets(Point2D localLocation) {
            ArrayList<? extends HoverTarget> hoverTargets = new ArrayList<HoverTarget>();
            for (AnnotationOverlay overlay : this.overlays.values()) {
                hoverTargets.addAll(overlay.findHoverTargets(localLocation));
            }
            return hoverTargets;
        }

        private class AnnotationOverlay
        extends NodeCachePane {
            private TextAnnotationPresenter presenter;
            private Map<TextAnnotation, Node> usedNodes;
            private Set<TextAnnotation> current;

            public AnnotationOverlay(TextAnnotationPresenter presenter) {
                super(presenter::createNode);
                this.usedNodes = new HashMap<TextAnnotation, Node>();
                this.current = new HashSet<TextAnnotation>();
                this.presenter = presenter;
                this.setOpacity(0.5);
            }

            private Node getNode(TextAnnotation a) {
                Node node = this.usedNodes.get(a);
                if (node == null) {
                    node = this.getNode();
                    this.usedNodes.put(a, node);
                }
                return node;
            }

            public void prepareNodes(Set<TextAnnotation> annotations) {
                boolean same = this.current.equals(annotations);
                if (same) {
                    return;
                }
                this.current = annotations;
                Iterator<Map.Entry<TextAnnotation, Node>> iterator = this.usedNodes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<TextAnnotation, Node> entry = iterator.next();
                    if (!annotations.contains(entry.getKey())) {
                        this.releaseNode(entry.getValue());
                        iterator.remove();
                        continue;
                    }
                    if (this.presenter.isVisible(entry.getKey())) continue;
                    this.releaseNode(entry.getValue());
                    iterator.remove();
                }
                for (TextAnnotation a : annotations) {
                    Node n = this.getNode(a);
                    this.presenter.updateNode(n, a);
                }
            }

            protected void layoutChildren() {
                for (Map.Entry<TextAnnotation, Node> entry : this.usedNodes.entrySet()) {
                    Range<Integer> range = entry.getKey().getRange();
                    double x = LineNode.this.getCharLocation((Integer)range.lowerEndpoint());
                    double width = LineNode.this.getCharLocation((Integer)range.upperEndpoint()) - x;
                    entry.getValue().resizeRelocate(x, 0.0, width, this.getHeight());
                }
            }

            public Collection<? extends HoverTarget> findHoverTargets(Point2D localLocation) {
                return this.usedNodes.entrySet().stream().filter(e -> ((Node)e.getValue()).getBoundsInParent().contains(localLocation)).map(e -> {
                    TextAnnotation annotation = (TextAnnotation)e.getKey();
                    Bounds bounds = ((Node)e.getValue()).getBoundsInLocal();
                    Point2D anchor = new Point2D(bounds.getMinX(), bounds.getMaxY());
                    HoverTarget annotationTarget = new HoverTarget(annotation, LineNode.this.toGlobal(annotation.getRange()), ((Node)e.getValue()).localToScreen(anchor), ((Node)e.getValue()).localToScreen(bounds));
                    return annotationTarget;
                }).collect(Collectors.toList());
            }
        }
    }

    public class CaretLayer
    extends Region {
        private int caretIndex = -1;
        private Line caret = new Line();
        private Animation caretAnimation;
        Timeline scheduledAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)200.0), a -> this.caretAnimation.playFromStart(), new KeyValue[0])});

        public CaretLayer() {
            this.caret.setVisible(false);
            this.caret.setStrokeWidth(2.0);
            this.caret.getStyleClass().add((Object)"text-caret");
            this.caret.setVisible(false);
            this.getChildren().add((Object)this.caret);
            this.caretAnimation = LineNode.createCaretAnimation((Node)this.caret);
            this.sceneProperty().addListener((x, o, n) -> {
                if (n == null) {
                    if (this.caretAnimation != null) {
                        this.caretAnimation.stop();
                    }
                    this.caretAnimation = null;
                } else {
                    this.caretAnimation = LineNode.createCaretAnimation((Node)this.caret);
                }
            });
        }

        void hideCaret() {
            this.caret.setVisible(false);
        }

        private void showCaret() {
            this.caret.setVisible(true);
        }

        public void updateCaret(int index) {
            if (index != this.caretIndex) {
                if (this.scheduledAnimation != null) {
                    this.scheduledAnimation.stop();
                }
                this.caretAnimation.stop();
                if (index == -1) {
                    this.hideCaret();
                } else {
                    this.showCaret();
                    this.caret.setOpacity(1.0);
                    this.scheduledAnimation.playFromStart();
                }
                this.caretIndex = index;
                this.requestLayout();
                if (debugAnimation) {
                    LineNode.this.debugUpdateCaret.play();
                }
            }
        }

        public void layoutChildren() {
            double caretOffset = LineNode.this.getCharLocation(this.caretIndex);
            this.caret.setStartX(caretOffset);
            this.caret.setStrokeLineCap(StrokeLineCap.BUTT);
            this.caret.setEndX(caretOffset);
            this.caret.setStartY(0.0);
            this.caret.setEndY(this.getHeight());
            this.caret.toFront();
        }
    }

    public class InsertionMarkerLayer
    extends Region {
        private int insertionIndex = -1;
        private Node insertionMarker;

        public InsertionMarkerLayer() {
            this.heightProperty().addListener((x, o, n) -> {
                this.getChildren().remove((Object)this.insertionMarker);
                this.insertionMarker = LineNode.this.createInsertionMarker(n.doubleValue());
                this.getChildren().add((Object)this.insertionMarker);
            });
            this.insertionMarker = LineNode.this.createInsertionMarker(this.getHeight());
            this.getChildren().add((Object)this.insertionMarker);
        }

        void hideMarker() {
            this.insertionMarker.setVisible(false);
        }

        private void showMarker() {
            this.insertionMarker.setVisible(true);
        }

        public void updateInsertionIndex(int index) {
            if (index != this.insertionIndex) {
                if (index == -1) {
                    this.hideMarker();
                } else {
                    this.showMarker();
                }
                this.insertionIndex = index;
                this.requestLayout();
            }
        }

        public void layoutChildren() {
            double caretOffset = LineNode.this.getCharLocation(this.insertionIndex);
            this.insertionMarker.setLayoutX(caretOffset);
            this.insertionMarker.setLayoutY(0.0);
            this.insertionMarker.toFront();
        }
    }

    public class SelectionLayer
    extends Region {
        Region selectionMarker = new Region();
        Range<Integer> selection;
        private boolean continues;

        public SelectionLayer() {
            this.selectionMarker.getStyleClass().add((Object)LineNode.CSS_CLASS_SELECTION_MARKER);
            this.selectionMarker.setManaged(false);
            this.getChildren().setAll((Object[])new Node[]{this.selectionMarker});
        }

        private boolean isSelectionChange(Range<Integer> localSelection) {
            if (localSelection == null && this.selection == null) {
                return false;
            }
            return this.selection == null || !this.selection.equals(localSelection);
        }

        public void updateSelection(Range<Integer> localSelection, boolean continues) {
            this.continues = continues;
            if (this.isSelectionChange(localSelection)) {
                if (localSelection == null) {
                    this.selectionMarker.setVisible(false);
                } else {
                    this.selectionMarker.setVisible(true);
                }
                this.selection = localSelection;
                this.requestLayout();
                if (debugAnimation) {
                    LineNode.this.debugUpdateSelection.play();
                }
            }
        }

        protected void layoutChildren() {
            if (this.selection != null) {
                LineNode.this.textLayer.applyCss();
                LineNode.this.textLayer.layout();
                double begin = LineNode.this.textLayer.getCharLocation((Integer)this.selection.lowerEndpoint());
                double end = LineNode.this.textLayer.getCharLocation((Integer)this.selection.upperEndpoint());
                if (((Integer)this.selection.upperEndpoint()).intValue() == LineNode.this.lineHelper.getLength(LineNode.this.index) && this.continues) {
                    end = this.getWidth();
                }
                this.selectionMarker.resizeRelocate(begin, 0.0, end - begin, this.getHeight());
            }
        }
    }

    public class TextLayer
    extends Region {
        protected final ReuseCache<TextNode> cache;
        private List<Segment> currentContent = new ArrayList<Segment>();
        private List<TextNode> currentTextNodes = new ArrayList<TextNode>();

        public TextLayer(IntegerProperty tabCharAdvance) {
            this.getStyleClass().add((Object)LineNode.CSS_CLASS_SOURCE_SEGMENT_CONTAINER);
            this.setMinWidth(-1.0);
            this.cache = new ReuseCache<TextNode>(() -> LineNode.createNode(tabCharAdvance));
            this.cache.addOnActivate(node -> this.getChildren().add((Object)((Node)node)));
            this.cache.addOnRelease(node -> this.getChildren().remove(node));
        }

        public boolean updateContent(List<Segment> content) {
            if (this.currentContent.equals(content)) {
                return false;
            }
            for (TextNode c : this.currentTextNodes) {
                this.cache.releaseElement(c);
            }
            this.currentTextNodes.clear();
            for (Segment segment : content) {
                TextNode node = this.cache.getElement();
                node.updateText(segment.text);
                node.getStyleClass().setAll(segment.styleClasses);
                this.currentTextNodes.add(node);
            }
            if (content.isEmpty()) {
                TextNode node = this.cache.getElement();
                node.updateText("");
                this.currentTextNodes.add(node);
            }
            this.currentContent = content;
            return true;
        }

        public int getCaretIndexAtPoint(Point2D point) {
            Point2D scenePoint = this.localToScene(point);
            int offset = 0;
            for (TextNode t : this.currentTextNodes) {
                int idx;
                if (t.localToScene(t.getBoundsInLocal()).contains(scenePoint) && (idx = t.getCaretIndexAtPoint(t.sceneToLocal(scenePoint))) != -1) {
                    int result = idx + offset;
                    return result;
                }
                offset += t.getText().length();
            }
            return -1;
        }

        public double getCharLocation(int charOffset) {
            double result = 0.0;
            int startOffset = 0;
            for (TextNode t : this.currentTextNodes) {
                int len = t.getText().length();
                if (charOffset >= startOffset && charOffset <= startOffset + len) {
                    int textNodeOffset = charOffset - startOffset;
                    result = t.getCharLocation(textNodeOffset);
                    break;
                }
                if (charOffset > startOffset + len) {
                    result = t.getLayoutX() + t.getWidth();
                }
                startOffset += len;
            }
            return result;
        }

        protected void layoutChildren() {
            double x = 0.0;
            double h = this.getHeight();
            for (Node n : this.getChildren()) {
                if (!n.isManaged() || !(n instanceof TextNode)) continue;
                double w = n.prefWidth(-1.0);
                double y = h / 2.0 - n.prefHeight(-1.0) / 2.0;
                n.resizeRelocate(x, y, w, n.prefHeight(-1.0));
                x += w;
            }
        }

        protected double computePrefWidth(double height) {
            double x = 0.0;
            for (Node n : this.getChildren()) {
                if (!n.isManaged() || !(n instanceof TextNode)) continue;
                double w = n.prefWidth(-1.0);
                x += w;
            }
            return x;
        }

        protected String getText() {
            StringBuilder b = new StringBuilder();
            for (TextNode t : this.currentTextNodes) {
                b.append(t.getText());
            }
            return b.toString();
        }

        private int getStartOffset(Segment segment) {
            int result = 0;
            for (Segment s : this.currentContent) {
                if (s == segment) break;
                result += s.text.length();
            }
            return result;
        }

        private int getLength(Segment segment) {
            return segment.text.length();
        }

        public Collection<? extends HoverTarget> findHoverTargets(Point2D localLocation) {
            for (TextNode t : this.currentTextNodes) {
                Bounds segmentBounds = t.getBoundsInParent();
                if (!segmentBounds.contains(localLocation)) continue;
                Segment segment = this.currentContent.get(this.currentTextNodes.indexOf(t));
                Point2D anchor = new Point2D(segmentBounds.getMinX(), segmentBounds.getMaxY());
                int segmentBegin = this.getStartOffset(segment);
                int segmentEnd = segmentBegin + this.getLength(segment);
                Range range = Range.closed((Comparable)Integer.valueOf(segmentBegin), (Comparable)Integer.valueOf(segmentEnd));
                HoverTarget segmentTarget = new HoverTarget(segment, LineNode.this.toGlobal((Range<Integer>)range), this.localToScreen(anchor), this.localToScreen(segmentBounds));
                return Collections.singletonList(segmentTarget);
            }
            return Collections.emptyList();
        }

        public Optional<TextNode> findTextNode(Point2D localLocation) {
            for (TextNode t : this.currentTextNodes) {
                Bounds segmentBounds = t.getBoundsInParent();
                if (!segmentBounds.contains(localLocation)) continue;
                return Optional.of(t);
            }
            return Optional.empty();
        }
    }
}

