/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.io.CharStreams;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public abstract class AbstractTraceRegionToString {
    private int radix = 10;
    private boolean showTree = true;
    private boolean showLegend = true;

    protected abstract String getRemoteText(SourceRelativeURI var1);

    protected abstract String getLocalText();

    protected abstract AbstractTraceRegion getTrace();

    protected ITextRegion getLocalFrame() {
        return null;
    }

    protected ITextRegion getRemoteFrame(SourceRelativeURI uri) {
        return null;
    }

    protected String getLocalTitle() {
        return "generated.java";
    }

    protected String getRemoteTitle(SourceRelativeURI uri) {
        URI _uRI = uri.getURI();
        return _uRI.toString();
    }

    protected boolean shouldInclude(AbstractTraceRegion region) {
        ITextRegion frame = this.getLocalFrame();
        boolean _equals = Objects.equal((Object)frame, null);
        if (_equals) {
            return true;
        }
        ITextRegionWithLineInformation _myRegion = region.getMyRegion();
        return frame.contains((ITextRegion)_myRegion);
    }

    protected boolean shouldInclude(AbstractTraceRegion region, ILocationData location) {
        SourceRelativeURI _associatedSrcRelativePath;
        SourceRelativeURI _elvis = null;
        SourceRelativeURI _srcRelativePath = location.getSrcRelativePath();
        _elvis = _srcRelativePath != null ? _srcRelativePath : (_associatedSrcRelativePath = region.getAssociatedSrcRelativePath());
        ITextRegion frame = this.getRemoteFrame(_elvis);
        boolean _equals = Objects.equal((Object)frame, null);
        if (_equals) {
            return true;
        }
        return frame.contains((ITextRegion)location);
    }

    protected void add(Map<SourceRelativeURI, File> files, SourceRelativeURI uri, ITextRegion it, RegionHandle region, LocationHandle location) {
        File file = files.get(uri);
        if (file == null) {
            File _file;
            File _file_1 = file = (_file = new File(uri));
            files.put(uri, _file_1);
        }
        this.add(file, it, region, location);
    }

    protected void add(File file, ITextRegion it, RegionHandle region, LocationHandle location) {
        int _offset = it.getOffset();
        Insert _insert = new Insert(_offset, true, region, location);
        file.inserts.add(_insert);
        int _offset_1 = it.getOffset();
        int _length = it.getLength();
        int _plus = _offset_1 + _length;
        Insert _insert_1 = new Insert(_plus, false, region, location);
        file.inserts.add(_insert_1);
    }

    protected int collect(final AbstractTraceRegion reg, int nextID, File lFile, Map<SourceRelativeURI, File> rFiles, List<RegionHandle> result) {
        int i = nextID;
        List childResult = result;
        boolean _shouldInclude = this.shouldInclude(reg);
        if (_shouldInclude) {
            int _plusPlus = i++;
            RegionHandle regHandle = new RegionHandle(_plusPlus, reg);
            result.add((RegionHandle)regHandle);
            childResult = regHandle.children;
            ITextRegionWithLineInformation _myRegion = reg.getMyRegion();
            this.add(lFile, (ITextRegion)_myRegion, regHandle, null);
            List<ILocationData> _associatedLocations = reg.getAssociatedLocations();
            Functions.Function1<ILocationData, Boolean> _function = new Functions.Function1<ILocationData, Boolean>(){

                public Boolean apply(ILocationData it) {
                    return AbstractTraceRegionToString.this.shouldInclude(reg, it);
                }
            };
            Iterable _filter = IterableExtensions.filter(_associatedLocations, (Functions.Function1)_function);
            List locs = IterableExtensions.toList((Iterable)_filter);
            int j = 0;
            while (j < locs.size()) {
                SourceRelativeURI _associatedSrcRelativePath;
                ILocationData loc = (ILocationData)locs.get(j);
                int _xifexpression = 0;
                int _size = locs.size();
                boolean _greaterThan = _size > 1;
                _xifexpression = _greaterThan ? j + 1 : -1;
                LocationHandle locHandle = new LocationHandle(regHandle, _xifexpression, loc);
                regHandle.locations.add(locHandle);
                SourceRelativeURI _elvis = null;
                SourceRelativeURI _srcRelativePath = loc.getSrcRelativePath();
                _elvis = _srcRelativePath != null ? _srcRelativePath : (_associatedSrcRelativePath = reg.getAssociatedSrcRelativePath());
                SourceRelativeURI path = _elvis;
                this.add(rFiles, path, (ITextRegion)loc, regHandle, locHandle);
                ++j;
            }
        }
        List<AbstractTraceRegion> _nestedRegions = reg.getNestedRegions();
        for (AbstractTraceRegion child : _nestedRegions) {
            int _collect;
            i = _collect = this.collect(child, i, lFile, rFiles, childResult);
        }
        return i;
    }

    protected String render(Insert it, int width) {
        String _string = Integer.toString(it.region.id, this.radix);
        String first = Strings.padStart((String)_string, (int)width, (char)'0');
        String _xifexpression = null;
        if (it.location != null && it.location.id >= 0) {
            String _string_1 = Integer.toString(it.location.id, this.radix);
            _xifexpression = String.valueOf(first) + "_" + _string_1;
        } else {
            _xifexpression = first;
        }
        return _xifexpression;
    }

    protected int sortKey(Insert it) {
        int base = it.region.id * Short.MAX_VALUE;
        int _xifexpression = 0;
        _xifexpression = !Objects.equal((Object)it.location, null) && it.location.id >= 0 ? base + it.location.id : base;
        return _xifexpression;
    }

    protected String render(Collection<Insert> inserts, final int width) {
        Functions.Function1<Insert, Boolean> _function = new Functions.Function1<Insert, Boolean>(){

            public Boolean apply(Insert it) {
                return it.open;
            }
        };
        Iterable _filter = IterableExtensions.filter(inserts, (Functions.Function1)_function);
        Functions.Function1<Insert, Integer> _function_1 = new Functions.Function1<Insert, Integer>(){

            public Integer apply(Insert it) {
                return AbstractTraceRegionToString.this.sortKey(it);
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)_filter, (Functions.Function1)_function_1);
        Functions.Function1<Insert, String> _function_2 = new Functions.Function1<Insert, String>(){

            public String apply(Insert it) {
                return AbstractTraceRegionToString.this.render(it, width);
            }
        };
        List _map = ListExtensions.map((List)_sortBy, (Functions.Function1)_function_2);
        String opens = IterableExtensions.join((Iterable)_map, (CharSequence)",");
        Functions.Function1<Insert, Boolean> _function_3 = new Functions.Function1<Insert, Boolean>(){

            public Boolean apply(Insert it) {
                return !it.open;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(inserts, (Functions.Function1)_function_3);
        Functions.Function1<Insert, Integer> _function_4 = new Functions.Function1<Insert, Integer>(){

            public Integer apply(Insert it) {
                int _sortKey = AbstractTraceRegionToString.this.sortKey(it);
                return -_sortKey;
            }
        };
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)_filter_1, (Functions.Function1)_function_4);
        Functions.Function1<Insert, String> _function_5 = new Functions.Function1<Insert, String>(){

            public String apply(Insert it) {
                return AbstractTraceRegionToString.this.render(it, width);
            }
        };
        List _map_1 = ListExtensions.map((List)_sortBy_1, (Functions.Function1)_function_5);
        String closes = IterableExtensions.join((Iterable)_map_1, (CharSequence)",");
        String _xifexpression = null;
        boolean _isEmpty = opens.isEmpty();
        _xifexpression = _isEmpty ? "" : "[" + opens + "[";
        String s1 = _xifexpression;
        String _xifexpression_1 = null;
        boolean _isEmpty_1 = closes.isEmpty();
        _xifexpression_1 = _isEmpty_1 ? "" : "]" + closes + "]";
        String s2 = _xifexpression_1;
        return String.valueOf(s2) + s1;
    }

    protected List<String> render(File file, int width) {
        try {
            int _length_1;
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)file.uri, null);
            _xifexpression = _equals ? this.getLocalText() : this.getRemoteText(file.uri);
            String text = _xifexpression;
            ITextRegion _elvis = null;
            ITextRegion _xifexpression_1 = null;
            boolean _equals_1 = Objects.equal((Object)file.uri, null);
            _xifexpression_1 = _equals_1 ? this.getLocalFrame() : this.getRemoteFrame(file.uri);
            if (_xifexpression_1 != null) {
                _elvis = _xifexpression_1;
            } else {
                int _length = text.length();
                TextRegion _textRegion = new TextRegion(0, _length);
                _elvis = _textRegion;
            }
            final ITextRegion frame = _elvis;
            Functions.Function1<Insert, Boolean> _function = new Functions.Function1<Insert, Boolean>(){

                public Boolean apply(Insert it) {
                    return it.offset >= frame.getOffset() && it.offset <= frame.getOffset() + frame.getLength();
                }
            };
            Iterable inframe = IterableExtensions.filter((Iterable)file.inserts, (Functions.Function1)_function);
            Function<Insert, Integer> _function_1 = new Function<Insert, Integer>(){

                public Integer apply(Insert it) {
                    return it.offset;
                }
            };
            ImmutableListMultimap _index = Multimaps.index((Iterable)inframe, (Function)_function_1);
            ImmutableMap _asMap = _index.asMap();
            ImmutableSet _entrySet = _asMap.entrySet();
            List _list = IterableExtensions.toList((Iterable)_entrySet);
            Functions.Function1<Map.Entry<Integer, Collection<Insert>>, Integer> _function_2 = new Functions.Function1<Map.Entry<Integer, Collection<Insert>>, Integer>(){

                public Integer apply(Map.Entry<Integer, Collection<Insert>> it) {
                    return it.getKey();
                }
            };
            List offsets = IterableExtensions.sortBy((Iterable)_list, (Functions.Function1)_function_2);
            int last = frame.getOffset();
            StringBuilder result = new StringBuilder();
            for (Map.Entry e : offsets) {
                Integer offset = (Integer)e.getKey();
                Collection _value = (Collection)e.getValue();
                String insert = this.render(_value, width);
                String prefix = text.substring(last, offset);
                result.append(prefix);
                result.append(insert);
                last = offset;
            }
            int _offset = frame.getOffset();
            int end = _offset + (_length_1 = frame.getLength());
            if (last < end) {
                String _substring = text.substring(last, end);
                result.append(_substring);
            }
            String _string = result.toString();
            StringReader _stringReader = new StringReader(_string);
            return CharStreams.readLines((Readable)_stringReader);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String title(SourceRelativeURI uri, int width) {
        String _xifexpression = null;
        _xifexpression = uri == null ? this.getLocalTitle() : this.getRemoteTitle(uri);
        String _plus = " " + _xifexpression;
        String s = String.valueOf(_plus) + " ";
        int _length = s.length();
        int _minus = width - _length;
        int _divide = _minus / 2;
        String left = Strings.repeat((String)"-", (int)_divide);
        int _length_1 = s.length();
        int _length_2 = left.length();
        int _plus_1 = _length_1 + _length_2;
        int _minus_1 = width - _plus_1;
        String right = Strings.repeat((String)"-", (int)_minus_1);
        return String.valueOf(left) + s + right;
    }

    protected <T> Set<T> collect(T start, Functions.Function1<? super T, ? extends Iterable<T>> reachable) {
        LinkedHashSet _newLinkedHashSet = CollectionLiterals.newLinkedHashSet((Object[])new Object[0]);
        return this.collect(start, reachable, _newLinkedHashSet);
    }

    protected <R extends Collection<? super T>, T> R collect(T start, Functions.Function1<? super T, ? extends Iterable<T>> reachable, R collector) {
        boolean _add = collector.add(start);
        if (_add) {
            Iterable _apply = (Iterable)reachable.apply(start);
            for (Object r : _apply) {
                this.collect(r, reachable, collector);
            }
        }
        return collector;
    }

    protected String render(LocationHandle loc) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        if (loc.id >= 0) {
            String _string = Integer.toString(loc.id, this.radix);
            _xifexpression = String.valueOf(_string) + ": ";
        } else {
            _xifexpression = "";
        }
        String prefix = _xifexpression;
        Class<?> _class = loc.location.getClass();
        String name = _class.getSimpleName();
        String _xifexpression_1 = null;
        SourceRelativeURI _srcRelativePath = loc.location.getSrcRelativePath();
        boolean bl = _tripleNotEquals = _srcRelativePath != null;
        if (_tripleNotEquals) {
            SourceRelativeURI _srcRelativePath_1 = loc.location.getSrcRelativePath();
            _xifexpression_1 = "," + _srcRelativePath_1;
        } else {
            _xifexpression_1 = "";
        }
        String path = _xifexpression_1;
        int _offset = loc.location.getOffset();
        String _plus = String.valueOf(prefix) + name + "[" + Integer.valueOf(_offset);
        String _plus_1 = String.valueOf(_plus) + ",";
        int _length = loc.location.getLength();
        String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_length);
        String _plus_3 = String.valueOf(_plus_2) + path;
        return String.valueOf(_plus_3) + "]";
    }

    protected void render(RegionHandle region, int idW, int offsetW, int lengthW, int indent, List<String> result) {
        String _string = Integer.toString(region.id, this.radix);
        String id = Strings.padStart((String)_string, (int)idW, (char)'0');
        String _xifexpression = null;
        boolean _isUseForDebugging = region.region.isUseForDebugging();
        _xifexpression = _isUseForDebugging ? "D" : " ";
        String debug = _xifexpression;
        int _myOffset = region.region.getMyOffset();
        String _string_1 = Integer.toString(_myOffset);
        String offset = Strings.padStart((String)_string_1, (int)offsetW, (char)'0');
        int _myLength = region.region.getMyLength();
        String _string_2 = Integer.toString(_myLength);
        String length = Strings.padStart((String)_string_2, (int)lengthW, (char)'0');
        String space = Strings.repeat((String)" ", (int)indent);
        Class<?> _class = region.region.getClass();
        String name = _class.getSimpleName();
        Functions.Function1<LocationHandle, String> _function = new Functions.Function1<LocationHandle, String>(){

            public String apply(LocationHandle it) {
                return AbstractTraceRegionToString.this.render(it);
            }
        };
        List _map = ListExtensions.map((List)region.locations, (Functions.Function1)_function);
        String locations = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        String loc = String.valueOf(debug) + " " + offset + "-" + length + space;
        String header = String.valueOf(id) + ": " + loc + name + " -> " + locations;
        boolean _isEmpty = region.children.isEmpty();
        if (_isEmpty) {
            result.add(header);
        } else {
            result.add(String.valueOf(header) + " {");
            for (RegionHandle child : region.children) {
                this.render(child, idW, offsetW, lengthW, indent + 2, result);
            }
            int _length = loc.length();
            String _repeat = Strings.repeat((String)" ", (int)_length);
            String _plus = String.valueOf(id) + ": " + _repeat;
            String _plus_1 = String.valueOf(_plus) + "}";
            result.add(_plus_1);
        }
    }

    protected String render() {
        File localFile = new File(null);
        LinkedHashMap remoteFiles = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        ArrayList roothandles = CollectionLiterals.newArrayList((Object[])new RegionHandle[0]);
        AbstractTraceRegion _trace = this.getTrace();
        int maxid = this.collect(_trace, 1, localFile, remoteFiles, roothandles);
        String _string = Integer.toString(maxid, this.radix);
        int idwidth = _string.length();
        List<String> _render = this.render(localFile, idwidth);
        Iterables.addAll((Collection)localFile.lines, _render);
        Collection _values = remoteFiles.values();
        for (File file : _values) {
            List<String> _render_1 = this.render(file, idwidth);
            Iterables.addAll((Collection)file.lines, _render_1);
        }
        Functions.Function1<String, Integer> _function = new Functions.Function1<String, Integer>(){

            public Integer apply(String it) {
                return it.length();
            }
        };
        List _map = ListExtensions.map((List)localFile.lines, (Functions.Function1)_function);
        Integer _max = (Integer)IterableExtensions.max((Iterable)_map);
        String _localTitle = this.getLocalTitle();
        int _length = _localTitle.length();
        int _plus = _length + 2;
        int localWidth = Math.max(_max, _plus);
        Collection _values_1 = remoteFiles.values();
        Functions.Function1<File, Integer> _function_1 = new Functions.Function1<File, Integer>(){

            public Integer apply(File it) {
                Functions.Function1<String, Integer> _function = new Functions.Function1<String, Integer>(){

                    public Integer apply(String it) {
                        return it.length();
                    }
                };
                List _map = ListExtensions.map((List)it.lines, (Functions.Function1)_function);
                Integer _max = (Integer)IterableExtensions.max((Iterable)_map);
                String _remoteTitle = AbstractTraceRegionToString.this.getRemoteTitle(it.uri);
                int _length = _remoteTitle.length();
                int _plus = _length + 2;
                return Math.max(_max, _plus);
            }
        };
        Iterable _map_1 = IterableExtensions.map(_values_1, (Functions.Function1)_function_1);
        Integer remoteWidth = (Integer)IterableExtensions.max((Iterable)_map_1);
        String _title = this.title(null, localWidth);
        localFile.lines.add(0, _title);
        Collection _values_2 = remoteFiles.values();
        for (File file_1 : _values_2) {
            String _title_1 = this.title(file_1.uri, remoteWidth);
            file_1.lines.add(0, _title_1);
        }
        List left = localFile.lines;
        Collection _values_3 = remoteFiles.values();
        Functions.Function1<File, List<String>> _function_2 = new Functions.Function1<File, List<String>>(){

            public List<String> apply(File it) {
                return it.lines;
            }
        };
        Iterable _map_2 = IterableExtensions.map(_values_3, (Functions.Function1)_function_2);
        Iterable _flatten = Iterables.concat((Iterable)_map_2);
        List right = IterableExtensions.toList((Iterable)_flatten);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new String[0]);
        if (this.showLegend) {
            result.add("Regions are surrounded by [N[ ... ]N]. Regions on the left and right with the same N are associated.");
        }
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)left, Object.class)).length || i < ((Object[])Conversions.unwrapArray((Object)right, Object.class)).length) {
            String _xifexpression = null;
            int _size = left.size();
            boolean _lessThan = i < _size;
            _xifexpression = _lessThan ? (String)left.get(i) : "";
            String l = Strings.padEnd((String)_xifexpression, (int)localWidth, (char)' ');
            String _xifexpression_1 = null;
            int _size_1 = right.size();
            boolean _lessThan_1 = i < _size_1;
            _xifexpression_1 = _lessThan_1 ? (String)right.get(i) : "";
            String r = _xifexpression_1;
            result.add(String.valueOf(l) + " | " + r);
            ++i;
        }
        if (this.showTree) {
            String _repeat = Strings.repeat((String)"-", (int)(localWidth + remoteWidth + 3));
            result.add(_repeat);
            if (this.showLegend) {
                result.add("<N>: <isDebug> <offset>-<length> <RegionJavaClass> -> <LocationJavaClass>[<offset>,<length>,<uri>]");
            }
            Functions.Function1<RegionHandle, Set<RegionHandle>> _function_3 = new Functions.Function1<RegionHandle, Set<RegionHandle>>(){

                public Set<RegionHandle> apply(RegionHandle it) {
                    Functions.Function1<RegionHandle, Iterable<RegionHandle>> _function = new Functions.Function1<RegionHandle, Iterable<RegionHandle>>(){

                        public Iterable<RegionHandle> apply(RegionHandle it) {
                            return it.children;
                        }
                    };
                    return AbstractTraceRegionToString.this.collect(it, _function);
                }
            };
            List _map_3 = ListExtensions.map((List)roothandles, (Functions.Function1)_function_3);
            Iterable allhandles = Iterables.concat((Iterable)_map_3);
            Functions.Function1<RegionHandle, Integer> _function_4 = new Functions.Function1<RegionHandle, Integer>(){

                public Integer apply(RegionHandle it) {
                    return it.region.getMyOffset();
                }
            };
            Iterable _map_4 = IterableExtensions.map((Iterable)allhandles, (Functions.Function1)_function_4);
            Integer _max_1 = (Integer)IterableExtensions.max((Iterable)_map_4);
            String _valueOf = String.valueOf(_max_1);
            int offsetWidth = _valueOf.length();
            Functions.Function1<RegionHandle, Integer> _function_5 = new Functions.Function1<RegionHandle, Integer>(){

                public Integer apply(RegionHandle it) {
                    return it.region.getMyLength();
                }
            };
            Iterable _map_5 = IterableExtensions.map((Iterable)allhandles, (Functions.Function1)_function_5);
            Integer _max_2 = (Integer)IterableExtensions.max((Iterable)_map_5);
            String _valueOf_1 = String.valueOf(_max_2);
            int lengthWidth = _valueOf_1.length();
            for (RegionHandle handle : roothandles) {
                this.render(handle, idwidth, offsetWidth, lengthWidth, 1, result);
            }
        }
        String _newLine = org.eclipse.xtext.util.Strings.newLine();
        return IterableExtensions.join((Iterable)result, (CharSequence)_newLine);
    }

    public String toString() {
        String _xtrycatchfinallyexpression = null;
        try {
            return this.render();
        }
        catch (Throwable _t) {
            if (!(_t instanceof Exception)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Exception e = (Exception)_t;
            _xtrycatchfinallyexpression = Throwables.getStackTraceAsString((Throwable)e);
            return _xtrycatchfinallyexpression;
        }
    }

    @Pure
    public int getRadix() {
        return this.radix;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    @Pure
    public boolean isShowTree() {
        return this.showTree;
    }

    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    @Pure
    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    @Accessors
    protected static class File {
        private final SourceRelativeURI uri;
        private final List<Insert> inserts = CollectionLiterals.newArrayList((Object[])new Insert[0]);
        private final List<String> lines = CollectionLiterals.newArrayList((Object[])new String[0]);

        public File(SourceRelativeURI uri) {
            this.uri = uri;
        }

        @Pure
        public SourceRelativeURI getUri() {
            return this.uri;
        }

        @Pure
        public List<Insert> getInserts() {
            return this.inserts;
        }

        @Pure
        public List<String> getLines() {
            return this.lines;
        }
    }

    @Accessors
    protected static class Insert {
        private final int offset;
        private final boolean open;
        private final RegionHandle region;
        private final LocationHandle location;

        public Insert(int offset, boolean open, RegionHandle region, LocationHandle location) {
            this.offset = offset;
            this.open = open;
            this.region = region;
            this.location = location;
        }

        @Pure
        public int getOffset() {
            return this.offset;
        }

        @Pure
        public boolean isOpen() {
            return this.open;
        }

        @Pure
        public RegionHandle getRegion() {
            return this.region;
        }

        @Pure
        public LocationHandle getLocation() {
            return this.location;
        }
    }

    @Accessors
    protected static class LocationHandle {
        private final RegionHandle region;
        private final int id;
        private final ILocationData location;

        public LocationHandle(RegionHandle region, int id, ILocationData location) {
            this.region = region;
            this.id = id;
            this.location = location;
        }

        @Pure
        public RegionHandle getRegion() {
            return this.region;
        }

        @Pure
        public int getId() {
            return this.id;
        }

        @Pure
        public ILocationData getLocation() {
            return this.location;
        }
    }

    @Accessors
    protected static class RegionHandle {
        private final int id;
        private final AbstractTraceRegion region;
        private final List<LocationHandle> locations = CollectionLiterals.newArrayList((Object[])new LocationHandle[0]);
        private final List<RegionHandle> children = CollectionLiterals.newArrayList((Object[])new RegionHandle[0]);

        public RegionHandle(int id, AbstractTraceRegion region) {
            this.id = id;
            this.region = region;
        }

        @Pure
        public int getId() {
            return this.id;
        }

        @Pure
        public AbstractTraceRegion getRegion() {
            return this.region;
        }

        @Pure
        public List<LocationHandle> getLocations() {
            return this.locations;
        }

        @Pure
        public List<RegionHandle> getChildren() {
            return this.children;
        }
    }
}

