/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Activator;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilderWrapperImpl;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    private HttpServiceRuntimeImpl httpServiceRuntimeImpl;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.unregisterHttpService(this);
        super.destroy();
    }

    public void setHttpServiceRuntimeImpl(HttpServiceRuntimeImpl httpServiceRuntimeImpl) {
        this.httpServiceRuntimeImpl = httpServiceRuntimeImpl;
    }

    public void sessionIdChanged(String oldSessionId) {
        this.httpServiceRuntimeImpl.fireSessionIdChanged(oldSessionId);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkRuntime();
        String alias = HttpServletRequestBuilderWrapperImpl.getDispatchPathInfo(request);
        if (alias == null) {
            alias = "/";
        }
        if (this.httpServiceRuntimeImpl.doDispatch(request, response, alias)) {
            return;
        }
        response.sendError(404, "ProxyServlet: " + alias);
    }

    private void checkRuntime() {
        if (this.httpServiceRuntimeImpl == null) {
            throw new IllegalStateException("Proxy servlet not properly initialized. httpServiceRuntimeImpl is null");
        }
    }
}

