/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;

public class PdaToDot<STATE, STACKITEM>
extends GraphvizDotBuilder {
    protected Function<STACKITEM, String> popFormatter;
    protected Function<STACKITEM, String> pushFormatter;
    protected Function<STATE, String> stateFormatter;

    protected GraphvizDotBuilder.Node create(GraphvizDotBuilder.Digraph result, Pda<STATE, STACKITEM> pda, STATE state) {
        GraphvizDotBuilder.Node n = new GraphvizDotBuilder.Node(state, this.stateToString(pda, state));
        if (state == pda.getStart() || state == pda.getStop()) {
            n.setShape("diamond");
        }
        return n;
    }

    protected GraphvizDotBuilder.Edge create(GraphvizDotBuilder.Digraph result, Pda<STATE, STACKITEM> pda, STATE from, STATE to) {
        return new GraphvizDotBuilder.Edge(from, to);
    }

    protected void draw(GraphvizDotBuilder.Digraph result, Pda<STATE, STACKITEM> pda) {
        for (Object s : new NfaUtil().collect(pda)) {
            result.add(this.create(result, pda, s));
            for (Object f : pda.getFollowers(s)) {
                result.add(this.create(result, pda, s, f));
            }
        }
    }

    @Override
    protected GraphvizDotBuilder.Props drawObject(Object obj) {
        GraphvizDotBuilder.Digraph result = new GraphvizDotBuilder.Digraph();
        if (obj instanceof Pda) {
            this.draw(result, (Pda)obj);
        }
        return result;
    }

    public PdaToDot<STATE, STACKITEM> setPopFormatter(Function<STACKITEM, String> popFormatter) {
        this.popFormatter = popFormatter;
        return this;
    }

    public PdaToDot<STATE, STACKITEM> setPushFormatter(Function<STACKITEM, String> pushFormatter) {
        this.pushFormatter = pushFormatter;
        return this;
    }

    public PdaToDot<STATE, STACKITEM> setStateFormatter(Function<STATE, String> stateFormatter) {
        this.stateFormatter = stateFormatter;
        return this;
    }

    protected String stateToString(Pda<STATE, STACKITEM> pda, STATE state) {
        String prefix;
        STACKITEM push = pda.getPush(state);
        STACKITEM pop = pda.getPop(state);
        if (this.pushFormatter != null && push != null) {
            return (String)this.pushFormatter.apply(push);
        }
        if (this.popFormatter != null && pop != null) {
            return (String)this.popFormatter.apply(pop);
        }
        String string = push != null && pop != null ? "<>" : (push != null ? ">>" : (prefix = pop != null ? "<<" : ""));
        if (this.stateFormatter != null) {
            String fmt = (String)this.stateFormatter.apply(state);
            return fmt.startsWith(prefix) ? fmt : String.valueOf(prefix) + fmt;
        }
        if (state == null) {
            return String.valueOf(prefix) + "null";
        }
        String fmt = state.toString();
        return fmt.startsWith(prefix) ? fmt : String.valueOf(prefix) + fmt;
    }
}

