/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.fx.core.Subscription;

public interface ThreadSynchronize {
    public <V> V syncExec(Callable<V> var1, V var2);

    default public <T, R> R syncExec(T value, Function<T, R> function, R defaultValue) {
        Callable<Object> c = () -> function.apply(value);
        return (R)this.syncExec(c, defaultValue);
    }

    public void syncExec(Runnable var1);

    public <V> Future<V> asyncExec(Callable<V> var1);

    public void asyncExec(Runnable var1);

    default public <T> void asyncExec(T value, Consumer<T> consumer) {
        this.asyncExec(() -> consumer.accept(value));
    }

    public Subscription scheduleExecution(long var1, Runnable var3);

    public <T> CompletableFuture<T> scheduleExecution(long var1, Callable<T> var3);

    default public <T> Subscription delayedChangeExecution(final long delay, final Property<T> property, final Consumer<T> consumer) {
        final ChangeListener l = new ChangeListener<T>(){
            private Subscription currentSubscription;

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                if (this.currentSubscription != null) {
                    this.currentSubscription.dispose();
                }
                this.currentSubscription = ThreadSynchronize.this.scheduleExecution(delay, () -> {
                    consumer.accept(newValue);
                    this.currentSubscription = null;
                });
            }
        };
        property.addListener(l);
        return new Subscription(){

            @Override
            public void dispose() {
                property.removeListener(l);
            }
        };
    }

    default public Runnable wrap(Runnable r) {
        return () -> this.asyncExec(r);
    }

    default public <T> Consumer<T> wrap(Consumer<T> c) {
        return t -> this.asyncExec(() -> c.accept(t));
    }

    default public <T, U> BiConsumer<T, U> wrap(BiConsumer<T, U> c) {
        return (t, u) -> this.asyncExec(() -> c.accept(t, u));
    }

    default public <T> Supplier<T> wrap(Supplier<T> s) {
        return () -> this.syncExec(() -> ThreadSynchronize.lambda$8((Supplier)s), null);
    }

    private static /* synthetic */ Object lambda$8(Supplier supplier) throws Exception {
        return supplier.get();
    }

    public static class BlockCondition<T> {
        List<Consumer<T>> callbacks = new ArrayList<Consumer<T>>();
        private boolean isBlocked = true;

        public Subscription subscribeUnblockedCallback(final Consumer<T> r) {
            if (!this.isBlocked) {
                throw new IllegalStateException();
            }
            this.callbacks.add(r);
            return new Subscription(){

                @Override
                public void dispose() {
                    callbacks.remove(r);
                }
            };
        }

        public boolean isBlocked() {
            return this.isBlocked;
        }

        public void release(T value) {
            for (Consumer<T> r : this.callbacks) {
                r.accept(value);
            }
            this.callbacks.clear();
            this.isBlocked = false;
        }
    }
}

