/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LengthAdjust implements Enumerator
{
    SPACING(0, "spacing", "spacing"),
    SPACING_AND_GLYPHS(1, "spacingAndGlyphs", "spacingAndGlyphs");

    public static final int SPACING_VALUE = 0;
    public static final int SPACING_AND_GLYPHS_VALUE = 1;
    private static final LengthAdjust[] VALUES_ARRAY;
    public static final List<LengthAdjust> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LengthAdjust[]{SPACING, SPACING_AND_GLYPHS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LengthAdjust get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LengthAdjust result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LengthAdjust getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LengthAdjust result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LengthAdjust get(int value) {
        switch (value) {
            case 0: {
                return SPACING;
            }
            case 1: {
                return SPACING_AND_GLYPHS;
            }
        }
        return null;
    }

    private LengthAdjust(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

