/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.SourceFileChange;
import org.eclipse.fx.code.editor.SourceFileInput;
import org.eclipse.fx.core.adapter.Adapt;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.function.ExExecutor;

public class LocalSourceFileInput
implements SourceFileInput {
    private final Path path;
    private final Charset charSet;
    private String data;
    private EventBus eventBus;
    private Map<String, Object> transientData = new HashMap<String, Object>();

    @Inject
    public LocalSourceFileInput(@Adapt @Named(value="documentUrl") Path path, @Optional EventBus eventBus) {
        this(path, StandardCharsets.UTF_8, eventBus);
    }

    public LocalSourceFileInput(Path path, Charset charSet, @Optional EventBus eventBus) {
        this.path = path;
        this.charSet = charSet;
        this.eventBus = eventBus;
    }

    @Override
    public Map<String, Object> getTransientData() {
        return this.transientData;
    }

    @PostConstruct
    protected void init() {
        if (this.eventBus != null) {
            this.eventBus.publish(Constants.TOPIC_SOURCE_FILE_INPUT_CREATED, (Object)this, true);
        }
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    @PreDestroy
    public final void dispose() {
        this.doDispose();
    }

    protected void doDispose() {
        if (this.eventBus != null) {
            this.eventBus.publish(Constants.TOPIC_SOURCE_FILE_INPUT_DISPOSED, (Object)this, true);
        }
    }

    @Override
    public String getData() {
        if (this.data == null) {
            try {
                byte[] bytes = Files.readAllBytes(this.path);
                this.data = new String(bytes, this.charSet);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read file content of '" + this.path + "'", e);
            }
        }
        return this.data;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public void persist() {
        try {
            Files.write(this.path, this.data.getBytes(this.charSet), new OpenOption[0]);
            if (this.eventBus != null) {
                this.eventBus.publish(Constants.TOPIC_SOURCE_FILE_INPUT_SAVED, (Object)this, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write content to file '" + this.path + "'", e);
        }
    }

    @Override
    public String getURI() {
        return ExExecutor.executeSupplier(() -> this.path.toUri().toURL().toExternalForm(), (String)("Could not retrieve URI from '" + this.path + "'")).orElse(null);
    }

    @Override
    public void updateData(int offset, int length, String replacement) {
        StringBuilder b = new StringBuilder(this.data.length() - length + replacement.length());
        b.append(this.data.substring(0, offset));
        b.append(replacement);
        b.append(this.data.substring(offset + length, this.data.length()));
        this.data = b.toString();
        if (this.eventBus != null) {
            SourceFileChange sourceChange = new SourceFileChange(this, offset, length, replacement);
            this.eventBus.publish(Constants.TOPIC_SOURCE_FILE_INPUT_MODIFIED, (Object)sourceChange, true);
        }
    }
}

