/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import com.google.common.base.Strings;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.fx.core.ObjectSerializer;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.core.ValueSerializer;
import org.eclipse.fx.core.di.context.internal.PreferenceValue;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.preferences.PreferenceDefaultValueFactory;
import org.eclipse.fx.core.preferences.Value;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={ExtendedObjectSupplier.class}, property={"dependency.injection.annotation=org.eclipse.fx.core.preferences.Preference"})
public class PreferenceValueSupplier
extends ExtendedObjectSupplier {
    private Map<String, HashMap<String, List<PrefInjectionListener>>> listenerCache = new HashMap<String, HashMap<String, List<PrefInjectionListener>>>();
    private static Logger LOGGER;
    private static ValueSerializer serializer;
    private static ObjectSerializer objectSerializer;
    private static IPreferencesService preferenceService;

    private static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = LoggerCreator.createLogger(PreferenceValueSupplier.class);
        }
        return LOGGER;
    }

    private static ValueSerializer getValueSerializer() {
        if (serializer == null) {
            serializer = (ValueSerializer)Util.lookupService(ValueSerializer.class);
        }
        return serializer;
    }

    private static ObjectSerializer getObjectSerializer() {
        if (objectSerializer == null) {
            objectSerializer = (ObjectSerializer)Util.lookupService(ObjectSerializer.class);
        }
        return objectSerializer;
    }

    private static IPreferencesService getPreferenceService() {
        if (preferenceService == null) {
            preferenceService = (IPreferencesService)Util.lookupService(IPreferencesService.class);
        }
        return preferenceService;
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        ObjectSerializer objectSerializer;
        Class factory;
        if (descriptor == null) {
            return null;
        }
        Class<?> descriptorsClass = PreferenceValueSupplier.getDesiredClass(descriptor.getDesiredType());
        if (descriptorsClass == null) {
            return null;
        }
        String nodePath = PreferenceValueSupplier.getNodePath(descriptor, requestor.getRequestingObjectClass());
        if (nodePath == null || nodePath.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(nodePath);
        if (preferences == null) {
            return IInjector.NOT_A_VALUE;
        }
        String key = PreferenceValueSupplier.getKey(descriptor);
        if (key == null || key.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        Preference p = (Preference)descriptor.getQualifier(Preference.class);
        String defaultValue = p.defaultValue();
        if ("EFX__NO_VALUE__".equals(defaultValue)) {
            defaultValue = null;
        }
        if ((factory = p.factory()) == PreferenceDefaultValueFactory.class) {
            factory = null;
        }
        if (descriptorsClass.equals(Boolean.TYPE) || descriptorsClass.equals(Boolean.class) || descriptorsClass.equals(Integer.TYPE) || descriptorsClass.equals(Integer.class) || descriptorsClass.equals(Double.TYPE) || descriptorsClass.equals(Double.class) || descriptorsClass.equals(Float.TYPE) || descriptorsClass.equals(Float.class) || descriptorsClass.equals(Long.TYPE) || descriptorsClass.equals(Long.class) || descriptorsClass.equals(String.class)) {
            if (track) {
                this.addListener(nodePath, key, requestor);
            }
            Object v = PreferenceValueSupplier.getDefault(defaultValue, descriptorsClass, p, factory);
            return PreferenceValueSupplier.getValue(nodePath, key, descriptorsClass, v);
        }
        ValueSerializer valueSerializer = PreferenceValueSupplier.getValueSerializer();
        if (valueSerializer != null && valueSerializer.test(descriptorsClass)) {
            if (track) {
                this.addListener(nodePath, key, requestor);
            }
            Object v = PreferenceValueSupplier.getDefault(defaultValue, descriptorsClass, p, factory);
            return PreferenceValueSupplier.getValue(nodePath, key, descriptorsClass, v);
        }
        Requestor r = (Requestor)requestor;
        PreferenceValue v = (PreferenceValue)r.getInjector().make(PreferenceValue.class, r.getPrimarySupplier());
        if (descriptorsClass != Value.class && !v.canAdaptTo(descriptorsClass) && (objectSerializer = PreferenceValueSupplier.getObjectSerializer()) != null) {
            if (track) {
                this.addListener(nodePath, key, requestor);
            }
            return PreferenceValueSupplier.getValue(nodePath, key, descriptorsClass, PreferenceValueSupplier.getDefault(defaultValue, descriptorsClass, p, factory));
        }
        Class type = p.type();
        if (type == Object.class && descriptor.getDesiredType() instanceof ParameterizedType) {
            Type t = ((ParameterizedType)descriptor.getDesiredType()).getActualTypeArguments()[0];
            Class clazz = type = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        }
        if (type == Object.class) {
            return IInjector.NOT_A_VALUE;
        }
        v.init(nodePath, key, type, PreferenceValueSupplier.getDefault(defaultValue, type, p, factory));
        if (descriptorsClass != Value.class) {
            return v.adaptTo(descriptorsClass);
        }
        return v;
    }

    private static <T> @Nullable T getDefault(@Nullable String value, @NonNull Class<@NonNull T> type, Preference p, Class<?> factory) {
        if (factory != null) {
            try {
                PreferenceDefaultValueFactory instance = (PreferenceDefaultValueFactory)factory.newInstance();
                return (T)instance.create(p);
            }
            catch (IllegalAccessException | InstantiationException e) {
                PreferenceValueSupplier.getLogger().error("Failed to create instance of '" + factory + "'", (Throwable)e);
            }
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (value == null || value.isEmpty()) {
                return (T)Integer.valueOf(0);
            }
            try {
                return (T)Integer.valueOf(value);
            }
            catch (Throwable t) {
                PreferenceValueSupplier.getLogger().error("Unable to parse provided default value '" + value + "'", t);
                return (T)Integer.valueOf(0);
            }
        }
        if (type == Double.class || type == Double.TYPE) {
            if (value == null || value.isEmpty()) {
                return (T)Double.valueOf(0.0);
            }
            try {
                return (T)Double.valueOf(value);
            }
            catch (Throwable t) {
                PreferenceValueSupplier.getLogger().error("Unable to parse provided default value '" + value + "'", t);
                return (T)Double.valueOf(0.0);
            }
        }
        if (type == Float.class || type == Float.TYPE) {
            if (value == null || value.isEmpty()) {
                return (T)Float.valueOf(0.0f);
            }
            try {
                return (T)Float.valueOf(value);
            }
            catch (Throwable t) {
                PreferenceValueSupplier.getLogger().error("Unable to parse provided default value '" + value + "'", t);
                return (T)Float.valueOf(value);
            }
        }
        if (type == Long.class || type == Long.TYPE) {
            if (value == null || value.isEmpty()) {
                return (T)Long.valueOf(0L);
            }
            try {
                return (T)Long.valueOf(value);
            }
            catch (Throwable t) {
                PreferenceValueSupplier.getLogger().error("Unable to parse provided default value '" + value + "'", t);
                return (T)Long.valueOf(0L);
            }
        }
        if (type == String.class) {
            return (T)value;
        }
        if (value != null) {
            ValueSerializer valueSerializer = PreferenceValueSupplier.getValueSerializer();
            if (valueSerializer != null && valueSerializer.test(type)) {
                return (T)valueSerializer.fromString(type, value);
            }
            ObjectSerializer objectSerializer = PreferenceValueSupplier.getObjectSerializer();
            if (objectSerializer != null) {
                return (T)objectSerializer.deserialize(type, value);
            }
        }
        return (T)((Object)null);
    }

    public static <T> T getValue(String path, String key, Class<T> type, T defaultValue) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(PreferenceValueSupplier.getPreferenceService().getBoolean(path, key, ((Boolean)defaultValue).booleanValue(), null));
            }
            if (type.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(PreferenceValueSupplier.getPreferenceService().getInt(path, key, ((Integer)defaultValue).intValue(), null));
            }
            if (type.equals(Double.TYPE)) {
                return (T)Double.valueOf(PreferenceValueSupplier.getPreferenceService().getDouble(path, key, ((Double)defaultValue).doubleValue(), null));
            }
            if (type.equals(Float.TYPE)) {
                return (T)Float.valueOf(PreferenceValueSupplier.getPreferenceService().getFloat(path, key, ((Float)defaultValue).floatValue(), null));
            }
            if (type.equals(Long.TYPE)) {
                return (T)Long.valueOf(PreferenceValueSupplier.getPreferenceService().getLong(path, key, ((Long)defaultValue).longValue(), null));
            }
        }
        if (String.class.equals(type) || CharSequence.class.equals(type)) {
            String v = null;
            if (defaultValue != null) {
                v = defaultValue.toString();
            }
            return (T)PreferenceValueSupplier.getPreferenceService().getString(path, key, v, null);
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(PreferenceValueSupplier.getPreferenceService().getBoolean(path, key, ((Boolean)defaultValue).booleanValue(), null));
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(PreferenceValueSupplier.getPreferenceService().getInt(path, key, ((Integer)defaultValue).intValue(), null));
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(PreferenceValueSupplier.getPreferenceService().getDouble(path, key, ((Double)defaultValue).doubleValue(), null));
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(PreferenceValueSupplier.getPreferenceService().getFloat(path, key, ((Float)defaultValue).floatValue(), null));
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(PreferenceValueSupplier.getPreferenceService().getLong(path, key, ((Long)defaultValue).longValue(), null));
        }
        String value = PreferenceValueSupplier.getPreferenceService().getString(path, key, null, null);
        if (value != null) {
            ValueSerializer valueSerializer = PreferenceValueSupplier.getValueSerializer();
            if (valueSerializer != null && valueSerializer.test(type)) {
                return (T)valueSerializer.fromString(type, value);
            }
            ObjectSerializer objectSerializer = PreferenceValueSupplier.getObjectSerializer();
            if (objectSerializer != null) {
                return (T)objectSerializer.deserialize(type, value);
            }
        }
        return defaultValue;
    }

    private static @Nullable Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private static String getKey(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        return qualifier.key();
    }

    private static String getNodePath(IObjectDescriptor descriptor, Class<?> requestingObject) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        String nodePath = qualifier.nodePath();
        if (Strings.isNullOrEmpty((String)nodePath)) {
            if (requestingObject == null) {
                return null;
            }
            nodePath = FrameworkUtil.getBundle(requestingObject).getSymbolicName();
        }
        return nodePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String nodePath, String key, IRequestor requestor) {
        if (requestor == null) {
            return;
        }
        Map<String, HashMap<String, List<PrefInjectionListener>>> map = this.listenerCache;
        synchronized (map) {
            HashMap<String, List<PrefInjectionListener>> map2;
            if (this.listenerCache.containsKey(nodePath) && (map2 = this.listenerCache.get(nodePath)).containsKey(key)) {
                for (PrefInjectionListener listener : map2.get(key)) {
                    IRequestor previousRequestor = listener.getRequestor();
                    if (!previousRequestor.equals(requestor)) continue;
                    return;
                }
            }
        }
        IEclipsePreferences instanceNode = InstanceScope.INSTANCE.getNode(nodePath);
        PrefInjectionListener listener = new PrefInjectionListener(instanceNode, key, requestor);
        instanceNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        IEclipsePreferences configNode = ConfigurationScope.INSTANCE.getNode(nodePath);
        configNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode(nodePath);
        defaultNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        Map<String, HashMap<String, List<PrefInjectionListener>>> map3 = this.listenerCache;
        synchronized (map3) {
            List<PrefInjectionListener> listeningRequestors;
            HashMap<String, List<PrefInjectionListener>> map4 = this.listenerCache.get(nodePath);
            if (map4 == null) {
                map4 = new HashMap();
                this.listenerCache.put(nodePath, map4);
            }
            if ((listeningRequestors = map4.get(key)) == null) {
                listeningRequestors = new ArrayList<PrefInjectionListener>();
                map4.put(key, listeningRequestors);
            }
            listeningRequestors.add(listener);
        }
    }

    private static class PrefInjectionListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IRequestor requestor;
        private final IEclipsePreferences node;
        private final String key;

        public PrefInjectionListener(IEclipsePreferences node, String key, IRequestor requestor) {
            this.node = node;
            this.key = key;
            this.requestor = requestor;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!this.requestor.isValid()) {
                this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                return;
            }
            if (!event.getKey().equals(this.key)) {
                return;
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }
    }
}

