/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.widget;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPropertyChangeHandler;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;

public abstract class WWidgetImpl<N, M extends MUIElement>
implements WWidget<M> {
    private N nativeWidget;
    private M domElement;
    private List<WCallback<Boolean, Void>> activationCallbacks = new ArrayList<WCallback<Boolean, Void>>();
    private boolean active;
    protected WWidget.WidgetState state = WWidget.WidgetState.IN_SETUP;
    private WPropertyChangeHandler<? extends WWidget<M>> propertyChangeHandler;

    protected abstract N createWidget();

    public void setWidgetState(WWidget.WidgetState state) {
        this.state = state;
    }

    public WWidget.WidgetState getWidgetState() {
        return this.state;
    }

    public void activate() {
        this.active = true;
        if (this.activationCallbacks != null) {
            for (WCallback<Boolean, Void> c : this.activationCallbacks) {
                c.call((Object)Boolean.TRUE);
            }
        }
    }

    public void deactivate() {
        this.active = false;
        if (this.activationCallbacks != null) {
            for (WCallback<Boolean, Void> c : this.activationCallbacks) {
                c.call((Object)Boolean.FALSE);
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void registerActivationCallback(WCallback<Boolean, Void> callback) {
        if (this.activationCallbacks != null) {
            this.activationCallbacks.add(callback);
        }
    }

    @PostConstruct
    protected void init() {
        this.getWidget();
    }

    @PreDestroy
    void destroy() {
        if (this.nativeWidget != null) {
            this.setUserData(null);
        }
        this.propertyChangeHandler = null;
        this.domElement = null;
        this.activationCallbacks.clear();
        this.activationCallbacks = null;
        this.doCleanup();
    }

    protected void doCleanup() {
    }

    public final void setDomElement(M domElement) {
        this.domElement = domElement;
    }

    public M getDomElement() {
        return this.domElement;
    }

    public N getWidget() {
        if (this.nativeWidget == null) {
            this.nativeWidget = this.createWidget();
            this.bindProperties(this.nativeWidget);
            this.setUserData(this);
        }
        return this.nativeWidget;
    }

    protected void bindProperties(N widget) {
    }

    protected void bindProperty(final String propertyName, ObservableValue<? extends Object> value) {
        value.addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                WWidgetImpl.this.fireChange(propertyName, newValue);
            }
        });
    }

    protected abstract void setUserData(WWidgetImpl<N, M> var1);

    public void setPropertyChangeHandler(WPropertyChangeHandler<? extends WWidget<M>> propertyChangeHandler) {
        this.propertyChangeHandler = propertyChangeHandler;
    }

    protected void fireChange(String propertyName, Object newValue) {
        if (this.propertyChangeHandler != null) {
            WPropertyChangeHandler.WPropertyChangeEvent e = new WPropertyChangeHandler.WPropertyChangeEvent((WWidget)this, propertyName, newValue);
            this.propertyChangeHandler.propertyObjectChanged(e);
        }
    }
}

