/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.ecore;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenRuntimeVersion;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenPackageImpl;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe2.ecore.CvsIdFilteringGeneratorAdapterFactoryDescriptor;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.util.GenModelUtil2;

@Log
public class EMFGeneratorFragment2
extends AbstractXtextGeneratorFragment {
    @Inject
    private CodeConfig codeConfig;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String basePackage;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String modelPluginID;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String javaModelDirectory;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateEdit = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editPluginID;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editDirectory;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateEditor = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editorPluginID;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String editorDirectory;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private String genModel;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean skipGenerate = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean updateBuildProperties = true;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean longFileNames = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean suppressLoadInitialization = false;
    private GenRuntimeVersion emfRuntimeVersion;
    private GenJDKLevel jdkLevel = GenJDKLevel.JDK60_LITERAL;
    private boolean bindEPackageAndEFactory = false;
    private static final Logger LOG = Logger.getLogger(EMFGeneratorFragment2.class);

    public void setEmfRuntimeVersion(String emfRuntimeVersion) {
        this.emfRuntimeVersion = GenRuntimeVersion.get((String)emfRuntimeVersion);
        if (this.emfRuntimeVersion == null) {
            LOG.warn((Object)("Illegal EMF runtime version: " + emfRuntimeVersion));
        }
    }

    public void setJdkLevel(String jdkLevel) {
        this.jdkLevel = GenJDKLevel.getByName((String)jdkLevel);
        if (this.jdkLevel == null) {
            LOG.warn((Object)("Illegal JDK level: " + jdkLevel));
        }
    }

    public void setBindEPackageAndEFactory(boolean bindEPackageAndEFactory) {
        this.bindEPackageAndEFactory = bindEPackageAndEFactory;
    }

    protected String getModelPluginID() {
        String _name;
        String _elvis = null;
        _elvis = this.modelPluginID != null ? this.modelPluginID : (_name = this.getProjectConfig().getRuntime().getName());
        return _elvis;
    }

    protected String getJavaModelDirectory() {
        if (this.javaModelDirectory != null) {
            return this.javaModelDirectory;
        }
        String srcGenPath = this.getProjectConfig().getRuntime().getSrcGen().getPath();
        String rootPath = this.getProjectConfig().getRuntime().getRoot().getPath();
        if (!StringExtensions.isNullOrEmpty((String)rootPath) && srcGenPath.startsWith(rootPath)) {
            String _modelPluginID = this.getModelPluginID();
            String _plus = "/" + _modelPluginID;
            String _substring = srcGenPath.substring(rootPath.length());
            return _plus + _substring;
        }
        throw new RuntimeException("Could not derive the Java model directory from the project configuration. Please set the property 'javaModelDirectory' explicitly.");
    }

    protected String getModelName(Grammar grammar) {
        String _xifexpression = null;
        _xifexpression = this.longFileNames ? grammar.getName().replace(".", "_") : GrammarUtil.getSimpleName((Grammar)grammar);
        return _xifexpression;
    }

    protected String getEcoreFilePath(Grammar grammar) {
        String _xblockexpression = null;
        String ecoreModelFolder = this.getProjectConfig().getRuntime().getEcoreModelFolder();
        String _modelPluginID = this.getModelPluginID();
        String _plus = "/" + _modelPluginID;
        String _plus_1 = _plus + "/";
        String _plus_2 = _plus_1 + ecoreModelFolder;
        String _plus_3 = _plus_2 + "/";
        String _modelName = this.getModelName(grammar);
        String _plus_4 = _plus_3 + _modelName;
        _xblockexpression = _plus_4 + ".ecore";
        return _xblockexpression;
    }

    protected URI getEcoreFileUri(Grammar grammar) {
        return URI.createPlatformResourceURI((String)this.getEcoreFilePath(grammar), (boolean)true);
    }

    protected String getGenModelPath(Grammar grammar) {
        String _elvis = null;
        if (this.genModel != null) {
            _elvis = this.genModel;
        } else {
            String _xblockexpression = null;
            String ecoreModelFolder = this.getProjectConfig().getRuntime().getEcoreModelFolder();
            String _modelPluginID = this.getModelPluginID();
            String _plus = "/" + _modelPluginID;
            String _plus_1 = _plus + "/";
            String _plus_2 = _plus_1 + ecoreModelFolder;
            String _plus_3 = _plus_2 + "/";
            String _modelName = this.getModelName(grammar);
            String _plus_4 = _plus_3 + _modelName;
            _elvis = _xblockexpression = _plus_4 + ".genmodel";
        }
        return _elvis;
    }

    protected URI getGenModelUri(Grammar grammar) {
        return URI.createPlatformResourceURI((String)this.getGenModelPath(grammar), (boolean)true);
    }

    protected String getRelativePath(String pathInRoot) {
        String _xblockexpression = null;
        String _name = this.getProjectConfig().getRuntime().getName();
        String projectPath = "/" + _name;
        String _xifexpression = null;
        boolean _startsWith = pathInRoot.startsWith(projectPath);
        if (_startsWith) {
            int _length = projectPath.length();
            int _plus = _length + 1;
            _xifexpression = pathInRoot.substring(_plus);
        } else {
            _xifexpression = pathInRoot;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String getEditPluginID() {
        String _elvis = null;
        if (this.editPluginID != null) {
            _elvis = this.editPluginID;
        } else {
            String _plus;
            String _modelPluginID = this.getModelPluginID();
            _elvis = _plus = _modelPluginID + ".edit";
        }
        return _elvis;
    }

    protected String getEditDirectory() {
        String _elvis = null;
        if (this.editDirectory != null) {
            _elvis = this.editDirectory;
        } else {
            String _plus_1;
            String _editPluginID = this.getEditPluginID();
            String _plus = "/" + _editPluginID;
            _elvis = _plus_1 = _plus + "/src";
        }
        return _elvis;
    }

    protected String getEditorPluginID() {
        String _elvis = null;
        if (this.editorPluginID != null) {
            _elvis = this.editorPluginID;
        } else {
            String _plus;
            String _modelPluginID = this.getModelPluginID();
            _elvis = _plus = _modelPluginID + ".editor";
        }
        return _elvis;
    }

    protected String getEditorDirectory() {
        String _elvis = null;
        if (this.editorDirectory != null) {
            _elvis = this.editorDirectory;
        } else {
            String _plus;
            String _editorPluginID = this.getEditorPluginID();
            _elvis = _plus = _editorPluginID + "/src";
        }
        return _elvis;
    }

    protected String getBasePackage(Grammar grammar) {
        String _namespace;
        String _elvis = null;
        _elvis = this.basePackage != null ? this.basePackage : (_namespace = GrammarUtil.getNamespace((Grammar)grammar));
        return _elvis;
    }

    @Override
    public void initialize(Injector injector) {
        boolean _not;
        super.initialize(injector);
        boolean _containsKey = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("genmodel");
        boolean bl = _not = !_containsKey;
        if (_not) {
            Map _extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
            EcoreResourceFactoryImpl _ecoreResourceFactoryImpl = new EcoreResourceFactoryImpl();
            _extensionToFactoryMap.put("genmodel", _ecoreResourceFactoryImpl);
        }
        GenModelPackage.eINSTANCE.getGenAnnotation();
    }

    @Override
    public void generate() {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)this.getGrammar().getMetamodelDeclarations(), GeneratedMetamodel.class));
        if (_isEmpty) {
            return;
        }
        try {
            boolean _isEmpty_1;
            boolean _not;
            Grammar clonedGrammar = this.cloneGrammarIntoNewResourceSet(this.getGrammar());
            ResourceSet workingResourceSet = clonedGrammar.eResource().getResourceSet();
            Functions.Function1 _function = it -> it.getEPackage();
            List generatedPackages = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)clonedGrammar.getMetamodelDeclarations(), GeneratedMetamodel.class), (Functions.Function1)_function));
            if (this.genModel != null) {
                this.registerUsedGenModel(workingResourceSet.getURIConverter(), clonedGrammar);
            }
            boolean bl = _not = !(_isEmpty_1 = generatedPackages.isEmpty());
            if (_not) {
                Map<String, EPackage> usedEPackages = this.findAllUsedEPackages(generatedPackages);
                Map<String, EPackage> loadedEPackages = this.findEPackagesInGenPackages(usedEPackages.keySet(), workingResourceSet);
                Map<EObject, EObject> eNamedElementMapping = this.createENamedElementMapping(usedEPackages, loadedEPackages);
                this.replaceReferencesInGeneratedPackages(generatedPackages, eNamedElementMapping);
                Resource ePackageResource = this.createResourceForEPackages(clonedGrammar, generatedPackages, workingResourceSet);
                if (!this.skipGenerate) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Generating EMF model");
                    if (this.generateEdit) {
                        if (this.generateEditor) {
                            _builder.append(", edit");
                        } else {
                            _builder.append(" and edit");
                        }
                    }
                    if (this.generateEditor) {
                        _builder.append(" and editor");
                    }
                    _builder.append(" code");
                    LOG.info((Object)_builder);
                    GenModel genModel = this.getSaveAndReconcileGenModel(clonedGrammar, generatedPackages, workingResourceSet);
                    genModel.reconcile();
                    this.doGenerate(genModel);
                    this.addProjectContributions(clonedGrammar, generatedPackages, workingResourceSet);
                    if (this.bindEPackageAndEFactory) {
                        for (EPackage pkg : generatedPackages) {
                            final GenPackage genPkg = GenModelUtil2.getGenPackage(pkg, genModel.eResource().getResourceSet());
                            GuiceModuleAccess.BindingFactory _bindingFactory = new GuiceModuleAccess.BindingFactory();
                            TypeReference _typeRef = TypeReference.typeRef(genPkg.getQualifiedPackageInterfaceName(), new TypeReference[0]);
                            StringConcatenationClient _client = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    String _packageInterfaceName = genPkg.getPackageInterfaceName();
                                    _builder.append((Object)_packageInterfaceName);
                                    _builder.append((Object)".eINSTANCE");
                                }
                            };
                            GuiceModuleAccess.BindingFactory _addTypeToInstance = _bindingFactory.addTypeToInstance(_typeRef, _client);
                            TypeReference _typeRef_1 = TypeReference.typeRef(genPkg.getQualifiedFactoryInterfaceName(), new TypeReference[0]);
                            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    String _factoryInterfaceName = genPkg.getFactoryInterfaceName();
                                    _builder.append((Object)_factoryInterfaceName);
                                    _builder.append((Object)".eINSTANCE");
                                }
                            };
                            _addTypeToInstance.addTypeToInstance(_typeRef_1, _client_1).contributeTo(this.getLanguage().getRuntimeGenModule());
                        }
                    }
                }
                this.saveResource(ePackageResource);
            }
            this.updateBuildProperties();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                LOG.error((Object)"Failed to execute EMF generator", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected void addProjectContributions(Grammar grammar, List<EPackage> generatedPackages, ResourceSet rs) {
        ManifestAccess _manifest;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        PluginXmlAccess _pluginXml = this.getProjectConfig().getRuntime().getPluginXml();
        boolean bl = _tripleNotEquals = _pluginXml != null;
        if (_tripleNotEquals) {
            List<CharSequence> _entries = this.getProjectConfig().getRuntime().getPluginXml().getEntries();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<extension point=\"org.eclipse.emf.ecore.generated_package\">");
            _builder.newLine();
            for (EPackage pack : generatedPackages) {
                _builder.append("\t");
                _builder.append("<package ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("uri = \"");
                String _nsURI = pack.getNsURI();
                _builder.append(_nsURI, "\t\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("class = \"");
                String _qualifiedPackageInterfaceName = GenModelUtil2.getGenPackage(pack, rs).getQualifiedPackageInterfaceName();
                _builder.append(_qualifiedPackageInterfaceName, "\t\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("genModel = \"");
                String _relativePath = this.getRelativePath(this.getGenModelPath(grammar));
                _builder.append(_relativePath, "\t\t");
                _builder.append("\" />");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("</extension>");
            _builder.newLine();
            _entries.add(_builder.toString());
        }
        boolean bl2 = _tripleNotEquals_1 = (_manifest = this.getProjectConfig().getRuntime().getManifest()) != null;
        if (_tripleNotEquals_1) {
            CollectionExtensions.addAll(this.getProjectConfig().getRuntime().getManifest().getRequiredBundles(), (Object[])new String[]{"org.eclipse.emf.ecore", "org.eclipse.emf.common"});
        }
        for (final EPackage pack_1 : generatedPackages) {
            final GenPackage genPackage = GenModelUtil2.getGenPackage(pack_1, rs);
            if (this.getProjectConfig().getRuntime().getManifest() != null && this.modelPluginID == null) {
                CollectionExtensions.addAll(this.getProjectConfig().getRuntime().getManifest().getExportedPackages(), (Object[])new String[]{genPackage.getInterfacePackageName(), genPackage.getClassPackageName(), genPackage.getUtilitiesPackageName()});
            }
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"if (!");
                    _builder.append(EPackage.class);
                    _builder.append((Object)".Registry.INSTANCE.containsKey(\"");
                    String _nsURI = pack_1.getNsURI();
                    _builder.append((Object)_nsURI);
                    _builder.append((Object)"\")) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append(EPackage.class, "\t");
                    _builder.append((Object)".Registry.INSTANCE.put(\"");
                    String _nsURI_1 = pack_1.getNsURI();
                    _builder.append((Object)_nsURI_1, "\t");
                    _builder.append((Object)"\", ");
                    String _qualifiedPackageInterfaceName = genPackage.getQualifiedPackageInterfaceName();
                    TypeReference _typeReference = new TypeReference(_qualifiedPackageInterfaceName);
                    _builder.append((Object)_typeReference, "\t");
                    _builder.append((Object)".eINSTANCE);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            this.getLanguage().getRuntimeGenSetup().getRegistrations().add(_client);
        }
    }

    private Grammar cloneGrammarIntoNewResourceSet(Grammar original) {
        Resource originalResource = original.eResource();
        XtextResourceSet _xtextResourceSet = new XtextResourceSet();
        XtextResourceSet clonedResourceSet = (XtextResourceSet)EcoreUtil2.clone((ResourceSet)_xtextResourceSet, (ResourceSet)originalResource.getResourceSet());
        Resource clonedResource = clonedResourceSet.getResource(originalResource.getURI(), false);
        EObject _head = (EObject)IterableExtensions.head((Iterable)clonedResource.getContents());
        return (Grammar)_head;
    }

    private void registerUsedGenModel(URIConverter converter, Grammar grammar) {
        URI genModelUri = this.getGenModelUri(grammar);
        boolean _exists = converter.exists(genModelUri, null);
        if (_exists) {
            try {
                GenModelHelper _genModelHelper = new GenModelHelper();
                XtextResourceSet _xtextResourceSet = new XtextResourceSet();
                _genModelHelper.registerGenModel((ResourceSet)_xtextResourceSet, genModelUri);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    LOG.error((Object)"Failed to register GenModel", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    private Map<String, EPackage> findAllUsedEPackages(List<EPackage> generatedPackages) {
        HashMap result = CollectionLiterals.newHashMap();
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            EList _eCrossReferences = current.eCrossReferences();
            for (EObject referenced : _eCrossReferences) {
                EPackage referencedPackage;
                boolean _contains;
                boolean _not;
                boolean _eIsProxy = referenced.eIsProxy();
                if (_eIsProxy) {
                    throw new RuntimeException("Unresolved proxy: " + referenced + " in " + current);
                }
                if (!(referenced instanceof EClassifier) || !(_not = !(_contains = generatedPackages.contains(referencedPackage = ((EClassifier)referenced).getEPackage())))) continue;
                result.put(referencedPackage.getNsURI(), referencedPackage);
            }
        }
        return result;
    }

    private Map<String, EPackage> findEPackagesInGenPackages(Collection<String> packageNsURIs, ResourceSet resourceSet) {
        HashMap result = CollectionLiterals.newHashMap();
        for (String nsURI : packageNsURIs) {
            GenModel loadedGenModel;
            Resource resource = GenModelUtil2.getGenModelResource(null, nsURI, resourceSet);
            if (resource == null || (loadedGenModel = (GenModel)IterableExtensions.head((Iterable)Iterables.filter((Iterable)resource.getContents(), GenModel.class))) == null) continue;
            GenPackage genPackage = this.findGenPackageByNsURI(loadedGenModel, nsURI);
            result.put(nsURI, genPackage.getEcorePackage());
        }
        return result;
    }

    private GenPackage findGenPackageByNsURI(GenModel genModel, String nsURI) {
        List allGenPackages = genModel.getAllGenUsedAndStaticGenPackagesWithClassifiers();
        for (GenPackage genPackage : allGenPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            if (ecorePackage == null || ecorePackage.eIsProxy()) {
                URI _uRI = genModel.eResource().getURI();
                String _plus = "Unresolved proxy: " + ecorePackage + " in " + _uRI;
                throw new RuntimeException(_plus);
            }
            String _nsURI = ecorePackage.getNsURI();
            boolean _equals = Objects.equal((Object)nsURI, (Object)_nsURI);
            if (!_equals) continue;
            return genPackage;
        }
        URI _uRI = genModel.eResource().getURI();
        String _plus = "No GenPackage for NsURI " + nsURI + " found in " + _uRI;
        throw new RuntimeException(_plus);
    }

    private Map<EObject, EObject> createENamedElementMapping(Map<String, EPackage> usedEPackages, Map<String, EPackage> loadedEPackages) {
        HashMap result = CollectionLiterals.newHashMap();
        Set<Map.Entry<String, EPackage>> _entrySet = usedEPackages.entrySet();
        for (Map.Entry<String, EPackage> entry : _entrySet) {
            this.putMappingData(result, entry.getValue(), loadedEPackages.get(entry.getKey()));
        }
        return result;
    }

    private void putMappingData(Map<EObject, EObject> result, EPackage usedEPackage, EPackage loadedEPackage) {
        if (loadedEPackage != null && !Objects.equal((Object)usedEPackage, (Object)loadedEPackage)) {
            result.put((EObject)usedEPackage, (EObject)loadedEPackage);
            EList _eClassifiers = usedEPackage.getEClassifiers();
            for (EClassifier usedClassifier : _eClassifiers) {
                EClassifier loadedClassifier = loadedEPackage.getEClassifier(usedClassifier.getName());
                if (loadedClassifier == null) {
                    String _name = usedClassifier.getName();
                    String _plus = "Cannot find classifier '" + _name;
                    String _plus_1 = _plus + "' in loaded EPackage from ";
                    URI _uRI = loadedEPackage.eResource().getURI();
                    String _plus_2 = _plus_1 + _uRI;
                    throw new RuntimeException(_plus_2);
                }
                result.put((EObject)usedClassifier, (EObject)loadedClassifier);
            }
            EList _eSubpackages = usedEPackage.getESubpackages();
            for (EPackage usedNestedPackage : _eSubpackages) {
                Functions.Function1 _function = it -> {
                    String _name = it.getName();
                    String _name_1 = usedNestedPackage.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                };
                EPackage loadedNestedPackage = (EPackage)IterableExtensions.findFirst((Iterable)loadedEPackage.getESubpackages(), (Functions.Function1)_function);
                if (loadedNestedPackage == null) continue;
                this.putMappingData(result, usedNestedPackage, loadedNestedPackage);
            }
        }
    }

    private void replaceReferencesInGeneratedPackages(List<EPackage> generatedPackages, Map<EObject, EObject> eNamedElementMapping) {
        TreeIterator packageContentIterator = EcoreUtil.getAllContents(generatedPackages);
        while (packageContentIterator.hasNext()) {
            EObject current = (EObject)packageContentIterator.next();
            EList _eAllStructuralFeatures = current.eClass().getEAllStructuralFeatures();
            EStructuralFeature[] crossReferenceFeatures = ((EClassImpl.FeatureSubsetSupplier)_eAllStructuralFeatures).crossReferences();
            if (crossReferenceFeatures == null) continue;
            for (EStructuralFeature crossReferenceFeature : crossReferenceFeatures) {
                boolean _isChangeable = crossReferenceFeature.isChangeable();
                if (!_isChangeable) continue;
                EReference reference = (EReference)crossReferenceFeature;
                boolean _isMany = reference.isMany();
                if (_isMany) {
                    Object _eGet = current.eGet((EStructuralFeature)reference);
                    List values = (List)_eGet;
                    for (EObject value : values) {
                        boolean _containsKey = eNamedElementMapping.containsKey(value);
                        if (!_containsKey) continue;
                        EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value, (Object)eNamedElementMapping.get(value));
                    }
                    continue;
                }
                Object _eGet_1 = current.eGet((EStructuralFeature)reference);
                EObject value_1 = (EObject)_eGet_1;
                boolean _containsKey_1 = eNamedElementMapping.containsKey(value_1);
                if (!_containsKey_1) continue;
                EcoreUtil.replace((EObject)current, (EStructuralFeature)reference, (Object)value_1, (Object)eNamedElementMapping.get(value_1));
            }
        }
    }

    protected Resource createResourceForEPackages(Grammar grammar, List<EPackage> packs, ResourceSet rs) {
        URI ecoreFileUri = this.getEcoreFileUri(grammar);
        Resource existing = rs.getResource(ecoreFileUri, false);
        if (existing != null) {
            existing.unload();
            rs.getResources().remove((Object)existing);
        }
        Resource ecoreFile = rs.createResource(ecoreFileUri, "");
        ecoreFile.getContents().addAll(packs);
        return ecoreFile;
    }

    protected GenModel getSaveAndReconcileGenModel(Grammar grammar, List<EPackage> packs, ResourceSet rs) {
        GenModel genModel = this.getGenModel(rs, grammar);
        genModel.initialize(packs);
        EList _genPackages = genModel.getGenPackages();
        for (GenPackage genPackage : _genPackages) {
            genPackage.setBasePackage(this.getBasePackage(grammar));
            if (this.suppressLoadInitialization) {
                genPackage.setLoadInitialization(false);
            }
            if (this.getLanguage().getFileExtensions().isEmpty() || !packs.contains(genPackage.getEcorePackage())) continue;
            genPackage.setFileExtensions(IterableExtensions.join(this.getLanguage().getFileExtensions(), (CharSequence)","));
        }
        Set<EPackage> referencedEPackages = this.getReferencedEPackages(packs);
        List<GenPackage> usedGenPackages = this.getGenPackagesForPackages(genModel, referencedEPackages);
        this.reconcileMissingGenPackagesInUsedModels(usedGenPackages);
        genModel.getUsedGenPackages().addAll(usedGenPackages);
        this.saveResource(genModel.eResource());
        new GenModelHelper().registerGenModel(genModel);
        return genModel;
    }

    protected void reconcileMissingGenPackagesInUsedModels(List<GenPackage> usedGenPackages) {
        HashSet processedModels = Sets.newHashSetWithExpectedSize((int)usedGenPackages.size());
        for (GenPackage usedGenPackage : usedGenPackages) {
            GenModel genModel = usedGenPackage.getGenModel();
            boolean _add = processedModels.add(genModel);
            if (!_add) continue;
            List missingPackages = genModel.getMissingPackages();
            List<GenPackage> missingGenPackages = this.getGenPackagesForPackages(genModel, missingPackages);
            genModel.getUsedGenPackages().addAll(missingGenPackages);
        }
    }

    protected GenModel getGenModel(ResourceSet rs, Grammar grammar) {
        try {
            URI genModelUri = this.getGenModelUri(grammar);
            Resource resource = rs.getResource(genModelUri, false);
            if (resource != null) {
                resource.unload();
                rs.getResources().remove((Object)resource);
            }
            Resource genModelFile = rs.createResource(genModelUri, "");
            GenModelImpl genModel = null;
            boolean _exists = rs.getURIConverter().exists(genModelUri, null);
            if (_exists) {
                genModelFile.load(null);
                boolean _hasFragment = genModelUri.hasFragment();
                if (_hasFragment) {
                    EObject _eObject = genModelFile.getEObject(genModelUri.fragment());
                    genModel = (GenModel)_eObject;
                } else {
                    EObject _head = (EObject)IterableExtensions.head((Iterable)genModelFile.getContents());
                    genModel = (GenModel)_head;
                }
            } else {
                boolean _tripleNotEquals;
                genModel = new GenModelImpl(){

                    public GenPackage createGenPackage() {
                        return new GenPackageImpl(){

                            public String getSerializedPackageFilename() {
                                String _name = this.getName();
                                return _name + ".loadinitialization_ecore";
                            }
                        };
                    }
                };
                genModel.setModelName(this.getModelName(grammar));
                genModel.setModelPluginID(this.getModelPluginID());
                genModel.setModelDirectory(this.getJavaModelDirectory());
                if (this.generateEdit) {
                    genModel.setEditPluginID(this.getEditPluginID());
                    genModel.setEditDirectory(this.getEditDirectory());
                }
                if (this.generateEditor) {
                    genModel.setEditorPluginID(this.getEditorPluginID());
                    genModel.setEditorDirectory(this.getEditorDirectory());
                }
                genModel.setValidateModel(false);
                genModel.setForceOverwrite(true);
                genModel.setFacadeHelperClass(null);
                genModel.setBundleManifest(true);
                genModel.setUpdateClasspath(false);
                genModel.setComplianceLevel(this.jdkLevel);
                genModel.setRuntimeVersion(this.emfRuntimeVersion);
                genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
                genModel.setLineDelimiter(this.codeConfig.getLineDelimiter());
                String _fileHeader = this.codeConfig.getFileHeader();
                boolean bl = _tripleNotEquals = _fileHeader != null;
                if (_tripleNotEquals) {
                    genModel.setCopyrightText(EMFGeneratorFragment2.trimMultiLineComment(this.codeConfig.getFileHeader()));
                }
            }
            genModelFile.getContents().add((Object)genModel);
            return genModel;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String trimMultiLineComment(String string) {
        return string.replace("*/", "").replace("/*", "").replace(" * ", "").trim();
    }

    protected Set<EPackage> getReferencedEPackages(List<EPackage> packs) {
        HashSet result = CollectionLiterals.newHashSet();
        for (EPackage pkg : packs) {
            TreeIterator iterator = pkg.eAllContents();
            while (iterator.hasNext()) {
                EObject obj = (EObject)iterator.next();
                EList _eCrossReferences = obj.eCrossReferences();
                for (EObject crossRef : _eCrossReferences) {
                    boolean _eIsProxy = crossRef.eIsProxy();
                    if (_eIsProxy) {
                        URI _eProxyURI = ((InternalEObject)crossRef).eProxyURI();
                        String _plus = "Proxy '" + _eProxyURI;
                        String _plus_1 = _plus + "' could not be resolved";
                        LOG.error((Object)_plus_1);
                        continue;
                    }
                    EPackage p = (EPackage)EcoreUtil2.getContainerOfType((EObject)crossRef, EPackage.class);
                    if (p == null) continue;
                    result.add(p);
                }
            }
        }
        result.removeAll(packs);
        result.remove(EcorePackage.eINSTANCE);
        result.remove(XMLTypePackage.eINSTANCE);
        result.remove(XMLNamespacePackage.eINSTANCE);
        return result;
    }

    protected List<GenPackage> getGenPackagesForPackages(GenModel existingGenModel, Collection<EPackage> packs) {
        ArrayList result = CollectionLiterals.newArrayList();
        for (EPackage pkg : packs) {
            Functions.Function1 _function = it -> {
                EPackage _ecorePackage = it.getEcorePackage();
                String _nsURI = null;
                if (_ecorePackage != null) {
                    _nsURI = _ecorePackage.getNsURI();
                }
                String _nsURI_1 = pkg.getNsURI();
                return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
            };
            boolean _exists = IterableExtensions.exists((Iterable)existingGenModel.getGenPackages(), (Functions.Function1)_function);
            boolean _not = !_exists;
            if (!_not) continue;
            result.add(GenModelUtil2.getGenPackage(pkg, existingGenModel.eResource().getResourceSet()));
        }
        Comparator _function_1 = (o1, o2) -> EcoreUtil.getURI((EObject)o1).toString().compareTo(EcoreUtil.getURI((EObject)o2).toString());
        Collections.sort(result, _function_1);
        return result;
    }

    protected void saveResource(Resource resource) {
        try {
            HashMap saveOptions = CollectionLiterals.newHashMap();
            saveOptions.put("URI_HANDLER", new URIHandlerImpl.AbsoluteCrossBundleAware(){

                public URI deresolve(URI uri) {
                    boolean _not;
                    boolean _isPlatform = uri.isPlatform();
                    boolean bl = _not = !_isPlatform;
                    if (_not) {
                        Set _entrySet = EcorePlugin.getPlatformResourceMap().entrySet();
                        for (Map.Entry entry : _entrySet) {
                            String _key = (String)entry.getKey();
                            String _plus = "platform:/resource/" + _key;
                            String _plus_1 = _plus + "/";
                            URI newPrefix = URI.createURI((String)_plus_1);
                            URI uri2 = uri.replacePrefix((URI)entry.getValue(), newPrefix);
                            if (uri2 == null) continue;
                            return super.deresolve(uri2);
                        }
                    }
                    return super.deresolve(uri);
                }
            });
            saveOptions.put("LINE_DELIMITER", this.codeConfig.getLineDelimiter());
            resource.save((Map)saveOptions);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void doGenerate(GenModel genModel) {
        boolean _notEquals;
        Generator generator = new Generator(){

            public JControlModel getJControlModel() {
                if (this.jControlModel == null) {
                    JControlModel _jControlModel;
                    this.jControlModel = _jControlModel = new JControlModel();
                    this.jControlModel.initialize(null, this.options.mergeRulesURI);
                }
                return this.jControlModel;
            }
        };
        GeneratorAdapterFactory.Descriptor.Registry _adapterFactoryDescriptorRegistry = generator.getAdapterFactoryDescriptorRegistry();
        String _lineDelimiter = this.codeConfig.getLineDelimiter();
        CvsIdFilteringGeneratorAdapterFactoryDescriptor _cvsIdFilteringGeneratorAdapterFactoryDescriptor = new CvsIdFilteringGeneratorAdapterFactoryDescriptor(_lineDelimiter);
        _adapterFactoryDescriptorRegistry.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", (GeneratorAdapterFactory.Descriptor)_cvsIdFilteringGeneratorAdapterFactoryDescriptor);
        genModel.setCanGenerate(true);
        generator.setInput((Object)genModel);
        BasicMonitor _basicMonitor = new BasicMonitor();
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)_basicMonitor);
        int _severity = diagnostic.getSeverity();
        boolean bl = _notEquals = _severity != 0;
        if (_notEquals) {
            LOG.warn((Object)diagnostic);
        }
        if (this.generateEdit) {
            boolean _notEquals_1;
            BasicMonitor _basicMonitor_1 = new BasicMonitor();
            Diagnostic editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)_basicMonitor_1);
            int _severity_1 = editDiag.getSeverity();
            boolean bl2 = _notEquals_1 = _severity_1 != 0;
            if (_notEquals_1) {
                LOG.warn((Object)editDiag);
            }
        }
        if (this.generateEditor) {
            boolean _notEquals_2;
            BasicMonitor _basicMonitor_2 = new BasicMonitor();
            Diagnostic editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)_basicMonitor_2);
            int _severity_2 = editorDiag.getSeverity();
            boolean bl3 = _notEquals_2 = _severity_2 != 0;
            if (_notEquals_2) {
                LOG.warn((Object)editorDiag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuildProperties() {
        block12: {
            try {
                if (!this.updateBuildProperties || this.modelPluginID != null || this.getProjectConfig().getRuntime().getManifest() == null) {
                    return;
                }
                String _path = this.getProjectConfig().getRuntime().getRoot().getPath();
                String buildPropertiesPath = _path + "/build.properties";
                File buildPropertiesFile = new File(buildPropertiesPath);
                boolean _exists = buildPropertiesFile.exists();
                if (!_exists) break block12;
                String modelContainer = this.getProjectConfig().getRuntime().getEcoreModelFolder();
                Properties buildProperties = new Properties();
                Charset charset = Charset.forName(this.codeConfig.getEncoding());
                FileInputStream _fileInputStream = new FileInputStream(buildPropertiesFile);
                String _xtrycatchfinallyexpression = null;
                try (InputStreamReader reader = new InputStreamReader((InputStream)_fileInputStream, charset);){
                    _xtrycatchfinallyexpression = CharStreams.toString((Readable)reader);
                }
                String existingContent = _xtrycatchfinallyexpression;
                StringInputStream _stringInputStream = new StringInputStream(existingContent, "ISO-8859-1");
                buildProperties.load((InputStream)_stringInputStream);
                String binIncludes = buildProperties.getProperty("bin.includes");
                boolean changed = false;
                if (binIncludes == null) {
                    String _existingContent = existingContent;
                    String _newLine = Strings.newLine();
                    String _plus = "bin.includes = " + modelContainer + "/" + _newLine;
                    String _plus_1 = _plus + "               ";
                    existingContent = _existingContent + _plus_1;
                    changed = true;
                } else {
                    boolean _not;
                    boolean _contains = binIncludes.contains(modelContainer);
                    boolean bl = _not = !_contains;
                    if (_not) {
                        String _newLine_1 = Strings.newLine();
                        String _plus_2 = "bin.includes = " + modelContainer + "/,\\" + _newLine_1;
                        String _plus_3 = _plus_2 + "               ";
                        existingContent = existingContent.replace("bin.includes = ", _plus_3);
                        changed = true;
                    }
                }
                if (!changed) break block12;
                FileOutputStream _fileOutputStream = new FileOutputStream(buildPropertiesFile);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)_fileOutputStream, charset);){
                    writer.write(existingContent);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setModelPluginID(String modelPluginID) {
        this.modelPluginID = modelPluginID;
    }

    public void setJavaModelDirectory(String javaModelDirectory) {
        this.javaModelDirectory = javaModelDirectory;
    }

    public void setGenerateEdit(boolean generateEdit) {
        this.generateEdit = generateEdit;
    }

    public void setEditPluginID(String editPluginID) {
        this.editPluginID = editPluginID;
    }

    public void setEditDirectory(String editDirectory) {
        this.editDirectory = editDirectory;
    }

    public void setGenerateEditor(boolean generateEditor) {
        this.generateEditor = generateEditor;
    }

    public void setEditorPluginID(String editorPluginID) {
        this.editorPluginID = editorPluginID;
    }

    public void setEditorDirectory(String editorDirectory) {
        this.editorDirectory = editorDirectory;
    }

    public void setGenModel(String genModel) {
        this.genModel = genModel;
    }

    public void setSkipGenerate(boolean skipGenerate) {
        this.skipGenerate = skipGenerate;
    }

    public void setUpdateBuildProperties(boolean updateBuildProperties) {
        this.updateBuildProperties = updateBuildProperties;
    }

    public void setLongFileNames(boolean longFileNames) {
        this.longFileNames = longFileNames;
    }

    public void setSuppressLoadInitialization(boolean suppressLoadInitialization) {
        this.suppressLoadInitialization = suppressLoadInitialization;
    }
}

