/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.addons.internal;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.ui.controls.image.GraphicNode;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.base.addons.TrimStackIdHelper;
import org.eclipse.fx.ui.workbench.renderers.base.services.PartialRestoreMinMaxService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMaximizationHost;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.addons.internal.Messages;

public class DefaultTrimStackImpl
implements PartialRestoreMinMaxService.TrimStack {
    private static final String MINIMIZED_AND_SHOWING = "MinimizedAndShowing";
    private static final String USE_OVERLAYS_KEY = "UseOverlays";
    private MUIElement minimizedElement;
    private boolean isShowing = false;
    @Inject
    EModelService modelService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    EPartService partService;
    @Inject
    PartialRestoreMinMaxService minMaxService;
    @Inject
    private GraphicsLoader graphicsLoader;
    private Pane trimStackTB;
    private EventHandler<ActionEvent> toolItemSelectionListener = evt -> {
        ToggleButton source = (ToggleButton)evt.getTarget();
        MUIElement uiElement = (MUIElement)source.getUserData();
        if (!source.isSelected()) {
            this.partService.requestActivation();
            this.showStack(false);
            return;
        }
        if (uiElement instanceof MPart) {
            this.partService.activate((MPart)uiElement);
        } else if (uiElement instanceof MPerspective) {
            uiElement.getParent().setSelectedElement(uiElement);
        }
        this.showStack(true);
    };
    private boolean cachedUseOverlays = true;

    public void restoreStack() {
        this.showStack(false);
        this.minimizedElement.setVisible(true);
        this.minimizedElement.getTags().remove("Minimized");
        this.toolControl.setToBeRendered(false);
    }

    public void showStack(boolean show) {
        WWidget ctrl = (WWidget)this.minimizedElement.getWidget();
        if (ctrl == null) {
            return;
        }
        if (show && !this.isShowing) {
            MPlaceholder ph;
            if (this.useOverlays()) {
                Object widget = this.window.getWidget();
                if (widget instanceof WMaximizationHost && ((WMaximizationHost)widget).supportPartialRestore()) {
                    MTrimBar tb = (MTrimBar)this.toolControl.getParent();
                    ((WMaximizationHost)widget).addPartialWidget((WLayoutedWidget)ctrl, tb.getSide() == SideValue.LEFT ? WMaximizationHost.Location.UPPER_LEFT : WMaximizationHost.Location.UPPER_RIGHT);
                } else {
                    this.minimizedElement.setVisible(true);
                }
                this.cachedUseOverlays = true;
            } else {
                this.minimizedElement.setVisible(true);
                this.cachedUseOverlays = false;
            }
            this.isShowing = true;
            this.toolControl.getTags().add(MINIMIZED_AND_SHOWING);
            if (this.minimizedElement instanceof MPartStack) {
                MPlaceholder ph2;
                MPartStack theStack = (MPartStack)this.minimizedElement;
                MStackElement curSel = (MStackElement)theStack.getSelectedElement();
                if (curSel instanceof MPart) {
                    this.partService.activate((MPart)curSel);
                } else if (curSel instanceof MPlaceholder && (ph2 = (MPlaceholder)curSel).getRef() instanceof MPart) {
                    this.partService.activate((MPart)ph2.getRef());
                }
            } else if (this.isEditorStack()) {
                MArea area = (MArea)((MPlaceholder)this.minimizedElement).getRef();
                MPart partToActivate = null;
                MUIElement selectedElement = area.getSelectedElement();
                while (partToActivate == null && selectedElement != null) {
                    if (selectedElement instanceof MPart) {
                        partToActivate = (MPart)selectedElement;
                        continue;
                    }
                    if (selectedElement instanceof MPlaceholder) {
                        MPlaceholder ph3 = (MPlaceholder)selectedElement;
                        if (ph3.getRef() instanceof MPart) {
                            partToActivate = (MPart)ph3.getRef();
                            continue;
                        }
                        selectedElement = null;
                        continue;
                    }
                    if (!(selectedElement instanceof MElementContainer)) continue;
                    MElementContainer container = (MElementContainer)selectedElement;
                    selectedElement = container.getSelectedElement();
                }
                if (partToActivate == null) {
                    List parts = this.modelService.findElements((MUIElement)area, null, MPart.class, null);
                    for (MPart part : parts) {
                        if (!this.partService.isPartVisible(part)) continue;
                        partToActivate = part;
                        break;
                    }
                }
                if (partToActivate != null) {
                    this.partService.activate(partToActivate);
                }
            } else if (this.minimizedElement instanceof MPlaceholder && (ph = (MPlaceholder)this.minimizedElement).getRef() instanceof MPart) {
                MPart part = (MPart)ph.getRef();
                this.partService.activate(part);
            }
            this.fixToolItemSelection();
        } else if (!show && this.isShowing) {
            if (this.cachedUseOverlays) {
                WMaximizationHost host = (WMaximizationHost)this.window.getWidget();
                host.removePartialWidget((WLayoutedWidget)ctrl);
            } else {
                this.minimizedElement.setVisible(false);
            }
            this.isShowing = false;
            this.toolControl.getTags().remove(MINIMIZED_AND_SHOWING);
            this.fixToolItemSelection();
        } else {
            this.fixToolItemSelection();
        }
    }

    private boolean isEditorStack() {
        if (!(this.minimizedElement instanceof MPlaceholder)) {
            return false;
        }
        MPlaceholder ph = (MPlaceholder)this.minimizedElement;
        return ph.getRef() instanceof MArea;
    }

    private void fixToolItemSelection() {
        if (this.trimStackTB == null) {
            return;
        }
        if (!this.isShowing) {
            for (Node item : this.trimStackTB.getChildren()) {
                if (!(item instanceof ToggleButton)) continue;
                ((ToggleButton)item).setSelected(false);
            }
        } else if (this.isEditorStack() || this.minimizedElement instanceof MPlaceholder) {
            ((ToggleButton)this.trimStackTB.getChildren().get(1)).setSelected(true);
        } else if (this.isPerspectiveStack()) {
            MPerspectiveStack pStack = (MPerspectiveStack)this.minimizedElement;
            MUIElement selElement = pStack.getSelectedElement();
            for (Node item : this.trimStackTB.getChildren()) {
                if (!(item instanceof ToggleButton)) continue;
                ((ToggleButton)item).setSelected(item.getUserData() == selElement);
            }
        } else {
            MPartStack partStack = (MPartStack)this.minimizedElement;
            MUIElement selElement = partStack.getSelectedElement();
            if (selElement instanceof MPlaceholder) {
                selElement = ((MPlaceholder)selElement).getRef();
            }
            for (Node item : this.trimStackTB.getChildren()) {
                if (!(item instanceof ToggleButton)) continue;
                boolean isSel = item.getUserData() == selElement;
                ((ToggleButton)item).setSelected(isSel);
            }
        }
    }

    private boolean isPerspectiveStack() {
        return this.minimizedElement instanceof MPerspectiveStack;
    }

    @PostConstruct
    void createWidget(Parent parent, MToolControl me) {
        MElementContainer meParent;
        if (this.minimizedElement == null) {
            this.minimizedElement = this.findElement();
        }
        if ((meParent = me.getParent()) instanceof MTrimBar) {
            MTrimBar bar = (MTrimBar)meParent;
            this.trimStackTB = bar.getSide() == SideValue.RIGHT || bar.getSide() == SideValue.LEFT ? new VBox() : new HBox();
        }
        if (parent instanceof Pane) {
            ((Pane)parent).getChildren().add((Object)this.trimStackTB);
        } else {
            ((Group)parent).getChildren().add((Object)this.trimStackTB);
        }
        this.trimStackTB.getStyleClass().add((Object)"trim-stack");
        if (this.minMaxService.supportPartialRestore(this.minimizedElement)) {
            this.trimStackTB.getChildren().add((Object)this.createRestoreButton());
        }
        this.updateTrimStackItems();
    }

    private MUIElement findElement() {
        MUIElement result;
        List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (ps.isEmpty()) {
            String toolControlId = this.toolControl.getElementId();
            int index = toolControlId.indexOf(40);
            String stackId = toolControlId.substring(0, index);
            result = this.modelService.find(stackId, (MUIElement)this.window);
        } else {
            List perspectives;
            String toolControlId = this.toolControl.getElementId();
            Map parsedIds = TrimStackIdHelper.parseTrimStackId((String)toolControlId);
            String stackId = (String)parsedIds.get(TrimStackIdHelper.TrimStackIdPart.ELEMENT_ID);
            String perspId = (String)parsedIds.get(TrimStackIdHelper.TrimStackIdPart.PERSPECTIVE_ID);
            MPerspective persp = null;
            if (perspId != null && (perspectives = this.modelService.findElements((MUIElement)ps.get(0), perspId, MPerspective.class, null)) != null && !perspectives.isEmpty()) {
                persp = (MPerspective)perspectives.get(0);
            }
            result = persp != null ? this.modelService.find(stackId, persp) : this.modelService.find(stackId, (MUIElement)this.window);
        }
        return result;
    }

    private void updateTrimStackItems() {
        if (!this.trimStackTB.getChildren().isEmpty() && this.minMaxService.supportPartialRestore(this.minimizedElement)) {
            Node restore = (Node)this.trimStackTB.getChildren().get(0);
            this.trimStackTB.getChildren().removeIf(n -> n != restore);
        }
        if (this.isEditorStack() && this.trimStackTB.getChildren().size() == 1) {
            ToggleButton ti = new ToggleButton();
            ti.getStyleClass().add((Object)"shared-area");
            ti.setTooltip(new Tooltip(Messages.getString("TrimStack.SharedArea")));
            ti.setGraphic((Node)new GraphicNode());
            ti.setOnAction(this.toolItemSelectionListener);
            this.trimStackTB.getChildren().add((Object)ti);
        } else if (this.minimizedElement instanceof MPlaceholder) {
            MPlaceholder ph = (MPlaceholder)this.minimizedElement;
            if (ph.getRef() instanceof MPart) {
                MPart part = (MPart)ph.getRef();
                this.trimStackTB.getChildren().add((Object)this.createButton((MUILabel)part));
            }
        } else if (this.minimizedElement instanceof MGenericStack) {
            MGenericStack theStack = (MGenericStack)this.minimizedElement;
            boolean hasRenderedElements = theStack.getChildren().stream().anyMatch(stackElement -> stackElement != null && ((MUIElement)stackElement).isToBeRendered());
            if (hasRenderedElements) {
                for (MUIElement stackElement2 : theStack.getChildren()) {
                    if (stackElement2 == null || !stackElement2.isToBeRendered()) continue;
                    this.trimStackTB.getChildren().add((Object)this.createButton((MUILabel)stackElement2));
                }
            } else if (theStack.getTags().contains("NoAutoCollapse")) {
                this.trimStackTB.getChildren().add((Object)this.createEmptyStackButton());
            } else {
                this.restoreStack();
                return;
            }
        }
    }

    private static MUILabel getLabelElement(MUIElement element) {
        if (element instanceof MPlaceholder) {
            element = ((MPlaceholder)element).getRef();
        }
        return (MUILabel)(element instanceof MUILabel ? element : null);
    }

    private static String getLabelText(MUILabel label) {
        String text;
        if (label instanceof MUIElement && (text = DefaultTrimStackImpl.getOverrideTitleToolTip((MUIElement)label)) != null && text.length() > 0) {
            return text;
        }
        String string = label.getLocalizedLabel();
        return string == null ? "" : string;
    }

    private static String getOverrideTitleToolTip(MUIElement element) {
        String label;
        String result = null;
        Object stringObject = element.getTransientData().get("e4_override_title_tool_tip_key");
        if (stringObject instanceof String) {
            result = (String)stringObject;
        }
        if (result == null || result.length() == 0) {
            return null;
        }
        if (element instanceof MUILabel && (label = ((MUILabel)element).getLocalizedLabel()) != null && label.length() > 0) {
            result = String.valueOf(label) + ' ' + '(' + result + ')';
        }
        return result;
    }

    private boolean useOverlays() {
        if (this.toolControl == null) {
            return true;
        }
        String useOverlays = (String)this.toolControl.getPersistedState().get(USE_OVERLAYS_KEY);
        if (useOverlays == null) {
            useOverlays = "true";
        }
        return Boolean.parseBoolean(useOverlays);
    }

    protected Node createRestoreButton() {
        Button b = new Button(Messages.getString("TrimStack.Restore"));
        b.setGraphic((Node)new GraphicNode());
        b.getStyleClass().add((Object)"restore");
        b.setOnAction(evt -> {
            boolean bl = this.minimizedElement.getTags().remove("Minimized");
        });
        return b;
    }

    protected Node createButton(MUILabel element) {
        ToggleButton ti = new ToggleButton();
        ti.getStyleClass().add((Object)"part-button");
        ti.setId(((MUIElement)element).getElementId());
        ti.setUserData((Object)element);
        if (!Strings.isNullOrEmpty((String)element.getIconURI())) {
            EMFUri uri = new EMFUri(URI.createURI((String)element.getIconURI()));
            ti.setGraphic(this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)uri));
        } else {
            ti.setGraphic((Node)new GraphicNode());
        }
        ti.setText(DefaultTrimStackImpl.getLabelText(element));
        ti.setTooltip(new Tooltip(DefaultTrimStackImpl.getLabelText(element)));
        ti.setOnAction(this.toolItemSelectionListener);
        return ti;
    }

    protected Node createEmptyStackButton() {
        ToggleButton ti = new ToggleButton();
        ti.setTooltip(new Tooltip(Messages.getString("TrimStack.EmptyStack")));
        ti.getStyleClass().add((Object)"empty-stack");
        ti.setGraphic((Node)new GraphicNode());
        ti.setOnAction(this.toolItemSelectionListener);
        return ti;
    }
}

