/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.threadpool;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.equinox.internal.util.UtilActivator;
import org.eclipse.equinox.internal.util.impl.tpt.ServiceFactoryImpl;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.Executor;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.Job;
import org.eclipse.equinox.internal.util.impl.tpt.threadpool.ThreadPoolFactoryImpl;
import org.eclipse.equinox.internal.util.pool.ObjectPool;
import org.eclipse.equinox.internal.util.timer.TimerListener;

public class ThreadPoolManagerImpl
extends ObjectPool
implements TimerListener,
PrivilegedAction<Executor> {
    static ThreadPoolManagerImpl threadPool = null;
    static ObjectPool jobPool;
    private int used = 0;
    static int tMaximum;
    Job waiting = new Job();
    private static String pAutoMaximum;
    private static String pMin;
    private static String pMax;
    private static String pIgnoreMax;
    private static int defMin;
    private static int defMax;
    private static int MAX_WAITING;
    private static float MAX_OVERLOAD;
    private static boolean ignoreMax;
    private static boolean autoMax;

    static {
        tMaximum = 0;
        pAutoMaximum = "equinox.util.threadpool.autoMaximum";
        pMin = "equinox.util.threadpool.minThreads";
        pMax = "equinox.util.threadpool.maxThreads";
        pIgnoreMax = "equinox.util.threadpool.ignoreMaximum";
        defMin = 1;
        defMax = 48;
        MAX_WAITING = 20;
        MAX_OVERLOAD = 0.1f;
    }

    private ThreadPoolManagerImpl(int i, int j, int m) {
        super((Class<?>)null, i, j, m);
        tMaximum = i * j;
        ignoreMax = UtilActivator.getBoolean(pIgnoreMax);
        autoMax = UtilActivator.getBoolean(pAutoMaximum);
        jobPool = new ObjectPool(this.waiting, 5, 8, 4);
    }

    public static ThreadPoolManagerImpl getThreadPool() {
        if (threadPool == null) {
            int intSize;
            int minFill = intSize = UtilActivator.getInteger(pMin, defMin);
            int factor = UtilActivator.getInteger(pMax, defMax);
            int n = intSize = intSize < 2 ? 2 : intSize;
            if (intSize > factor) {
                factor = (int)((double)intSize * 1.5 + 0.5);
            }
            threadPool = new ThreadPoolManagerImpl(intSize, factor / intSize, minFill);
        }
        return threadPool;
    }

    @Override
    public void clear() {
        this.shrink(-1);
        threadPool = null;
    }

    @Override
    public Object getInstance() throws Exception {
        if (ServiceFactoryImpl.privileged()) {
            return AccessController.doPrivileged(this);
        }
        return new Executor();
    }

    @Override
    public Executor run() {
        return new Executor();
    }

    @Override
    public Object getObject() {
        try {
            return super.getObject();
        }
        catch (Throwable tw) {
            if (ServiceFactoryImpl.log != null) {
                ServiceFactoryImpl.log.error("Unable to create more threads!\r\nActive Thread Pool tasks: " + this.used, tw);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor getExecutor() {
        Object object = this.getSyncMonitor();
        synchronized (object) {
            Executor e;
            if ((this.used < tMaximum || ignoreMax) && (e = (Executor)this.getObject()) != null) {
                ++this.used;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shrink(int count) {
        Object object = this.getSyncMonitor();
        synchronized (object) {
            this.dontExtend = true;
            while (this.nextFree > count) {
                int x = this.nextFree / this.factor;
                int y = this.nextFree % this.factor;
                Executor e = (Executor)this.buff[x][y];
                this.buff[x][y] = null;
                e.terminate();
                --this.nextFree;
            }
        }
    }

    @Override
    public void shrink() {
        this.shrink(this.minimumFill - 1);
        this.dontExtend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseObject(Object obj) {
        Job tmp = null;
        Executor x = (Executor)obj;
        Object object = this.getSyncMonitor();
        synchronized (object) {
            x.factory.finished();
            if (this.used <= tMaximum || ignoreMax) {
                tmp = this.waiting.getJob();
            }
        }
        if (tmp == null) {
            --this.used;
            x.clear();
            x.setPriorityI(5);
            return super.releaseObject(obj);
        }
        if (UtilActivator.LOG_DEBUG) {
            UtilActivator.log.debug(256, 10005, tmp.name, null, false);
        }
        x.setPriorityI(tmp.priority);
        x.setRunnable(tmp.run, tmp.name, tmp.factory, tmp.acc);
        tmp.fullClear();
        jobPool.releaseObject(tmp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timer(int event) {
        int count = 0;
        int all = 0;
        Object object = this.getSyncMonitor();
        synchronized (object) {
            int i = 0;
            while (i < this.buff.length) {
                if (this.buff[i] != null) {
                    int j = 0;
                    while (j < this.buff[i].length) {
                        Executor e = (Executor)this.buff[i][j];
                        if (e != null) {
                            ++all;
                            if (!e.accessed) {
                                ++count;
                            } else {
                                e.accessed = false;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (count > 0 && all > this.minimumFill - 1 && all > count) {
                if (count > this.minimumFill) {
                    this.shrink(count - 2);
                } else {
                    this.shrink(this.minimumFill - 2);
                }
                this.dontExtend = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable job, int priority, String name, ThreadPoolFactoryImpl factory, AccessControlContext acc) {
        Executor ex = null;
        Object object = this.getSyncMonitor();
        synchronized (object) {
            if (this.used < tMaximum || ignoreMax) {
                ex = (Executor)this.getObject();
            }
            if (ex != null) {
                ++this.used;
            } else {
                this.addInTasksQueue(job, name, priority, factory, acc);
                return;
            }
        }
        ex.setPriorityI(priority);
        ex.setRunnable(job, name, factory, acc);
    }

    private void addInTasksQueue(Runnable job, String name, int priority, ThreadPoolFactoryImpl factory, AccessControlContext acc) {
        Executor ex;
        this.waiting.addJob(job, name, priority, factory, acc);
        if (UtilActivator.LOG_DEBUG) {
            UtilActivator.log.debug("In Threadpool Queue: " + name + ", queue size:" + this.waiting.counter, null);
        }
        if (autoMax && this.waiting.counter > MAX_WAITING && (ex = (Executor)this.getObject()) != null) {
            tMaximum += MAX_WAITING;
            MAX_WAITING += (int)((float)MAX_WAITING * MAX_OVERLOAD);
            Job j = this.waiting.getJob();
            while (j != null) {
                if (ex == null) {
                    ex = (Executor)this.getObject();
                }
                if (ex != null) {
                    ++this.used;
                } else {
                    this.waiting.addJob(j.run, j.name, j.priority, j.factory, acc);
                    break;
                }
                ex.setPriorityI(j.priority);
                ex.setRunnable(j.run, j.name, factory, acc);
                ex = null;
                j = this.waiting.getJob();
            }
        }
    }

    public void reset() {
        this.shrink(-1);
        this.dontExtend = false;
    }

    public Object getSyncMonitor() {
        return this.buff;
    }
}

