/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.ICommentAssociater;
import org.eclipse.xtext.parsetree.reconstr.IEObjectConsumer;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.IParseTreeConstructor;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.ITokenStreamExtension;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.parsetree.reconstr.impl.EObjectConsumer;
import org.eclipse.xtext.parsetree.reconstr.impl.HiddenAndTokenNodeIterator;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstructionReportImpl;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;

public abstract class AbstractParseTreeConstructor
implements IParseTreeConstructor {
    @Inject
    protected ICommentAssociater commentAssociater;
    @Inject
    protected ITokenSerializer.ICrossReferenceSerializer crossRefSerializer;
    @Inject
    protected ITokenSerializer.IEnumLiteralSerializer enumLitSerializer;
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;
    @Inject
    protected ITokenSerializer.IKeywordSerializer keywordSerializer;
    private final Logger log = Logger.getLogger(AbstractParseTreeConstructor.class);
    @Inject
    protected TokenUtil tokenUtil;
    @Inject
    protected Provider<TreeConstructionReportImpl> treeConstructionReportProvider;
    @Inject
    protected ITransientValueService tvService;
    @Inject
    protected ITokenSerializer.IValueSerializer valueSerializer;

    protected void assignComment(ILeafNode comment, Map<EObject, AbstractToken> eObject2Token, Map<ILeafNode, EObject> comments) {
        EObject container = comments.get(comment);
        if (container == null) {
            return;
        }
        AbstractToken token = eObject2Token.get(container);
        if (token != null) {
            for (int i = 0; i < token.getTokensForSemanticChildren().size(); ++i) {
                AbstractToken t = token.getTokensForSemanticChildren().get(i);
                if (!(t instanceof KeywordToken) && !(t instanceof AssignmentToken) || t.getNode() != null) continue;
                token.getTokensForSemanticChildren().add(i, new CommentToken(comment));
                return;
            }
            token.getTokensForSemanticChildren().add(new CommentToken(comment));
        }
    }

    protected void assignNodesByMatching(Map<EObject, AbstractToken> eObject2Token, ICompositeNode rootNode, Map<ILeafNode, EObject> comments) throws IOException {
        NodeIterator contents = new NodeIterator(rootNode);
        while (contents.hasNext()) {
            INode containedNode = contents.next();
            AbstractRule rule = containedNode.getGrammarElement() instanceof AbstractRule ? (AbstractRule)containedNode.getGrammarElement() : null;
            if (this.hiddenTokenHelper.isWhitespace(rule)) continue;
            if (containedNode instanceof ILeafNode && this.hiddenTokenHelper.isComment(rule)) {
                this.assignComment((ILeafNode)containedNode, eObject2Token, comments);
                continue;
            }
            if (!this.tokenUtil.isToken(containedNode)) continue;
            Pair<List<ILeafNode>, List<ILeafNode>> leadingAndTrailingHiddenTokens = this.tokenUtil.getLeadingAndTrailingHiddenTokens(containedNode);
            for (ILeafNode leadingHiddenNode : (List)leadingAndTrailingHiddenTokens.getFirst()) {
                if (!this.tokenUtil.isCommentNode(leadingHiddenNode)) continue;
                this.assignComment(leadingHiddenNode, eObject2Token, comments);
            }
            this.assignTokenByMatcher(containedNode, eObject2Token);
            for (ILeafNode trailingHiddenNode : (List)leadingAndTrailingHiddenTokens.getSecond()) {
                if (!this.tokenUtil.isCommentNode(trailingHiddenNode)) continue;
                this.assignComment(trailingHiddenNode, eObject2Token, comments);
            }
            contents.prune();
            for (ICompositeNode parentNode = containedNode.getParent(); parentNode != null && this.assignTokenDirect(parentNode, eObject2Token); parentNode = parentNode.getParent()) {
            }
            if (containedNode.getOffset() <= rootNode.getEndOffset()) continue;
            break;
        }
    }

    protected void assignTokenByMatcher(INode node, AbstractToken token, boolean recursive) {
        for (AbstractToken t : token.getTokensForSemanticChildren()) {
            if (recursive && t instanceof AssignmentToken) {
                return;
            }
            if (t.getNode() == null && t.equalsOrReplacesNode(node)) {
                t.setNode(node);
                return;
            }
            if (!(node.getGrammarElement() instanceof Keyword) || !(t instanceof ActionToken)) continue;
            this.assignTokenByMatcher(node, t, true);
        }
    }

    protected void assignTokenByMatcher(INode node, Map<EObject, AbstractToken> eObject2Token) {
        EObject owner = this.tokenUtil.getTokenOwner(node);
        if (owner == null) {
            return;
        }
        AbstractToken token = eObject2Token.get(owner);
        if (token != null) {
            this.assignTokenByMatcher(node, token, false);
        }
    }

    protected boolean assignTokenDirect(INode node, Map<EObject, AbstractToken> eObject2Token) {
        if (!node.hasDirectSemanticElement()) {
            return true;
        }
        AbstractToken token = eObject2Token.get(node.getSemanticElement());
        if (token != null && token.getNode() == null) {
            token.setNode(node);
            return true;
        }
        return false;
    }

    protected void collectRootsAndEObjects(AbstractToken token, Map<EObject, AbstractToken> obj2token, Set<ICompositeNode> roots) {
        ICompositeNode node = NodeModelUtils.getNode(token.getEObjectConsumer().getEObject());
        if (node != null && !this.containsNodeOrAnyParent(roots, node)) {
            while (node.getParent() != null && !node.getParent().hasDirectSemanticElement()) {
                node = node.getParent();
            }
            roots.add(node);
        }
        if (!token.getTokensForSemanticChildren().isEmpty()) {
            obj2token.put(token.getTokensForSemanticChildren().get(0).getEObjectConsumer().getEObject(), token);
            for (AbstractToken t : token.getTokensForSemanticChildren()) {
                if (t.getTokensForSemanticChildren().isEmpty()) continue;
                this.collectRootsAndEObjects(t, obj2token, roots);
            }
        }
    }

    protected boolean containsNodeOrAnyParent(Set<ICompositeNode> nodes, INode node) {
        if (nodes.contains(node)) {
            return true;
        }
        if (node.getParent() != null) {
            return this.containsNodeOrAnyParent(nodes, node.getParent());
        }
        return false;
    }

    protected IEObjectConsumer createEObjectConsumer(EObject obj) {
        return new EObjectConsumer(this.tvService, obj);
    }

    protected TreeConstructionReportImpl createReport(EObject root) {
        TreeConstructionReportImpl result = (TreeConstructionReportImpl)this.treeConstructionReportProvider.get();
        result.setRoot(root);
        return result;
    }

    protected String debug(AbstractToken t, IEObjectConsumer i) {
        StringBuffer b = new StringBuffer(t.dumpTokens(10, 50, true));
        b.append(t.getClass().getSimpleName() + ":" + t.getTransitionIndex() + " -> " + i);
        return b.toString();
    }

    protected void dump(String indent, AbstractToken token) {
        System.out.println(indent + "begin " + token.getClass().getSimpleName() + " - " + EmfFormatter.objPath((EObject)token.getEObjectConsumer().getEObject()) + " node:" + this.dumpNode(token.getNode()));
        String newIndent = indent + "\t";
        for (AbstractToken child : token.getTokensForSemanticChildren()) {
            if (child.getTokensForSemanticChildren().isEmpty()) {
                System.out.println(newIndent + " -> " + child.getClass().getSimpleName() + " - " + (child.getEObjectConsumer() == null ? "null" : EmfFormatter.objPath((EObject)child.getEObjectConsumer().getEObject())) + " node:" + this.dumpNode(child.getNode()));
                continue;
            }
            this.dump(newIndent, child);
        }
        System.out.println(indent + "end");
    }

    protected String dumpNode(INode node) {
        if (node == null) {
            return "null";
        }
        return node.getClass().getSimpleName() + "'" + node.getText().replace("\n", "\\n") + "' " + Integer.toHexString(node.hashCode());
    }

    protected abstract AbstractToken getRootToken(IEObjectConsumer var1);

    protected AbstractToken serialize(EObject object, AbstractToken currentToken, TreeConstructionReportImpl rep) {
        if (object == null) {
            throw new NullPointerException("The to-be-serialized EObject is null");
        }
        IEObjectConsumer currentInstance = currentToken.getEObjectConsumer();
        int followerIndex = 0;
        int depth = 0;
        boolean lastSuccess = true;
        while (currentToken != null) {
            AbstractToken nextToken = null;
            IEObjectConsumer nextInstance = null;
            nextToken = currentToken.createFollower(followerIndex, currentInstance);
            if (nextToken != null) {
                while (nextToken != null && (nextInstance = nextToken.tryConsume()) == null) {
                    nextToken = currentToken.createFollower(++followerIndex, currentInstance);
                }
            }
            if (nextToken instanceof RootToken && nextToken.getNext() != null) {
                return nextToken.getNext();
            }
            if (nextToken != null && nextInstance != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.debug(currentToken, currentInstance) + " -> found -> " + currentToken.serialize(null)));
                }
                currentToken = nextToken;
                currentInstance = nextInstance;
                followerIndex = 0;
                lastSuccess = true;
                ++depth;
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(this.debug(currentToken, currentInstance) + " -> fail -> " + (currentToken.getTransitionIndex() + 1)));
            }
            if (lastSuccess) {
                rep.addDeadEnd(depth, currentToken);
            }
            followerIndex = currentToken.getTransitionIndex() + 1;
            currentInstance = currentToken.getEObjectConsumer();
            currentToken = currentToken.getNext();
            lastSuccess = false;
            --depth;
        }
        throw new XtextSerializationException(rep, "Serialization failed");
    }

    protected AbstractToken serialize(EObject object, TreeConstructionReportImpl rep) {
        if (object == null) {
            throw new NullPointerException("The to-be-serialized EObject is null");
        }
        AbstractToken root = this.getRootToken(this.createEObjectConsumer(object));
        AbstractToken first = this.serialize(object, root, rep);
        HashMap semantic2token = Maps.newHashMap();
        for (AbstractToken t = first; t != null; t = t.getNext()) {
            List tokens = (List)semantic2token.get(t.getEObjectConsumer().getEObject());
            if (tokens == null) {
                tokens = Lists.newArrayList();
                semantic2token.put(t.getEObjectConsumer().getEObject(), tokens);
            }
            if (t.getLastRuleCallOrigin() != null) {
                tokens.add(t);
            }
            if (t.getNext() == null) continue;
            if (t.getNext().getLastRuleCallOrigin() == null) {
                root.tokensForSemanticChildren = tokens;
                continue;
            }
            if (t.getNext().getEObjectConsumer().getEObject() != t.getEObjectConsumer().getEObject().eContainer()) continue;
            t.getNext().tokensForSemanticChildren = tokens;
        }
        return root;
    }

    @Override
    public IParseTreeConstructor.TreeConstructionReport serializeSubtree(EObject object, ITokenStream out) throws IOException {
        TreeConstructionReportImpl report = this.createReport(object);
        AbstractToken root = this.serialize(object, report);
        HashSet roots = Sets.newHashSet();
        HashMap obj2token = Maps.newHashMap();
        this.collectRootsAndEObjects(root, obj2token, roots);
        Map<ILeafNode, EObject> comments = this.commentAssociater.associateCommentsWithSemanticEObjects(object, roots);
        for (ICompositeNode r : roots) {
            this.assignNodesByMatching(obj2token, r, comments);
        }
        WsMergerStream wsout = new WsMergerStream(out);
        ITextRegion previousLocation = ITextRegion.EMPTY_REGION;
        this.initStream(root, wsout);
        previousLocation = this.write(root, wsout, previousLocation);
        wsout.flush();
        report.setPreviousLocation(previousLocation);
        return report;
    }

    protected void initStream(AbstractToken token, WsMergerStream out) {
        AbstractElement rootMostElement = null;
        if (!token.getTokensForSemanticChildren().isEmpty()) {
            for (AbstractToken t : Lists.reverse(token.getTokensForSemanticChildren())) {
                if (t.getGrammarElement() == null) continue;
                rootMostElement = t.getGrammarElement();
                break;
            }
        } else if (token.getGrammarElement() != null) {
            rootMostElement = token.getGrammarElement();
        }
        if (rootMostElement != null) {
            ParserRule rootRule = GrammarUtil.containingParserRule(rootMostElement);
            out.init(rootRule);
        }
    }

    protected ITextRegion write(AbstractToken token, WsMergerStream out, ITextRegion location) throws IOException {
        ITextRegion currentLocation = location;
        INode node = token.getNode();
        if (node != null) {
            currentLocation = currentLocation.merge(node.getTextRegion());
        }
        if (!token.getTokensForSemanticChildren().isEmpty()) {
            for (AbstractToken t : token.getTokensForSemanticChildren()) {
                currentLocation = this.write(t, out, currentLocation);
            }
        } else if (token instanceof CommentToken) {
            out.writeComment((ILeafNode)node);
        } else {
            String val = token.serialize(node);
            if (val != null) {
                if (token instanceof AssignmentToken) {
                    out.writeSemantic(((AssignmentToken)token).getAssignmentElement(), val, node);
                } else {
                    out.writeSemantic(token.getGrammarElement(), val, node);
                }
            }
        }
        return currentLocation;
    }

    protected void writeComments(Iterable<ILeafNode> comments, WsMergerStream out, Set<INode> consumedComments) throws IOException {
        for (ILeafNode c : comments) {
            if (!consumedComments.add(c)) continue;
            out.writeComment(c);
        }
    }

    public abstract class AbstractToken {
        protected final IEObjectConsumer eObjectConsumer;
        protected final AbstractToken lastRuleCallOrigin;
        protected final AbstractToken next;
        protected INode node;
        protected List<AbstractToken> tokensForSemanticChildren = Collections.emptyList();
        protected final int transitionIndex;

        public AbstractToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer currentSemanticElement) {
            this.next = next;
            this.lastRuleCallOrigin = parent;
            this.transitionIndex = no;
            this.eObjectConsumer = currentSemanticElement;
        }

        protected boolean checkForRecursion(Class<?> clazz, IEObjectConsumer curr) {
            for (AbstractToken token = this.next; token != null; token = token.getNext()) {
                if (token.getClass() != clazz) continue;
                return token.getEObjectConsumer() == curr;
            }
            return false;
        }

        public AbstractToken createFollower(int index, IEObjectConsumer inst) {
            return null;
        }

        public AbstractToken createFollowerAfterReturn(AbstractToken next, int actIndex, int index, IEObjectConsumer inst) {
            return null;
        }

        public String dumpTokens(int maxTokenCount, int maxStringLength, boolean appendDots) {
            boolean overlength;
            boolean overdepth;
            ArrayList<String> tokensAsStrings = new ArrayList<String>();
            for (AbstractToken currentToken = this; currentToken != null && tokensAsStrings.size() <= maxTokenCount + 1; currentToken = currentToken.getNext()) {
                String s = currentToken.serialize(null);
                if (s == null) continue;
                tokensAsStrings.add(s);
            }
            boolean bl = overdepth = tokensAsStrings.size() > maxTokenCount;
            if (overdepth) {
                tokensAsStrings.remove(tokensAsStrings.size() - 1);
            }
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < tokensAsStrings.size(); ++i) {
                result.append((String)tokensAsStrings.get(i));
                if (i == tokensAsStrings.size() - 1) continue;
                result.append(" ");
            }
            boolean bl2 = overlength = result.length() > maxStringLength;
            if (overlength) {
                result.delete(maxStringLength + 1, result.length());
            }
            if (appendDots && (overdepth || overlength)) {
                result.append("...");
            }
            return result.toString();
        }

        public boolean equalsOrReplacesNode(INode node) {
            return false;
        }

        public EObject getEObject() {
            return this.eObjectConsumer.getEObject();
        }

        public IEObjectConsumer getEObjectConsumer() {
            return this.eObjectConsumer;
        }

        public abstract AbstractElement getGrammarElement();

        public AbstractToken getLastRuleCallOrigin() {
            return this.lastRuleCallOrigin;
        }

        public AbstractToken getNext() {
            return this.next;
        }

        public INode getNode() {
            return this.node;
        }

        public List<AbstractToken> getTokensForSemanticChildren() {
            return this.tokensForSemanticChildren;
        }

        public int getTransitionIndex() {
            return this.transitionIndex;
        }

        public final String serialize(INode node) {
            String result = this.serializeInternal(node);
            if (result != "<KEEP_VALUE_FROM_NODE_MODEL>") {
                return result;
            }
            if (node == null) {
                throw new UnsupportedOperationException("Can not keep value from Node Model when there is no Node Model. Context:" + this);
            }
            return AbstractParseTreeConstructor.this.tokenUtil.serializeNode(node);
        }

        protected String serializeInternal(INode node) {
            return null;
        }

        public void setNode(INode node) {
            this.node = node;
        }

        public IEObjectConsumer tryConsume() {
            return this.eObjectConsumer;
        }
    }

    public abstract class ActionToken
    extends AbstractToken {
        public ActionToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }
    }

    public abstract class AlternativesToken
    extends AbstractToken {
        public AlternativesToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }
    }

    public abstract class AssignmentToken
    extends AbstractToken {
        protected IEObjectConsumer consumed;
        protected AbstractElement element;
        protected AssignmentType type;
        protected Object value;

        public AssignmentToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }

        @Override
        public boolean equalsOrReplacesNode(INode node) {
            if (this.type == null) {
                return false;
            }
            switch (this.type) {
                case CROSS_REFERENCE: {
                    return AbstractParseTreeConstructor.this.crossRefSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (CrossReference)this.element, (EObject)this.value, node);
                }
                case KEYWORD: {
                    return AbstractParseTreeConstructor.this.keywordSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (Keyword)this.element, this.value, node);
                }
                case TERMINAL_RULE_CALL: {
                    return AbstractParseTreeConstructor.this.valueSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (RuleCall)this.element, this.value, node);
                }
                case ENUM_RULE_CALL: {
                    return AbstractParseTreeConstructor.this.enumLitSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (RuleCall)this.element, this.value, node);
                }
                case PARSER_RULE_CALL: {
                    return false;
                }
                case DATATYPE_RULE_CALL: {
                    return AbstractParseTreeConstructor.this.valueSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (RuleCall)this.element, this.value, node);
                }
            }
            return false;
        }

        public AbstractElement getAssignmentElement() {
            return this.element;
        }

        public AssignmentType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        protected String serializeInternal(INode node) {
            if (this.type == null) {
                return null;
            }
            switch (this.type) {
                case CROSS_REFERENCE: {
                    String ref = AbstractParseTreeConstructor.this.crossRefSerializer.serializeCrossRef(this.eObjectConsumer.getEObject(), (CrossReference)this.element, (EObject)this.value, node);
                    if (ref == null) {
                        Assignment ass = GrammarUtil.containingAssignment(this.element);
                        throw new XtextSerializationException("Could not serialize cross reference from " + EmfFormatter.objPath((EObject)this.eObjectConsumer.getEObject()) + "." + ass.getFeature() + " to " + EmfFormatter.objPath((EObject)((EObject)this.value)));
                    }
                    return ref;
                }
                case KEYWORD: {
                    return AbstractParseTreeConstructor.this.keywordSerializer.serializeAssignedKeyword(this.eObjectConsumer.getEObject(), (Keyword)this.element, this.value, node);
                }
                case TERMINAL_RULE_CALL: {
                    return AbstractParseTreeConstructor.this.valueSerializer.serializeAssignedValue(this.eObjectConsumer.getEObject(), (RuleCall)this.element, this.value, node);
                }
                case ENUM_RULE_CALL: {
                    return AbstractParseTreeConstructor.this.enumLitSerializer.serializeAssignedEnumLiteral(this.eObjectConsumer.getEObject(), (RuleCall)this.element, this.value, node);
                }
                case PARSER_RULE_CALL: {
                    return null;
                }
                case DATATYPE_RULE_CALL: {
                    return AbstractParseTreeConstructor.this.valueSerializer.serializeAssignedValue(this.eObjectConsumer.getEObject(), (RuleCall)this.element, this.value, node);
                }
            }
            return null;
        }
    }

    public static enum AssignmentType {
        CROSS_REFERENCE,
        DATATYPE_RULE_CALL,
        ENUM_RULE_CALL,
        KEYWORD,
        PARSER_RULE_CALL,
        TERMINAL_RULE_CALL;

    }

    protected class CommentToken
    extends AbstractToken {
        public CommentToken(ILeafNode node) {
            super(null, null, 0, null);
            this.setNode(node);
        }

        @Override
        public AbstractElement getGrammarElement() {
            return null;
        }
    }

    public abstract class GroupToken
    extends AbstractToken {
        public GroupToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }
    }

    public abstract class KeywordToken
    extends AbstractToken {
        public KeywordToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }

        @Override
        public boolean equalsOrReplacesNode(INode node) {
            return AbstractParseTreeConstructor.this.keywordSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (Keyword)this.getGrammarElement(), node);
        }

        @Override
        protected String serializeInternal(INode node) {
            return AbstractParseTreeConstructor.this.keywordSerializer.serializeUnassignedKeyword(this.eObjectConsumer.getEObject(), (Keyword)this.getGrammarElement(), node);
        }
    }

    public class RootToken
    extends AbstractToken {
        private RootToken(AbstractToken next, IEObjectConsumer inst) {
            super(null, next, 0, inst);
        }

        public RootToken(IEObjectConsumer inst) {
            super(null, null, 0, inst);
        }

        public boolean containsRuleCall() {
            return true;
        }

        @Override
        public AbstractToken createFollowerAfterReturn(AbstractToken next, int actIndex, int index, IEObjectConsumer i) {
            return index != 0 || !i.isConsumed() ? null : new RootToken(next, i);
        }

        @Override
        public AbstractElement getGrammarElement() {
            return null;
        }
    }

    public abstract class RuleCallToken
    extends AbstractToken {
        public RuleCallToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }
    }

    public abstract class UnassignedTextToken
    extends AbstractToken {
        public UnassignedTextToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }

        @Override
        public boolean equalsOrReplacesNode(INode node) {
            return AbstractParseTreeConstructor.this.valueSerializer.equalsOrReplacesNode(this.eObjectConsumer.getEObject(), (RuleCall)this.getGrammarElement(), node);
        }

        @Override
        protected String serializeInternal(INode node) {
            return AbstractParseTreeConstructor.this.valueSerializer.serializeUnassignedValue(this.eObjectConsumer.getEObject(), (RuleCall)this.getGrammarElement(), node);
        }
    }

    public abstract class UnorderedGroupToken
    extends AbstractToken {
        public UnorderedGroupToken(AbstractToken parent, AbstractToken next, int no, IEObjectConsumer current) {
            super(parent, next, no, current);
        }
    }

    protected class WsMergerStream {
        protected ICompositeNode lastCompositeNode = null;
        protected int lastIndex = 0;
        protected ITokenStream out;
        @Inject
        protected HiddenAndTokenNodeIterator nodeIterator;

        public WsMergerStream(ITokenStream out) {
            this.out = out;
        }

        public void flush() throws IOException {
            ArrayList whitespaces = Lists.newArrayList();
            if (this.nodeIterator != null) {
                while (this.nodeIterator.hasNext()) {
                    INode nextNode = this.nodeIterator.next();
                    if (AbstractParseTreeConstructor.this.tokenUtil.isToken(nextNode)) {
                        whitespaces.clear();
                        break;
                    }
                    if (!AbstractParseTreeConstructor.this.tokenUtil.isWhitespaceNode(nextNode)) continue;
                    whitespaces.add((ILeafNode)nextNode);
                }
            }
            for (ILeafNode l : whitespaces) {
                this.out.writeHidden(l.getGrammarElement(), l.getText());
            }
            this.out.flush();
        }

        public void writeComment(ILeafNode comment) throws IOException {
            this.writeWhitespacesSince(comment);
            this.out.writeHidden(comment.getGrammarElement(), comment.getText());
        }

        public void writeSemantic(AbstractElement grammarElement, String value, INode node) throws IOException {
            this.writeWhitespacesSince(node);
            this.out.writeSemantic(grammarElement, value);
        }

        public void init(ParserRule parseRule) {
            if (this.out instanceof ITokenStreamExtension) {
                ((ITokenStreamExtension)this.out).init(parseRule);
            }
        }

        protected void writeWhitespacesSince(INode node) throws IOException {
            if (node == null) {
                this.nodeIterator = null;
                return;
            }
            if (this.nodeIterator == null || !this.nodeIterator.hasNext()) {
                this.nodeIterator = new HiddenAndTokenNodeIterator(node, AbstractParseTreeConstructor.this.tokenUtil);
                return;
            }
            ArrayList whitespaces = Lists.newArrayList();
            while (this.nodeIterator.hasNext()) {
                INode nextNode = this.nodeIterator.next();
                if (AbstractParseTreeConstructor.this.tokenUtil.isWhitespaceNode(nextNode)) {
                    whitespaces.add((ILeafNode)nextNode);
                    continue;
                }
                if (node.equals(nextNode)) {
                    if (whitespaces.isEmpty()) {
                        this.out.writeHidden(AbstractParseTreeConstructor.this.hiddenTokenHelper.getWhitespaceRuleFor(null, ""), "");
                    }
                    for (ILeafNode whitespace : whitespaces) {
                        this.out.writeHidden(whitespace.getGrammarElement(), whitespace.getText());
                    }
                    return;
                }
                this.nodeIterator = new HiddenAndTokenNodeIterator(node, AbstractParseTreeConstructor.this.tokenUtil);
                return;
            }
        }
    }
}

