/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.fx;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fx.formats.svg.fx.FXToSvgUtils;
import org.eclipse.fx.formats.svg.svg.PresentationAttributes;
import org.eclipse.fx.formats.svg.svg.SpreadMethod;
import org.eclipse.fx.formats.svg.svg.SvgDefsElement;
import org.eclipse.fx.formats.svg.svg.SvgElement;
import org.eclipse.fx.formats.svg.svg.SvgFactory;
import org.eclipse.fx.formats.svg.svg.SvgLinearGradientElement;
import org.eclipse.fx.formats.svg.svg.SvgPathElement;
import org.eclipse.fx.formats.svg.svg.SvgRectElement;
import org.eclipse.fx.formats.svg.svg.SvgStopElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PresentationAttributesUtil {
    private Supplier<SvgDefsElement> defSupplier;

    public PresentationAttributesUtil(Supplier<SvgDefsElement> defSupplier) {
        this.defSupplier = defSupplier;
    }

    public List<SvgElement> createBorder(Border b, final Region r) {
        boolean _equals = Objects.equal((Object)b, null);
        if (_equals) {
            return Collections.emptyList();
        }
        Functions.Function1<BorderStroke, List<SvgElement>> _function = new Functions.Function1<BorderStroke, List<SvgElement>>(){

            public List<SvgElement> apply(BorderStroke it) {
                return PresentationAttributesUtil.this.createBorderStroke(it, r);
            }
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)b.getStrokes(), (Functions.Function1)_function)));
    }

    public List<SvgElement> createBorderStroke(BorderStroke s, Region r) {
        boolean st;
        boolean w = s.getWidths().getBottom() == s.getWidths().getLeft() && s.getWidths().getBottom() == s.getWidths().getRight() && s.getWidths().getBottom() == s.getWidths().getTop();
        boolean c = Objects.equal((Object)s.getBottomStroke(), (Object)s.getLeftStroke()) && Objects.equal((Object)s.getBottomStroke(), (Object)s.getRightStroke()) && Objects.equal((Object)s.getBottomStroke(), (Object)s.getTopStroke());
        boolean bl = st = Objects.equal((Object)s.getBottomStyle(), (Object)s.getLeftStyle()) && Objects.equal((Object)s.getBottomStyle(), (Object)s.getRightStyle()) && Objects.equal((Object)s.getBottomStyle(), (Object)s.getTopStyle());
        if (w && c && st && PresentationAttributesUtil.checkRadii(s.getRadii())) {
            SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
            rv.setFill("transparent");
            double _minX = r.getLayoutBounds().getMinX();
            double _left = s.getInsets().getLeft();
            rv.setX(Double.valueOf(_minX + _left).toString());
            double _minY = r.getLayoutBounds().getMinY();
            double _top = s.getInsets().getTop();
            rv.setY(Double.valueOf(_minY + _top).toString());
            double _width = r.getLayoutBounds().getWidth();
            double _left_1 = s.getInsets().getLeft();
            double _minus = _width - _left_1;
            double _right = s.getInsets().getRight();
            rv.setWidth(Double.valueOf(_minus - _right).toString());
            double _height = r.getLayoutBounds().getHeight();
            double _top_1 = s.getInsets().getTop();
            double _minus_1 = _height - _top_1;
            double _bottom = s.getInsets().getBottom();
            rv.setHeight(Double.valueOf(_minus_1 - _bottom).toString());
            rv.setStroke_width(Double.valueOf(s.getWidths().getBottom()).toString());
            this.applyStroke(rv, s.getBottomStroke());
            return Collections.singletonList(rv);
        }
        InputOutput.println((Object)"====> Dup actions");
        return Collections.emptyList();
    }

    public static boolean checkRadii(CornerRadii r) {
        boolean ry;
        boolean rx = r.getBottomLeftHorizontalRadius() == r.getBottomRightHorizontalRadius() && r.getBottomLeftHorizontalRadius() == r.getTopLeftHorizontalRadius() && r.getBottomLeftHorizontalRadius() == r.getTopRightHorizontalRadius();
        boolean bl = ry = r.getBottomLeftVerticalRadius() == r.getBottomRightVerticalRadius() && r.getBottomLeftVerticalRadius() == r.getTopLeftVerticalRadius() && r.getBottomLeftVerticalRadius() == r.getTopRightVerticalRadius();
        return rx && ry;
    }

    public SvgElement createBackgroundFill(BackgroundFill f, Region r) {
        boolean _checkRadii = PresentationAttributesUtil.checkRadii(f.getRadii());
        if (_checkRadii) {
            SvgRectElement rv = SvgFactory.eINSTANCE.createSvgRectElement();
            rv.setRx(Double.valueOf(f.getRadii().getBottomLeftHorizontalRadius()).toString());
            rv.setRy(Double.valueOf(f.getRadii().getBottomLeftVerticalRadius()).toString());
            rv.setX(Double.valueOf(f.getInsets().getLeft()).toString());
            rv.setY(Double.valueOf(f.getInsets().getTop()).toString());
            double _width = r.getLayoutBounds().getWidth();
            double _left = f.getInsets().getLeft();
            double _minus = _width - _left;
            double _right = f.getInsets().getRight();
            rv.setWidth(Double.valueOf(_minus - _right).toString());
            double _height = r.getLayoutBounds().getHeight();
            double _top = f.getInsets().getTop();
            double _minus_1 = _height - _top;
            double _bottom = f.getInsets().getBottom();
            rv.setHeight(Double.valueOf(_minus_1 - _bottom).toString());
            rv.setFill("transparent");
            this.applyFill(rv, f.getFill());
            String _plus = r + " ===> ";
            String _fill = rv.getFill();
            String _plus_1 = String.valueOf(_plus) + _fill;
            String _plus_2 = String.valueOf(_plus_1) + "; ";
            Paint _fill_1 = f.getFill();
            String _plus_3 = String.valueOf(_plus_2) + _fill_1;
            InputOutput.println((Object)_plus_3);
            return rv;
        }
        SvgPathElement rv_1 = SvgFactory.eINSTANCE.createSvgPathElement();
        return rv_1;
    }

    protected void _applyFill(PresentationAttributes e, Color p) {
        boolean _notEquals;
        e.setFill(FXToSvgUtils.toRGBHex(p));
        double _opacity = p.getOpacity();
        boolean bl = _notEquals = _opacity != 1.0;
        if (_notEquals) {
            e.setFill_opacity(Double.valueOf(p.getOpacity()).toString());
        }
    }

    protected void _applyFill(PresentationAttributes e, ImagePattern p) {
        System.err.println("ImagePattern not yet supported");
    }

    protected void _applyFill(PresentationAttributes e, LinearGradient p) {
        SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
        l.setId(EcoreUtil.generateUUID());
        String _xifexpression = null;
        boolean _isProportional = p.isProportional();
        _xifexpression = _isProportional ? FXToSvgUtils.toProportion(p.getStartX()) : Double.valueOf(p.getStartX()).toString();
        l.setX1(_xifexpression);
        String _xifexpression_1 = null;
        boolean _isProportional_1 = p.isProportional();
        _xifexpression_1 = _isProportional_1 ? FXToSvgUtils.toProportion(p.getEndX()) : Double.valueOf(p.getEndX()).toString();
        l.setX2(_xifexpression_1);
        String _xifexpression_2 = null;
        boolean _isProportional_2 = p.isProportional();
        _xifexpression_2 = _isProportional_2 ? FXToSvgUtils.toProportion(p.getStartY()) : Double.valueOf(p.getStartY()).toString();
        l.setY1(_xifexpression_2);
        String _xifexpression_3 = null;
        boolean _isProportional_3 = p.isProportional();
        _xifexpression_3 = _isProportional_3 ? FXToSvgUtils.toProportion(p.getEndY()) : Double.valueOf(p.getEndY()).toString();
        l.setY2(_xifexpression_3);
        l.setSpreadMethod(PresentationAttributesUtil.toSpread(p.getCycleMethod()));
        List _stops = p.getStops();
        for (Stop s : _stops) {
            EList _children = l.getChildren();
            SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
            _children.add((Object)_stop);
        }
        EList _children_1 = this.defSupplier.get().getChildren();
        _children_1.add((Object)l);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("url(#");
        String _id = l.getId();
        _builder.append(_id);
        _builder.append(")");
        e.setFill(_builder.toString());
    }

    protected void _applyFill(PresentationAttributes e, RadialGradient p) {
        System.err.println("RadialGradient not yet supported");
    }

    protected void _applyStroke(PresentationAttributes e, Color p) {
        boolean _notEquals;
        e.setStroke(FXToSvgUtils.toRGBHex(p));
        double _opacity = p.getOpacity();
        boolean bl = _notEquals = _opacity != 0.0;
        if (_notEquals) {
            e.setStroke_opacity(Double.valueOf(p.getOpacity()).toString());
        }
    }

    protected void _applyStroke(PresentationAttributes e, ImagePattern p) {
        System.err.println("ImagePattern not yet supported");
    }

    protected void _applyStroke(PresentationAttributes e, LinearGradient p) {
        SvgLinearGradientElement l = SvgFactory.eINSTANCE.createSvgLinearGradientElement();
        l.setId(EcoreUtil.generateUUID());
        String _xifexpression = null;
        boolean _isProportional = p.isProportional();
        _xifexpression = _isProportional ? FXToSvgUtils.toProportion(p.getStartX()) : Double.valueOf(p.getStartX()).toString();
        l.setX1(_xifexpression);
        String _xifexpression_1 = null;
        boolean _isProportional_1 = p.isProportional();
        _xifexpression_1 = _isProportional_1 ? FXToSvgUtils.toProportion(p.getEndX()) : Double.valueOf(p.getEndX()).toString();
        l.setX2(_xifexpression_1);
        String _xifexpression_2 = null;
        boolean _isProportional_2 = p.isProportional();
        _xifexpression_2 = _isProportional_2 ? FXToSvgUtils.toProportion(p.getStartY()) : Double.valueOf(p.getStartY()).toString();
        l.setY1(_xifexpression_2);
        String _xifexpression_3 = null;
        boolean _isProportional_3 = p.isProportional();
        _xifexpression_3 = _isProportional_3 ? FXToSvgUtils.toProportion(p.getEndY()) : Double.valueOf(p.getEndY()).toString();
        l.setY2(_xifexpression_3);
        l.setSpreadMethod(PresentationAttributesUtil.toSpread(p.getCycleMethod()));
        List _stops = p.getStops();
        for (Stop s : _stops) {
            EList _children = l.getChildren();
            SvgStopElement _stop = PresentationAttributesUtil.toStop(s);
            _children.add((Object)_stop);
        }
        EList _children_1 = this.defSupplier.get().getChildren();
        _children_1.add((Object)l);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("url(#");
        String _id = l.getId();
        _builder.append(_id);
        _builder.append(")");
        e.setStroke(_builder.toString());
    }

    protected void _applyStroke(PresentationAttributes e, RadialGradient p) {
        System.err.println("RadialGradient not yet supported");
    }

    public static SvgStopElement toStop(Stop s) {
        SvgStopElement e = SvgFactory.eINSTANCE.createSvgStopElement();
        e.setStop_color(FXToSvgUtils.toRGBHex(s.getColor()));
        e.setOffset(Double.valueOf(s.getOffset()).toString());
        return e;
    }

    public static SpreadMethod toSpread(CycleMethod cm) {
        SpreadMethod _switchResult = null;
        if (cm != null) {
            switch (cm) {
                case NO_CYCLE: {
                    _switchResult = SpreadMethod.PAD;
                    break;
                }
                case REFLECT: {
                    _switchResult = SpreadMethod.REFLECT;
                    break;
                }
                case REPEAT: {
                    _switchResult = SpreadMethod.REPEAT;
                    break;
                }
            }
        }
        return _switchResult;
    }

    public void applyFill(PresentationAttributes e, Paint p) {
        if (p instanceof Color) {
            this._applyFill(e, (Color)p);
            return;
        }
        if (p instanceof ImagePattern) {
            this._applyFill(e, (ImagePattern)p);
            return;
        }
        if (p instanceof LinearGradient) {
            this._applyFill(e, (LinearGradient)p);
            return;
        }
        if (p instanceof RadialGradient) {
            this._applyFill(e, (RadialGradient)p);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, p).toString());
    }

    public void applyStroke(PresentationAttributes e, Paint p) {
        if (p instanceof Color) {
            this._applyStroke(e, (Color)p);
            return;
        }
        if (p instanceof ImagePattern) {
            this._applyStroke(e, (ImagePattern)p);
            return;
        }
        if (p instanceof LinearGradient) {
            this._applyStroke(e, (LinearGradient)p);
            return;
        }
        if (p instanceof RadialGradient) {
            this._applyStroke(e, (RadialGradient)p);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e, p).toString());
    }
}

