/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.frontend;

import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.fx.drift.PresentationMode;
import org.eclipse.fx.drift.TransferType;
import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.FPSCounter;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.frontend.FrontSwapChain;
import org.eclipse.fx.drift.internal.frontend.FrontendImpl;
import org.eclipse.fx.drift.internal.frontend.FxImage;
import org.eclipse.fx.drift.internal.frontend.FxImageFactory;

public class SimpleFrontSwapChain
implements FrontSwapChain {
    private FrontendImpl frontend;
    private UUID id;
    private List<FxImage<?>> images = new ArrayList();
    private Map<ImageData, FxImage<?>> imageMap = new HashMap();
    private AtomicReference<ImageData> mailbox = new AtomicReference();
    private BiConsumer<UUID, ImageData> onRelease;
    private Vec2i size;
    private int imageCount;
    private PresentationMode presentationMode;
    public FPSCounter fpsCounter = new FPSCounter(100);
    private boolean disposed = false;

    public SimpleFrontSwapChain(FrontendImpl frontend, UUID id, List<ImageData> images, PresentationMode presentationMode, BiConsumer<UUID, ImageData> onRelease) {
        this.frontend = frontend;
        this.id = id;
        for (ImageData image : images) {
            FxImage fxImage = FxImageFactory.createFxImage(image);
            this.images.add(fxImage);
            this.imageMap.put(image, fxImage);
        }
        this.presentationMode = presentationMode;
        this.onRelease = onRelease;
        this.allocate().join();
    }

    @Override
    public Optional<FxImage<?>> getCurrentImage() {
        return Optional.ofNullable(this.mailbox.get()).map(this.imageMap::get);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public CompletableFuture<Void> allocate() {
        return this.frontend.asyncCallQuantumRenderer(() -> {
            ResourceFactory factory = GraphicsPipeline.getDefaultResourceFactory();
            try {
                for (FxImage<?> fxImage : this.images) {
                    fxImage.allocate(factory);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> dispose() {
        return ((CompletableFuture)this.frontend.asyncCallQuantumRenderer(() -> {
            ImageData old = this.mailbox.getAndSet(null);
            if (old != null) {
                this.release(old);
            }
            for (FxImage<?> fxImage : this.images) {
                fxImage.release();
            }
            return null;
        }).thenRun(() -> {
            this.disposed = true;
        })).thenRun(() -> this.frontend.sendSwapchainDisposed(this.id));
    }

    @Override
    public Vec2i getSize() {
        return ((ImageData)this.images.get((int)0).getData()).size;
    }

    @Override
    public TransferType getTransferType() {
        return ((ImageData)this.images.get((int)0).getData()).type;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void present(ImageData image) {
        this.frontend.asyncCallQuantumRenderer(() -> {
            ImageData old = this.mailbox.getAndSet(image);
            if (old != null) {
                this.release(old);
            }
            return null;
        }).join();
        this.fpsCounter.tick();
    }

    private void release(ImageData image) {
        this.onRelease.accept(this.id, image);
    }
}

