/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.fieldeditors;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.common.utils.environment.EnvironmentVariableResolver;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;

public class TITANResourceLocatorFieldEditor
extends StringFieldEditor {
    private int type;
    private String rootPath;
    private Composite composite;
    private Button pathButton;
    private Button envButton;
    private Button browseButton;
    private String target = "";
    private Label resolvedPathLabelText;
    private MessageConsole console = null;

    public TITANResourceLocatorFieldEditor(String name, String labelText, Composite parent, int type, String rootPath) {
        this.init(name, labelText);
        this.type = type;
        this.rootPath = rootPath;
        this.createControl(parent);
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
        this.resolveVariable();
    }

    public void setConsole(MessageConsole console) {
        this.console = console;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void addModifyListener(ModifyListener listener) {
        Text text = this.getTextControl();
        if (text != null) {
            text.addModifyListener(listener);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns - 1);
        this.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TITANResourceLocatorFieldEditor.this.target = TITANResourceLocatorFieldEditor.this.getTextControl().getText();
                TITANResourceLocatorFieldEditor.this.resolveVariable();
            }
        });
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.composite.setLayout((Layout)layout);
        GridData gd = new GridData(784);
        gd.horizontalSpan = 3;
        this.composite.setLayoutData((Object)gd);
        this.resolvedPathLabelText = new Label(this.composite, 4);
        this.resolvedPathLabelText.setText("Resolved location: ");
        this.resolvedPathLabelText.setVisible(false);
        gd = new GridData(560);
        this.resolvedPathLabelText.setLayoutData((Object)gd);
        Composite buttons = new Composite(this.composite, 0);
        layout = new GridLayout(3, false);
        buttons.setLayout((Layout)layout);
        gd = new GridData(144);
        buttons.setLayoutData((Object)gd);
        this.pathButton = new Button(buttons, 8);
        this.pathButton.setText("path variable");
        this.pathButton.setFont(parent.getFont());
        this.pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TITANResourceLocatorFieldEditor.this.handleVariablesButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 128;
        this.pathButton.setLayoutData((Object)gd);
        this.envButton = new Button(buttons, 8);
        this.envButton.setText("env variable");
        this.envButton.setFont(parent.getFont());
        this.envButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TITANResourceLocatorFieldEditor.this.handleEnvSelectButtonSelected();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 128;
        this.envButton.setLayoutData((Object)gd);
        this.browseButton = new Button(buttons, 8);
        this.browseButton.setText("browse");
        this.browseButton.setFont(parent.getFont());
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TITANResourceLocatorFieldEditor.this.handleBrowseButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 128;
        this.browseButton.setLayoutData((Object)gd);
    }

    private void handleEnvSelectButtonSelected() {
        EnvironmentVariable variable;
        Map envVariables = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getTextControl().getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EnvironmentVariable) {
                    EnvironmentVariable temp = (EnvironmentVariable)element;
                    return temp.name + " [ " + temp.value + " ] ";
                }
                return super.getText(element);
            }
        });
        dialog.setTitle("Environmental variable selection");
        dialog.setMessage("Select a variable to constrain your search.");
        ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(envVariables.size());
        Iterator i = envVariables.keySet().iterator();
        while (i.hasNext()) {
            variable = new EnvironmentVariable();
            variable.name = (String)i.next();
            variable.value = (String)envVariables.get(variable.name);
            variables.add(variable);
        }
        dialog.setElements((Object[])variables.toArray(new EnvironmentVariable[variables.size()]));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            Object result = dialog.getFirstResult();
            variable = (EnvironmentVariable)result;
            String original = this.getTextControl().getText();
            this.getTextControl().setText(original + "[" + variable.name + "]");
        }
    }

    private void handleVariablesButtonPressed() {
        String[] variableNames;
        PathVariableSelectionDialog dialog;
        int variableTypes = 2;
        if (this.type == 1) {
            variableTypes |= 1;
        }
        if ((dialog = new PathVariableSelectionDialog(this.getTextControl().getShell(), variableTypes)).open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
            this.getTextControl().setText(variableNames[0]);
        }
    }

    private void handleBrowseButtonPressed() {
        FileDialog dialog;
        String selection = null;
        URI resolvedPath = TITANPathUtilities.resolvePathURI(this.target, this.rootPath);
        if (this.type == 1) {
            dialog = new FileDialog(this.getTextControl().getShell());
            dialog.setText("Select the target file.");
            IPath path = URIUtil.toPath((URI)resolvedPath);
            dialog.setFilterPath(path.removeLastSegments(1).toOSString());
            selection = dialog.open();
        } else {
            dialog = new DirectoryDialog(this.getTextControl().getShell());
            dialog.setMessage("Select the target folder.");
            dialog.setFilterPath(URIUtil.toPath((URI)resolvedPath).toOSString());
            selection = dialog.open();
        }
        if (selection != null) {
            if (this.console != null) {
                this.console.newMessageStream().println("Browsed the path: " + selection);
            }
            String result = PathUtil.getRelativePath(this.rootPath, selection);
            this.setStringValue(result);
        }
    }

    private void resolveVariable() {
        if ("".equals(this.target)) {
            this.resolvedPathLabelText.setVisible(false);
            return;
        }
        URI path = URIUtil.toURI((String)this.target);
        URI resolvedPath = TITANPathUtilities.resolvePathURI(this.target, this.rootPath);
        String message = "Resolved location: " + URIUtil.toPath((URI)resolvedPath);
        this.resolvedPathLabelText.setText(message);
        if (path.equals(resolvedPath)) {
            this.resolvedPathLabelText.setVisible(false);
        } else {
            this.resolvedPathLabelText.setVisible(true);
        }
        this.composite.layout();
    }

    protected boolean doCheckState() {
        URI root;
        URI absoluteURI;
        String result;
        if (StringUtils.isNullOrEmpty(this.target)) {
            return this.isEmptyStringAllowed();
        }
        Map envVariables = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        try {
            result = EnvironmentVariableResolver.eclipseStyle().resolve(this.target, envVariables);
            result = EnvironmentVariableResolver.unixStyle().resolve(result, envVariables);
        }
        catch (EnvironmentVariableResolver.VariableNotFoundException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        URI uri = URIUtil.toURI((String)result);
        URI resolvedURI = pathVariableManager.resolveURI(uri);
        if (this.rootPath != null && !resolvedURI.isAbsolute() && (absoluteURI = (root = URIUtil.toURI((String)this.rootPath)).resolve(resolvedURI)) != null && !absoluteURI.isAbsolute()) {
            this.setErrorMessage("Could not be resolved to an absolute path");
            return false;
        }
        return true;
    }

    private static final class EnvironmentVariable {
        private String name;
        private String value;

        private EnvironmentVariable() {
        }
    }
}

