/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewPackageWizardPage
extends NewContainerWizardPage {
    private static final String PACKAGE_INFO_JAVA_FILENAME = "package-info.java";
    private static final String PACKAGE_HTML_FILENAME = "package.html";
    private static final String PAGE_NAME = "NewPackageWizardPage";
    private static final String PACKAGE = "NewPackageWizardPage.package";
    private static final String SETTINGS_CREATEPACKAGE_INFO_JAVA = "create_package_info_java";
    private StringDialogField fPackageDialogField;
    private SelectionButtonDialogField fCreatePackageInfoJavaDialogField;
    private IStatus fPackageStatus;
    private IPackageFragment fCreatedPackageFragment;

    public NewPackageWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewPackageWizardPage_title);
        this.setDescription(NewWizardMessages.NewPackageWizardPage_description);
        this.fCreatedPackageFragment = null;
        PackageFieldAdapter adapter = new PackageFieldAdapter();
        this.fPackageDialogField = new StringDialogField();
        this.fPackageDialogField.setDialogFieldListener(adapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.NewPackageWizardPage_package_label);
        this.fCreatePackageInfoJavaDialogField = new SelectionButtonDialogField(32);
        this.fCreatePackageInfoJavaDialogField.setDialogFieldListener(adapter);
        this.fCreatePackageInfoJavaDialogField.setLabelText(NewWizardMessages.NewPackageWizardPage_package_CreatePackageInfoJava);
        this.fPackageStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        IDialogSettings section;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        String pName = "";
        if (jelem != null) {
            IPackageFragmentRoot pkgFragmentRoot;
            IPackageFragment pf = (IPackageFragment)jelem.getAncestor(4);
            if (pf != null && !pf.isDefaultPackage()) {
                pName = pf.getElementName();
            } else if (jelem.getJavaProject() != null && (pkgFragmentRoot = this.getPackageFragmentRoot()) != null && pkgFragmentRoot.exists()) {
                try {
                    String prName;
                    IStatus status;
                    IJavaElement[] packages = pkgFragmentRoot.getChildren();
                    if (packages.length == 1 && (status = this.getPackageStatus(prName = jelem.getJavaProject().getElementName())).getSeverity() == 0) {
                        pName = prName;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        this.setPackageText(pName, true);
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(PAGE_NAME)) != null) {
            boolean createPackageDocumentation = section.getBoolean(SETTINGS_CREATEPACKAGE_INFO_JAVA);
            this.fCreatePackageInfoJavaDialogField.setSelection(createPackageDocumentation);
        }
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(NewWizardMessages.NewPackageWizardPage_info);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_package_wizard_page_context");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fPackageDialogField.setFocus();
    }

    private void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns - 1);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(composite);
        TextFieldNavigationHandler.install(text);
        this.fCreatePackageInfoJavaDialogField.doFillIntoGrid(composite, nColumns);
        BidiUtils.applyBidiProcessing((Text)this.fPackageDialogField.getTextControl(null), (String)"java");
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.getPackageStatus(this.getPackageText());
        }
        this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus});
    }

    private IStatus validatePackageName(String text) {
        IJavaProject project = this.getJavaProject();
        if (project == null || !project.exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        return JavaConventionsUtil.validatePackageName(text, (IJavaElement)project);
    }

    private IStatus getPackageStatus(String packName) {
        StatusInfo status = new StatusInfo();
        if (packName.length() > 0) {
            IStatus val = this.validatePackageName(packName);
            if (val.getSeverity() == 4) {
                status.setError(Messages.format(NewWizardMessages.NewPackageWizardPage_error_InvalidPackageName, val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(Messages.format(NewWizardMessages.NewPackageWizardPage_warning_DiscouragedPackageName, val.getMessage()));
            }
        } else {
            status.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
            return status;
        }
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null && root.getJavaProject().exists()) {
            IPackageFragment pack = root.getPackageFragment(packName);
            try {
                IPath packagePath;
                IPath rootPath = root.getPath();
                IPath outputPath = root.getJavaProject().getOutputLocation();
                if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = pack.getPath())) {
                    status.setError(NewWizardMessages.NewPackageWizardPage_error_IsOutputFolder);
                    return status;
                }
                if (pack.exists()) {
                    if (!this.isCreatePackageDocumentation() || this.packageDocumentationAlreadyExists(pack)) {
                        if (pack.containsJavaResources() || !pack.hasSubpackages()) {
                            status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExists);
                        } else {
                            status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageNotShown);
                        }
                    }
                } else {
                    IFileStore store;
                    IResource resource = pack.getResource();
                    if (resource != null && !ResourcesPlugin.getWorkspace().validateFiltered(resource).isOK()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageNameFiltered);
                        return status;
                    }
                    URI location = pack.getResource().getLocationURI();
                    if (location != null && (store = EFS.getStore((URI)location)).fetchInfo().exists()) {
                        status.setError(NewWizardMessages.NewPackageWizardPage_error_PackageExistsDifferentCase);
                    }
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return status;
    }

    private boolean packageDocumentationAlreadyExists(IPackageFragment pack) throws JavaModelException {
        ICompilationUnit packageInfoJava = pack.getCompilationUnit(PACKAGE_INFO_JAVA_FILENAME);
        if (packageInfoJava.exists()) {
            return true;
        }
        Object[] nonJavaResources = pack.getNonJavaResources();
        int i = 0;
        while (i < nonJavaResources.length) {
            IFile file;
            String fileName;
            Object resource = nonJavaResources[i];
            if (resource instanceof IFile && PACKAGE_HTML_FILENAME.equals(fileName = (file = (IFile)resource).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public boolean isCreatePackageDocumentation() {
        return this.fCreatePackageInfoJavaDialogField.isSelected();
    }

    public void setPackageText(String str, boolean canBeModified) {
        this.fPackageDialogField.setText(str);
        this.fPackageDialogField.setEnabled(canBeModified);
    }

    public IResource getModifiedResource() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            IPackageFragment pack = root.getPackageFragment(this.getPackageText());
            IResource packRes = pack.getResource();
            if (this.isCreatePackageDocumentation()) {
                if (JavaModelUtil.is50OrHigher(this.getJavaProject())) {
                    return pack.getCompilationUnit(PACKAGE_INFO_JAVA_FILENAME).getResource();
                }
                if (packRes instanceof IFolder) {
                    return ((IFolder)packRes).getFile(PACKAGE_HTML_FILENAME);
                }
            }
            return packRes;
        }
        return null;
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    NewPackageWizardPage.this.createPackage(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public IPackageFragment getNewPackageFragment() {
        return this.fCreatedPackageFragment;
    }

    public void createPackage(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IDialogSettings dialogSettings;
        IPackageFragmentRoot root;
        IPackageFragment pack;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fCreatedPackageFragment = (pack = (root = this.getPackageFragmentRoot()).getPackageFragment(this.getPackageText())).exists() ? pack : root.createPackageFragment(this.getPackageText(), true, monitor);
        if (this.isCreatePackageDocumentation()) {
            if (JavaModelUtil.is50OrHigher(this.getJavaProject())) {
                this.createPackageInfoJava(monitor);
            } else {
                this.createPackageHtml(root, monitor);
            }
        }
        if ((dialogSettings = this.getDialogSettings()) != null) {
            IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
            if (section == null) {
                section = dialogSettings.addNewSection(PAGE_NAME);
            }
            section.put(SETTINGS_CREATEPACKAGE_INFO_JAVA, this.isCreatePackageDocumentation());
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void createPackageInfoJava(IProgressMonitor monitor) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed(this.fCreatedPackageFragment.getJavaProject());
        StringBuilder content = new StringBuilder();
        String fileComment = this.getFileComment(lineDelimiter);
        String typeComment = this.getTypeComment(lineDelimiter);
        if (fileComment != null) {
            content.append(fileComment);
            content.append(lineDelimiter);
        }
        if (typeComment != null) {
            content.append(typeComment);
            content.append(lineDelimiter);
        } else if (fileComment != null) {
            content.append("/**");
            content.append(lineDelimiter);
            content.append(" *");
            content.append(lineDelimiter);
            content.append(" */");
            content.append(lineDelimiter);
        }
        content.append("package ");
        content.append(this.fCreatedPackageFragment.getElementName());
        content.append(";");
        ICompilationUnit compilationUnit = this.fCreatedPackageFragment.createCompilationUnit(PACKAGE_INFO_JAVA_FILENAME, content.toString(), true, monitor);
        JavaModelUtil.reconcile(compilationUnit);
        compilationUnit.becomeWorkingCopy(monitor);
        try {
            IBuffer buffer = compilationUnit.getBuffer();
            ISourceRange sourceRange = compilationUnit.getSourceRange();
            String originalContent = buffer.getText(sourceRange.getOffset(), sourceRange.getLength());
            String formattedContent = CodeFormatterUtil.format(8, originalContent, 0, lineDelimiter, this.fCreatedPackageFragment.getJavaProject());
            formattedContent = Strings.trimLeadingTabsAndSpaces(formattedContent);
            buffer.replace(sourceRange.getOffset(), sourceRange.getLength(), formattedContent);
            compilationUnit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            compilationUnit.discardWorkingCopy();
        }
    }

    private String getFileComment(String lineDelimiterUsed) throws CoreException {
        ICompilationUnit cu = this.fCreatedPackageFragment.getCompilationUnit(PACKAGE_INFO_JAVA_FILENAME);
        return CodeGeneration.getFileComment(cu, lineDelimiterUsed);
    }

    private String getTypeComment(String lineDelimiterUsed) throws CoreException {
        ICompilationUnit cu = this.fCreatedPackageFragment.getCompilationUnit(PACKAGE_INFO_JAVA_FILENAME);
        String typeName = PACKAGE_INFO_JAVA_FILENAME.substring(0, PACKAGE_INFO_JAVA_FILENAME.length() - ".java".length());
        return CodeGeneration.getTypeComment(cu, typeName, lineDelimiterUsed);
    }

    private void createPackageHtml(IPackageFragmentRoot root, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFolder createdPackage = workspace.getRoot().getFolder(this.fCreatedPackageFragment.getPath());
        IFile packageHtml = createdPackage.getFile(PACKAGE_HTML_FILENAME);
        String charset = packageHtml.getCharset();
        String content = this.buildPackageHtmlContent(root, charset);
        try {
            packageHtml.create((InputStream)new ByteArrayInputStream(content.getBytes(charset)), false, monitor);
        }
        catch (UnsupportedEncodingException e) {
            String message = "charset " + charset + " not supported by platform";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", message, (Throwable)e));
        }
    }

    private String buildPackageHtmlContent(IPackageFragmentRoot root, String charset) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed(root.getJavaProject());
        StringBuilder content = new StringBuilder();
        String fileComment = this.getFileComment(lineDelimiter);
        String typeComment = this.getTypeComment(lineDelimiter);
        content.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        content.append(lineDelimiter);
        if (fileComment != null) {
            content.append("<!--");
            content.append(lineDelimiter);
            content.append(this.stripJavaComments(fileComment));
            content.append(lineDelimiter);
            content.append("-->");
            content.append(lineDelimiter);
        }
        content.append("<html>");
        content.append(lineDelimiter);
        content.append("<head>");
        content.append(lineDelimiter);
        content.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        content.append(charset);
        content.append("\">");
        content.append(lineDelimiter);
        content.append("<title>");
        content.append(this.fCreatedPackageFragment.getElementName());
        content.append("</title>");
        content.append(lineDelimiter);
        content.append("</head>");
        content.append(lineDelimiter);
        content.append("<body>");
        content.append(lineDelimiter);
        if (typeComment != null) {
            content.append(this.stripJavaComments(typeComment));
            content.append(lineDelimiter);
        }
        content.append("</body>");
        content.append(lineDelimiter);
        content.append("</html>");
        return content.toString();
    }

    private String stripJavaComments(String comment) {
        try (DocumentAdapter documentAdapter = new DocumentAdapter(null, this.fCreatedPackageFragment.getPath());){
            documentAdapter.setContents(comment);
            String string = NewPackageWizardPage.getString((Reader)((Object)new JavaDoc2HTMLTextReader((Reader)((Object)new JavaDocCommentReader(documentAdapter, 0, comment.length())))));
            return string;
        }
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    private class PackageFieldAdapter
    implements IDialogFieldListener {
        private PackageFieldAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewPackageWizardPage.this.fPackageStatus = NewPackageWizardPage.this.getPackageStatus(NewPackageWizardPage.this.getPackageText());
            NewPackageWizardPage.this.handleFieldChanged(NewPackageWizardPage.PACKAGE);
        }
    }
}

