/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.SearchUtils;

public class RippleMethodFinder2 {
    private final IMethod fMethod;
    private List<IMethod> fDeclarations;
    private ITypeHierarchy fHierarchy;
    private Map<IType, IMethod> fTypeToMethod;
    private Set<IType> fRootTypes;
    private MultiMap<IType, IType> fRootReps;
    private Map<IType, ITypeHierarchy> fRootHierarchies;
    private UnionFind fUnionFind;
    private final boolean fExcludeBinaries;
    private final ReferencesInBinaryContext fBinaryRefs;
    private Map<IMethod, SearchMatch> fDeclarationToMatch;

    private RippleMethodFinder2(IMethod method, boolean excludeBinaries) {
        this.fMethod = method;
        this.fExcludeBinaries = excludeBinaries;
        this.fBinaryRefs = null;
    }

    private RippleMethodFinder2(IMethod method, ReferencesInBinaryContext binaryRefs) {
        this.fMethod = method;
        this.fExcludeBinaries = true;
        this.fDeclarationToMatch = new HashMap<IMethod, SearchMatch>();
        this.fBinaryRefs = binaryRefs;
    }

    public static IMethod[] getRelatedMethods(IMethod method, boolean excludeBinaries, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        try {
            if (!MethodChecks.isVirtual(method)) {
                IMethod[] iMethodArray = new IMethod[]{method};
                return iMethodArray;
            }
            IMethod[] iMethodArray = new RippleMethodFinder2(method, excludeBinaries).getAllRippleMethods(pm, owner);
            return iMethodArray;
        }
        finally {
            pm.done();
        }
    }

    public static IMethod[] getRelatedMethods(IMethod method, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        return RippleMethodFinder2.getRelatedMethods(method, true, pm, owner);
    }

    public static IMethod[] getRelatedMethods(IMethod method, ReferencesInBinaryContext binaryRefs, IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        try {
            if (!MethodChecks.isVirtual(method)) {
                IMethod[] iMethodArray = new IMethod[]{method};
                return iMethodArray;
            }
            IMethod[] iMethodArray = new RippleMethodFinder2(method, binaryRefs).getAllRippleMethods(pm, owner);
            return iMethodArray;
        }
        finally {
            pm.done();
        }
    }

    private IMethod[] getAllRippleMethods(IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        IMethod[] rippleMethods = this.findAllRippleMethods(pm, owner);
        if (this.fDeclarationToMatch == null) {
            return rippleMethods;
        }
        ArrayList<IMethod> rippleMethodsList = new ArrayList<IMethod>(Arrays.asList(rippleMethods));
        Iterator iter = rippleMethodsList.iterator();
        while (iter.hasNext()) {
            SearchMatch match = this.fDeclarationToMatch.get(iter.next());
            if (match == null) continue;
            iter.remove();
            this.fBinaryRefs.add(match);
        }
        this.fDeclarationToMatch = null;
        return rippleMethodsList.toArray(new IMethod[rippleMethodsList.size()]);
    }

    private IMethod[] findAllRippleMethods(IProgressMonitor pm, WorkingCopyOwner owner) throws CoreException {
        pm.beginTask("", 4);
        this.findAllDeclarations((IProgressMonitor)new SubProgressMonitor(pm, 1), owner);
        if (!this.fDeclarations.contains(this.fMethod)) {
            Assert.isTrue((boolean)false, (String)("Search for method declaration did not find original element: " + this.fMethod.toString()));
        }
        this.createHierarchyOfDeclarations((IProgressMonitor)new SubProgressMonitor(pm, 1), owner);
        this.createTypeToMethod();
        this.createUnionFind();
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fHierarchy = null;
        this.fRootTypes = null;
        HashMap<IType, ArrayList<IType>> partitioning = new HashMap<IType, ArrayList<IType>>();
        for (IType type : this.fTypeToMethod.keySet()) {
            IType rep = this.fUnionFind.find(type);
            ArrayList<IType> types = (ArrayList<IType>)partitioning.get(rep);
            if (types == null) {
                types = new ArrayList<IType>();
            }
            types.add(type);
            partitioning.put(rep, types);
        }
        Assert.isTrue((partitioning.size() > 0 ? 1 : 0) != 0);
        if (partitioning.size() == 1) {
            return this.fDeclarations.toArray(new IMethod[this.fDeclarations.size()]);
        }
        IType methodTypeRep = this.fUnionFind.find(this.fMethod.getDeclaringType());
        List relatedTypes = (List)partitioning.get(methodTypeRep);
        boolean hasRelatedInterfaces = false;
        ArrayList<IMethod> relatedMethods = new ArrayList<IMethod>();
        for (IType relatedType : relatedTypes) {
            relatedMethods.add(this.fTypeToMethod.get(relatedType));
            if (!relatedType.isInterface()) continue;
            hasRelatedInterfaces = true;
        }
        ArrayList<IMethod> alienDeclarations = new ArrayList<IMethod>(this.fDeclarations);
        this.fDeclarations = null;
        alienDeclarations.removeAll(relatedMethods);
        ArrayList<IType> alienTypes = new ArrayList<IType>();
        boolean hasAlienInterfaces = false;
        for (IMethod alienDeclaration : alienDeclarations) {
            IType alienType = alienDeclaration.getDeclaringType();
            alienTypes.add(alienType);
            if (!alienType.isInterface()) continue;
            hasAlienInterfaces = true;
        }
        if (alienTypes.size() == 0) {
            return relatedMethods.toArray(new IMethod[relatedMethods.size()]);
        }
        if (!hasRelatedInterfaces && !hasAlienInterfaces) {
            return relatedMethods.toArray(new IMethod[relatedMethods.size()]);
        }
        HashSet<IType> relatedSubTypes = new HashSet<IType>();
        ArrayList relatedTypesToProcess = new ArrayList(relatedTypes);
        while (relatedTypesToProcess.size() > 0) {
            Iterator iter = relatedTypesToProcess.iterator();
            while (iter.hasNext()) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IType relatedType = (IType)iter.next();
                ITypeHierarchy hierarchy = this.getCachedHierarchy(relatedType, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (hierarchy == null) {
                    hierarchy = relatedType.newTypeHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                IType[] allSubTypes = hierarchy.getAllSubtypes(relatedType);
                int i = 0;
                while (i < allSubTypes.length) {
                    relatedSubTypes.add(allSubTypes[i]);
                    ++i;
                }
            }
            relatedTypesToProcess.clear();
            HashSet<IType> marriedAlienTypeReps = new HashSet<IType>();
            Iterator iter2 = alienTypes.iterator();
            while (iter2.hasNext()) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IType alienType = (IType)iter2.next();
                IMethod alienMethod = this.fTypeToMethod.get(alienType);
                ITypeHierarchy hierarchy = this.getCachedHierarchy(alienType, owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (hierarchy == null) {
                    hierarchy = alienType.newTypeHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                IType[] allSubtypes = hierarchy.getAllSubtypes(alienType);
                int i = 0;
                while (i < allSubtypes.length) {
                    IType subtype = allSubtypes[i];
                    if (relatedSubTypes.contains(subtype) && JavaModelUtil.isVisibleInHierarchy((IMember)alienMethod, subtype.getPackageFragment())) {
                        marriedAlienTypeReps.add(this.fUnionFind.find(alienType));
                    }
                    ++i;
                }
            }
            if (marriedAlienTypeReps.size() == 0) {
                return relatedMethods.toArray(new IMethod[relatedMethods.size()]);
            }
            for (IType marriedAlienTypeRep : marriedAlienTypeReps) {
                List marriedAlienTypes = (List)partitioning.get(marriedAlienTypeRep);
                for (IType marriedAlienInterfaceType : marriedAlienTypes) {
                    relatedMethods.add(this.fTypeToMethod.get(marriedAlienInterfaceType));
                }
                alienTypes.removeAll(marriedAlienTypes);
                relatedTypesToProcess.addAll(marriedAlienTypes);
            }
        }
        this.fRootReps = null;
        this.fRootHierarchies = null;
        this.fTypeToMethod = null;
        this.fUnionFind = null;
        return relatedMethods.toArray(new IMethod[relatedMethods.size()]);
    }

    private ITypeHierarchy getCachedHierarchy(IType type, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        IType rep = this.fUnionFind.find(type);
        if (rep != null) {
            Collection<IType> collection = this.fRootReps.get(rep);
            for (IType root : collection) {
                ITypeHierarchy hierarchy = this.fRootHierarchies.get(root);
                if (hierarchy == null) {
                    hierarchy = root.newTypeHierarchy(owner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.fRootHierarchies.put(root, hierarchy);
                }
                if (!hierarchy.contains(type)) continue;
                return hierarchy;
            }
        }
        return null;
    }

    private void findAllDeclarations(IProgressMonitor monitor, WorkingCopyOwner owner) throws CoreException {
        this.fDeclarations = new ArrayList<IMethod>();
        int limitTo = 48;
        int matchRule = 24;
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fMethod, (int)limitTo, (int)matchRule);
        SearchParticipant[] participants = SearchUtils.getDefaultSearchParticipants();
        IJavaSearchScope scope = RefactoringScopeFactory.createRelatedProjectsScope(this.fMethod.getJavaProject(), 7);
        class MethodRequestor
        extends SearchRequestor {
            MethodRequestor() {
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMethod method = (IMethod)match.getElement();
                boolean isBinary = method.isBinary();
                if (RippleMethodFinder2.this.fBinaryRefs != null || !RippleMethodFinder2.this.fExcludeBinaries || !isBinary) {
                    RippleMethodFinder2.this.fDeclarations.add(method);
                }
                if (isBinary && RippleMethodFinder2.this.fBinaryRefs != null) {
                    RippleMethodFinder2.this.fDeclarationToMatch.put(method, match);
                }
            }
        }
        MethodRequestor requestor = new MethodRequestor();
        SearchEngine searchEngine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        searchEngine.search(pattern, participants, scope, (SearchRequestor)requestor, monitor);
    }

    private void createHierarchyOfDeclarations(IProgressMonitor pm, WorkingCopyOwner owner) throws JavaModelException {
        IRegion region = JavaCore.newRegion();
        Iterator<IMethod> iter = this.fDeclarations.iterator();
        while (iter.hasNext()) {
            IType declaringType = iter.next().getDeclaringType();
            region.add((IJavaElement)declaringType);
        }
        this.fHierarchy = JavaCore.newTypeHierarchy((IRegion)region, (WorkingCopyOwner)owner, (IProgressMonitor)pm);
    }

    private void createTypeToMethod() {
        this.fTypeToMethod = new HashMap<IType, IMethod>();
        for (IMethod declaration : this.fDeclarations) {
            this.fTypeToMethod.put(declaration.getDeclaringType(), declaration);
        }
    }

    private void createUnionFind() throws JavaModelException {
        this.fRootTypes = new HashSet<IType>(this.fTypeToMethod.keySet());
        this.fUnionFind = new UnionFind();
        for (IType type : this.fTypeToMethod.keySet()) {
            this.fUnionFind.init(type);
        }
        for (IType type : this.fTypeToMethod.keySet()) {
            this.uniteWithSupertypes(type, type);
        }
        this.fRootReps = new MultiMap();
        for (IType type : this.fRootTypes) {
            IType rep = this.fUnionFind.find(type);
            if (rep == null) continue;
            this.fRootReps.put(rep, type);
        }
        this.fRootHierarchies = new HashMap<IType, ITypeHierarchy>();
    }

    private void uniteWithSupertypes(IType anchor, IType type) throws JavaModelException {
        IType[] supertypes = this.fHierarchy.getSupertypes(type);
        int i = 0;
        while (i < supertypes.length) {
            IType supertype = supertypes[i];
            IType superRep = this.fUnionFind.find(supertype);
            if (superRep == null) {
                this.uniteWithSupertypes(anchor, supertype);
            } else {
                IMember superMethod = (IMember)this.fTypeToMethod.get(supertype);
                if (JavaModelUtil.isVisibleInHierarchy(superMethod, anchor.getPackageFragment())) {
                    IType rep = this.fUnionFind.find(anchor);
                    this.fUnionFind.union(rep, superRep);
                    this.fRootTypes.remove(anchor);
                    this.uniteWithSupertypes(supertype, supertype);
                }
            }
            ++i;
        }
    }

    private static class MultiMap<K, V> {
        HashMap<K, Collection<V>> fImplementation = new HashMap();

        private MultiMap() {
        }

        public void put(K key, V value) {
            Collection<V> collection = this.fImplementation.get(key);
            if (collection == null) {
                collection = new HashSet<V>();
                this.fImplementation.put(key, collection);
            }
            collection.add(value);
        }

        public Collection<V> get(K key) {
            return this.fImplementation.get(key);
        }
    }

    private static class UnionFind {
        HashMap<IType, IType> fElementToRepresentative = new HashMap();

        private UnionFind() {
        }

        public void init(IType type) {
            this.fElementToRepresentative.put(type, type);
        }

        public IType find(IType element) {
            IType root = element;
            IType rep = this.fElementToRepresentative.get(root);
            while (rep != null && !rep.equals(root)) {
                root = rep;
                rep = this.fElementToRepresentative.get(root);
            }
            if (rep == null) {
                return null;
            }
            rep = this.fElementToRepresentative.get(element);
            while (!rep.equals(root)) {
                IType temp = element;
                element = rep;
                this.fElementToRepresentative.put(temp, root);
                rep = this.fElementToRepresentative.get(element);
            }
            return root;
        }

        public void union(IType rep1, IType rep2) {
            this.fElementToRepresentative.put(rep1, rep2);
        }
    }
}

