/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.engine.LowPassFilter;
import fr.inria.zvtm.engine.SpeedCoupling;
import fr.inria.zvtm.glyphs.Translucency;
import fr.inria.zvtm.glyphs.Translucent;
import fr.inria.zvtm.lens.BlendingLens;
import fr.inria.zvtm.lens.TTrailingTimer;
import fr.inria.zvtm.lens.TemporalLens;
import fr.inria.zvtm.lens.TemporalParamListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;

public class SCBLens
extends BlendingLens
implements TemporalLens {
    double frequency = -1.0;
    long mLastSampleTime = -1L;
    int xOffset = -10;
    int yOffset = 10;
    double maxDist = 2 * Math.abs(this.xOffset);
    LowPassFilter filter = new LowPassFilter();
    Point2D currentPos = new Point2D.Double(0.0, 0.0);
    Point2D parentPos = new Point2D.Double(0.0, 0.0);
    Point2D targetPos = new Point2D.Double(0.0, 0.0);
    Timer timer;
    TTrailingTimer mouseStillUpdater;
    double cutoffParamA = 0.2;
    double cutoffParamB = 0.2;
    protected SpeedCoupling speedCoupling = null;
    protected float scRingRadius = this.LR2;
    protected boolean doRing = false;
    protected float dMM = this.MM;
    protected float mindMM = 1.0f;
    Color bColor = Color.BLACK;
    Color rColor = Color.BLACK;
    float a = 1.0f;
    float b = 0.0f;
    TemporalParamListener tpl;

    public SCBLens() {
        this(2.0f, 0.0f, 1.0f, 100, 0, 0);
    }

    public SCBLens(float mm) {
        this(mm, 0.0f, 1.0f, 100, 0, 0);
    }

    public SCBLens(float mm, float minT, float maxT, int innerRadius) {
        this(mm, minT, maxT, innerRadius, 0, 0);
    }

    public SCBLens(float mm, float minT, float maxT, int innerRadius, int x, int y) {
        this.MM = this.dMM = mm;
        this.LR2 = innerRadius;
        this.MMTf = maxT;
        this.updateMagBufferWorkingDimensions();
        this.computeOpacityFactors(minT, maxT);
        this.lx = x;
        this.ly = y;
        this.initTimer();
    }

    @Override
    void computeDropoffFactors() {
    }

    void computeOpacityFactors(float minT, float maxT) {
        this.a = maxT - minT;
        this.b = minT;
    }

    void initTimer() {
        this.timer = new Timer();
        this.mouseStillUpdater = new TTrailingTimer(this);
        this.timer.scheduleAtFixedRate((TimerTask)this.mouseStillUpdater, 40L, 20L);
    }

    @Override
    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
    }

    @Override
    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    @Override
    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
    }

    @Override
    public void gfT(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        g[0] = this.d <= (double)this.LR2 ? this.MMTf : 0.0f;
    }

    public void updateFrequency() {
        this.updateFrequency(System.currentTimeMillis());
    }

    public void updateFrequency(long currentTime) {
        if (this.frequency == -1.0) {
            this.frequency = 1.0;
        } else if (currentTime != this.mLastSampleTime) {
            this.frequency = 1000.0 / (double)(currentTime - this.mLastSampleTime);
        }
        this.mLastSampleTime = currentTime;
    }

    @Override
    public void updateTimeBasedParams(int cx, int cy) {
        this.parentPos.setLocation(cx, cy);
        this.updateTimeBasedParams();
    }

    @Override
    public void updateTimeBasedParams() {
        float bR;
        double opacity;
        if (this.speedCoupling != null) {
            opacity = 1.0 - (double)this.speedCoupling.getCoef();
        } else {
            this.targetPos.setLocation(this.parentPos.getX() + (double)this.xOffset, this.parentPos.getY() + (double)this.yOffset);
            double distAway = this.targetPos.distance(this.currentPos);
            opacity = 1.0 - Math.min(1.0, distAway / this.maxDist);
            this.filter.setCutOffFrequency((1.0 - opacity) * this.cutoffParamA + this.cutoffParamB);
            this.currentPos = this.filter.apply(this.targetPos, this.frequency);
            int tx = (int)Math.round(this.currentPos.getX());
            int ty = (int)Math.round(this.currentPos.getY());
            tx = Math.max(tx, this.w / 2);
            ty = Math.min(ty, this.owningView.parent.getPanelSize().height - this.h / 2);
        }
        float nMMTf = (float)opacity * this.a + this.b;
        if (Math.abs(this.MMTf - nMMTf) > 0.01f) {
            this.MMTf = nMMTf;
            this.owningView.parent.repaint();
            if (this.tpl != null) {
                this.tpl.parameterUpdated();
            }
        }
        this.dMM = (float)opacity * (this.MM - this.mindMM) + this.mindMM;
        if (this.doRing && Math.abs((bR = Math.min((float)this.LR2, (float)opacity * (float)this.LR2 + 1.0f)) - this.scRingRadius) > 1.0f) {
            this.scRingRadius = bR;
            this.owningView.parent.repaint();
        }
    }

    public void setCutoffFrequencyParameters(double a, double b) {
        this.cutoffParamA = a;
        this.cutoffParamB = b;
    }

    public void setSpeedCoupling(SpeedCoupling sc) {
        this.speedCoupling = sc;
    }

    public void setDoRing(boolean b) {
        this.doRing = b;
    }

    public boolean getDoRing() {
        return this.doRing;
    }

    @Override
    public void setNoUpdateWhenMouseStill(boolean b) {
        this.mouseStillUpdater.setEnabled(!b);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.cancel();
    }

    @Override
    public synchronized void setAbsolutePosition(int ax, int ay, long absTime) {
        super.setAbsolutePosition(ax, ay);
        this.updateFrequency(absTime);
        this.updateTimeBasedParams(ax, ay);
        if (this.speedCoupling != null) {
            this.speedCoupling.addPoint(ax, ay, absTime);
        }
    }

    @Override
    public int getRadius() {
        return this.LR2;
    }

    public void setBoundaryColor(Color bc) {
        this.bColor = bc;
    }

    public void setObservedRegionColor(Color bc) {
        this.rColor = bc;
    }

    @Override
    public void drawBoundary(Graphics2D g2d) {
        if (this.bColor != null) {
            g2d.setColor(this.bColor);
            g2d.drawOval(this.lx + this.w / 2 - this.lensWidth / 2, this.ly + this.h / 2 - this.lensHeight / 2, this.lensWidth, this.lensHeight);
        }
        if (this.rColor != null) {
            this.lensProjectedWidth = Math.round((float)this.lensWidth / this.MM);
            this.lensProjectedHeight = Math.round((float)this.lensHeight / this.MM);
            g2d.setColor(this.rColor);
            g2d.setComposite(Translucency.acs[Math.round((1.0f - this.MMTf) * 20.0f)]);
            g2d.drawOval(this.lx + this.w / 2 - this.lensProjectedWidth / 2, this.ly + this.h / 2 - this.lensProjectedHeight / 2, this.lensProjectedWidth, this.lensProjectedHeight);
            g2d.setComposite(Translucent.acO);
        }
        if (this.doRing && this.rColor != null) {
            g2d.setColor(this.rColor);
            float dbr = Math.max((float)this.lensProjectedWidth / 2.0f, this.scRingRadius - 2.0f);
            g2d.drawOval(this.lx + this.w / 2 - (int)dbr, this.ly + this.h / 2 - (int)dbr, 2 * (int)dbr, 2 * (int)dbr);
        }
    }

    @Override
    public float getActualRingRadius() {
        return this.scRingRadius;
    }

    @Override
    public float getActualMaximumMagnification() {
        return this.dMM;
    }

    @Override
    public void setTemporalParamListener(TemporalParamListener tpl) {
        this.tpl = tpl;
    }

    @Override
    public TemporalParamListener getTemporalParamListener() {
        return this.tpl;
    }
}

