/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.GlyphFactory;
import fr.inria.zvtm.glyphs.GlyphPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class VShapePanel
extends GlyphPanel
implements MouseMotionListener,
MouseListener {
    Polygon p;
    int x2;
    int y2;
    double tmpD;

    VShapePanel(GlyphFactory gfact) {
        super(gfact);
        this.vertices = this.gf.vertices;
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        for (int j = 0; j < this.vertices.length - 1; ++j) {
            this.xcoords[j] = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle) * this.vertices[j]);
            this.ycoords[j] = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle) * this.vertices[j]);
            this.vertexAngle += Math.PI * 2 / (double)this.vertices.length;
        }
        this.xcoords[this.vertices.length - 1] = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle) * this.vertices[this.vertices.length - 1]);
        this.ycoords[this.vertices.length - 1] = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle) * this.vertices[this.vertices.length - 1]);
        this.p = new Polygon(this.xcoords, this.ycoords, this.xcoords.length);
        if (this.alpha > 0.0) {
            if (this.alpha == 1.0) {
                this.g2d.setColor(this.fColor);
                this.g2d.fillPolygon(this.p);
            } else {
                this.g2d.setColor(this.fColor);
                this.g2d.setComposite(this.acST);
                this.g2d.fillPolygon(this.p);
                this.g2d.setComposite(acO);
            }
        }
        this.g2d.setColor(this.bColor);
        this.g2d.drawPolygon(this.p);
        this.g2d.setColor(Color.black);
        if (this.displayIndicators) {
            this.g2d.setStroke(dashed);
            this.g2d.drawOval(this.cx - this.cs, this.cy - this.cs, 2 * this.cs, 2 * this.cs);
            this.vertexAngle = this.gf.angle;
            for (int i = 0; i < this.xcoords.length; ++i) {
                this.x2 = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle));
                this.y2 = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle));
                this.g2d.drawLine(this.cx, this.cy, this.x2, this.y2);
                if (i == this.selectedVertex) {
                    this.g2d.setColor(Color.red);
                    this.g2d.fillRect(this.xcoords[i] - 3, this.ycoords[i] - 3, 6, 6);
                    this.g2d.setColor(Color.black);
                } else {
                    this.g2d.fillRect(this.xcoords[i] - 3, this.ycoords[i] - 3, 6, 6);
                }
                this.vertexAngle += Math.PI * 2 / (double)this.vertices.length;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedVertex >= 0) {
            this.tmpD = Math.sqrt((e.getX() - this.cx) * (e.getX() - this.cx) + (e.getY() - this.cy) * (e.getY() - this.cy)) / (double)this.cs;
            if (this.tmpD < 0.0) {
                this.tmpD = 0.0;
            } else if (this.tmpD > 1.0) {
                this.tmpD = 1.0;
            }
            this.vertices[this.selectedVertex] = this.tmpD;
            this.gf.setVertexVal(this.tmpD);
            this.repaint();
        } else {
            this.orientDrag(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        boolean selectedSomething = false;
        if (GlyphFactory.hasEditableVertexValues()) {
            for (int i = 0; i < this.xcoords.length; ++i) {
                if (this.xcoords[i] - 3 > mx || mx > this.xcoords[i] + 3 || this.ycoords[i] - 3 > my || my > this.ycoords[i] + 3) continue;
                this.selectedVertex = i;
                selectedSomething = true;
                break;
            }
        }
        if (!selectedSomething) {
            this.selectedVertex = this.gf.orientable && GlyphFactory.hasEditableAngle() && this.xorientHandle - 3 <= mx && mx <= this.xorientHandle + 3 && this.yorientHandle - 3 <= my && my <= this.yorientHandle + 3 ? -2 : -1;
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        boolean selectedSomething = false;
        if (GlyphFactory.hasEditableVertexValues()) {
            for (int i = 0; i < this.xcoords.length; ++i) {
                if (this.xcoords[i] - 3 > mx || mx > this.xcoords[i] + 3 || this.ycoords[i] - 3 > my || my > this.ycoords[i] + 3) continue;
                selectedSomething = true;
                this.selectedVertex = i;
                this.gf.setVertexVal(this.vertices[i]);
                break;
            }
        }
        if (!selectedSomething) {
            this.selectedVertex = -1;
            this.gf.setVertexVal(-1.0);
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(1));
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.gf.vertices = this.vertices;
    }
}

