/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.projection.ProjEllipse;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class VEllipse<T>
extends ClosedShape
implements RectangularShape {
    public double vw;
    public double vh;
    public double ar;
    ProjEllipse[] pc;

    public VEllipse() {
        this(0.0, 0.0, 0, 20.0, 10.0, Color.WHITE, Color.BLACK, 1.0f);
    }

    public VEllipse(double x, double y, int z, double w, double h, Color c) {
        this(x, y, z, w, h, c, Color.BLACK, 1.0f);
    }

    public VEllipse(double x, double y, int z, double w, double h, Color c, Color bc) {
        this(x, y, z, w, h, c, bc, 1.0f);
    }

    public VEllipse(double x, double y, int z, double w, double h, Color c, Color bc, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.orient = 0.0;
        this.setColor(c);
        this.setBorderColor(bc);
        this.computeSize();
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new ProjEllipse[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjEllipse();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjEllipse[] ta = this.pc;
                this.pc = new ProjEllipse[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjEllipse();
            } else {
                System.err.println("VEllipse:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjEllipse[1];
            this.pc[0] = new ProjEllipse();
        } else {
            System.err.println("VEllipse:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return 0.0;
    }

    @Override
    public void orientTo(double angle) {
    }

    void computeSize() {
        this.size = Math.max(this.vw, this.vh);
        this.ar = this.vw / this.vh;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        if (this.vw >= this.vh) {
            this.vw = this.size;
            this.vh = this.vw / this.ar;
        } else {
            this.vh = this.size;
            this.vw = this.vh * this.ar;
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setWidth(double w) {
        this.vw = w;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHeight(double h) {
        this.vh = h;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        if (this.vw >= this.vh) {
            this.vw = this.size;
            this.vh = this.vw / this.ar;
        } else {
            this.vh = this.size;
            this.vw = this.vh * this.ar;
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return this.pc[camIndex].ellipse.contains(jpx, jpy);
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].ellipse.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cvw = (int)Math.round(this.vw / 2.0 * this.coef);
        this.pc[i].cvh = (int)Math.round(this.vh / 2.0 * this.coef);
        this.pc[i].ellipse.setFrame((double)this.pc[i].cx - this.vw / 2.0 * this.coef, (double)this.pc[i].cy - this.vh / 2.0 * this.coef, 2.0f * this.pc[i].cvw, 2.0f * this.pc[i].cvh);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcvw = (int)Math.round(this.vw / 2.0 * this.coef);
        this.pc[i].lcvh = (int)Math.round(this.vh / 2.0 * this.coef);
        this.pc[i].lellipse.setFrame((double)this.pc[i].lcx - this.vw / 2.0 * this.coef, (double)this.pc[i].lcy - this.vh / 2.0 * this.coef, 2.0f * this.pc[i].lcvw, 2.0f * this.pc[i].lcvh);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].ellipse.getBounds().width > 2 || this.pc[i].ellipse.getBounds().height > 2) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fill(this.pc[i].ellipse);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.draw(this.pc[i].ellipse);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.draw(this.pc[i].ellipse);
                        g.translate(-dx, -dy);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fill(this.pc[i].ellipse);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.draw(this.pc[i].ellipse);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.draw(this.pc[i].ellipse);
                        g.translate(-dx, -dy);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lellipse.getBounds().width > 2 || this.pc[i].lellipse.getBounds().height > 2) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fill(this.pc[i].lellipse);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.draw(this.pc[i].lellipse);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.draw(this.pc[i].lellipse);
                        g.translate(-dx, -dy);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fill(this.pc[i].lellipse);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.draw(this.pc[i].lellipse);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.draw(this.pc[i].lellipse);
                        g.translate(-dx, -dy);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            }
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Ellipse2D.Double(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public Object clone() {
        VEllipse<T> res = new VEllipse<T>(this.vx, this.vy, this.vz, this.vw, this.vh, this.color, this.borderColor, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

