/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.CameraListener;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Camera {
    public static final float DEFAULT_FOCAL = 100.0f;
    int index;
    public double vx;
    public double vy;
    private double wb = -1.7976931348623157E308;
    private double nb = Double.MAX_VALUE;
    private double eb = Double.MAX_VALUE;
    private double sb = -1.7976931348623157E308;
    public double altitude;
    public double focal;
    boolean enabled;
    VirtualSpace parentSpace;
    View view;
    Glyph[] stickedGlyphs;
    Camera[] stickedCameras;
    boolean[] stickAltitude;
    boolean eager = true;
    boolean shouldRepaint = false;
    private double zoomFloor = 0.0;
    private double zoomCeiling = Double.MAX_VALUE;
    private final List<CameraListener> listeners = new CopyOnWriteArrayList<CameraListener>();
    protected volatile double dx;
    protected volatile double dy;
    protected volatile double dz;
    protected volatile boolean zile = false;
    protected volatile double zilX;
    protected volatile double zilY;

    Camera(double x, double y, double alt, double f, int i) {
        this(x, y, alt, f, i, false);
    }

    Camera(double x, double y, double alt, double f, int i, boolean l) {
        this.vx = x;
        this.vy = y;
        this.altitude = alt;
        this.focal = f;
        this.index = i;
        this.enabled = true;
        this.eager = !l;
    }

    public void setZoomFloor(double a) {
        this.zoomFloor = a;
    }

    public double getZoomFloor() {
        return this.zoomFloor;
    }

    public void setZoomCeiling(double a) {
        this.zoomCeiling = a;
    }

    public double getZoomCeiling() {
        return this.zoomCeiling;
    }

    public void setBounds(double[] wnes) {
        if (wnes[0] > wnes[2] || wnes[1] < wnes[3]) {
            throw new IllegalArgumentException("Invalid Camera bounds");
        }
        this.wb = wnes[0];
        this.nb = wnes[1];
        this.eb = wnes[2];
        this.sb = wnes[3];
    }

    public double[] getBounds() {
        return new double[]{this.wb, this.nb, this.eb, this.sb};
    }

    public void move(double x, double y) {
        this.moveTo(this.vx + x, this.vy + y);
    }

    public void moveTo(double x, double y) {
        if (x < this.wb) {
            x = this.wb;
        }
        if (x > this.eb) {
            x = this.eb;
        }
        if (y < this.sb) {
            y = this.sb;
        }
        if (y > this.nb) {
            y = this.nb;
        }
        this.vx = x;
        this.vy = y;
        this.propagateMove(x - this.vx, y - this.vy);
        if (this.view != null) {
            VirtualSpaceManager.INSTANCE.repaint(this.view);
        }
        this.notifyMoved();
    }

    public void setAltitude(double a) {
        this.setAltitude(a, true);
    }

    public void altitudeOffset(double a) {
        this.altitudeOffset(a, true);
    }

    public void setAltitude(double a, boolean repaint) {
        double oldAlt = this.altitude;
        this.altitude = a < this.zoomFloor ? this.zoomFloor : (a > this.zoomCeiling ? this.zoomCeiling : a);
        this.propagateAltitudeChange(this.altitude - oldAlt);
        if (repaint && this.view != null) {
            VirtualSpaceManager.INSTANCE.repaint(this.view);
        }
        this.notifyMoved();
    }

    public void altitudeOffset(double a, boolean repaint) {
        this.setAltitude(this.altitude + a, repaint);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setLocation(Location l) {
        double clippedx = l.vx;
        double clippedy = l.vy;
        if (clippedx < this.wb) {
            clippedx = this.wb;
        }
        if (clippedx > this.eb) {
            clippedx = this.eb;
        }
        if (clippedy < this.sb) {
            clippedy = this.sb;
        }
        if (clippedy > this.nb) {
            clippedy = this.nb;
        }
        double deltax = clippedx - this.vx;
        double deltay = clippedy - this.vy;
        this.vx = clippedx;
        this.vy = clippedy;
        this.propagateMove(deltax, deltay);
        double clippedAlt = l.alt;
        if (clippedAlt < this.zoomFloor) {
            clippedAlt = this.zoomFloor;
        }
        if (clippedAlt > this.zoomCeiling) {
            clippedAlt = this.zoomCeiling;
        }
        double deltaAlt = clippedAlt - this.altitude;
        this.propagateAltitudeChange(clippedAlt);
        this.altitude = clippedAlt;
        if (this.view != null) {
            VirtualSpaceManager.INSTANCE.repaint(this.view);
        }
        this.notifyMoved();
    }

    public Location getLocation() {
        return new Location(this.vx, this.vy, this.altitude);
    }

    public void setXspeed(double dx) {
        this.dx = dx;
    }

    public void setYspeed(double dy) {
        this.dy = dy;
    }

    public void setZspeed(double dz) {
        this.dz = dz;
    }

    public void setZoomInvariantLocation(double x, double y) {
        this.zilX = x;
        this.zilY = y;
    }

    public void enableCustomZoomInvariantLocation(boolean b) {
        this.zile = b;
    }

    public double getZilX() {
        return this.zilX;
    }

    public double getZilY() {
        return this.zilY;
    }

    public boolean isCustomZoomInvariantLocationEnabled() {
        return this.zile;
    }

    public double getXspeed() {
        return this.dx;
    }

    public double getYspeed() {
        return this.dy;
    }

    public double getZspeed() {
        return this.dz;
    }

    public void addListener(CameraListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CameraListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyMoved() {
        for (CameraListener listener : this.listeners) {
            listener.cameraMoved(this, new Point2D.Double(this.vx, this.vy), this.altitude);
        }
    }

    public void setFocal(double f) {
        if (f < 0.0) {
            f = 0.0;
        }
        this.focal = f;
    }

    public double getFocal() {
        return this.focal;
    }

    public void propagateMove(double x, double y) {
        int i;
        double lx = x;
        double ly = y;
        if (this.stickedGlyphs != null) {
            for (i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].move(lx, ly);
            }
        }
        if (this.stickedCameras != null) {
            for (i = 0; i < this.stickedCameras.length; ++i) {
                this.stickedCameras[i].moveTo(this.vx, this.vy);
            }
        }
    }

    public void propagateAltitudeChange(double alt) {
        if (this.stickedCameras != null && alt != 0.0) {
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                if (!this.stickAltitude[i]) continue;
                this.stickedCameras[i].setAltitude(this.altitude);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    protected void setOwningSpace(VirtualSpace vs) {
        this.parentSpace = vs;
    }

    public VirtualSpace getOwningSpace() {
        return this.parentSpace;
    }

    public void setOwningView(View vi) {
        this.view = vi;
    }

    public View getOwningView() {
        return this.view;
    }

    public void stick(Glyph g) {
        if (this.stickedGlyphs == null) {
            this.stickedGlyphs = new Glyph[1];
            this.stickedGlyphs[0] = g;
            g.stickedTo = this;
        } else {
            boolean alreadySticked = false;
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                alreadySticked = true;
                break;
            }
            if (!alreadySticked) {
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length + 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length);
                newStickList[this.stickedGlyphs.length] = g;
                this.stickedGlyphs = newStickList;
                g.stickedTo = this;
            } else if (VirtualSpaceManager.debugModeON()) {
                System.err.println("Warning: trying to stick Glyph " + g + " to Camera " + this + " while they are already sticked.");
            }
        }
    }

    public void unstick(Glyph g) {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                g.stickedTo = null;
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, i);
                System.arraycopy(this.stickedGlyphs, i + 1, newStickList, i, this.stickedGlyphs.length - i - 1);
                this.stickedGlyphs = newStickList;
                break;
            }
            if (this.stickedGlyphs.length == 0) {
                this.stickedGlyphs = null;
            }
        }
    }

    public void unstickAllGlyphs() {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].stickedTo = null;
                this.stickedGlyphs[i] = null;
            }
            this.stickedGlyphs = null;
        }
    }

    public Glyph[] getStickedGlyphArray() {
        return this.stickedGlyphs;
    }

    public void stick(Camera c) {
        this.stick(c, true);
    }

    public void stick(Camera c, boolean stickAlt) {
        if (this.stickedCameras == null) {
            this.stickedCameras = new Camera[1];
            this.stickedCameras[0] = c;
            this.stickAltitude = new boolean[1];
            this.stickAltitude[0] = stickAlt;
        } else {
            boolean alreadySticked = false;
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                if (this.stickedCameras[i] != c) continue;
                alreadySticked = true;
                break;
            }
            if (!alreadySticked) {
                Camera[] newStickList = new Camera[this.stickedCameras.length + 1];
                System.arraycopy(this.stickedCameras, 0, newStickList, 0, this.stickedCameras.length);
                newStickList[this.stickedCameras.length] = c;
                this.stickedCameras = newStickList;
                boolean[] newStickAltList = new boolean[this.stickAltitude.length + 1];
                System.arraycopy(this.stickAltitude, 0, newStickAltList, 0, this.stickAltitude.length);
                newStickAltList[this.stickAltitude.length] = stickAlt;
                this.stickAltitude = newStickAltList;
            } else if (VirtualSpaceManager.debugModeON()) {
                System.err.println("Warning: trying to stick Camera " + c + " to Camera " + this + " while they are already sticked.");
            }
        }
    }

    public void unstick(Camera c) {
        if (this.stickedCameras != null) {
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                if (this.stickedCameras[i] != c) continue;
                Camera[] newStickList = new Camera[this.stickedCameras.length - 1];
                System.arraycopy(this.stickedCameras, 0, newStickList, 0, i);
                System.arraycopy(this.stickedCameras, i + 1, newStickList, i, this.stickedCameras.length - i - 1);
                this.stickedCameras = newStickList;
                boolean[] newStickAltList = new boolean[this.stickAltitude.length - 1];
                System.arraycopy(this.stickAltitude, 0, newStickAltList, 0, i);
                System.arraycopy(this.stickAltitude, i + 1, newStickAltList, i, this.stickAltitude.length - i - 1);
                this.stickAltitude = newStickAltList;
                break;
            }
            if (this.stickedCameras.length == 0) {
                this.stickedCameras = null;
                this.stickAltitude = null;
            }
        }
    }

    public void unstickAllCameras() {
        if (this.stickedCameras != null) {
            for (int i = 0; i < this.stickedCameras.length; ++i) {
                this.stickedCameras[i] = null;
            }
            this.stickedCameras = null;
            this.stickAltitude = null;
        }
    }

    public Camera[] getStickedCameraArray() {
        return this.stickedCameras;
    }

    public void setEnabled(boolean b) {
        if (b != this.enabled) {
            this.enabled = b;
            VirtualSpaceManager.INSTANCE.repaint(this.view);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLaziness(boolean b) {
        this.eager = !b;
    }

    public boolean getLaziness() {
        return !this.eager;
    }

    public void repaint() {
        this.shouldRepaint = true;
    }

    protected boolean shouldRepaint() {
        if (this.shouldRepaint) {
            this.shouldRepaint = false;
            return true;
        }
        return false;
    }

    public String toString() {
        return new String("Camera: index" + this.index + " position (" + this.vx + "," + this.vy + ") alt " + this.altitude + " focal " + this.focal);
    }

    public static void stickToCamera(Glyph g, Camera c) {
        c.stick(g);
    }

    public static void unstickAllGlyphs(Camera c) {
        c.unstickAllGlyphs();
    }
}

