/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.properties.data.DOMErrorHandlerImpl;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public final class GUIProjectImporter {
    private static final String CREATING_PROJECT = "creating project";
    private static final String CREATION_FAILED = "Project creation failed";
    private static final String DOM_IMPLEMENTATION_SOURCE = "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl";
    private static final String LOAD_SAVE_VERSION = "LS 3.0";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String TRUE = "true";

    private Document getDocumentFromFile(String file) {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", DOM_IMPLEMENTATION_SOURCE);
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)ce);
            return null;
        }
        catch (InstantiationException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
            return null;
        }
        catch (IllegalAccessException iae) {
            ErrorReporter.logExceptionStackTrace((Exception)iae);
            return null;
        }
        DOMImplementation domImpl = registry.getDOMImplementation(LOAD_SAVE_VERSION);
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)domImpl);
        LSParser parser = domImplLS.createLSParser((short)1, XML_SCHEMA);
        DOMConfiguration config = parser.getDomConfig();
        DOMErrorHandlerImpl errorHandler = new DOMErrorHandlerImpl();
        config.setParameter("error-handler", errorHandler);
        config.setParameter("validate", Boolean.TRUE);
        config.setParameter("schema-type", XML_SCHEMA);
        config.setParameter("validate-if-schema", Boolean.TRUE);
        LSInput lsInput = domImplLS.createLSInput();
        try {
            FileInputStream istream = new FileInputStream(file);
            lsInput.setByteStream(istream);
            Document document = parser.parse(lsInput);
            ((InputStream)istream).close();
            return document;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return null;
        }
        catch (DOMException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return null;
        }
        catch (LSException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return null;
        }
    }

    public ProjectInformation loadProjectFile(String projectFile, SubMonitor monitor, boolean headless) {
        Document document = this.getDocumentFromFile(projectFile);
        if (document == null) {
            return null;
        }
        String documentType = document.getDoctype().getNodeName();
        if (!"TITAN_GUI_project_file".equals(documentType)) {
            this.reportError("Incorrect document type `" + documentType + "' in file `" + projectFile + "'. Expected: `TITAN_GUI_project_file'", headless);
            return null;
        }
        String rootNodeName = document.getDocumentElement().getNodeName();
        if (!"Project".equals(rootNodeName)) {
            this.reportError("Incorrect root node name `" + rootNodeName + "' in file `" + projectFile + "'. Expected root node name: `Project'", headless);
            return null;
        }
        ProjectInformation projectInformation = new ProjectInformation();
        projectInformation.sourceFile = projectFile;
        Path path = new Path(projectFile);
        path = path.removeFileExtension();
        projectInformation.name = path.lastSegment();
        NodeList rootList = document.getDocumentElement().getChildNodes();
        int size = rootList.getLength();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        progress.setTaskName("Loading data");
        for (int j = 0; j < size; ++j) {
            Node node = rootList.item(j);
            String nodeName = node.getNodeName();
            if (!"#text".equals(nodeName)) {
                if ("General".equals(nodeName)) {
                    this.loadGeneralSettings(node, projectInformation);
                } else if ("Modules".equals(nodeName)) {
                    this.loadListSettings(node, "Module", projectInformation.modules);
                } else if ("TestPorts".equals(nodeName)) {
                    this.loadListSettings(node, "TestPort", projectInformation.testports);
                } else if ("Other_Sources".equals(nodeName)) {
                    this.loadListSettings(node, "Other_Source", projectInformation.otherSources);
                } else if ("Configs".equals(nodeName)) {
                    this.loadListSettings(node, "Config", projectInformation.configs);
                } else if ("Test_Cases".equals(nodeName)) {
                    this.loadListSettings(node, "Test_Case", projectInformation.testcases);
                } else if ("Test_Sets".equals(nodeName)) {
                    this.loadTestSets(node, projectInformation);
                } else if ("Others".equals(nodeName)) {
                    this.loadListSettings(node, "Other", projectInformation.others);
                } else if ("Included_Projects".equals(nodeName)) {
                    this.loadIncludedProjects(node, projectInformation, (IProgressMonitor)progress.newChild(1));
                } else if ("File_Group".equals(nodeName)) {
                    projectInformation.fileGroupRoot = new FileGroup();
                    this.loadFileGroups(node, projectInformation.fileGroupRoot, projectFile, (IProgressMonitor)progress.newChild(1), headless);
                } else {
                    this.reportError("Incorrect node name `" + nodeName + "' within node `Project' in file `" + projectFile + "'", headless);
                }
            }
            progress.setWorkRemaining(size - j - 1);
        }
        progress.done();
        return projectInformation;
    }

    private void reportError(String message, boolean headless) {
        ErrorReporter.logError((String)("Import from prj error: " + message));
    }

    private void loadGeneralSettings(Node generalNode, ProjectInformation projectInformation) {
        NodeList nodeList = generalNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String temp;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if ("#text".equals(nodeName)) continue;
            if ("Project_Name".equals(nodeName)) {
                projectInformation.name = node.getTextContent();
                continue;
            }
            if ("Executable_Path".equals(nodeName)) {
                projectInformation.executablePath = node.getTextContent();
                continue;
            }
            if ("Executable_Name".equals(nodeName)) {
                projectInformation.executableName = node.getTextContent();
                continue;
            }
            if ("Working_Dir".equals(nodeName)) {
                projectInformation.workingDir = node.getTextContent();
                continue;
            }
            if ("Execution_Mode".equals(nodeName)) {
                String context = node.getTextContent();
                projectInformation.executionMode = "Single".equals(context) ? ExecutionModes.SINGLE : ExecutionModes.PARALLEL;
                continue;
            }
            if ("Code_Splitting_Mode".equals(nodeName)) {
                temp = node.getTextContent();
                if (!"Type".equals(temp)) continue;
                projectInformation.codeSplittingMode = CodeSplittingModes.TYPE;
                continue;
            }
            if ("ScriptFile_AfterMake".equals(nodeName)) {
                projectInformation.scriptAfterMake = node.getTextContent();
                continue;
            }
            if ("GNU_Make".equals(nodeName)) {
                projectInformation.gnuMake = node.getTextContent();
                continue;
            }
            if ("Generate_Absolute_references_In_Makefile".equals(nodeName)) {
                projectInformation.useAbsoluteReferencesInMakefile = node.getTextContent();
                continue;
            }
            if ("Use_FunctionTest_Runtime_In_Makefile".equals(nodeName)) {
                projectInformation.useFunctionTestRuntime = node.getTextContent();
                continue;
            }
            if ("Use_Dynamic_Linking_In_Makefile".equals(nodeName)) {
                projectInformation.useDynamicLinking = node.getTextContent();
                continue;
            }
            if ("Build_Host".equals(nodeName)) {
                projectInformation.buildHost = node.getTextContent();
                continue;
            }
            if ("Localhost_Execute".equals(nodeName)) {
                projectInformation.localHostExecute = node.getTextContent();
                continue;
            }
            if ("Execute_Command".equals(nodeName)) {
                projectInformation.executeCommand = node.getTextContent();
                continue;
            }
            if ("Execute_Hosts".equals(nodeName)) {
                projectInformation.executeHosts = node.getTextContent();
                continue;
            }
            if ("Log_Dir".equals(nodeName)) {
                projectInformation.logDirs.add(node.getTextContent());
                continue;
            }
            if (!"UnUsed_List".equals(nodeName)) continue;
            temp = node.getTextContent();
            String[] temp2 = temp.split(",");
            Collections.addAll(projectInformation.unUsedList, temp2);
        }
    }

    public static void applySettings(IProject project, ProjectInformation info, SubMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
        progress.setTaskName("Creating settings");
        GUIProjectImporter.setGeneralSettings(project, info, (IProgressMonitor)progress.newChild(1));
        GUIProjectImporter.setListSettings(project, info.sourceFile, info.modules, progress.newChild(1));
        GUIProjectImporter.setListSettings(project, info.sourceFile, info.testports, progress.newChild(1));
        GUIProjectImporter.setListSettings(project, info.sourceFile, info.otherSources, progress.newChild(1));
        GUIProjectImporter.setListSettings(project, info.sourceFile, info.configs, progress.newChild(1));
        GUIProjectImporter.setListSettings(project, info.sourceFile, info.others, progress.newChild(1));
        GUIProjectImporter.setGroupFileSettings(project, info.sourceFile, info.fileGroupRoot, (IProgressMonitor)progress.newChild(1));
        GUIProjectImporter.setIncludedProjects(project, info);
        GUIProjectImporter.setUnusedFiles(project, info, (IProgressMonitor)progress.newChild(1));
        progress.done();
    }

    public static void setGeneralSettings(IProject project, ProjectInformation info, IProgressMonitor monitor) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateMakefile"), TRUE);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"), "cpp");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "C/C++ compiler"), "g++");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "addSourceLineInfo"), TRUE);
            monitor.subTask("Resolving the path `" + info.workingDir + "'");
            String absolutePath = PathConverter.getAbsolutePath((String)project.getLocation().toOSString(), (String)info.workingDir);
            String relativePath = absolutePath == null ? "bin" : PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)absolutePath);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"), relativePath);
            if (info.executablePath != null) {
                monitor.subTask("Resolving the path `" + info.executablePath + "'");
                absolutePath = PathConverter.getAbsolutePath((String)project.getLocation().toOSString(), (String)info.executablePath);
            } else {
                monitor.subTask("Resolving the path `" + info.workingDir + "'");
                absolutePath = PathConverter.getAbsolutePath((String)project.getLocation().toOSString(), (String)info.workingDir);
                absolutePath = absolutePath + File.separatorChar + info.executableName;
            }
            if (absolutePath == null) {
                absolutePath = "bin" + File.separatorChar + info.executableName;
            }
            relativePath = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)absolutePath);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"), relativePath);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "singleMode"), ExecutionModes.SINGLE.equals((Object)info.executionMode) ? TRUE : "false");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"), CodeSplittingModes.TYPE.equals((Object)info.codeSplittingMode) ? "type" : "none");
            if (info.scriptAfterMake != null) {
                monitor.subTask("Resolving the path `" + info.scriptAfterMake + "'");
                absolutePath = PathConverter.getAbsolutePath((String)info.sourceFile, (String)info.scriptAfterMake);
                relativePath = absolutePath == null ? null : PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)absolutePath);
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"), relativePath);
            }
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "GNUMake"), "yes".equals(info.gnuMake) ? TRUE : "false");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useAbsolutePath"), "yes".equals(info.useAbsoluteReferencesInMakefile) ? TRUE : "false");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime"), "yes".equals(info.useFunctionTestRuntime) ? TRUE : "false");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "DynamicLinkingProperty"), "yes".equals(info.useDynamicLinking) ? TRUE : "false");
            int size = info.logDirs.size();
            for (int i = 0; i < size; ++i) {
                monitor.subTask("Resolving the path `" + (String)info.logDirs.get(i) + "'");
                absolutePath = PathConverter.getAbsolutePath((String)info.sourceFile, (String)((String)info.logDirs.get(i)));
                if (absolutePath == null) continue;
                Path path = new Path(absolutePath);
                IPath locationPath = project.getLocation();
                if (locationPath.isPrefixOf((IPath)path)) continue;
                IFolder folder = project.getFolder("Log_Dir" + (i + 1));
                URI linkTarget = URIUtil.toURI((String)absolutePath);
                folder.createLink(linkTarget, 16, null);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public static void setUnusedFiles(IProject project, ProjectInformation info, IProgressMonitor monitor) throws CoreException {
        int size = info.unUsedList.size();
        for (int i = 0; i < size; ++i) {
            Path path;
            IFile file;
            String temp = (String)info.unUsedList.get(i);
            monitor.subTask("Resolving the path `" + temp + "'");
            String absolutePath = PathConverter.getAbsolutePath((String)info.sourceFile, (String)temp);
            if (absolutePath == null || !(file = project.getFile((path = new Path(absolutePath)).lastSegment())).isAccessible()) continue;
            QualifiedName excludedFileQualifier = new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild");
            file.setPersistentProperty(excludedFileQualifier, TRUE);
        }
    }

    private static void createLink(IProject project, String absolutePath) {
        if (absolutePath == null) {
            return;
        }
        Path path = new Path(absolutePath);
        IPath locationPath = project.getLocation();
        if (!locationPath.isPrefixOf((IPath)path)) {
            IFile file = project.getFile(path.lastSegment());
            URI linkTarget = URIUtil.toURI((String)absolutePath);
            if (file.exists()) {
                URI fileLocation = file.getLocationURI().normalize();
                if (!fileLocation.equals(linkTarget.normalize()) && !fileLocation.equals(linkTarget)) {
                    ErrorReporter.logWarning((String)("The file `" + file.getName() + "' could not be created pointing to location `" + linkTarget + "' as it already exists and is pointing to `" + fileLocation + "'"));
                }
            } else {
                try {
                    file.createLink(linkTarget, 16, null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While creating link `" + file.getName() + "' pointing to `" + linkTarget + "'"), (Throwable)e);
                }
            }
        }
    }

    private void loadListSettings(Node generalNode, String expectedNodeName, List<String> list) {
        NodeList nodeList = generalNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!expectedNodeName.equals(nodeName)) continue;
            list.add(node.getTextContent());
        }
    }

    private static void setListSettings(IProject project, String basePath, List<String> list, SubMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)list.size());
        progress.setTaskName("Creating links");
        for (String element : list) {
            progress.subTask("Resolving the path `" + element + "'");
            String absolutePath = PathConverter.getAbsolutePath((String)basePath, (String)element);
            if (absolutePath != null) {
                progress.subTask("creating link for `" + absolutePath + "'");
                GUIProjectImporter.createLink(project, absolutePath);
            }
            progress.worked(1);
        }
        progress.done();
    }

    private void loadTestSets(Node generalNode, ProjectInformation projectInformation) {
        NodeList nodeList = generalNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!"Test_Set".equals(nodeName)) continue;
            ArrayList<String> testcases = new ArrayList<String>();
            Node namedAttribute = node.getAttributes().getNamedItem("name");
            if (namedAttribute != null) {
                String name = namedAttribute.getTextContent();
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    String nodeName2 = node2.getNodeName();
                    if (!"TC".equals(nodeName2)) continue;
                    testcases.add(node2.getTextContent());
                }
                TestSet set = new TestSet();
                set.name = name;
                set.testcases = testcases;
                projectInformation.testsets.add(set);
                continue;
            }
            this.reportError("One of the Test sets does not have the mandatory `name' attribute", false);
        }
    }

    private void loadIncludedProjects(Node generalNode, ProjectInformation projectInformation, IProgressMonitor monitor) {
        NodeList nodeList = generalNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!"Included_Project".equals(nodeName)) continue;
            Node filesAttribute = node.getAttributes().getNamedItem("included_files");
            Node pathAttribute = node.getAttributes().getNamedItem("path");
            if (filesAttribute != null && pathAttribute != null) {
                IncludedProject included = new IncludedProject();
                included.files = filesAttribute.getTextContent();
                included.path = pathAttribute.getTextContent();
                monitor.subTask("Resolving the path `" + included.path + "'");
                String absolutePath = PathConverter.getAbsolutePath((String)projectInformation.sourceFile, (String)included.path);
                if (absolutePath == null) {
                    included.absolutePath = null;
                } else {
                    included.absolutePath = (IPath)new Path(absolutePath);
                }
                projectInformation.includeProjects.add(included);
                continue;
            }
            this.reportError("One of the included projects is specified incorrectly", false);
        }
    }

    public static void setIncludedProjects(IProject project, ProjectInformation info) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = project.getDescription();
        IProject[] referencedProjects = description.getReferencedProjects();
        List<IProject> references = Arrays.asList(referencedProjects);
        int size = info.includeProjects.size();
        for (int i = 0; i < size; ++i) {
            IPath path = ((IncludedProject)info.includeProjects.get(i)).absolutePath;
            if (path == null) continue;
            path = path.removeFileExtension();
            String includedProjectName = path.lastSegment();
            IProject newProject = workspace.getRoot().getProject(includedProjectName);
            references.add(newProject);
        }
        description.setReferencedProjects(references.toArray(new IProject[references.size()]));
        project.setDescription(description, null);
    }

    private void loadFileGroups(Node generalNode, FileGroup fileGroup, String basePath, IProgressMonitor monitor, boolean headless) {
        Node pathAttribute = generalNode.getAttributes().getNamedItem("path");
        Node nameAttribute = generalNode.getAttributes().getNamedItem("name");
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (pathAttribute != null) {
            String path = pathAttribute.getTextContent();
            if (reportDebugInformation) {
                TITANDebugConsole.println("Read the file group path `" + path + "'");
            }
            progress.subTask("Resolving the path `" + path + "'");
            path = PathConverter.getAbsolutePath((String)basePath, (String)path);
            if (reportDebugInformation) {
                TITANDebugConsole.println("The absolute file group path relative to `" + basePath + "' is `" + path + "'");
            }
            if (path == null) {
                return;
            }
            File file = new File(path);
            if (!file.exists()) {
                this.reportError("Could not load the group file `" + path + "' referred by `" + basePath + "' as `" + pathAttribute.getTextContent() + "'", headless);
                return;
            }
            Document document = this.getDocumentFromFile(path);
            if (document == null) {
                this.reportError("Could not load the group from the group file `" + path + "'", headless);
                return;
            }
            FileGroup newGroup = new FileGroup();
            SubMonitor groupMonitor = progress.newChild(1);
            groupMonitor.setTaskName("Loading group: " + file.getAbsolutePath());
            groupMonitor.subTask("Loading group: " + file.getAbsolutePath());
            this.loadFileGroups(document.getDocumentElement(), newGroup, path, (IProgressMonitor)groupMonitor.newChild(1), headless);
            groupMonitor.done();
            progress.done();
            fileGroup.groups.add(newGroup);
            if (reportDebugInformation) {
                TITANDebugConsole.println("Added file group `" + newGroup.name + "'");
            }
            return;
        }
        if (nameAttribute != null) {
            fileGroup.name = nameAttribute.getTextContent();
            if (reportDebugInformation) {
                TITANDebugConsole.println("Read the file group name `" + fileGroup.name + "'");
            }
        } else {
            fileGroup.name = "<nameless>";
        }
        NodeList nodeList = generalNode.getChildNodes();
        SubMonitor groupMonitor = progress.newChild(1);
        groupMonitor.beginTask("Loading group: " + fileGroup.name, nodeList.getLength());
        groupMonitor.subTask("Loading group: " + fileGroup.name);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if ("File".equals(nodeName)) {
                Node pathAttribute2 = node.getAttributes().getNamedItem("path");
                if (pathAttribute2 == null) {
                    this.reportError("One of the `File' nodes in the group `" + fileGroup.name + "' does not have a `path' attribute", headless);
                    continue;
                }
                if (reportDebugInformation) {
                    TITANDebugConsole.println("Read the named file group path `" + pathAttribute2.getTextContent() + "'");
                }
                groupMonitor.subTask("Resolving the path `" + pathAttribute2.getTextContent() + "'");
                String path = PathConverter.getAbsolutePath((String)basePath, (String)pathAttribute2.getTextContent());
                if (reportDebugInformation) {
                    TITANDebugConsole.println("The named absolute file group path relative to `" + basePath + "' is `" + path + "'");
                }
                if (path == null) continue;
                fileGroup.files.add(path);
                if (reportDebugInformation) {
                    TITANDebugConsole.println("Added file `" + path + "'");
                }
            } else if ("File_Groups".equals(nodeName)) {
                NodeList nodeList2 = node.getChildNodes();
                SubMonitor groupMonitor2 = groupMonitor.newChild(1);
                groupMonitor2.beginTask("Loading internal group nodes", nodeList2.getLength());
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    String nodeName2 = node2.getNodeName();
                    if ("File_Group".equals(nodeName2)) {
                        FileGroup newGroup = new FileGroup();
                        this.loadFileGroups(node2, newGroup, basePath, (IProgressMonitor)groupMonitor2, headless);
                        fileGroup.groups.add(newGroup);
                    }
                    groupMonitor2.worked(1);
                }
                groupMonitor2.done();
            } else if ("File_Group".equals(nodeName)) {
                FileGroup newGroup = new FileGroup();
                this.loadFileGroups(node, newGroup, basePath, (IProgressMonitor)groupMonitor, headless);
                fileGroup.groups.add(newGroup);
            }
            groupMonitor.worked(1);
        }
        groupMonitor.done();
        progress.done();
    }

    public static void setGroupFileSettings(IProject project, String sourceFile, FileGroup group, IProgressMonitor monitor) throws CoreException {
        int i;
        if (group == null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(group.files.size() + group.groups.size()));
        progress.setTaskName("Creating settings");
        int size = group.files.size();
        for (i = 0; i < size; ++i) {
            String temp = (String)group.files.get(i);
            progress.subTask("Resolving the path `" + temp + "'");
            String absolutePath = PathConverter.getAbsolutePath((String)sourceFile, (String)temp);
            if (absolutePath != null) {
                progress.subTask("creating link for `" + absolutePath + "'");
                GUIProjectImporter.createLink(project, absolutePath);
            }
            progress.worked(1);
        }
        size = group.groups.size();
        for (i = 0; i < size; ++i) {
            GUIProjectImporter.setGroupFileSettings(project, sourceFile, (FileGroup)group.groups.get(i), (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            progress.setTaskName(CREATING_PROJECT);
            projectHandle.create(description, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)progress.newChild(1));
            projectHandle.refreshLocal(1, (IProgressMonitor)progress.newChild(1));
        }
        finally {
            progress.done();
        }
    }

    static IProject createNewProject(IProject newProjectHandle, ProjectInformation info, URI targetLocation) {
        if (info == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(info.getName());
        description.setLocationURI(targetLocation);
        TITANNature.addTITANNatureToProject(description);
        try {
            GUIProjectImporter.createProject(description, newProjectHandle, null);
            GUIProjectImporter.applySettings(newProjectHandle, info, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        IProject newProject = newProjectHandle;
        return newProject;
    }

    public static boolean importProjectfromPrj(String projectFile) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<String> processedProjectFiles = new ArrayList<String>();
        ArrayList<Object> projectFilesToBeProcessed = new ArrayList<Object>();
        projectFilesToBeProcessed.add(new Path(projectFile));
        while (!projectFilesToBeProcessed.isEmpty()) {
            IPath tempPath = (IPath)projectFilesToBeProcessed.remove(projectFilesToBeProcessed.size() - 1);
            if (processedProjectFiles.contains(tempPath.toOSString())) continue;
            processedProjectFiles.add(tempPath.toOSString());
            GUIProjectImporter importer = new GUIProjectImporter();
            ProjectInformation tempProjectInformation = importer.loadProjectFile(tempPath.toOSString(), null, true);
            if (tempProjectInformation == null) continue;
            IPath tempPath2 = tempPath.removeFileExtension();
            String includedProjectName = tempPath2.lastSegment();
            IProject tempProject = workspace.getRoot().getProject(includedProjectName);
            if (tempProject.exists() || (tempProject = GUIProjectImporter.createNewProject(tempProject, tempProjectInformation, null)) == null) continue;
            try {
                TITANNature.addTITANBuilderToProject(tempProject);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            ProjectFileHandler pfHandler = new ProjectFileHandler(tempProject);
            pfHandler.saveProjectSettings();
            try {
                tempProject.refreshLocal(2, null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            List<IncludedProject> includedProjects = tempProjectInformation.getIncludedProjects();
            for (IncludedProject includedProject : includedProjects) {
                IPath temp = includedProject.getAbsolutePath();
                if (temp == null) continue;
                projectFilesToBeProcessed.add(temp);
            }
        }
        return true;
    }

    static final class ProjectInformation {
        private String sourceFile;
        private String name;
        private String executablePath;
        private String executableName;
        private String workingDir;
        private String buildHost;
        private ExecutionModes executionMode;
        private CodeSplittingModes codeSplittingMode = CodeSplittingModes.NONE;
        private String scriptAfterMake;
        private String gnuMake;
        private String useFunctionTestRuntime;
        private String useDynamicLinking;
        private String useAbsoluteReferencesInMakefile;
        private String localHostExecute;
        private String executeCommand;
        private String executeHosts;
        private List<String> logDirs = new ArrayList<String>();
        private List<String> unUsedList = new ArrayList<String>();
        private List<String> modules = new ArrayList<String>();
        private List<String> testports = new ArrayList<String>();
        private List<String> otherSources = new ArrayList<String>();
        private List<String> configs = new ArrayList<String>();
        private List<String> testcases = new ArrayList<String>();
        private List<TestSet> testsets = new ArrayList<TestSet>();
        private List<String> others = new ArrayList<String>();
        private List<IncludedProject> includeProjects = new ArrayList<IncludedProject>();
        private FileGroup fileGroupRoot = null;

        private ProjectInformation() {
        }

        public String getName() {
            return this.name;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getWorkingDir() {
            return this.workingDir;
        }

        public List<IncludedProject> getIncludedProjects() {
            return this.includeProjects;
        }
    }

    private static enum CodeSplittingModes {
        NONE,
        TYPE;

    }

    static enum ExecutionModes {
        SINGLE,
        PARALLEL;

    }

    private static final class FileGroup {
        private String name;
        private List<String> files = new ArrayList<String>();
        private List<FileGroup> groups = new ArrayList<FileGroup>();

        private FileGroup() {
        }
    }

    public static final class IncludedProject {
        private String files;
        private String path;
        private IPath absolutePath;

        private IncludedProject() {
        }

        public String getPath() {
            return this.path;
        }

        public IPath getAbsolutePath() {
            return this.absolutePath;
        }
    }

    private static final class TestSet {
        private String name;
        private List<String> testcases = new ArrayList<String>();

        private TestSet() {
        }
    }
}

