/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MakefileCreationData {
    public static final String USE_ABSOLUTEPATH_PROPERTY = "useAbsolutePath";
    public static final String GNU_MAKE_PROPERTY = "GNUMake";
    public static final String INCREMENTAL_DEPENDENCY_PROPERTY = "IncrementalDependency";
    public static final String DYNAMIC_LINKING_PROPERTY = "DynamicLinkingProperty";
    public static final String FUNCTIONTESTRUNTIME_PROPERTY = "Function test runtime";
    public static final String SINGLEMODE_PROPERTY = "singleMode";
    public static final String TARGET_EXECUTABLE_PROPERTY = "targetExecutable";
    public static final String CODE_SPLITTING_PROPERTY = "codeSplitting";
    public static final String DEFAULT_TARGET_PROPERTY = "defaultTarget";
    public static final boolean USE_ABSOLUTEPATH_DEFAULT_VALUE = false;
    public static final boolean GNU_MAKE_DEFAULT_VALUE = true;
    public static final boolean INCREMENTAL_DEPENDENCY_DEFAULT_VALUE = true;
    public static final boolean DYNAMIC_LINKING_DEFAULT_VALUE = false;
    public static final boolean FUNCTIONTESTRUNTIME_DEFAULT_VALUE = false;
    public static final boolean SINGLEMODE_DEFAULT_VALUE = false;
    public static final String CODE_SPLITTING_DEFAULT_VALUE = "none";
    public static final String DEFAULT_TARGET_DEFAULT_VALUE = DefaultTarget.getDefault().toString();
    public static final String[] MAKEFILE_PROPERTIES = new String[]{"useAbsolutePath", "GNUMake", "IncrementalDependency", "DynamicLinkingProperty", "Function test runtime", "singleMode", "codeSplitting", "defaultTarget"};
    public static final String[] MAKEFILE_TAGS = new String[]{"useAbsolutePath", "GNUMake", "incrementalDependencyRefresh", "dynamicLinking", "functiontestRuntime", "singleMode", "codeSplitting", "defaultTarget"};
    private static final String[] DEFAULT_VALUES = new String[]{String.valueOf(false), String.valueOf(true), String.valueOf(true), String.valueOf(false), String.valueOf(false), String.valueOf(false), "none", DEFAULT_TARGET_DEFAULT_VALUE};

    private MakefileCreationData() {
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", USE_ABSOLUTEPATH_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", GNU_MAKE_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", INCREMENTAL_DEPENDENCY_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DYNAMIC_LINKING_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", FUNCTIONTESTRUNTIME_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", SINGLEMODE_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", CODE_SPLITTING_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DEFAULT_TARGET_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TARGET_EXECUTABLE_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[MAKEFILE_TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, MAKEFILE_TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            for (int j = 0; j < MAKEFILE_TAGS.length; ++j) {
                if (!MAKEFILE_TAGS[j].equals(name)) continue;
                newValues[j] = node.getTextContent();
            }
            if (!TARGET_EXECUTABLE_PROPERTY.equals(name)) continue;
            String temp = node.getTextContent();
            if (temp == null || temp.length() == 0) {
                temp = "bin/" + project.getName();
            }
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TARGET_EXECUTABLE_PROPERTY), temp);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading targetExecutable attribute of `" + project.getName() + "'"), (Throwable)e);
            }
        }
        for (i = 0; i < MAKEFILE_TAGS.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", MAKEFILE_PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading attribute `" + MAKEFILE_PROPERTIES[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        Element node;
        String temp = null;
        for (int i = 0; i < MAKEFILE_PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", MAKEFILE_PROPERTIES[i]));
                if (temp == null || DEFAULT_VALUES[i].equals(temp)) continue;
                node = document.createElement(MAKEFILE_TAGS[i]);
                node.appendChild(document.createTextNode(temp));
                makefileSettings.appendChild(node);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving attribute `" + MAKEFILE_PROPERTIES[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
        node = MakefileCreationData.saveMakefileExecutableSettings(document, project);
        if (node != null) {
            makefileSettings.appendChild(node);
        }
    }

    private static Element saveMakefileExecutableSettings(Document document, IProject project) {
        Element node = null;
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TARGET_EXECUTABLE_PROPERTY));
            if (temp == null) {
                temp = "bin/" + project.getName();
            }
            node = document.createElement(TARGET_EXECUTABLE_PROPERTY);
            node.appendChild(document.createTextNode(temp));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving executable settings of `" + project.getName() + "'"), (Throwable)e);
        }
        return node;
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        Node node;
        int i;
        NodeList resourceList = source.getChildNodes();
        String[] newValues = new String[MAKEFILE_TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, MAKEFILE_TAGS.length);
        String targetExecutable = "";
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            node = resourceList.item(i);
            String name = node.getNodeName();
            for (int j = 0; j < MAKEFILE_TAGS.length; ++j) {
                if (!MAKEFILE_TAGS[j].equals(name)) continue;
                newValues[j] = node.getTextContent();
            }
            if (!TARGET_EXECUTABLE_PROPERTY.equals(name)) continue;
            targetExecutable = node.getTextContent();
        }
        for (i = 0; i < MAKEFILE_PROPERTIES.length; ++i) {
            String temp = newValues[i];
            if (!saveDefaultValues && (temp == null || DEFAULT_VALUES[i].equals(temp))) continue;
            node = document.createElement(MAKEFILE_TAGS[i]);
            node.appendChild(document.createTextNode(temp));
            makefileSettings.appendChild(node);
        }
        Element node2 = document.createElement(TARGET_EXECUTABLE_PROPERTY);
        node2.appendChild(document.createTextNode(targetExecutable));
        makefileSettings.appendChild(node2);
    }

    public static String getDefaultTargetExecutableName(IProject project) {
        return MakefileCreationData.getDefaultTargetExecutableName(project, false);
    }

    public static String getDefaultTargetExecutableName(IProject project, boolean isAbsolute) {
        StringBuilder name = new StringBuilder();
        if (isAbsolute) {
            try {
                String location = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
                if (location != null) {
                    name.append(location);
                    name.append(File.separator);
                } else {
                    TITANDebugConsole.println("Unable to get project location, returning relative path to executable");
                }
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
                TITANDebugConsole.println("Exception while determining project location, returning relative path to executable");
            }
        }
        name.append("bin");
        name.append(File.separator);
        name.append(project.getName().replace(' ', '_'));
        if ("win32".equals(Platform.getOS())) {
            name.append(".exe");
        }
        return name.toString();
    }

    public static enum DefaultTarget {
        EXECUTABLE,
        LIBRARY;


        public static DefaultTarget getDefault() {
            return EXECUTABLE;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static DefaultTarget createInstance(String str) {
            return DefaultTarget.valueOf(str.toUpperCase());
        }

        public static String[][] getDisplayNamesAndValues() {
            return new String[][]{{"Executable", EXECUTABLE.toString()}, {"Library", LIBRARY.toString()}};
        }
    }
}

