/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo;
    private String fValue;
    private String[][] fEntryNamesAndValues;

    public ComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        for (int i = 0; i < table.length; ++i) {
            String[] array = table[i];
            if (array != null && array.length == 2) continue;
            return false;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 3;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
            }
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = ComboFieldEditor.this.fValue;
                    String name = ComboFieldEditor.this.fCombo.getText();
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.getValueForName(name);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, ComboFieldEditor.this.fValue);
                }
            });
        }
        return this.fCombo;
    }

    public void setSelectedValue(String value) {
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            if (!value.equals(this.fEntryNamesAndValues[i][1])) continue;
            this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
            this.fValue = value;
            return;
        }
    }

    private String getValueForName(String name) {
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (!name.equals(entry[0])) continue;
            return entry[1];
        }
        return this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String value) {
        this.fValue = value;
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            if (!value.equals(this.fEntryNamesAndValues[i][1])) continue;
            this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
            return;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
    }

    public String getActualValue() {
        return this.fValue;
    }
}

