/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.common.parsers.TitanListener;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.preprocess.PreprocessorDirective;
import org.eclipse.titan.designer.parsers.ttcn3parser.ConditionalStateStack;
import org.eclipse.titan.designer.parsers.ttcn3parser.PPDirectiveTokenFactory;
import org.eclipse.titan.designer.parsers.ttcn3parser.PPListener;
import org.eclipse.titan.designer.parsers.ttcn3parser.PreprocessorDirectiveLexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.PreprocessorDirectiveParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.TokenStreamData;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Lexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Parser;

public class PreprocessedTokenStream
extends BufferedTokenStream {
    private static final int RECURSION_LIMIT = 20;
    IFile actualFile;
    Ttcn3Lexer actualLexer;
    Ttcn3Parser parser;
    ConditionalStateStack condStateStack;
    Map<String, String> macros = new Hashtable<String, String>();
    Stack<TokenStreamData> tokenStreamStack = new Stack();
    Set<IFile> includedFiles = new HashSet<IFile>();
    List<Location> inactiveCodeLocations = new ArrayList<Location>();
    Location lastPPDirectiveLocation = null;
    private TitanListener lexerListener = null;
    private TitanListener parserListener = null;
    private List<SyntacticErrorStorage> errorsStored = new ArrayList<SyntacticErrorStorage>();
    private List<TITANMarker> warnings = new ArrayList<TITANMarker>();
    private List<TITANMarker> unsupportedConstructs = new ArrayList<TITANMarker>();

    public Set<IFile> getIncludedFiles() {
        return this.includedFiles;
    }

    public List<Location> getInactiveCodeLocations() {
        return this.inactiveCodeLocations;
    }

    public List<SyntacticErrorStorage> getErrorStorage() {
        return this.errorsStored;
    }

    public void reportWarning(TITANMarker marker) {
        this.warnings.add(marker);
    }

    public List<TITANMarker> getWarnings() {
        return this.warnings;
    }

    public void reportUnsupportedConstruct(TITANMarker marker) {
        this.unsupportedConstructs.add(marker);
    }

    public List<TITANMarker> getUnsupportedConstructs() {
        return this.unsupportedConstructs;
    }

    public PreprocessedTokenStream(TokenSource tokenSource) {
        super(tokenSource);
        this.condStateStack = new ConditionalStateStack(this.unsupportedConstructs);
    }

    public void setActualFile(IFile file) {
        this.actualFile = file;
    }

    public void setActualLexer(Ttcn3Lexer lexer) {
        this.actualLexer = lexer;
    }

    public void setParser(Ttcn3Parser parser) {
        this.parser = parser;
    }

    public void setMacros(String[] definedList) {
        for (String s : definedList) {
            this.macros.put(s, "");
        }
    }

    private void processIncludeDirective(PreprocessorDirective ppDirective) {
        int rootInt;
        if (ppDirective.str == null || "".equals(ppDirective.str)) {
            TITANMarker marker = new TITANMarker("File name was not provided", ppDirective.line, -1, -1, 2, 1);
            this.unsupportedConstructs.add(marker);
            return;
        }
        IFile includedFile = GlobalParser.getProjectSourceParser(this.actualFile.getProject()).getTTCN3IncludeFileByName(ppDirective.str);
        if (includedFile == null) {
            TITANMarker marker = new TITANMarker(MessageFormat.format("Included file `{0}'' could not be found", ppDirective.str), ppDirective.line, -1, -1, 2, 1);
            this.unsupportedConstructs.add(marker);
            return;
        }
        if (!"ttcnin".equals(includedFile.getFileExtension())) {
            TITANMarker marker = new TITANMarker(MessageFormat.format("File `{0}'' does not have the `{1}'' extension", ppDirective.str, "ttcnin"), ppDirective.line, -1, -1, 1, 1);
            this.warnings.add(marker);
        }
        String code = null;
        if (EditorTracker.containsKey(includedFile)) {
            List<ISemanticTITANEditor> editors = EditorTracker.getEditor(includedFile);
            ISemanticTITANEditor editor = editors.get(0);
            IDocument document = editor.getDocument();
            code = document.get();
        }
        Reader reader = null;
        UnbufferedCharStream charStream = null;
        Ttcn3Lexer lexer = null;
        if (code != null) {
            reader = new StringReader(code);
            charStream = new UnbufferedCharStream(reader);
            lexer = new Ttcn3Lexer((CharStream)charStream);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            rootInt = code.length();
        } else {
            IFileStore store;
            try {
                InputStreamReader temp = new InputStreamReader(includedFile.getContents());
                if (!includedFile.getCharset().equals(temp.getEncoding())) {
                    try {
                        temp.close();
                    }
                    catch (IOException e) {
                        ErrorReporter.logWarningExceptionStackTrace((Exception)e);
                    }
                    temp = new InputStreamReader(includedFile.getContents(), includedFile.getCharset());
                }
                reader = new BufferedReader(temp);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            catch (UnsupportedEncodingException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                return;
            }
            charStream = new UnbufferedCharStream(reader);
            lexer = new Ttcn3Lexer((CharStream)charStream);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            this.lexerListener = new TitanListener();
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)this.lexerListener);
            try {
                store = EFS.getStore((URI)includedFile.getLocationURI());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            IFileInfo fileInfo = store.fetchInfo();
            rootInt = (int)fileInfo.getLength();
        }
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.setTTCNPP();
        lexer.initRootInterval(rootInt);
        lexer.setActualFile(includedFile);
        this.tokenStreamStack.push(new TokenStreamData(lexer, includedFile, reader));
        if (this.parser != null) {
            this.parser.setActualFile(includedFile);
            this.parser.setLexer(lexer);
        }
        this.includedFiles.add(includedFile);
    }

    public int fetch(int n) {
        if (this.fetchedEOF) {
            return 0;
        }
        int i = 0;
        block8: while (true) {
            Token t;
            if ((t = this.tokenStreamStack.isEmpty() ? this.getTokenSource().nextToken() : this.tokenStreamStack.peek().getTokenSource().nextToken()) == null) {
                return 0;
            }
            int tokenType = t.getType();
            if (tokenType == 216) {
                this.lastPPDirectiveLocation = new Location((IResource)this.actualFile, t.getLine(), t.getStartIndex(), t.getStopIndex() + 1);
                String text = t.getText().substring(1).replace("\\\n", "");
                StringReader reader = new StringReader(text);
                UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
                PreprocessorDirectiveLexer lexer = new PreprocessorDirectiveLexer((CharStream)charStream);
                lexer.setTokenFactory(new PPDirectiveTokenFactory(true, t));
                this.lexerListener = new PPListener();
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)this.lexerListener);
                lexer.setLine(t.getLine());
                lexer.setCharPositionInLine(t.getCharPositionInLine());
                BufferedTokenStream tokens = new BufferedTokenStream((TokenSource)lexer);
                PreprocessorDirectiveParser localParser = new PreprocessorDirectiveParser((TokenStream)tokens);
                localParser.setBuildParseTree(false);
                this.parserListener = new PPListener(localParser);
                localParser.removeErrorListeners();
                localParser.addErrorListener((ANTLRErrorListener)this.parserListener);
                localParser.setIsActiveCode(this.condStateStack.isPassing());
                localParser.setMacros(this.macros);
                localParser.setLine(t.getLine());
                PreprocessorDirective ppDirective = null;
                ppDirective = localParser.pr_Directive().ppDirective;
                this.errorsStored.addAll(localParser.getErrorStorage());
                this.warnings.addAll(localParser.getWarnings());
                this.unsupportedConstructs.addAll(localParser.getUnsupportedConstructs());
                if (ppDirective == null) continue;
                ppDirective.line = t.getLine();
                if (ppDirective.isConditional()) {
                    Location ppLocation;
                    boolean preIsPassing = this.condStateStack.isPassing();
                    this.condStateStack.processDirective(ppDirective);
                    boolean postIsPassing = this.condStateStack.isPassing();
                    if (preIsPassing == postIsPassing || !this.tokenStreamStack.isEmpty() || !(this.getTokenSource() instanceof Ttcn3Lexer) || (ppLocation = this.lastPPDirectiveLocation) == null) continue;
                    if (preIsPassing) {
                        Location loc = new Location((IResource)this.actualFile, ppLocation.getLine(), ppLocation.getEndOffset(), ppLocation.getEndOffset());
                        this.inactiveCodeLocations.add(loc);
                        continue;
                    }
                    int iclSize = this.inactiveCodeLocations.size();
                    if (iclSize <= 0) continue;
                    Location lastLocation = this.inactiveCodeLocations.get(iclSize - 1);
                    lastLocation.setEndOffset(ppLocation.getOffset());
                    continue;
                }
                if (!this.condStateStack.isPassing()) continue;
                switch (ppDirective.type) {
                    case INCLUDE: {
                        if (this.tokenStreamStack.size() > 20) {
                            TITANMarker marker = new TITANMarker("Maximum #include recursion depth reached", ppDirective.line, -1, -1, 2, 1);
                            this.unsupportedConstructs.add(marker);
                            break;
                        }
                        this.processIncludeDirective(ppDirective);
                        break;
                    }
                    case ERROR: {
                        String errorMessage = ppDirective.str == null ? "" : ppDirective.str;
                        TITANMarker marker = new TITANMarker(errorMessage, ppDirective.line, -1, -1, 2, 1);
                        this.unsupportedConstructs.add(marker);
                        break;
                    }
                    case WARNING: {
                        String warningMessage = ppDirective.str == null ? "" : ppDirective.str;
                        TITANMarker marker = new TITANMarker(warningMessage, ppDirective.line, -1, -1, 1, 1);
                        this.warnings.add(marker);
                        break;
                    }
                    case LINECONTROL: 
                    case LINEMARKER: 
                    case PRAGMA: 
                    case NULL: {
                        String reportPreference = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportIgnoredPreprocessorDirectives", "warning", null);
                        if ("ignore".equals(reportPreference)) continue block8;
                        boolean isError = "error".equals(reportPreference);
                        TITANMarker marker = new TITANMarker(MessageFormat.format("Preprocessor directive {0} is ignored", ppDirective.type.getName()), ppDirective.line, -1, -1, isError ? 2 : 1, 1);
                        if (isError) {
                            this.unsupportedConstructs.add(marker);
                            break;
                        }
                        this.warnings.add(marker);
                        break;
                    }
                }
                continue;
            }
            if (tokenType == -1) {
                if (!this.tokenStreamStack.isEmpty()) {
                    TokenStreamData tsd = this.tokenStreamStack.pop();
                    if (this.parser != null) {
                        if (this.tokenStreamStack.isEmpty()) {
                            this.parser.setActualFile(this.actualFile);
                            this.parser.setLexer(this.actualLexer);
                        } else {
                            this.parser.setActualFile(this.tokenStreamStack.peek().file);
                            this.parser.setLexer(this.tokenStreamStack.peek().lexer);
                        }
                    }
                    if (tsd.reader == null) continue;
                    try {
                        tsd.reader.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                this.fetchedEOF = true;
                this.condStateStack.eofCheck();
                this.tokens.add(t);
                ((CommonToken)t).setTokenIndex(this.tokens.size() - 1);
                ++i;
                if (--n != 0) continue;
                return i;
            }
            if (!this.condStateStack.isPassing()) continue;
            this.tokens.add(t);
            ((CommonToken)t).setTokenIndex(this.tokens.size() - 1);
            ++i;
            if (--n == 0) break;
        }
        return i;
    }
}

