/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.extensions.IProjectProcesser;

public enum ExtensionHandler {
    INSTANCE;

    private static final String ID = "org.eclipse.titan.designer.extensions.post_analyze";
    private List<IProjectProcesser> plugins;

    public synchronized void registerContributors() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(ID);
        this.plugins = new ArrayList<IProjectProcesser>();
        for (IConfigurationElement element : config) {
            try {
                Object o = element.createExecutableExtension("class");
                if (!(o instanceof IProjectProcesser)) continue;
                this.plugins.add((IProjectProcesser)o);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While adding extension with value `" + element.getValue() + "'"), (Throwable)e);
            }
        }
    }

    public void executeContributors(IProgressMonitor monitor, final IProject project) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                ErrorReporter.logExceptionStackTrace((String)("Error in client plugin while processing project `" + project.getName() + "'"), (Throwable)e);
            }

            public void run() throws Exception {
                try {
                    progress.beginTask("Executing extensions", ExtensionHandler.this.plugins.size());
                    for (IProjectProcesser proc : ExtensionHandler.this.plugins) {
                        proc.workOnProject((IProgressMonitor)progress.newChild(1), project);
                        if (!progress.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    progress.done();
                }
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

