/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.parsers.cfg.indices.ComponentSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.GroupSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.MCSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentsSubPage;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.GroupsSubPage;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.MCSubPage;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class ComponentsGroupsMCPage
extends FormPage {
    private ConfigEditor editor;
    private ScrolledForm form;
    private ComponentsSubPage componentsSubPage;
    private GroupsSubPage groupsSubPage;
    private MCSubPage mcsubPage;

    public ComponentsGroupsMCPage(ConfigEditor editor) {
        super((FormEditor)editor, "Components_Groups_MainController_section_page", "Components, Groups and Main Controller");
        this.editor = editor;
        this.componentsSubPage = new ComponentsSubPage(editor);
        this.groupsSubPage = new GroupsSubPage(editor);
        this.mcsubPage = new MCSubPage(editor);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText("Components, Groups and main controller sections");
        this.form.setBackgroundImage(ImageCache.getImage("form_banner.gif"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        Composite client = toolkit.createComposite(this.form.getBody(), 64);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        this.mcsubPage.createMainControllerSection(client, this.form, toolkit);
        this.componentsSubPage.createComponentsSection(client, this.form, toolkit);
        this.groupsSubPage.createGroupsSection(this.form.getBody(), this.form, toolkit);
        this.setErrorMessage();
    }

    public void refreshData(ComponentSectionHandler componentSectionHandler, GroupSectionHandler groupSectionHandler, MCSectionHandler mcSectionHandler) {
        this.componentsSubPage.refreshData(componentSectionHandler);
        this.groupsSubPage.refreshData(groupSectionHandler);
        this.mcsubPage.refreshData(mcSectionHandler);
    }

    public void setActive(boolean active) {
        this.setErrorMessage();
        super.setActive(active);
    }

    public void setErrorMessage() {
        if (this.form != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ComponentsGroupsMCPage.this.editor.getErrorMessage() == null) {
                        ComponentsGroupsMCPage.this.form.getForm().setMessage(null, 0);
                    } else {
                        ComponentsGroupsMCPage.this.form.getForm().setMessage(ComponentsGroupsMCPage.this.editor.getErrorMessage(), 3);
                    }
                    ComponentsGroupsMCPage.this.form.getForm().getHead().layout();
                    ComponentsGroupsMCPage.this.form.getForm().getHead().redraw();
                }
            });
        }
    }
}

