/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.IndexedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Values
extends ASTNode
implements IIncrementallyUpdateable {
    private final boolean isIndexed;
    private ArrayList<IValue> values;
    private ArrayList<IndexedValue> indexedValues;

    public Values(boolean indexed) {
        this.isIndexed = indexed;
        if (indexed) {
            this.indexedValues = new ArrayList();
        } else {
            this.values = new ArrayList();
        }
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public void addValue(IValue value) {
        if (value != null) {
            this.values.add(value);
            value.setFullNameParent(this);
        }
    }

    public void addIndexedValue(IndexedValue indexedValue) {
        if (indexedValue != null) {
            this.indexedValues.add(indexedValue);
            indexedValue.setFullNameParent(this);
        }
    }

    public int getNofValues() {
        if (this.isIndexed) {
            return 0;
        }
        return this.values.size();
    }

    public int getNofIndexedValues() {
        if (!this.isIndexed) {
            return 0;
        }
        return this.indexedValues.size();
    }

    public IValue getValueByIndex(int index) {
        if (this.isIndexed) {
            return null;
        }
        return this.values.get(index);
    }

    public IndexedValue getIndexedValueByIndex(int index) {
        if (!this.isIndexed) {
            return null;
        }
        return this.indexedValues.get(index);
    }

    public IValue getIndexedValueByRealIndex(int index) {
        if (!this.isIndexed) {
            return null;
        }
        for (int i = 0; i < this.indexedValues.size(); ++i) {
            Integer_Value integerValue;
            IndexedValue temp = this.indexedValues.get(i);
            Value value = temp.getIndex().getValue();
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)value.getValuetype()) || index != (integerValue = (Integer_Value)value).intValue()) continue;
            return temp.getValue();
        }
        return null;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.isIndexed) {
            this.indexedValues.trimToSize();
            for (int i = 0; i < this.indexedValues.size(); ++i) {
                this.indexedValues.get(i).setMyScope(scope);
            }
        } else {
            this.values.trimToSize();
            for (int i = 0; i < this.values.size(); ++i) {
                this.values.get(i).setMyScope(scope);
            }
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.isIndexed) {
            for (int i = 0; i < this.indexedValues.size(); ++i) {
                if (this.indexedValues.get(i) != child) continue;
                return builder.append("[").append(String.valueOf(i)).append("]");
            }
        } else {
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) != child) continue;
                return builder.append("[").append(String.valueOf(i)).append("]");
            }
        }
        return builder;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.isIndexed) {
            int size = this.indexedValues.size();
            for (int i = 0; i < size; ++i) {
                IndexedValue indexedValue = this.indexedValues.get(i);
                indexedValue.updateSyntax(reparser, false);
                reparser.updateLocation(indexedValue.getLocation());
            }
        } else {
            int size = this.values.size();
            for (int i = 0; i < size; ++i) {
                IValue value = this.values.get(i);
                if (!(value instanceof IIncrementallyUpdateable)) {
                    throw new ReParseException();
                }
                ((IIncrementallyUpdateable)((Object)value)).updateSyntax(reparser, false);
                reparser.updateLocation(value.getLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.isIndexed) {
            for (IndexedValue iv : this.indexedValues) {
                iv.findReferences(referenceFinder, foundIdentifiers);
            }
        } else {
            for (IValue v : this.values) {
                v.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.isIndexed) {
            for (IndexedValue iv : this.indexedValues) {
                if (iv.accept(v)) continue;
                return false;
            }
        } else {
            for (IValue iv : this.values) {
                if (iv.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

