/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Anytype_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Choice_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Set_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Sequence_Value
extends Value {
    private static final String TOOMANYELEMENTS = "Too many elements in value list notation for type `{0}'': {1} was expected instead of {2}";
    private static final String ALLARENOTUSED = "All elements of value list notation for type `{0}'' are not used symbols (`-'')";
    private static final String NONEXISTENTFIELD = "Reference to non-existent record field `{0}'' in type `{1}''";
    private final NamedValues values;
    private Value convertedValue;

    public Sequence_Value(NamedValues values) {
        this.values = values;
        if (values != null) {
            values.setFullNameParent(this);
        }
    }

    public static Sequence_Value convert(CompilationTimeStamp timestamp, SequenceOf_Value value) {
        boolean allNotUsed;
        int upperLimit;
        if (value.getMyGovernor() == null) {
            Sequence_Value target = new Sequence_Value(null);
            target.copyGeneralProperties(value);
            return target;
        }
        IType t = value.getMyGovernor().getTypeRefdLast(timestamp);
        int nofComponents = 0;
        switch (t.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                nofComponents = ((TTCN3_Sequence_Type)t).getNofComponents();
                break;
            }
            case TYPE_ASN1_SEQUENCE: {
                nofComponents = ((ASN1_Sequence_Type)t).getNofComponents(timestamp);
                break;
            }
            case TYPE_SIGNATURE: {
                nofComponents = ((Signature_Type)t).getNofParameters();
                break;
            }
            default: {
                Sequence_Value target = new Sequence_Value(null);
                target.copyGeneralProperties(value);
                return target;
            }
        }
        Values oldValues = value.getValues();
        int nofValues = oldValues.getNofValues();
        if (nofValues > nofComponents) {
            value.getLocation().reportSemanticError(MessageFormat.format(TOOMANYELEMENTS, t.getTypename(), nofComponents, nofValues));
            value.setIsErroneous(true);
        }
        if (nofValues <= nofComponents) {
            upperLimit = nofValues;
            allNotUsed = true;
        } else {
            upperLimit = nofComponents;
            allNotUsed = false;
        }
        NamedValues values = new NamedValues();
        for (int i = 0; i < upperLimit; ++i) {
            Identifier identifier;
            IValue v = oldValues.getValueByIndex(i);
            if (IValue.Value_type.NOTUSED_VALUE.equals((Object)v.getValuetype())) continue;
            allNotUsed = false;
            switch (t.getTypetype()) {
                case TYPE_TTCN3_SEQUENCE: {
                    identifier = ((TTCN3_Sequence_Type)t).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_ASN1_SEQUENCE: {
                    identifier = ((ASN1_Sequence_Type)t).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_SIGNATURE: {
                    identifier = ((Signature_Type)t).getParameterIdentifierByIndex(i);
                    break;
                }
                default: {
                    Sequence_Value target = new Sequence_Value(null);
                    target.copyGeneralProperties(value);
                    return target;
                }
            }
            NamedValue namedValue = new NamedValue(identifier, v);
            namedValue.setLocation(v.getLocation());
            values.addNamedValue(namedValue);
        }
        if (allNotUsed && nofValues > 0) {
            value.getLocation().reportSemanticWarning(MessageFormat.format(ALLARENOTUSED, t.getTypename()));
        }
        Sequence_Value target = new Sequence_Value(values);
        target.copyGeneralProperties(value);
        return target;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.SEQUENCE_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("{");
        boolean isAsn1 = this.isAsn();
        for (int i = 0; i < this.values.getSize(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            NamedValue namedValue = this.values.getNamedValueByIndex(i);
            builder.append(namedValue.getName().getDisplayName());
            if (isAsn1) {
                builder.append(' ');
            } else {
                builder.append(" := ");
            }
            builder.append(namedValue.getValue().createStringRepresentation());
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        if (this.convertedValue != null && this.convertedValue != this) {
            IValue temp = this.convertedValue.getReferencedSubValue(timestamp, reference, actualSubReference, refChain);
            if (temp != null && temp.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return temp;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: {
                        if (((TTCN3_Sequence_Type)type).hasComponentWithName(fieldId.getName())) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        if (((ASN1_Sequence_Type)type).hasComponentWithName(fieldId)) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
                if (this.values.hasNamedValueWithName(fieldId)) {
                    return this.values.getNamedValueByName(fieldId).getValue().getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                }
                if (IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)type.getTypetype())) {
                    if (!reference.getUsedInIsbound()) {
                        subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to unbound record field `{0}''", fieldId.getDisplayName()));
                    }
                    return null;
                }
                CompField compField = ((ASN1_Sequence_Type)type).getComponentByName(fieldId);
                if (compField.isOptional()) {
                    Omit_Value result = new Omit_Value();
                    BridgingNamedNode bridge = new BridgingNamedNode(this, "." + fieldId.getDisplayName());
                    result.setFullNameParent(bridge);
                    result.setMyScope(this.getMyScope());
                    return result;
                }
                if (compField.hasDefault()) {
                    return compField.getDefault().getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                }
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.values == null) {
            return true;
        }
        for (int i = 0; i < this.values.getSize(); ++i) {
            IValue temp = this.values.getNamedValueByIndex(i).getValue();
            if (temp != null && !temp.isUnfoldable(timestamp, expectedValue, referenceChain)) continue;
            return true;
        }
        return false;
    }

    public void addNamedValue(NamedValue value) {
        if (value != null) {
            this.values.addNamedValue(value);
            value.setMyScope(this.myScope);
        }
    }

    public void removeGeneratedValues() {
        if (this.values != null) {
            this.values.removeGeneratedValues();
        }
    }

    protected NamedValues getValues() {
        return this.values;
    }

    public int getNofComponents() {
        if (this.values == null) {
            return 0;
        }
        return this.values.getSize();
    }

    public NamedValue getSeqValueByIndex(int index) {
        if (this.values == null) {
            return null;
        }
        return this.values.getNamedValueByIndex(index);
    }

    public boolean hasComponentWithName(Identifier name) {
        if (this.values == null) {
            return false;
        }
        return this.values.hasNamedValueWithName(name);
    }

    public NamedValue getComponentByName(Identifier name) {
        if (this.values == null) {
            return null;
        }
        return this.values.getNamedValueByName(name);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.values != null) {
            this.values.setMyScope(scope);
        }
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        switch (newType) {
            case SET_VALUE: {
                this.convertedValue = new Set_Value(this);
                break;
            }
            case CHOICE_VALUE: {
                this.convertedValue = new Choice_Value(timestamp, this);
                break;
            }
            case ANYTYPE_VALUE: {
                this.convertedValue = new Anytype_Value(timestamp, this);
                break;
            }
            case REAL_VALUE: {
                this.convertedValue = new Real_Value(timestamp, this);
                break;
            }
            default: {
                this.convertedValue = super.setValuetype(timestamp, newType);
            }
        }
        return this.convertedValue;
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.values == null) {
            return;
        }
        this.values.checkUniqueness(timestamp);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.values.getSize();
            for (int i = 0; i < size; ++i) {
                IValue temp = this.values.getNamedValueByIndex(i).getValue();
                if (temp == null) continue;
                referenceChain.markState();
                temp.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.convertedValue == null || this.convertedValue.getIsErroneous(timestamp)) {
            return this;
        }
        CompilationTimeStamp lastTimestamp = this.convertedValue.getLastTimeChecked();
        if (lastTimestamp == null || lastTimestamp.isLess(timestamp)) {
            return this;
        }
        return this.convertedValue.getValueRefdLast(timestamp, expectedValue, referenceChain);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        if (this.convertedValue != null && this.convertedValue != this) {
            return this.convertedValue.checkEquality(timestamp, other);
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (!IValue.Value_type.SEQUENCE_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        if (this.myGovernor == null) {
            return false;
        }
        IType leftGovernor = this.myGovernor.getTypeRefdLast(timestamp);
        Sequence_Value otherSequence = (Sequence_Value)last;
        if (this.values.getSize() != otherSequence.values.getSize()) {
            return false;
        }
        int nofComps = 0;
        switch (leftGovernor.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                nofComps = ((TTCN3_Sequence_Type)leftGovernor).getNofComponents();
                break;
            }
            case TYPE_ASN1_SEQUENCE: {
                nofComps = ((ASN1_Sequence_Type)leftGovernor).getNofComponents(timestamp);
                break;
            }
            default: {
                return false;
            }
        }
        CompField compField = null;
        for (int i = 0; i < nofComps; ++i) {
            switch (leftGovernor.getTypetype()) {
                case TYPE_TTCN3_SEQUENCE: {
                    compField = ((TTCN3_Sequence_Type)leftGovernor).getComponentByIndex(i);
                    break;
                }
                case TYPE_ASN1_SEQUENCE: {
                    compField = ((ASN1_Sequence_Type)leftGovernor).getComponentByIndex(i);
                    break;
                }
                default: {
                    return false;
                }
            }
            Identifier fieldName = compField.getIdentifier();
            if (this.hasComponentWithName(fieldName)) {
                IValue leftValue = this.getComponentByName(fieldName).getValue();
                if (otherSequence.hasComponentWithName(fieldName)) {
                    IValue otherValue = otherSequence.getComponentByName(fieldName).getValue();
                    if (IValue.Value_type.OMIT_VALUE.equals((Object)leftValue.getValuetype()) && !IValue.Value_type.OMIT_VALUE.equals((Object)otherValue.getValuetype()) || !IValue.Value_type.OMIT_VALUE.equals((Object)leftValue.getValuetype()) && IValue.Value_type.OMIT_VALUE.equals((Object)otherValue.getValuetype())) {
                        return false;
                    }
                    if (leftValue.checkEquality(timestamp, otherValue)) continue;
                    return false;
                }
                if (!(compField.hasDefault() ? !leftValue.checkEquality(timestamp, compField.getDefault()) : !IValue.Value_type.OMIT_VALUE.equals((Object)leftValue.getValuetype()))) continue;
                return false;
            }
            if (!otherSequence.hasComponentWithName(fieldName)) continue;
            IValue otherValue = otherSequence.getComponentByName(fieldName).getValue();
            if (!compField.hasDefault()) continue;
            if (IValue.Value_type.OMIT_VALUE.equals((Object)otherValue.getValuetype())) {
                return false;
            }
            if (compField.getDefault().checkEquality(timestamp, otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.values != null) {
            this.values.updateSyntax(reparser, false);
        }
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        if (this.values == null) {
            return true;
        }
        int size = this.values.getSize();
        for (int i = 0; i < size; ++i) {
            if (this.values.getNamedValueByIndex(i).getValue().evaluateIsvalue(true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluateIsbound(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        if (this.convertedValue != null && this.convertedValue != this) {
            return this.convertedValue.evaluateIsbound(timestamp, reference, actualSubReference);
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: {
                        if (((TTCN3_Sequence_Type)type).hasComponentWithName(fieldId.getName())) break;
                        return false;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        if (((ASN1_Sequence_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.values.hasNamedValueWithName(fieldId)) {
                    return this.values.getNamedValueByName(fieldId).getValue().evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                if (IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)type.getTypetype())) {
                    return false;
                }
                CompField compField = ((ASN1_Sequence_Type)type).getComponentByName(fieldId);
                if (compField.isOptional()) {
                    Omit_Value result = new Omit_Value();
                    BridgingNamedNode bridge = new BridgingNamedNode(this, "." + fieldId.getDisplayName());
                    result.setFullNameParent(bridge);
                    result.setMyScope(this.getMyScope());
                    return result.evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                if (compField.hasDefault()) {
                    return compField.getDefault().evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateIspresent(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        if (this.convertedValue != null && this.convertedValue != this) {
            return this.convertedValue.evaluateIsbound(timestamp, reference, actualSubReference);
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: {
                        if (((TTCN3_Sequence_Type)type).hasComponentWithName(fieldId.getName())) break;
                        return false;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        if (((ASN1_Sequence_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.values.hasNamedValueWithName(fieldId)) {
                    return this.values.getNamedValueByName(fieldId).getValue().evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                if (IType.Type_type.TYPE_TTCN3_SEQUENCE.equals((Object)type.getTypetype())) {
                    return false;
                }
                CompField compField = ((ASN1_Sequence_Type)type).getComponentByName(fieldId);
                if (compField.isOptional()) {
                    Omit_Value result = new Omit_Value();
                    BridgingNamedNode bridge = new BridgingNamedNode(this, "." + fieldId.getDisplayName());
                    result.setFullNameParent(bridge);
                    result.setMyScope(this.getMyScope());
                    return ((Value)result).evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                if (compField.hasDefault()) {
                    return compField.getDefault().evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        NamedValue nv;
        IType governorLast;
        if (this.values == null) {
            return;
        }
        if (referenceFinder.assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE && referenceFinder.fieldId != null && this.myGovernor != null && referenceFinder.type == (governorLast = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) && (nv = this.values.getNamedValueByName(referenceFinder.fieldId)) != null) {
            foundIdentifiers.add(new ReferenceFinder.Hit(nv.getName()));
        }
        this.values.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.values == null || this.values.accept(v);
    }
}

