/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PortTypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMapping;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappings;
import org.eclipse.titan.designer.AST.TTCN3.attributes.UserPortTypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class PortTypeBody
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String FULLNAMEPART1 = ".<in_list>";
    private static final String FULLNAMEPART2 = ".<out_list>";
    private static final String FULLNAMEPART3 = ".<inout_list>";
    private static final String FULLNAMEPART4 = ".<incoming_signatures>";
    private static final String FULLNAMEPART5 = ".<outgoing_signatures>";
    private static final String FULLNAMEPART6 = ".<incoming_messages>";
    private static final String FULLNAMEPART7 = ".<outgoing_messages>";
    private static final String REDUNDANTINALL = "Redundant `in all' and `inout all'";
    private static final String REDUNDANTOUTALL = "Redundant `out all' and `inout all' directives";
    private static final String UNSUPPORTEDINOUTALL = "Unsupported `inout all' directive was ignored";
    private static final String UNSUPPORTEDINALL = "Unsupported `in all' directive was ignored";
    private static final String UNSUPPORTEDOUTALL = "Unsupported `out all' directive was ignored";
    private static final String SIGNATUREONMESSAGEPORT = "Signature `{0}'' cannot be used on a message based port";
    private static final String DATAONPROCEDUREPORT = "Data type `{0}'' cannot be {1} on procedure based port";
    private static final String DUPLICATEDINSIGNATURE = "Duplicate incoming signature `{0}''";
    private static final String DUPLICATEDOUTSIGNATURE = "Duplicate outgoing signature `{0}''";
    private static final String DUPLICATEDINMESSAGE = "Duplicate incoming message type `{0}''";
    private static final String DUPLICATEDOUTMESSAGE = "Duplicate outgoing message type `{0}''";
    private final OperationModes operationMode;
    private TestPortAPI_type testportType;
    private PortType_type portType;
    private Port_Type myType;
    private List<IType> inTypes = null;
    private boolean inAll = false;
    private List<IType> outTypes = null;
    private boolean outAll = false;
    private List<IType> inoutTypes = null;
    private boolean inoutAll = false;
    private TypeSet inMessages;
    private TypeSet outMessages;
    private TypeSet inSignatures;
    private TypeSet outSignatures;
    private Reference providerReference;
    private IType providerType;
    private TypeMappings inMappings;
    private TypeMappings outMappings;
    private CompilationTimeStamp lastTimeChecked;
    private CompilationTimeStamp lastTimeAttributesChecked;
    private Location location = NULL_Location.INSTANCE;

    public PortTypeBody(OperationModes operationMode) {
        this.operationMode = operationMode;
        this.testportType = TestPortAPI_type.TP_REGULAR;
        this.portType = PortType_type.PT_REGULAR;
    }

    public void setMyType(Port_Type myType) {
        this.myType = myType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        int i;
        int size;
        StringBuilder builder = super.getFullName(child);
        if (this.inTypes != null) {
            size = this.inTypes.size();
            for (i = 0; i < size; ++i) {
                if (this.inTypes.get(i) != child) continue;
                return builder.append(FULLNAMEPART1);
            }
        }
        if (this.outTypes != null) {
            size = this.outTypes.size();
            for (i = 0; i < size; ++i) {
                if (this.outTypes.get(i) != child) continue;
                return builder.append(FULLNAMEPART2);
            }
        }
        if (this.inoutTypes != null) {
            size = this.inoutTypes.size();
            for (i = 0; i < size; ++i) {
                if (this.inoutTypes.get(i) != child) continue;
                return builder.append(FULLNAMEPART3);
            }
        }
        if (this.inMessages == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.outMessages == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.inSignatures == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.outSignatures == child) {
            return builder.append(FULLNAMEPART7);
        }
        if (this.providerReference == child) {
            return builder.append(".<provider_ref>");
        }
        if (this.inMappings == child) {
            return builder.append(".<inMappings>");
        }
        if (this.outMappings == child) {
            return builder.append(".<outMappings>");
        }
        return builder;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void addInTypes(List<IType> types) {
        if (types == null) {
            this.inAll = true;
        } else {
            if (this.inTypes == null) {
                this.inTypes = new ArrayList<IType>();
            }
            this.inTypes.addAll(types);
        }
    }

    public void addOutTypes(List<IType> types) {
        if (types == null) {
            this.outAll = true;
        } else {
            if (this.outTypes == null) {
                this.outTypes = new ArrayList<IType>();
            }
            this.outTypes.addAll(types);
        }
    }

    public void addInoutTypes(List<IType> types) {
        if (types == null) {
            this.inoutAll = true;
        } else {
            if (this.inoutTypes == null) {
                this.inoutTypes = new ArrayList<IType>();
            }
            this.inoutTypes.addAll(types);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        int i;
        int size;
        if (this.inTypes != null) {
            size = this.inTypes.size();
            for (i = 0; i < size; ++i) {
                this.inTypes.get(i).setMyScope(scope);
            }
        }
        if (this.outTypes != null) {
            size = this.outTypes.size();
            for (i = 0; i < size; ++i) {
                this.outTypes.get(i).setMyScope(scope);
            }
        }
        if (this.inoutTypes != null) {
            size = this.inoutTypes.size();
            for (i = 0; i < size; ++i) {
                this.inoutTypes.get(i).setMyScope(scope);
            }
        }
        if (this.providerReference != null) {
            this.providerReference.setMyScope(scope);
        }
        if (this.inMappings != null) {
            this.inMappings.setMyScope(scope);
        }
        if (this.outMappings != null) {
            this.outMappings.setMyScope(scope);
        }
    }

    public OperationModes getOperationMode() {
        return this.operationMode;
    }

    public TestPortAPI_type getTestportType() {
        return this.testportType;
    }

    public PortType_type getPortType() {
        return this.portType;
    }

    public IType getProviderType() {
        return this.providerType;
    }

    public TypeSet getInMessages() {
        return this.inMessages;
    }

    public TypeSet getOutMessage() {
        return this.outMessages;
    }

    public TypeSet getInSignatures() {
        return this.inSignatures;
    }

    public TypeSet getOutSignatures() {
        return this.outSignatures;
    }

    public boolean isInternal() {
        return TestPortAPI_type.TP_INTERNAL.equals((Object)this.testportType);
    }

    public IType getAddressType(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked == null || !TestPortAPI_type.TP_ADDRESS.equals((Object)this.testportType)) {
            return null;
        }
        IType t = null;
        t = PortType_type.PT_USER.equals((Object)this.portType) && this.providerType != null ? this.providerType : this.myType;
        return ((TTCN3Module)t.getMyScope().getModuleScope()).getAddressType(timestamp);
    }

    private void addProviderAttribute() {
        this.portType = PortType_type.PT_PROVIDER;
        this.providerReference = null;
        this.providerType = null;
        this.inMappings = null;
        this.outMappings = null;
    }

    public void addUserAttribute(Reference providerReference, TypeMappings inMappings, TypeMappings outMappings) {
        this.portType = PortType_type.PT_USER;
        this.providerReference = providerReference;
        this.providerReference.setFullNameParent(new BridgingNamedNode(this, ".<provider_ref>"));
        this.providerReference.setMyScope(this.myType.getMyScope());
        this.providerType = null;
        this.inMappings = inMappings;
        if (inMappings != null) {
            this.inMappings.setFullNameParent(new BridgingNamedNode(this, ".<inMappings>"));
            this.inMappings.setMyScope(this.myType.getMyScope());
        }
        this.outMappings = outMappings;
        if (outMappings != null) {
            this.outMappings.setFullNameParent(new BridgingNamedNode(this, ".<outMappings>"));
            this.outMappings.setMyScope(this.myType.getMyScope());
        }
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.inMessages = null;
        this.outMessages = null;
        this.inSignatures = null;
        this.outSignatures = null;
        this.lastTimeChecked = timestamp;
        if (this.inoutAll) {
            if (this.inAll) {
                this.location.reportSemanticWarning(REDUNDANTINALL);
                this.inAll = false;
            }
            if (this.outAll) {
                this.location.reportSemanticWarning(REDUNDANTOUTALL);
                this.outAll = false;
            }
            this.location.reportSemanticWarning(UNSUPPORTEDINOUTALL);
        } else {
            if (this.inAll) {
                this.location.reportSemanticWarning(UNSUPPORTEDINALL);
            }
            if (this.outAll) {
                this.location.reportSemanticWarning(UNSUPPORTEDOUTALL);
            }
        }
        if (this.inTypes != null) {
            this.checkList(timestamp, this.inTypes, true, false);
        }
        if (this.outTypes != null) {
            this.checkList(timestamp, this.outTypes, false, true);
        }
        if (this.inoutTypes != null) {
            this.checkList(timestamp, this.inoutTypes, true, true);
        }
    }

    private void checkUserAttribute(CompilationTimeStamp timestamp) {
        IType signatureType;
        Type targetType;
        int j;
        int nofTargets;
        TypeMapping mapping;
        IType messageType;
        Type sourceType;
        int size;
        if (this.providerReference == null) {
            return;
        }
        this.providerType = null;
        PortTypeBody providerBody = null;
        Assignment assignment = this.providerReference.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            if (Assignment.Assignment_type.A_TYPE.equals(assignment.getAssignmentType())) {
                IType type = assignment.getType(timestamp).getTypeRefdLast(timestamp);
                if (IType.Type_type.TYPE_PORT.equals((Object)type.getTypetype())) {
                    this.providerType = type;
                    providerBody = ((Port_Type)type).getPortBody();
                } else {
                    this.providerReference.getLocation().reportSemanticError(MessageFormat.format("Type reference `{0}'' does not refer to a port type", this.providerReference.getDisplayName()));
                }
            } else {
                this.providerReference.getLocation().reportSemanticError(MessageFormat.format("Reference `{0}'' does not refer to a type", this.providerReference.getDisplayName()));
            }
        }
        if (providerBody != null && !TestPortAPI_type.TP_INTERNAL.equals((Object)this.testportType)) {
            if (!PortType_type.PT_PROVIDER.equals((Object)providerBody.portType)) {
                this.providerReference.getLocation().reportSemanticError(MessageFormat.format("The referenced port type `{0}'' must have the `provider'' attribute", this.providerType.getTypename()));
            }
            switch (providerBody.testportType) {
                case TP_REGULAR: {
                    if (!TestPortAPI_type.TP_ADDRESS.equals((Object)this.testportType)) break;
                    this.providerReference.getLocation().reportSemanticError(MessageFormat.format("Attribute `address'' cannot be used because the provider port type `{0}'' does not have attribute `address''", this.providerType.getTypename()));
                    break;
                }
                case TP_INTERNAL: {
                    this.providerReference.getLocation().reportSemanticError(MessageFormat.format("Missing attribute `internal''. Provider port type `{0}'' has attribute `internal'', which must be also present here", this.providerType.getTypename()));
                    break;
                }
                case TP_ADDRESS: {
                    break;
                }
            }
            this.testportType = providerBody.testportType;
        }
        if (this.inMappings != null && this.inMappings.getNofMappings() != 0) {
            this.inMappings.check(timestamp);
            if (providerBody != null) {
                if (providerBody.inMessages != null) {
                    int i;
                    size = this.inMappings.getNofMappings();
                    for (i = 0; i < size; ++i) {
                        sourceType = this.inMappings.getMappingByIndex(i).getSourceType();
                        if (sourceType == null || providerBody.inMessages.hasType(timestamp, sourceType)) continue;
                        sourceType.getLocation().reportSemanticError(MessageFormat.format("Source type `{0}'' of the `in'' mapping is not present on the list of incoming messages in provider port type `{1}''", sourceType.getTypename(), this.providerType.getTypename()));
                    }
                    size = providerBody.inMessages.getNofTypes();
                    for (i = 0; i < size; ++i) {
                        messageType = providerBody.inMessages.getTypeByIndex(i);
                        if (this.inMappings.hasMappingForType(timestamp, messageType)) continue;
                        this.inMappings.getLocation().reportSemanticError(MessageFormat.format("Incoming message type `{0}'' of provider port type `{1}'' is not handled by the incoming mappings", messageType.getTypename(), this.providerType.getTypename()));
                        this.inMappings.hasMappingForType(timestamp, messageType);
                    }
                } else {
                    this.inMappings.getLocation().reportSemanticError(MessageFormat.format("Invalid incoming mappings. Provider port type `{0}' does not have incoming message types'", this.providerType.getTypename()));
                }
            }
            size = this.inMappings.getNofMappings();
            for (int i = 0; i < size; ++i) {
                mapping = this.inMappings.getMappingByIndex(i);
                nofTargets = mapping.getNofTargets();
                for (j = 0; j < nofTargets; ++j) {
                    targetType = mapping.getTargetByIndex(j).getTargetType();
                    if (targetType == null || this.inMessages != null && this.inMessages.hasType(timestamp, targetType)) continue;
                    targetType.getLocation().reportSemanticError(MessageFormat.format("Target type `{0}'' of the `in'' mapping is not present on the list of incoming messages in user port type `{1}''", targetType.getTypename(), this.myType.getTypename()));
                }
            }
        } else if (providerBody != null && providerBody.inMessages != null) {
            this.location.reportSemanticError(MessageFormat.format("Missing `in'' mappings to handle the incoming message types of provider port type `{0}''", this.providerType.getTypename()));
        }
        if (this.outMappings != null && this.outMappings.getNofMappings() != 0) {
            this.outMappings.check(timestamp);
            if (this.outMessages != null) {
                int i;
                size = this.outMappings.getNofMappings();
                for (i = 0; i < size; ++i) {
                    sourceType = this.outMappings.getMappingByIndex(i).getSourceType();
                    if (sourceType == null || this.outMessages.hasType(timestamp, sourceType)) continue;
                    sourceType.getLocation().reportSemanticError(MessageFormat.format("Source type `{0}'' of the `out'' mapping is not present on the list of outgoing messages in user port type `{1}''", sourceType.getTypename(), this.myType.getTypename()));
                }
                size = this.outMessages.getNofTypes();
                for (i = 0; i < size; ++i) {
                    messageType = this.outMessages.getTypeByIndex(i);
                    if (this.outMappings.hasMappingForType(timestamp, messageType)) continue;
                    this.outMappings.getLocation().reportSemanticError(MessageFormat.format("Outgoing message type `{0}'' of user port type `{1}'' is not handled by the outgoing mappings", messageType.getTypename(), this.myType.getTypename()));
                }
            } else {
                this.outMappings.getLocation().reportSemanticError(MessageFormat.format("Invalid outgoing mappings. User port type `{0}'' does not have outgoing message types", this.myType.getTypename()));
            }
            if (providerBody != null) {
                size = this.outMappings.getNofMappings();
                for (int i = 0; i < size; ++i) {
                    mapping = this.outMappings.getMappingByIndex(i);
                    nofTargets = mapping.getNofTargets();
                    for (j = 0; j < nofTargets; ++j) {
                        targetType = mapping.getTargetByIndex(j).getTargetType();
                        if (targetType == null || providerBody.outMessages != null && providerBody.outMessages.hasType(timestamp, targetType)) continue;
                        targetType.getLocation().reportSemanticError(MessageFormat.format("Target type `{0}'' of the `out'' mapping is not present on the list of outgoing messages in provider port type `{1}''", targetType.getTypename(), this.providerType.getTypename()));
                    }
                }
            }
        } else if (this.outMessages != null) {
            this.location.reportSemanticError(MessageFormat.format("Missing `out'' mapping to handle the outgoing message types of user port type `{0}''", this.myType.getTypename()));
        }
        if (providerBody == null) {
            return;
        }
        if (this.inSignatures != null) {
            size = this.inSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                Signature_Type lastSignature;
                IType last;
                signatureType = this.inSignatures.getTypeByIndex(i);
                if (providerBody.inSignatures != null && providerBody.inSignatures.hasType(timestamp, signatureType) || (last = signatureType.getTypeRefdLast(timestamp)).getIsErroneous(timestamp) || !IType.Type_type.TYPE_SIGNATURE.equals((Object)last.getTypetype()) || (lastSignature = (Signature_Type)last).isNonblocking() && lastSignature.getSignatureExceptions() == null) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Incoming signature `{0}'' of user port type `{1}'' is not present on the list of incoming signatures in provider port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), this.providerType.getTypename()));
            }
        }
        if (providerBody.inSignatures != null) {
            size = providerBody.inSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                signatureType = providerBody.inSignatures.getTypeByIndex(i);
                if (this.inSignatures != null && this.inSignatures.hasType(timestamp, signatureType)) continue;
                this.location.reportSemanticError(MessageFormat.format("Incoming signature `{0}'' of provider port type `{1}'' is not present on the list of incoming signatures in user port type `{2}''", signatureType.getTypename(), this.providerType.getTypename(), this.myType.getTypename()));
            }
        }
        if (this.outSignatures != null) {
            size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                signatureType = this.outSignatures.getTypeByIndex(i);
                if (providerBody.outSignatures != null && providerBody.outSignatures.hasType(timestamp, signatureType)) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Outgoing signature `{0}'' of user port type `{1}'' is not present on the list of outgoing signatures in provider port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), this.providerType.getTypename()));
            }
        }
        if (providerBody.outSignatures != null) {
            size = providerBody.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                Signature_Type lastSignature;
                IType last;
                signatureType = providerBody.outSignatures.getTypeByIndex(i);
                if (this.outSignatures != null && this.outSignatures.hasType(timestamp, signatureType) || (last = signatureType.getTypeRefdLast(timestamp)).getIsErroneous(timestamp) || !IType.Type_type.TYPE_SIGNATURE.equals((Object)last.getTypetype()) || (lastSignature = (Signature_Type)last).isNonblocking() && lastSignature.getSignatureExceptions() == null) continue;
                this.location.reportSemanticError(MessageFormat.format("Outgoing signature `{0}'' of provider port type `{1}'' is not present on the list of outgoing signatures in user port type `{2}''", signatureType.getTypename(), this.providerType.getTypename(), this.myType.getTypename()));
            }
        }
    }

    public void checkAttributes(CompilationTimeStamp timestamp, WithAttributesPath withAttributesPath) {
        TTCN3Module module;
        int i;
        if (this.lastTimeAttributesChecked != null && !this.lastTimeAttributesChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeAttributesChecked = this.lastTimeChecked;
        List<SingleWithAttribute> realAttributes = withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (int i2 = 0; i2 < realAttributes.size(); ++i2) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i2);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        if (attributes.isEmpty()) {
            return;
        }
        this.testportType = TestPortAPI_type.TP_REGULAR;
        this.portType = PortType_type.PT_REGULAR;
        block28: for (i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            if (!ExtensionAttribute.ExtensionAttribute_type.PORTTYPE.equals((Object)extensionAttribute.getAttributeType())) continue;
            PortTypeAttribute portAttribute = (PortTypeAttribute)extensionAttribute;
            switch (portAttribute.getPortTypeType()) {
                case INTERNAL: {
                    switch (this.testportType) {
                        case TP_REGULAR: {
                            break;
                        }
                        case TP_INTERNAL: {
                            extensionAttribute.getLocation().reportSemanticWarning("Duplicate attribute `internal'");
                            break;
                        }
                        case TP_ADDRESS: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `address' and `internal' cannot be used at the same time");
                            break;
                        }
                    }
                    this.testportType = TestPortAPI_type.TP_INTERNAL;
                    continue block28;
                }
                case ADDRESS: {
                    switch (this.testportType) {
                        case TP_REGULAR: {
                            break;
                        }
                        case TP_INTERNAL: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `address' and `internal' cannot be used at the same time");
                            break;
                        }
                        case TP_ADDRESS: {
                            extensionAttribute.getLocation().reportSemanticWarning("Duplicate attribute `address'");
                            break;
                        }
                    }
                    this.testportType = TestPortAPI_type.TP_ADDRESS;
                    continue block28;
                }
                case PROVIDER: {
                    switch (this.portType) {
                        case PT_REGULAR: {
                            break;
                        }
                        case PT_PROVIDER: {
                            extensionAttribute.getLocation().reportSemanticWarning("Duplicate attribute `provider'");
                            break;
                        }
                        case PT_USER: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `user' and `provider' cannot be used at the same time");
                            break;
                        }
                    }
                    this.addProviderAttribute();
                    continue block28;
                }
                case USER: {
                    switch (this.portType) {
                        case PT_REGULAR: {
                            break;
                        }
                        case PT_PROVIDER: {
                            extensionAttribute.getLocation().reportSemanticError("Attributes `provider' and `user' cannot be used at the same time");
                            break;
                        }
                        case PT_USER: {
                            extensionAttribute.getLocation().reportSemanticError("Duplicate attribute `user'");
                            break;
                        }
                    }
                    UserPortTypeAttribute user = (UserPortTypeAttribute)portAttribute;
                    this.addUserAttribute(user.getReference(), user.getInMappings(), user.getOutMappings());
                    continue block28;
                }
            }
        }
        if (PortType_type.PT_USER.equals((Object)this.portType)) {
            this.checkUserAttribute(timestamp);
        } else if (TestPortAPI_type.TP_ADDRESS.equals((Object)this.testportType) && (module = (TTCN3Module)this.myType.getMyScope().getModuleScope()).getAddressType(timestamp) == null) {
            this.location.reportSemanticError(MessageFormat.format("Type `address'' is not defined in module `{0}''", module.getIdentifier().getDisplayName()));
        }
    }

    private void checkList(CompilationTimeStamp timestamp, List<IType> list, boolean isIn, boolean isOut) {
        String errorMessage = isIn ? (isOut ? "sent or received" : "received") : "sent";
        int size = list.size();
        block3: for (int i = 0; i < size; ++i) {
            IType last;
            IType type = list.get(i);
            type.check(timestamp);
            if (type.isComponentInternal(timestamp)) {
                HashSet<IType> typeSet = new HashSet<IType>();
                type.checkComponentInternal(timestamp, typeSet, "sent or received on a port");
            }
            if ((last = type.getTypeRefdLast(timestamp)) == null || last.getIsErroneous(timestamp)) continue;
            switch (last.getTypetype()) {
                case TYPE_SIGNATURE: {
                    if (OperationModes.OP_Message.equals((Object)this.operationMode)) {
                        type.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREONMESSAGEPORT, last.getTypename()));
                    }
                    if (isIn) {
                        if (this.inSignatures != null && this.inSignatures.hasType(timestamp, last)) {
                            type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDINSIGNATURE, last.getTypename()));
                        } else {
                            if (this.inSignatures == null) {
                                this.inSignatures = new TypeSet();
                                this.inSignatures.setFullNameParent(this);
                            }
                            this.inSignatures.addType(type);
                        }
                    }
                    if (!isOut) continue block3;
                    if (this.outSignatures != null && this.outSignatures.hasType(timestamp, last)) {
                        type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDOUTSIGNATURE, last.getTypename()));
                        continue block3;
                    }
                    if (this.outSignatures == null) {
                        this.outSignatures = new TypeSet();
                        this.outSignatures.setFullNameParent(this);
                    }
                    this.outSignatures.addType(type);
                    continue block3;
                }
                default: {
                    if (OperationModes.OP_Procedure.equals((Object)this.operationMode)) {
                        type.getLocation().reportSemanticError(MessageFormat.format(DATAONPROCEDUREPORT, last.getTypename(), errorMessage));
                    }
                    if (isIn) {
                        if (this.inMessages != null && this.inMessages.hasType(timestamp, last)) {
                            type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDINMESSAGE, type.getTypename()));
                        } else {
                            if (this.inMessages == null) {
                                this.inMessages = new TypeSet();
                                this.inMessages.setFullNameParent(this);
                            }
                            this.inMessages.addType(type);
                        }
                    }
                    if (!isOut) continue block3;
                    if (this.outMessages != null && this.outMessages.hasType(timestamp, last)) {
                        type.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDOUTMESSAGE, type.getTypename()));
                        continue block3;
                    }
                    if (this.outMessages == null) {
                        this.outMessages = new TypeSet();
                        this.outMessages.setFullNameParent(this);
                    }
                    this.outMessages.addType(type);
                }
            }
        }
    }

    public boolean hasQueue(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (this.inMessages != null || this.inSignatures != null) {
            return true;
        }
        if (this.outSignatures != null) {
            int size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                Signature_Type signature = (Signature_Type)this.outSignatures.getTypeByIndex(i).getTypeRefdLast(timestamp);
                if (signature.isNonblocking() && signature.getSignatureExceptions() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getreplyAllowed(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (this.outSignatures != null) {
            IType tempType = null;
            int size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                tempType = this.outSignatures.getTypeByIndex(i).getTypeRefdLast(timestamp);
                if (((Signature_Type)tempType).isNonblocking()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean catchAllowed(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        if (this.outSignatures != null) {
            IType tempType = null;
            int size = this.outSignatures.getNofTypes();
            for (int i = 0; i < size; ++i) {
                tempType = this.outSignatures.getTypeByIndex(i).getTypeRefdLast(timestamp);
                if (((Signature_Type)tempType).getSignatureExceptions() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMappable(CompilationTimeStamp timestamp, PortTypeBody other) {
        int i;
        int size;
        if (this == other) {
            return true;
        }
        if (this.outMessages != null) {
            if (other.outMessages == null) {
                return false;
            }
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.outMessages.hasType(timestamp, this.outMessages.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (this.outSignatures != null) {
            if (other.outSignatures == null) {
                return false;
            }
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.outSignatures.hasType(timestamp, this.outSignatures.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (other.inMessages != null) {
            if (this.inMessages == null) {
                return false;
            }
            size = other.inMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (this.inMessages.hasType(timestamp, other.inMessages.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (other.inSignatures != null) {
            if (this.inSignatures == null) {
                return false;
            }
            size = other.inSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (this.inSignatures.hasType(timestamp, other.inSignatures.getTypeByIndex(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void reportMappingErrors(CompilationTimeStamp timestamp, PortTypeBody other) {
        IType signatureType;
        IType messageType;
        int i;
        int size;
        if (this.outMessages != null) {
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                messageType = this.outMessages.getTypeByIndex(i);
                if (other.outMessages != null && other.outMessages.hasType(timestamp, messageType)) continue;
                messageType.getLocation().reportSemanticError(MessageFormat.format("Outgoing message type `{0}'' of test component port type `{1}'' is not present on the outgoing list of system port type `{2}''", messageType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
        if (this.outSignatures != null) {
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                signatureType = this.outSignatures.getTypeByIndex(i);
                if (other.outSignatures != null && other.outSignatures.hasType(timestamp, signatureType)) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Outgoing signature type `{0}'' of test component port type `{1}'' is not present on the outgoing list of system port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
        if (other.inMessages != null) {
            size = other.inMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                messageType = other.inMessages.getTypeByIndex(i);
                if (this.inMessages != null && this.inMessages.hasType(timestamp, messageType)) continue;
                messageType.getLocation().reportSemanticError(MessageFormat.format("Incoming message type `{0}'' of system port type `{1}'' is not present on the incoming list of test component port type `{2}''", messageType.getTypename(), other.myType.getTypename(), this.myType.getTypename()));
            }
        }
        if (other.inSignatures != null) {
            size = other.inSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                signatureType = other.inSignatures.getTypeByIndex(i);
                if (this.inSignatures != null && this.inSignatures.hasType(timestamp, signatureType)) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Incoming signature type `{0}'' of system port type `{1}'' is not present on the incoming list of test component port type `{2}''", signatureType.getTypename(), other.myType.getTypename(), this.myType.getTypename()));
            }
        }
    }

    public boolean isConnectable(CompilationTimeStamp timestamp, PortTypeBody other) {
        int i;
        int size;
        if (this.outMessages != null) {
            if (other.inMessages == null) {
                return false;
            }
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.inMessages.hasType(timestamp, this.outMessages.getTypeByIndex(i))) continue;
                return false;
            }
        }
        if (this.outSignatures != null) {
            if (other.inSignatures == null) {
                return false;
            }
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                if (other.inSignatures.hasType(timestamp, this.outSignatures.getTypeByIndex(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void reportConnectionErrors(CompilationTimeStamp timestamp, PortTypeBody other) {
        int i;
        int size;
        if (this.outMessages != null) {
            size = this.outMessages.getNofTypes();
            for (i = 0; i < size; ++i) {
                IType messageType = this.outMessages.getTypeByIndex(i);
                if (other.inMessages != null && other.inMessages.hasType(timestamp, messageType)) continue;
                messageType.getLocation().reportSemanticError(MessageFormat.format("Outgoing message type `{0}'' of port type `{1}'' is not present on the incoming list of port type `{2}''", messageType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
        if (this.outSignatures != null) {
            size = this.outSignatures.getNofTypes();
            for (i = 0; i < size; ++i) {
                IType signatureType = this.outSignatures.getTypeByIndex(i);
                if (other.inSignatures != null && other.inSignatures.hasType(timestamp, this.outSignatures.getTypeByIndex(i))) continue;
                signatureType.getLocation().reportSemanticError(MessageFormat.format("Outgoing signature type `{0}'' of port type `{1}'' is not present on the incoming list of port type `{2}''", signatureType.getTypename(), this.myType.getTypename(), other.myType.getTypename()));
            }
        }
    }

    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() != i + 1 || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        if (OperationModes.OP_Message.equals((Object)this.operationMode) || OperationModes.OP_Mixed.equals((Object)this.operationMode)) {
            propCollector.addTemplateProposal("send", new Template("send( templateInstance )", "", propCollector.getContextIdentifier(), "send( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("send", new Template("send( templateInstance ) to location", "", propCollector.getContextIdentifier(), "send( ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addReceiveProposals(propCollector, i);
            PortTypeBody.addTriggerProposals(propCollector, i);
        }
        if (OperationModes.OP_Procedure.equals((Object)this.operationMode) || OperationModes.OP_Mixed.equals((Object)this.operationMode)) {
            propCollector.addTemplateProposal("call", new Template("call( templateInstance )", "", propCollector.getContextIdentifier(), "call( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("call", new Template("call( templateInstance , callTimer )", "with timer", propCollector.getContextIdentifier(), "call( ${templateInstance} , ${callTimer} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("call", new Template("call( templateInstance ) to location", "with to clause", propCollector.getContextIdentifier(), "call( ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("call", new Template("call( templateInstance , callTimer ) to location", "with timer and to clause", propCollector.getContextIdentifier(), "call( ${templateInstance} , ${callTimer} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addGetcallProposals(propCollector, i);
            propCollector.addTemplateProposal("reply", new Template("reply( templateInstance )", "", propCollector.getContextIdentifier(), "reply( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("reply", new Template("reply( templateInstance ) to location", "", propCollector.getContextIdentifier(), "reply( ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addGetreplyProposals(propCollector, i);
            propCollector.addTemplateProposal("raise", new Template("raise( signature, templateInstance )", "", propCollector.getContextIdentifier(), "raise( ${signature}, ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("raise", new Template("raise( signature, templateInstance ) to location", "with to clause", propCollector.getContextIdentifier(), "raise( ${signature}, ${templateInstance} ) to ${location};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            PortTypeBody.addCatchProposals(propCollector, i);
        }
        PortTypeBody.addCheckProposals(propCollector, i);
        propCollector.addProposal("clear;", "clear", ImageCache.getImage("port.gif"), "");
        propCollector.addProposal("start;", "start", ImageCache.getImage("port.gif"), "");
        propCollector.addProposal("stop;", "stop", ImageCache.getImage("port.gif"), "");
        propCollector.addProposal("halt;", "halt", ImageCache.getImage("port.gif"), "");
    }

    public static void addAnyorAllProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (i != 0 || subrefs.isEmpty() || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(0).getReferenceType())) {
            return;
        }
        String fakeModuleName = propCollector.getReference().getModuleIdentifier().getDisplayName();
        if ("any port".equals(fakeModuleName)) {
            PortTypeBody.addReceiveProposals(propCollector, i);
            PortTypeBody.addTriggerProposals(propCollector, i);
            PortTypeBody.addGetcallProposals(propCollector, i);
            PortTypeBody.addGetreplyProposals(propCollector, i);
            PortTypeBody.addCatchProposals(propCollector, i);
            PortTypeBody.addCheckProposals(propCollector, i);
        } else if ("all port".equals(fakeModuleName)) {
            propCollector.addProposal("clear;", "clear", ImageCache.getImage("port.gif"), "");
            propCollector.addProposal("start;", "start", ImageCache.getImage("port.gif"), "");
            propCollector.addProposal("stop;", "stop", ImageCache.getImage("port.gif"), "");
            propCollector.addProposal("halt;", "halt", ImageCache.getImage("port.gif"), "");
        }
    }

    private static void addReceiveProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("receive", "receive", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("receive", new Template("receive -> value myVar", "value redirect", propCollector.getContextIdentifier(), "receive -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "receive -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "receive -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive from myPeer", "from clause", propCollector.getContextIdentifier(), "receive from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "receive from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance )", "", propCollector.getContextIdentifier(), "receive( ${template} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) -> value myVar", "value redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) from myPeer", "from clause", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("receive", new Template("receive( templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "receive( ${templateInstance} ) from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addTriggerProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("trigger", "trigger", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("trigger", new Template("trigger -> value myVar", "value redirect", propCollector.getContextIdentifier(), "trigger -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "trigger -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "trigger -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger from myPeer", "from clause", propCollector.getContextIdentifier(), "trigger from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "trigger from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance )", "", propCollector.getContextIdentifier(), "trigger( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) -> value myVar", "value redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) from myPeer", "from clause", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("trigger", new Template("trigger( templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "trigger( ${templateInstance} ) from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addGetcallProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("getcall", "getcall", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("getcall", new Template("getcall from myPartner", "from clause", propCollector.getContextIdentifier(), "getcall from ${myPartner};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall -> sender myPartnerVar", "sender redirect", propCollector.getContextIdentifier(), "getcall -> sender ${myPartnerVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance )", "", propCollector.getContextIdentifier(), "getcall( ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) from myPartner", "from clause", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) from ${myPartner};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) -> sender myPartnerVar", "sender redirect", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) -> sender ${myPartnerVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) -> param(parameters)", "parameters", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) -> param( ${parameters} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) from myPartner -> param(parameters)", "from clause and parameters", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) from ${myPartner} -> param( ${parameters} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getcall", new Template("getcall( templateInstance ) -> param(parameters) sender mySenderVar", "parameters and sender clause", propCollector.getContextIdentifier(), "getcall( ${templateInstance} ) -> param( ${parameters} ) sender ${mySenderVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addGetreplyProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("getreply", "getreply", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("getreply", new Template("getreply from myPartner", "from clause", propCollector.getContextIdentifier(), "getreply from ${myPartner};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("getreply", new Template("getreply( templateInstance ) -> value myReturnValue param(parameters) sender mySenderVar", "value, parameters and sender clause", propCollector.getContextIdentifier(), "getreply( ${templateInstance} ) -> value ${myReturnValue} param( ${parameters} ) sender ${mySenderVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addCatchProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("catch", "catch", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("catch", new Template("catch -> value myVar", "value redirect", propCollector.getContextIdentifier(), "catch -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "catch -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "catch -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch from myPeer", "from clause", propCollector.getContextIdentifier(), "catch from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "catch from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance )", "", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) -> value myVar", "value redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) -> sender myPeer", "sender redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) -> sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) -> value myVar sender myPeer", "value and sender redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) -> value ${myVar} sender ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) from myPeer", "from clause", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) from ${myPeer};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( signature, templateInstance ) from myPeer -> value myVar", "from clause with value redirect", propCollector.getContextIdentifier(), "catch( ${signature}, ${templateInstance} ) from ${myPeer} -> value ${myVar};", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("catch", new Template("catch( timeout )", "", propCollector.getContextIdentifier(), "catch( timeout );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    public static void addCheckProposals(ProposalCollector propCollector, int i) {
        propCollector.addProposal("check", "check", ImageCache.getImage("port.gif"), "");
        propCollector.addTemplateProposal("check", new Template("check( portOperation )", "", propCollector.getContextIdentifier(), "check( ${portOperation} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( from myPeer)", "form clause", propCollector.getContextIdentifier(), "check( from ${myPeer});", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( from myPeer -> value myVar)", "form and value clause", propCollector.getContextIdentifier(), "check( from ${myPeer} -> value ${myVar});", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( -> value myVar)", "value clause", propCollector.getContextIdentifier(), "check( -> value ${myVar} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        propCollector.addTemplateProposal("check", new Template("check( -> value myVar sender myPeer)", "value and sender clause", propCollector.getContextIdentifier(), "check( -> value ${myVar} sender ${myPeer} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        IType type;
        int i;
        int size;
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.inTypes != null) {
            size = this.inTypes.size();
            for (i = 0; i < size; ++i) {
                type = this.inTypes.get(i);
                if (!(type instanceof IIncrementallyUpdateable)) {
                    throw new ReParseException();
                }
                ((IIncrementallyUpdateable)((Object)type)).updateSyntax(reparser, false);
                reparser.updateLocation(type.getLocation());
            }
        }
        if (this.outTypes != null) {
            size = this.outTypes.size();
            for (i = 0; i < size; ++i) {
                type = this.outTypes.get(i);
                if (!(type instanceof IIncrementallyUpdateable)) {
                    throw new ReParseException();
                }
                ((IIncrementallyUpdateable)((Object)type)).updateSyntax(reparser, false);
                reparser.updateLocation(type.getLocation());
            }
        }
        if (this.inoutTypes != null) {
            size = this.inoutTypes.size();
            for (i = 0; i < size; ++i) {
                type = this.inoutTypes.get(i);
                if (!(type instanceof IIncrementallyUpdateable)) {
                    throw new ReParseException();
                }
                ((IIncrementallyUpdateable)((Object)type)).updateSyntax(reparser, false);
                reparser.updateLocation(type.getLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.inTypes != null) {
            for (IType t : this.inTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.outTypes != null) {
            for (IType t : this.outTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.inoutTypes != null) {
            for (IType t : this.inoutTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
        if (this.providerReference != null) {
            this.providerReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.inMappings != null) {
            this.inMappings.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.outMappings != null) {
            this.outMappings.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.inTypes != null) {
            for (IType t : this.inTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        if (this.outTypes != null) {
            for (IType t : this.outTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        if (this.inoutTypes != null) {
            for (IType t : this.inoutTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        if (this.providerReference != null && !this.providerReference.accept(v)) {
            return false;
        }
        if (this.inMappings != null && !this.inMappings.accept(v)) {
            return false;
        }
        return this.outMappings == null || this.outMappings.accept(v);
    }

    public static enum PortType_type {
        PT_REGULAR,
        PT_PROVIDER,
        PT_USER;

    }

    public static enum TestPortAPI_type {
        TP_REGULAR,
        TP_INTERNAL,
        TP_ADDRESS;

    }

    public static enum OperationModes {
        OP_Message,
        OP_Procedure,
        OP_Mixed;

    }
}

