/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ExternalConst;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Component_Type
extends Type {
    private static final String COMPONENT_GIF = "component.gif";
    private static final String COMPONENTVALUEEXPECTED = "Component value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `{0}''";
    private static final String INVALIDSUBREFERENCE = "Referencing fields of a component is not allowed";
    private static final String[] SIMPLE_COMPONENT_PROPOSALS = new String[]{"alive", "create;", "create alive;", "done", "kill;", "killed", "running", "stop;"};
    private static final String[] ANY_COMPONENT_PROPOSALS = new String[]{"running", "alive", "done", "killed"};
    private static final String[] ALL_COMPONENT_PROPOSALS = new String[]{"running", "alive", "done", "killed", "stop;", "kill;"};
    private final ComponentTypeBody componentBody;

    public Component_Type(ComponentTypeBody component) {
        this.componentBody = component;
        this.componentBody.setFullNameParent(this);
        this.componentBody.setMyType(this);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_COMPONENT;
    }

    public ComponentTypeBody getComponentBody() {
        return this.componentBody;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.componentBody.setMyScope(scope);
    }

    @Override
    public void setAttributeParentPath(WithAttributesPath parent) {
        super.setAttributeParentPath(parent);
        this.componentBody.setAttributeParentPath(this.withAttributesPath);
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("component");
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        return IType.Type_type.TYPE_COMPONENT.equals((Object)temp.getTypetype()) && this.componentBody.isCompatible(timestamp, ((Component_Type)temp).componentBody);
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return COMPONENT_GIF;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.parseAttributes(timestamp);
        this.componentBody.check(timestamp);
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case TTCN3_NULL_VALUE: {
                value.setValuetype(timestamp, IValue.Value_type.EXPRESSION_VALUE);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(COMPONENTVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format(INVALIDSUBREFERENCE, ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        this.componentBody.addProposal(propCollector, i);
        if (subrefs.size() == i + 1) {
            for (String proposal : SIMPLE_COMPONENT_PROPOSALS) {
                propCollector.addProposal(proposal, proposal, ImageCache.getImage(this.getOutlineIcon()), "");
            }
            propCollector.addTemplateProposal("create", new Template("create( name )", "", propCollector.getContextIdentifier(), "create( ${name} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("create", new Template("create( name ) alive", "", propCollector.getContextIdentifier(), "create( ${name} ) alive;", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("create", new Template("create( name, location )", "", propCollector.getContextIdentifier(), "create( ${name}, ${location} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("create", new Template("create( name, location ) alive", "", propCollector.getContextIdentifier(), "create( ${name}, ${location} ) alive;", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("start", new Template("start( function name )", "", propCollector.getContextIdentifier(), "start( ${functionName} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    public static void addAnyorAllProposal(ProposalCollector propCollector, int i) {
        block4: {
            String fakeModuleName;
            block3: {
                List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
                if (i != 0 || subrefs.isEmpty() || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(0).getReferenceType())) {
                    return;
                }
                fakeModuleName = propCollector.getReference().getModuleIdentifier().getDisplayName();
                if (!"any component".equals(fakeModuleName)) break block3;
                for (String proposal : ANY_COMPONENT_PROPOSALS) {
                    propCollector.addProposal(proposal, proposal, ImageCache.getImage(COMPONENT_GIF), "");
                }
                break block4;
            }
            if (!"all component".equals(fakeModuleName)) break block4;
            for (String proposal : ALL_COMPONENT_PROPOSALS) {
                propCollector.addProposal(proposal, proposal, ImageCache.getImage(COMPONENT_GIF), "");
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= i || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(i).getReferenceType())) {
            return;
        }
        this.componentBody.addDeclaration(declarationCollector, i);
    }

    @Override
    public Object[] getOutlineChildren() {
        return this.componentBody.getDefinitions().toArray();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.componentBody != null && reparser.envelopsDamage(this.componentBody.getLocation())) {
                this.componentBody.updateSyntax(reparser, true);
                reparser.updateLocation(this.componentBody.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        this.componentBody.updateSyntax(reparser, false);
        reparser.updateLocation(this.componentBody.getLocation());
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    public static void checkExpressionOperandComponentRefernce(CompilationTimeStamp timestamp, IValue value, String operationName) {
        block0 : switch (value.getValuetype()) {
            case EXPRESSION_VALUE: {
                Expression_Value expression = (Expression_Value)value;
                if (!Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expression.getOperationType())) break;
                ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue last = value.getValueRefdLast(timestamp, chain);
                chain.release();
                if (last == null || last.getIsErroneous(timestamp)) {
                    value.setIsErroneous(true);
                    return;
                }
                IType type = last.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (type == null) {
                    value.setIsErroneous(true);
                    return;
                }
                if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                    value.setIsErroneous(true);
                    return;
                }
                if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break;
                value.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                value.setIsErroneous(true);
                return;
            }
            case REFERENCED_VALUE: {
                Reference reference = ((Referenced_Value)value).getReference();
                Assignment assignment = reference.getRefdAssignment(timestamp, true);
                if (assignment == null) {
                    value.setIsErroneous(true);
                    return;
                }
                switch (assignment.getAssignmentType()) {
                    case A_CONST: {
                        IType type = ((Def_Const)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
                            reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                            value.setIsErroneous(true);
                            return;
                        }
                        IValue tempValue = ((Def_Const)assignment).getValue();
                        if (tempValue == null) {
                            return;
                        }
                        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                        tempValue = tempValue.getReferencedSubValue(timestamp, reference, 1, chain);
                        chain.release();
                        if (tempValue == null) {
                            return;
                        }
                        chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                        tempValue = tempValue.getValueRefdLast(timestamp, chain);
                        chain.release();
                        if (IValue.Value_type.TTCN3_NULL_VALUE.equals((Object)tempValue.getValuetype())) {
                            reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the `null'' component reference", operationName));
                            value.setIsErroneous(true);
                            return;
                        }
                        if (!IValue.Value_type.EXPRESSION_VALUE.equals((Object)tempValue.getValuetype())) {
                            return;
                        }
                        switch (((Expression_Value)tempValue).getOperationType()) {
                            case MTC_COMPONENT_OPERATION: {
                                reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the component reference of the `mtc''", operationName));
                                value.setIsErroneous(true);
                                return;
                            }
                            case COMPONENT_NULL_OPERATION: {
                                reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the `null'' component reference", operationName));
                                value.setIsErroneous(true);
                                return;
                            }
                            case SYSTEM_COMPONENT_OPERATION: {
                                reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' refers to the component reference of the `system''", operationName));
                                value.setIsErroneous(true);
                                return;
                            }
                        }
                        break block0;
                    }
                    case A_EXT_CONST: {
                        IType type = ((Def_ExternalConst)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break block0;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return;
                    }
                    case A_MODULEPAR: {
                        IType type = ((Def_ModulePar)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break block0;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return;
                    }
                    case A_VAR: {
                        IType type = ((Def_Var)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break block0;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return;
                    }
                    case A_FUNCTION_RVAL: {
                        IType type = ((Def_Function)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break block0;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return;
                    }
                    case A_EXT_FUNCTION_RVAL: {
                        IType type = ((Def_Extfunction)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break block0;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return;
                    }
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: 
                    case A_PAR_VAL_OUT: 
                    case A_PAR_VAL_INOUT: {
                        IType type = ((FormalParameter)assignment).getType(timestamp).getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (type == null) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if ((type = type.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
                            value.setIsErroneous(true);
                            return;
                        }
                        if (IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) break block0;
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'': Type mismatch: component reference was expected instead of `{1}''", operationName, type.getTypename()));
                        value.setIsErroneous(true);
                        return;
                    }
                    default: {
                        reference.getLocation().reportSemanticError(MessageFormat.format("The first operand of operation `{0}'' should be a component reference instead of `{1}''", operationName, assignment.getDescription()));
                        value.setIsErroneous(true);
                        return;
                    }
                }
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.componentBody != null) {
            this.componentBody.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.componentBody == null || this.componentBody.accept(v);
    }
}

