/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Invoke_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Function_Reference_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ApplyExpression;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SpecificValue_Template
extends TTCN3Template {
    private final IValue specificValue;
    private TTCN3Template realTemplate;

    public SpecificValue_Template(IValue specificValue) {
        this.specificValue = specificValue;
        if (specificValue != null) {
            specificValue.setFullNameParent(this);
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.SPECIFIC_VALUE;
    }

    @Override
    public Location getLocation() {
        return new Location(this.specificValue.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous specific value";
        }
        return "specific value";
    }

    @Override
    public String createStringRepresentation() {
        if (this.specificValue == null) {
            return "<erroneous template>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.specificValue.createStringRepresentation());
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    public IValue getSpecificValue() {
        return this.specificValue;
    }

    public Identifier getIdentifier() {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)this.specificValue.getValuetype())) {
            return ((Undefined_LowerIdentifier_Value)this.specificValue).getIdentifier();
        }
        return null;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.specificValue != null) {
            this.specificValue.setMyScope(scope);
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked != null && this.lastTimeChecked.equals(timestamp) && this.myGovernor != null) {
            return this.myGovernor;
        }
        if (this.specificValue != null) {
            this.specificValue.setMyGovernor(null);
            IValue temp = this.specificValue.setLoweridToReference(timestamp);
            return temp.getExpressionGovernor(timestamp, expectedValue);
        }
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp) || this.specificValue == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.specificValue.setLoweridToReference(timestamp);
        return this.specificValue.getExpressionReturntype(timestamp, expectedValue);
    }

    @Override
    public ITTCN3Template setLoweridToReference(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && this.lastTimeChecked.equals(timestamp)) {
            return this.realTemplate;
        }
        this.lastTimeChecked = timestamp;
        this.realTemplate = this;
        this.isErroneous = false;
        IValue temp = this.specificValue.setLoweridToReference(timestamp);
        if (IValue.Value_type.REFERENCED_VALUE.equals((Object)temp.getValuetype())) {
            Assignment assignment = ((Referenced_Value)temp).getReference().getRefdAssignment(timestamp, false);
            if (assignment != null) {
                switch (assignment.getAssignmentType()) {
                    case A_TEMPLATE: 
                    case A_VAR_TEMPLATE: 
                    case A_PAR_TEMP_IN: 
                    case A_PAR_TEMP_OUT: 
                    case A_PAR_TEMP_INOUT: 
                    case A_FUNCTION_RTEMP: 
                    case A_EXT_FUNCTION_RTEMP: {
                        this.realTemplate = this.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_REFD);
                        break;
                    }
                }
            } else {
                this.isErroneous = true;
            }
        }
        return this.realTemplate;
    }

    @Override
    public TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.realTemplate != null && this.realTemplate != this) {
            return this.realTemplate.getTemplateReferencedLast(timestamp, referenceChain);
        }
        return this;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        if (this.specificValue == null) {
            return;
        }
        switch (this.specificValue.getValuetype()) {
            case EXPRESSION_VALUE: {
                break;
            }
            case OMIT_VALUE: {
                if (!allowOmit) {
                    this.getLocation().reportSemanticError("A specific value was expected instead of omit value");
                }
                return;
            }
            default: {
                return;
            }
        }
        Expression_Value expressionValue = (Expression_Value)this.specificValue;
        if (!Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expressionValue.getOperationType())) {
            return;
        }
        expressionValue.setLoweridToReference(timestamp);
        IType type = ((ApplyExpression)expressionValue).getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type == null) {
            return;
        }
        if (IType.Type_type.TYPE_FUNCTION.equals((Object)(type = type.getTypeRefdLast(timestamp)).getTypetype()) && ((Function_Type)type).returnsTemplate()) {
            TTCN3Template template = this.setTemplatetype(timestamp, ITTCN3Template.Template_type.TEMPLATE_INVOKE);
            template.checkSpecificValue(timestamp, allowOmit);
        }
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        IValue value = this.getValue();
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        value = value.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        switch (value.getValuetype()) {
            case BITSTRING_VALUE: {
                if (!IType.Type_type.TYPE_BITSTRING.equals((Object)typeType)) break;
                this.lengthRestriction.checkNofElements(timestamp, ((Bitstring_Value)value).getValueLength(), false, false, false, this);
                break;
            }
            case HEXSTRING_VALUE: {
                if (!IType.Type_type.TYPE_HEXSTRING.equals((Object)typeType)) break;
                this.lengthRestriction.checkNofElements(timestamp, ((Hexstring_Value)value).getValueLength(), false, false, false, this);
                break;
            }
            case OCTETSTRING_VALUE: {
                if (!IType.Type_type.TYPE_OCTETSTRING.equals((Object)typeType)) break;
                this.lengthRestriction.checkNofElements(timestamp, ((Octetstring_Value)value).getValueLength(), false, false, false, this);
                break;
            }
            case CHARSTRING_VALUE: {
                if (IType.Type_type.TYPE_CHARSTRING.equals((Object)typeType)) {
                    this.lengthRestriction.checkNofElements(timestamp, ((Charstring_Value)value).getValueLength(), false, false, false, this);
                    break;
                }
                if (!IType.Type_type.TYPE_UCHARSTRING.equals((Object)typeType)) break;
                value = value.setValuetype(timestamp, IValue.Value_type.UNIVERSALCHARSTRING_VALUE);
                this.lengthRestriction.checkNofElements(timestamp, ((UniversalCharstring_Value)value).getValueLength(), false, false, false, this);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                if (!IType.Type_type.TYPE_UCHARSTRING.equals((Object)typeType)) break;
                this.lengthRestriction.checkNofElements(timestamp, ((UniversalCharstring_Value)value).getValueLength(), false, false, false, this);
                break;
            }
            case SEQUENCEOF_VALUE: {
                if (!IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)typeType)) break;
                this.lengthRestriction.checkNofElements(timestamp, ((SequenceOf_Value)value).getNofComponents(), false, false, false, this);
                break;
            }
            case SETOF_VALUE: {
                if (!IType.Type_type.TYPE_SET_OF.equals((Object)typeType)) break;
                this.lengthRestriction.checkNofElements(timestamp, ((SetOf_Value)value).getNofComponents(), false, false, false, this);
                break;
            }
            case OMIT_VALUE: {
                this.lengthRestriction.getLocation().reportSemanticError("Length restriction cannot be used with omit value");
                break;
            }
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.realTemplate != null && this.realTemplate != this && !this.realTemplate.getIsErroneous(timestamp)) {
            this.realTemplate.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (type == null) {
            return;
        }
        type.check(timestamp);
        if (this.specificValue != null) {
            this.specificValue.setMyGovernor(type);
            IValue temporalValue = type.checkThisValueRef(timestamp, this.specificValue);
            type.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_TEMPLATE, isModified, allowOmit, true, implicitOmit, false));
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            if (this.location != null && !(this.location instanceof NULL_Location)) {
                this.location.reportSemanticError("`ifpresent' is not allowed here");
            } else if (this.specificValue != null && !(this.specificValue.getLocation() instanceof NULL_Location)) {
                this.specificValue.getLocation().reportSemanticError("`ifpresent' is not allowed here");
            }
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        if (IValue.Value_type.FUNCTION_REFERENCE_VALUE.equals((Object)this.specificValue.getValuetype())) {
            IType governor = ((Function_Reference_Value)this.specificValue).getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (governor == null) {
                return true;
            }
            IType last = governor.getTypeRefdLast(timestamp);
            if (IType.Type_type.TYPE_FUNCTION.equals((Object)last.getTypetype()) && ((Function_Type)last).returnsTemplate()) {
                return false;
            }
        } else if (IValue.Value_type.REFERENCED_VALUE.equals((Object)this.specificValue.getValuetype())) {
            Reference reference = this.getReference();
            Assignment assignment = reference.getRefdAssignment(timestamp, true);
            if (assignment == null) {
                return true;
            }
            switch (assignment.getAssignmentType()) {
                case A_CONST: 
                case A_EXT_CONST: 
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: 
                case A_VAR: 
                case A_FUNCTION_RVAL: 
                case A_EXT_FUNCTION_RVAL: 
                case A_MODULEPAR: {
                    return true;
                }
                case A_TEMPLATE: 
                case A_VAR_TEMPLATE: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_INOUT: 
                case A_FUNCTION_RTEMP: {
                    TTCN3Template ttemplate;
                    boolean result = true;
                    TemplateRestriction.Restriction_type rt = ((Definition)assignment).getTemplateRestriction();
                    if (TemplateRestriction.Restriction_type.TR_OMIT.equals((Object)rt) || TemplateRestriction.Restriction_type.TR_PRESENT.equals((Object)rt)) {
                        result = false;
                    }
                    if (!(ttemplate = this.getTemplateReferencedLast(timestamp)).equals(this) && ttemplate.isValue(timestamp)) {
                        return result;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        return this.specificValue;
    }

    public boolean isReference() {
        if (this.lengthRestriction != null || this.isIfpresent || this.specificValue == null) {
            return false;
        }
        switch (this.specificValue.getValuetype()) {
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                return true;
            }
            case REFERENCED_VALUE: {
                return ((Referenced_Value)this.specificValue).getReference() != null;
            }
        }
        return false;
    }

    public Reference getReference() {
        if (this.lengthRestriction != null || this.isIfpresent || this.specificValue == null) {
            return null;
        }
        switch (this.specificValue.getValuetype()) {
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                return ((Undefined_LowerIdentifier_Value)this.specificValue).getAsReference();
            }
            case REFERENCED_VALUE: {
                return ((Referenced_Value)this.specificValue).getReference();
            }
        }
        return null;
    }

    @Override
    public TTCN3Template setTemplatetype(CompilationTimeStamp timestamp, ITTCN3Template.Template_type newType) {
        this.lastTimeChecked = timestamp;
        switch (newType) {
            case TEMPLATE_REFD: {
                this.realTemplate = new Referenced_Template(timestamp, this);
                break;
            }
            case TEMPLATE_INVOKE: {
                this.realTemplate = new Invoke_Template(timestamp, this);
                break;
            }
            default: {
                this.realTemplate = super.setTemplatetype(timestamp, newType);
            }
        }
        return this.realTemplate;
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        if (this.specificValue instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.specificValue)).updateSyntax(reparser, false);
            reparser.updateLocation(this.specificValue.getLocation());
        } else if (this.specificValue != null) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.specificValue == null) {
            return;
        }
        this.specificValue.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.specificValue == null || this.specificValue.accept(v);
    }
}

