/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class CharString_Pattern_Template
extends TTCN3Template {
    private PatternString patternstring;

    public CharString_Pattern_Template() {
        this.patternstring = new PatternString(PatternString.PatternType.CHARSTRING_PATTERN);
    }

    public CharString_Pattern_Template(PatternString ps) {
        this.patternstring = ps;
    }

    public PatternString getPatternstring() {
        return this.patternstring;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.CSTR_PATTERN;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous character string pattern";
        }
        return "character string pattern";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("pattern \"");
        builder.append(this.patternstring.getFullString());
        builder.append('\"');
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    public boolean patternContainsAnyornoneSymbol() {
        return true;
    }

    public int getMinLengthOfPattern() {
        return 0;
    }

    @Override
    public TTCN3Template setTemplatetype(CompilationTimeStamp timestamp, ITTCN3Template.Template_type newType) {
        TTCN3Template realTemplate;
        switch (newType) {
            case USTR_PATTERN: {
                realTemplate = new UnivCharString_Pattern_Template(this.patternstring);
                realTemplate.copyGeneralProperties(this);
                break;
            }
            default: {
                realTemplate = super.setTemplatetype(timestamp, newType);
            }
        }
        return realTemplate;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return IType.Type_type.TYPE_CHARSTRING;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an charstring pattern");
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_CHARSTRING.equals((Object)typeType) || IType.Type_type.TYPE_UCHARSTRING.equals((Object)typeType)) {
            boolean hasAnyOrNone = this.patternContainsAnyornoneSymbol();
            this.lengthRestriction.checkNofElements(timestamp, this.getMinLengthOfPattern(), hasAnyOrNone, false, hasAnyOrNone, this);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.patternstring != null) {
            this.patternstring.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.patternstring == null || this.patternstring.accept(v);
    }
}

