/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateBody;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class AllElementsFrom
extends TemplateBody {
    private static final String SPECIFICVALUEEXPECTED = "After all from a specific value is expected";
    private static final String LISTEXPECTED = "After all from a variable or a template of list type is expected";
    private static final String TYPEMISMATCH = "Type mismatch: `{0}'' was expected in the list";
    private static final String REFERENCEEXPECTED = "Reference to a value was expected";
    private static final String ANYOROMITANDPERMUTATIONPRHOHIBITED = "`all from' can not refer to a template containing permutation or AnyElementsOrNone";
    private IType myGovernor;

    public AllElementsFrom() {
    }

    public AllElementsFrom(TTCN3Template t) {
        this.template = t;
    }

    @Override
    public IType getMyGovernor() {
        return this.myGovernor;
    }

    @Override
    public void setMyGovernor(IType governor) {
        this.myGovernor = governor;
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        if (this.template == null) {
            ErrorReporter.INTERNAL_ERROR();
            return;
        }
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)this.template.getTemplatetype())) {
            this.template.getLocation().reportSemanticError(SPECIFICVALUEEXPECTED);
            this.template.setIsErroneous(true);
            return;
        }
        if (!((SpecificValue_Template)this.template).isReference()) {
            this.template.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.template.setIsErroneous(true);
            return;
        }
        Reference reference = ((SpecificValue_Template)this.template).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.template.getLocation().reportSemanticError("Assignment not found");
            this.template.setIsErroneous(true);
            return;
        }
        IType assType = assignment.getType(timestamp);
        if (assType != null) {
            IType atype = assType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
            if (atype == null) {
                this.template.setIsErroneous(true);
                return;
            }
            IType referredType = atype.getTypeRefdLast(timestamp);
            IType it = null;
            if (referredType != null) {
                switch (referredType.getTypetype()) {
                    case TYPE_SEQUENCE_OF: {
                        it = ((SequenceOf_Type)referredType).getOfType();
                        break;
                    }
                    case TYPE_SET_OF: {
                        it = ((SetOf_Type)referredType).getOfType();
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: {
                        break;
                    }
                    default: {
                        this.template.getLocation().reportSemanticError(LISTEXPECTED);
                        this.template.setIsErroneous(true);
                    }
                }
            }
            if (it != null && !it.isCompatible(timestamp, type, null, null, null)) {
                this.template.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH, type.getTypename()));
                this.template.setIsErroneous(true);
            }
        }
        ITTCN3Template body = null;
        Value value = null;
        switch (assignment.getAssignmentType()) {
            case A_TEMPLATE: {
                body = ((Def_Template)assignment).getTemplate(timestamp);
                break;
            }
            case A_VAR_TEMPLATE: {
                body = ((Def_Var_Template)assignment).getInitialValue();
                break;
            }
            case A_CONST: {
                break;
            }
            case A_MODULEPAR: {
                value = ((Def_ModulePar)assignment).getDefaultValue();
                break;
            }
            case A_MODULEPAR_TEMPLATE: {
                body = ((Def_ModulePar_Template)assignment).getDefaultTemplate();
                break;
            }
            case A_VAR: {
                value = ((Def_Var)assignment).getInitialValue();
                break;
            }
            default: {
                return;
            }
        }
        if (body != null) {
            switch (body.getTemplatetype()) {
                case TEMPLATE_LIST: {
                    if (allowAnyOrOmit || !((Template_List)body).containsAnyornoneOrPermutation()) break;
                    this.template.getLocation().reportSemanticError(ANYOROMITANDPERMUTATIONPRHOHIBITED);
                    this.template.setIsErroneous(true);
                    break;
                }
                case NAMED_TEMPLATE_LIST: {
                    ((Named_Template_List)body).checkSpecificValue(timestamp, true);
                    break;
                }
                case SPECIFIC_VALUE: {
                    break;
                }
                default: {
                    this.template.getLocation().reportSemanticError(LISTEXPECTED);
                    this.template.setIsErroneous(true);
                    return;
                }
            }
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.ALLELEMENTSFROM;
    }

    @Override
    public String getTemplateTypeName() {
        return "all from ".concat(this.template.getTemplateTypeName());
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        return false;
    }

    private int getNofValues(IValue value, CompilationTimeStamp timestamp) {
        int result = 0;
        if (value == null) {
            return result;
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue lastValue = value.getValueRefdLast(timestamp, chain);
        chain.release();
        if (lastValue.getIsErroneous(timestamp)) {
            return result;
        }
        if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)lastValue.getValuetype())) {
            SequenceOf_Value lvalue = (SequenceOf_Value)lastValue;
            result = lvalue.getNofComponents();
            return result;
        }
        if (IValue.Value_type.SETOF_VALUE.equals((Object)lastValue.getValuetype())) {
            SetOf_Value svalue = (SetOf_Value)lastValue;
            result = svalue.getNofComponents();
            return result;
        }
        return 1;
    }

    public int getNofTemplatesNotAnyornone(CompilationTimeStamp timestamp) {
        int result = 0;
        if (this.template == null) {
            ErrorReporter.INTERNAL_ERROR();
            return result;
        }
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)this.template.getTemplatetype())) {
            this.template.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.template.setIsErroneous(true);
            return result;
        }
        if (!((SpecificValue_Template)this.template).isReference()) {
            this.template.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.template.setIsErroneous(true);
            return result;
        }
        Reference reference = ((SpecificValue_Template)this.template).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.template.getLocation().reportSemanticError("Assignment not found");
            this.template.setIsErroneous(true);
            return result;
        }
        ITTCN3Template body = null;
        switch (assignment.getAssignmentType()) {
            case A_TEMPLATE: {
                body = ((Def_Template)assignment).getTemplate(timestamp);
                break;
            }
            case A_VAR_TEMPLATE: {
                body = ((Def_Var_Template)assignment).getInitialValue();
                break;
            }
            case A_CONST: {
                IValue value = ((Def_Const)assignment).getValue();
                return this.getNofValues(value, timestamp);
            }
            case A_MODULEPAR: {
                Value mvalue = ((Def_ModulePar)assignment).getDefaultValue();
                return this.getNofValues(mvalue, timestamp);
            }
            case A_MODULEPAR_TEMPLATE: {
                body = ((Def_ModulePar_Template)assignment).getDefaultTemplate();
                break;
            }
            default: {
                return result;
            }
        }
        if (body == null) {
            ErrorReporter.INTERNAL_ERROR();
            return result;
        }
        if (!ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)body.getTemplatetype())) {
            this.template.getLocation().reportSemanticError("Template must be a record of or a set of values");
            this.template.setIsErroneous(true);
            return result;
        }
        result = ((Template_List)body).getNofTemplatesNotAnyornone(timestamp);
        return result;
    }
}

