/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Redirect;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Getreply_Statement
extends Statement {
    private static final String SIGNATUREEXPECTED = "The type of parameter is `{0}'', which is not a signature";
    private static final String VALUEREDIRECTWITHOUTRETURNTYPE = "Value redirect cannot be used because signature `{0}'' does not have return type";
    private static final String VALUEMATCHWITHOUTRETURNTYPE = "Value match cannot be used becuse signature `{0}'' does not have return type";
    private static final String NONBLOCKINGSIGNATURE = "Operation `{0}'' is not applicable to non-blocking signature `{1}''";
    private static final String ANYPORTWITHPARAMETERREDIRECTION = "Operation `any port.{0}'' cannot have parameter redirection";
    private static final String ANYPORTWITHVALUEREDIRECTION = "Operation `any port.{0}'' cannot have value redirection";
    private static final String ANYPORTWITHVALUEMATCH = "Operation `any port.{0}'' cannot have value match";
    private static final String ANYPORTWITHPARAMETER = "Operation `any port.{0}'' cannot have parameter";
    private static final String SIGNATUREMISSING = "Signature `{0}'' is not present on the outgoing list of port type `{1}''";
    private static final String UNKNOWNSIGNATURETYPE = "Cannot determine the type of the signature";
    private static final String PARAMETERREDIRECTWITHOUTSIGNATURE = "Parameter redirect cannot be used without signature template";
    private static final String VALUEREDIRECTWITHOUTSIGNATURE = "Value redirect cannot be used without signature template";
    private static final String GETREPLYNOTSUPPORTEDONPORT = "Port type `{0}'' does not have any outgoing signatures that support reply";
    private static final String GETREPLYONMESSAGEPORT = "Procedure-based operation `{0}'' is not applicable to a message-based port of type `{1}''";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".parameter";
    private static final String FULLNAMEPART3 = ".valuematch";
    private static final String FULLNAMEPART4 = ".from";
    private static final String FULLNAMEPART5 = ".redirecvalue";
    private static final String FULLNAMEPART6 = ".parameters";
    private static final String FULLNAMEPART7 = ".redirectSender";
    private static final String STATEMENT_NAME = "getreply";
    private final Reference portReference;
    private final TemplateInstance parameter;
    private final TemplateInstance valueMatch;
    private final TemplateInstance fromClause;
    private final Reference redirectValue;
    private final Parameter_Redirect redirectParameter;
    private final Reference redirectSender;

    public Getreply_Statement(Reference portReference, TemplateInstance parameter, TemplateInstance valueMatch, TemplateInstance fromClause, Reference redirectValue, Parameter_Redirect redirectParameter, Reference redirectSender) {
        this.portReference = portReference;
        this.parameter = parameter;
        this.valueMatch = valueMatch;
        this.fromClause = fromClause;
        this.redirectValue = redirectValue;
        this.redirectParameter = redirectParameter;
        this.redirectSender = redirectSender;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (valueMatch != null) {
            valueMatch.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectParameter != null) {
            redirectParameter.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_GETREPLY;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    public Reference getPortReference() {
        return this.portReference;
    }

    public TemplateInstance getReceiveParameter() {
        return this.parameter;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.valueMatch == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.redirectParameter == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART7);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.valueMatch != null) {
            this.valueMatch.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Getreply_Statement.checkGetreply(timestamp, this, STATEMENT_NAME, this.portReference, this.parameter, this.valueMatch, this.fromClause, this.redirectValue, this.redirectParameter, this.redirectSender);
        if (this.redirectValue != null) {
            this.redirectValue.setUsedOnLeftHandSide();
        }
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    public static void checkGetreply(CompilationTimeStamp timestamp, Statement source, String statementName, Reference portReference, TemplateInstance parameter, TemplateInstance valueMatch, TemplateInstance fromClause, Reference redirectValue, Parameter_Redirect redirectParameter, Reference redirectSender) {
        Port_Type portType = Port_Utility.checkPortReference(timestamp, source, portReference);
        if (parameter == null) {
            PortTypeBody body;
            if (portType != null && !(body = portType.getPortBody()).getreplyAllowed(timestamp)) {
                if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(GETREPLYONMESSAGEPORT, statementName, portType.getTypename()));
                } else {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(GETREPLYNOTSUPPORTEDONPORT, portType.getTypename()));
                }
            }
            if (redirectValue != null) {
                redirectValue.getLocation().reportSemanticError(VALUEREDIRECTWITHOUTSIGNATURE);
                Port_Utility.checkValueRedirect(timestamp, redirectValue, null);
            }
            if (redirectParameter != null) {
                redirectParameter.getLocation().reportSemanticError(PARAMETERREDIRECTWITHOUTSIGNATURE);
            }
        } else {
            IType signature = null;
            boolean signatureDetermined = false;
            if (portType != null) {
                PortTypeBody body = portType.getPortBody();
                if (PortTypeBody.OperationModes.OP_Message.equals((Object)body.getOperationMode())) {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(GETREPLYONMESSAGEPORT, statementName, portType.getTypename()));
                } else if (body.getreplyAllowed(timestamp)) {
                    TypeSet outSignatures = body.getOutSignatures();
                    if (outSignatures.getNofTypes() == 1) {
                        signature = outSignatures.getTypeByIndex(0);
                    } else {
                        signature = Port_Utility.getOutgoingType(timestamp, parameter);
                        if (signature == null) {
                            parameter.getLocation().reportSemanticError(UNKNOWNSIGNATURETYPE);
                        } else if (!outSignatures.hasType(timestamp, signature)) {
                            parameter.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREMISSING, signature.getTypename(), portType.getTypename()));
                        }
                    }
                    signatureDetermined = true;
                } else {
                    portReference.getLocation().reportSemanticError(MessageFormat.format(GETREPLYNOTSUPPORTEDONPORT, portType.getTypename()));
                }
            } else if (portReference == null) {
                parameter.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHPARAMETER, statementName));
                if (valueMatch != null) {
                    valueMatch.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHVALUEMATCH, statementName));
                }
                if (redirectValue != null) {
                    redirectValue.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHVALUEREDIRECTION, statementName));
                }
                if (redirectParameter != null) {
                    redirectParameter.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHPARAMETERREDIRECTION, statementName));
                }
            }
            if (!signatureDetermined) {
                signature = Port_Utility.getOutgoingType(timestamp, parameter);
            }
            if (signature != null) {
                parameter.check(timestamp, signature);
                signature = signature.getTypeRefdLast(timestamp);
                Type returnType = null;
                switch (signature.getTypetype()) {
                    case TYPE_SIGNATURE: {
                        String message;
                        Signature_Type signatureType = (Signature_Type)signature;
                        if (signatureType.isNonblocking()) {
                            message = MessageFormat.format(NONBLOCKINGSIGNATURE, statementName, signatureType.getTypename());
                            source.getLocation().reportSemanticError(message);
                        } else {
                            returnType = signatureType.getSignatureReturnType();
                        }
                        if (redirectParameter != null) {
                            redirectParameter.check(timestamp, signatureType, true);
                        }
                        if (returnType != null) break;
                        if (valueMatch != null) {
                            valueMatch.getLocation().reportSemanticError(MessageFormat.format(VALUEMATCHWITHOUTRETURNTYPE, signature.getTypename()));
                        }
                        if (redirectValue == null) break;
                        message = MessageFormat.format(VALUEREDIRECTWITHOUTRETURNTYPE, signature.getTypename());
                        redirectValue.getLocation().reportSemanticError(message);
                        break;
                    }
                    default: {
                        parameter.getLocation().reportSemanticError(MessageFormat.format(SIGNATUREEXPECTED, signature.getTypename()));
                        if (redirectParameter == null) break;
                        redirectParameter.checkErroneous(timestamp);
                    }
                }
                if (valueMatch != null && returnType != null) {
                    valueMatch.check(timestamp, returnType);
                }
                Port_Utility.checkValueRedirect(timestamp, redirectValue, returnType);
            }
        }
        Port_Utility.checkFromClause(timestamp, source, portType, fromClause, redirectSender);
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(129);
        if (this.redirectParameter != null) {
            return result;
        }
        result.add(105);
        if (this.redirectValue != null) {
            return result;
        }
        result.add(219);
        if (this.fromClause != null) {
            return result;
        }
        result.add(54);
        if (this.parameter != null) {
            return result;
        }
        result.add(251);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.valueMatch != null) {
            this.valueMatch.updateSyntax(reparser, false);
            reparser.updateLocation(this.valueMatch.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectParameter.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.valueMatch != null) {
            this.valueMatch.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.valueMatch != null && !this.valueMatch.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        if (this.redirectParameter != null && !this.redirectParameter.accept(v)) {
            return false;
        }
        return this.redirectSender == null || this.redirectSender.accept(v);
    }
}

