/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Clear_Statement
extends Statement {
    private static final String QUEUELESSPORT = "Port type `{0}'' does not have incoming queue because it has neither incoming messages nor incoming or outgoing signatures";
    private static final String FULLNAMEPART = ".portreference";
    private static final String STATEMENT_NAME = "clear";
    private final Reference portReference;

    public Clear_Statement(Reference portReference) {
        this.portReference = portReference;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CLEAR_PORT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Type portType = Port_Utility.checkPortReference(timestamp, this, this.portReference);
        if (portType != null && !portType.getPortBody().hasQueue(timestamp)) {
            this.portReference.getLocation().reportSemanticError(MessageFormat.format(QUEUELESSPORT, portType.getTypename()));
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.portReference == null || this.portReference.accept(v);
    }
}

