/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3;

import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class TemplateRestriction {
    private TemplateRestriction() {
    }

    public static Restriction_type getSubRestriction(Restriction_type tr, CompilationTimeStamp timestamp, Reference ref) {
        IType type;
        if (ref == null || ref.getSubreferences() == null) {
            return tr;
        }
        boolean isOptional = true;
        Assignment ass = ref.getRefdAssignment(timestamp, false, null);
        if (ass != null && (type = ass.getType(timestamp)) != null && (type = type.getFieldType(timestamp, ref, 1, Expected_Value_type.EXPECTED_TEMPLATE, true)) != null) {
            isOptional = false;
        }
        switch (tr) {
            case TR_NONE: {
                return Restriction_type.TR_NONE;
            }
            case TR_OMIT: {
                return Restriction_type.TR_OMIT;
            }
            case TR_VALUE: {
                return isOptional ? Restriction_type.TR_OMIT : Restriction_type.TR_VALUE;
            }
            case TR_PRESENT: {
                return isOptional ? Restriction_type.TR_NONE : Restriction_type.TR_PRESENT;
            }
        }
        return tr;
    }

    public static boolean isLessRestrictive(Restriction_type neededTemplateRestriction, Restriction_type refdTemplateRestriction) {
        switch (neededTemplateRestriction) {
            case TR_NONE: {
                return false;
            }
            case TR_VALUE: {
                return refdTemplateRestriction != Restriction_type.TR_VALUE;
            }
            case TR_OMIT: {
                return refdTemplateRestriction != Restriction_type.TR_VALUE && refdTemplateRestriction != Restriction_type.TR_OMIT;
            }
            case TR_PRESENT: {
                return refdTemplateRestriction != Restriction_type.TR_VALUE && refdTemplateRestriction != Restriction_type.TR_PRESENT;
            }
        }
        return true;
    }

    public static boolean check(CompilationTimeStamp timestamp, Definition definition, ITTCN3Template template, Reference ref) {
        if (template.getIsErroneous(timestamp)) {
            return false;
        }
        Restriction_type tr = definition.getTemplateRestriction();
        tr = TemplateRestriction.getSubRestriction(tr, timestamp, ref);
        switch (tr) {
            case TR_NONE: {
                return false;
            }
            case TR_VALUE: {
                return template.checkValueomitRestriction(timestamp, definition.getAssignmentName(), false, template.getLocation());
            }
            case TR_OMIT: {
                return template.checkValueomitRestriction(timestamp, definition.getAssignmentName(), true, template.getLocation());
            }
            case TR_PRESENT: {
                return template.checkPresentRestriction(timestamp, definition.getAssignmentName(), template.getLocation());
            }
        }
        return false;
    }

    public static enum Restriction_type {
        TR_NONE(""),
        TR_OMIT("omit"),
        TR_VALUE("value"),
        TR_PRESENT("present");

        private final String name;

        private Restriction_type(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

