/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.Location;

public final class CachedReferenceChain
implements IReferenceChain {
    private final List<IReferenceChainElement> chainLinks = new ArrayList<IReferenceChainElement>();
    private final Stack<Integer> markedStates = new Stack();
    private String message;
    private boolean isError;
    private List<List<IReferenceChainElement>> safeCopy = new ArrayList<List<IReferenceChainElement>>();
    private Stack<Integer> errorStates = new Stack();

    public CachedReferenceChain(String message, boolean isError) {
        this.message = message;
        this.isError = isError;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean add(IReferenceChainElement chainLink) {
        int index = this.chainLinks.indexOf(chainLink);
        this.chainLinks.add(chainLink);
        if (index >= 0) {
            this.safeCopy.add(new ArrayList<IReferenceChainElement>(this.chainLinks));
            return false;
        }
        return true;
    }

    public void reportAllTheErrors() {
        int i;
        if (null == this.safeCopy || this.safeCopy.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int n = i = this.errorStates.empty() ? 0 : this.errorStates.peek();
        while (i < this.safeCopy.size()) {
            List<IReferenceChainElement> current = this.safeCopy.get(i);
            for (int j = 0; j < current.size(); ++j) {
                int i2;
                builder.setLength(0);
                for (i2 = j; i2 < current.size(); ++i2) {
                    if (builder.length() != 0) {
                        builder.append(" -> ");
                    }
                    builder.append(current.get(i2).chainedDescription());
                }
                for (i2 = 0; i2 < j; ++i2) {
                    if (builder.length() != 0) {
                        builder.append(" -> ");
                    }
                    builder.append(current.get(i2).chainedDescription());
                }
                Location location = current.get(j).getChainLocation();
                if (location == null) continue;
                if (this.isError) {
                    location.reportSingularSemanticError(MessageFormat.format(this.message, builder.toString()));
                    continue;
                }
                location.reportSingularSemanticWarning(MessageFormat.format(this.message, builder.toString()));
            }
            ++i;
        }
    }

    @Override
    public void markState() {
        this.markedStates.add(this.chainLinks.size());
    }

    @Override
    public void previousState() {
        if (this.markedStates.isEmpty()) {
            return;
        }
        int markedLimit = (Integer)this.markedStates.get(this.markedStates.size() - 1);
        for (int i = this.chainLinks.size() - 1; i >= markedLimit; --i) {
            this.chainLinks.remove(i);
        }
        this.markedStates.remove(this.markedStates.size() - 1);
    }

    public void markErrorState() {
        this.errorStates.push(this.safeCopy.size());
    }

    public void prevErrorState() {
        if (this.errorStates.empty() || this.errorStates.peek() > this.safeCopy.size()) {
            return;
        }
        int markedLimit = (Integer)this.errorStates.get(this.errorStates.size() - 1);
        for (int i = this.safeCopy.size() - 1; i >= markedLimit; --i) {
            this.safeCopy.remove(i);
        }
        this.errorStates.pop();
    }

    public int getNofErrors() {
        return this.safeCopy.size() - this.errorStates.peek();
    }
}

