/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.definitions;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignments;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.AST.ASN1.definitions.Exports;
import org.eclipse.titan.designer.AST.ASN1.definitions.Imports;
import org.eclipse.titan.designer.AST.ASN1.definitions.Tag_types;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.asn1parser.ASN1Listener;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Lexer;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.ModuleLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokensFactory;

public final class SpecialASN1Module {
    public static final String INTERNAL_MODULE = "<internal_module>";
    public static final String PARSINGFAILED = "Parsing failed for internal ASN.1 module";
    public static final String PARSINGFAILEDWITHREASON = "Parsing failed for internal ASN.1 module with: `{1}''";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String EXTERNAL_ASSIGNMENT = " [UNIVERSAL 8] IMPLICIT SEQUENCE {" + NEWLINE + "  identification CHOICE {" + NEWLINE + "    syntaxes SEQUENCE {" + NEWLINE + "      abstract OBJECT IDENTIFIER, " + NEWLINE + "      transfer OBJECT IDENTIFIER " + NEWLINE + "    }, " + NEWLINE + "    syntax OBJECT IDENTIFIER, " + NEWLINE + "    presentation-context-id INTEGER, " + NEWLINE + "    context-negotiation SEQUENCE {" + NEWLINE + "      presentation-context-id INTEGER, " + NEWLINE + "      transfer-syntax OBJECT IDENTIFIER " + NEWLINE + "    }, " + NEWLINE + "    transfer-syntax OBJECT IDENTIFIER, " + NEWLINE + "    fixed NULL " + NEWLINE + "  }, " + NEWLINE + "  data-value-descriptor ObjectDescriptor OPTIONAL, " + NEWLINE + "  data-value OCTET STRING " + NEWLINE + "} (WITH COMPONENTS {" + NEWLINE + "  ..., " + NEWLINE + "  identification (WITH COMPONENTS {" + NEWLINE + "    ..., " + NEWLINE + "    syntaxes        ABSENT, " + NEWLINE + "    transfer-syntax ABSENT, " + NEWLINE + "    fixed           ABSENT " + NEWLINE + "  }) " + NEWLINE + "})";
    private static final String EMBEDDED_PDV_ASSIGNMENT = "[UNIVERSAL 11] IMPLICIT SEQUENCE {" + NEWLINE + "  identification CHOICE {" + NEWLINE + "    syntaxes SEQUENCE {" + NEWLINE + "      abstract OBJECT IDENTIFIER, " + NEWLINE + "      transfer OBJECT IDENTIFIER " + NEWLINE + "    }, " + NEWLINE + "    syntax OBJECT IDENTIFIER, " + NEWLINE + "    presentation-context-id INTEGER, " + NEWLINE + "    context-negotiation SEQUENCE {" + NEWLINE + "      presentation-context-id INTEGER, " + NEWLINE + "      transfer-syntax OBJECT IDENTIFIER " + NEWLINE + "    }, " + NEWLINE + "    transfer-syntax OBJECT IDENTIFIER, " + NEWLINE + "    fixed NULL " + NEWLINE + "  }, " + NEWLINE + "  data-value-descriptor ObjectDescriptor OPTIONAL, " + NEWLINE + "  data-value OCTET STRING " + NEWLINE + "} (WITH COMPONENTS {" + NEWLINE + "  ..., " + NEWLINE + "  data-value-descriptor ABSENT " + NEWLINE + "})";
    private static final String CHARACTER_STRING_ASSIGNMENT = "[UNIVERSAL 29] IMPLICIT SEQUENCE {" + NEWLINE + "  identification CHOICE {" + NEWLINE + "    syntaxes SEQUENCE {" + NEWLINE + "      abstract OBJECT IDENTIFIER, " + NEWLINE + "      transfer OBJECT IDENTIFIER " + NEWLINE + "    }, " + NEWLINE + "    syntax OBJECT IDENTIFIER, " + NEWLINE + "    presentation-context-id INTEGER, " + NEWLINE + "    context-negotiation SEQUENCE {" + NEWLINE + "      presentation-context-id INTEGER, " + NEWLINE + "      transfer-syntax OBJECT IDENTIFIER " + NEWLINE + "    }, " + NEWLINE + "    transfer-syntax OBJECT IDENTIFIER, " + NEWLINE + "    fixed NULL " + NEWLINE + "  }, " + NEWLINE + "  data-value-descriptor ObjectDescriptor OPTIONAL, " + NEWLINE + "  string-value OCTET STRING " + NEWLINE + "} (WITH COMPONENTS {" + NEWLINE + "  ..., " + NEWLINE + "  data-value-descriptor ABSENT " + NEWLINE + "})";
    private static final String REAL_ASSIGNMENT = "[UNIVERSAL 9] IMPLICIT SEQUENCE {" + NEWLINE + "  mantissa INTEGER, " + NEWLINE + "  base INTEGER (2|10), " + NEWLINE + "  exponent INTEGER " + NEWLINE + "}";
    private static final String TYPE_IDENTIFIER_ASSIGNMENT = "CLASS " + NEWLINE + "{" + NEWLINE + "  &id OBJECT IDENTIFIER UNIQUE, " + NEWLINE + "  &Type " + NEWLINE + "} " + NEWLINE + "WITH SYNTAX {" + NEWLINE + "  &Type IDENTIFIED BY &id " + NEWLINE + "}";
    private static final String ABSTRACT_SYNTAX_ASSIGNMENT = "CLASS {" + NEWLINE + "  &id OBJECT IDENTIFIER UNIQUE, " + NEWLINE + "  &Type, " + NEWLINE + "  &property BIT STRING {handles-invalid-encodings(0)} DEFAULT {} " + NEWLINE + "} " + NEWLINE + "WITH SYNTAX {" + NEWLINE + "  &Type IDENTIFIED BY &id [HAS PROPERTY &property] " + NEWLINE + "}";
    private static final String[][] INTERNAL_ASSIGNMENTS = new String[][]{{"EXTERNAL", EXTERNAL_ASSIGNMENT}, {"EMBEDDED PDV", EMBEDDED_PDV_ASSIGNMENT}, {"CHARACTER STRING", CHARACTER_STRING_ASSIGNMENT}, {"REAL", REAL_ASSIGNMENT}, {"TYPE-IDENTIFIER", TYPE_IDENTIFIER_ASSIGNMENT}, {"ABSTRACT-SYNTAX", ABSTRACT_SYNTAX_ASSIGNMENT}};
    private static ASN1Module specialAssignmentsModule = SpecialASN1Module.createSpecAsss();

    protected SpecialASN1Module() {
    }

    public static ASN1Module getSpecialModule() {
        return specialAssignmentsModule;
    }

    private static ASN1Module createSpecAsss() {
        if (null != specialAssignmentsModule) {
            return specialAssignmentsModule;
        }
        ASN1Assignments parsedAssignments = new ASN1Assignments();
        for (String[] assignment : INTERNAL_ASSIGNMENTS) {
            ASN1Assignment actualAssignment = SpecialASN1Module.parseSpecialInternalAssignment(assignment[1], new Identifier(Identifier.Identifier_type.ID_ASN, assignment[0]));
            parsedAssignments.addAssignment(actualAssignment);
        }
        specialAssignmentsModule = new ASN1Module(new Identifier(Identifier.Identifier_type.ID_ASN, INTERNAL_MODULE), null, Tag_types.AUTOMATIC_TAGS, false);
        specialAssignmentsModule.setExports(new Exports(true));
        specialAssignmentsModule.setImports(new Imports());
        specialAssignmentsModule.setAssignments(parsedAssignments);
        specialAssignmentsModule.setLocation(NULL_Location.INSTANCE);
        specialAssignmentsModule.setScopeName(INTERNAL_MODULE);
        CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
        ModuleImportationChain referenceChain = new ModuleImportationChain("Circular reference chain: `{0}''", false);
        specialAssignmentsModule.checkImports(timestamp, referenceChain, new ArrayList<Module>());
        specialAssignmentsModule.check(timestamp);
        return specialAssignmentsModule;
    }

    public static void preLoad() {
        SpecialASN1Module.createSpecAsss();
    }

    public static boolean isSpecAsss(Module module) {
        return null != specialAssignmentsModule && !specialAssignmentsModule.equals(module);
    }

    public static ASN1Assignment parseSpecialInternalAssignment(String inputCode, Identifier identifier) {
        ASN1Assignment assignment = null;
        StringReader reader = new StringReader(inputCode);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Asn1Lexer lexer = new Asn1Lexer((CharStream)charStream);
        lexer.setTokenFactory(new TokenWithIndexAndSubTokensFactory(true));
        ASN1Listener lexerListener = new ASN1Listener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)lexerListener);
        ModuleLevelTokenStreamTracker tracker = new ModuleLevelTokenStreamTracker((TokenSource)lexer);
        tracker.discard(2);
        tracker.discard(98);
        tracker.discard(97);
        Asn1Parser parser = new Asn1Parser((TokenStream)tracker);
        parser.setBuildParseTree(false);
        ASN1Listener parserListener = new ASN1Listener(parser);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        assignment = parser.pr_TITAN_special_Assignment((Identifier)identifier).assignment;
        if (!parser.getErrorStorage().isEmpty()) {
            ErrorReporter.INTERNAL_ERROR((String)PARSINGFAILED);
            for (SyntacticErrorStorage temp : parser.getErrorStorage()) {
                ErrorReporter.logError((String)temp.message);
            }
        }
        return assignment;
    }
}

