/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.layouts;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.gui.layouts.algorithms.HierarcicalLayoutAlgorithm;
import org.eclipse.titanium.metrics.IMetricEnum;

public abstract class BaseHierarchicalLayout<V, E>
implements Layout<V, E> {
    private static final Double INNER_NODE_POSITION_RATIO_Y = 0.5;
    private static final Double INNER_NODE_POSITION_RATIO_X = 0.5;
    public static final String MAX_DISTANCE_ALGORITHM = "MAX";
    public static final String SUM_DISTANCE_ALGORITHM = "SUM";
    protected Graph<V, E> graph;
    protected HierarcicalLayoutAlgorithm<V> alg;
    protected Map<V, Point2D> places;
    protected Dimension size;
    protected final String distanceAlgorithm;
    protected IMetricEnum chosenMetric = null;
    protected final GUIErrorHandler errorHandler = new GUIErrorHandler();
    protected final Comparator<V> nodeComparator = new Comparator<V>(){

        @Override
        public int compare(V v1, V v2) {
            return Integer.signum(BaseHierarchicalLayout.this.getNeighbours(v2).size() - BaseHierarchicalLayout.this.getNeighbours(v1).size());
        }
    };

    public BaseHierarchicalLayout(Graph<V, E> g, Dimension size) {
        this.graph = g;
        this.places = new HashMap<V, Point2D>();
        this.size = size;
        this.distanceAlgorithm = Activator.getDefault().getPreferenceStore().getString("Graph_Layout_DAG_Distance");
        this.initAlg();
        this.initialize();
    }

    public BaseHierarchicalLayout(Graph<V, E> g, Dimension size, IMetricEnum metric) {
        this.chosenMetric = metric;
        this.graph = g;
        this.places = new HashMap<V, Point2D>();
        this.size = size;
        this.distanceAlgorithm = Activator.getDefault().getPreferenceStore().getString("Graph_Layout_DAG_Distance");
        this.initAlg();
        this.initialize();
    }

    protected abstract void initAlg();

    public Point2D transform(V v) {
        Point2D p = this.places.get(v);
        return p != null ? p : new Point2D.Double();
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public Dimension getSize() {
        return this.size;
    }

    public final void initialize() {
        this.alg.run();
        this.organizeNodes();
    }

    public boolean isLocked(V v) {
        return false;
    }

    public void lock(V v, boolean lock) {
    }

    public void reset() {
    }

    public void setGraph(Graph<V, E> g) {
        this.graph = g;
    }

    public void setInitializer(Transformer<V, Point2D> trf) {
    }

    public void setLocation(V v, Point2D p) {
        this.places.put((Point2D)v, p);
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    protected void organizeNodes() {
        double actXPos;
        double actHeight;
        Map<V, Integer> nodeLevels = this.alg.getLevels();
        int[] nodesPerLevel = this.alg.getNumberOfNodesPerLevel();
        int noLevels = this.alg.getNumberOfLevels();
        Set<V> isolateNodes = this.alg.getIsolateNodes();
        double cellHeight = (double)this.size.height / (double)noLevels;
        double[] cellWidths = new double[noLevels];
        HashSet[] freePlaces = new HashSet[noLevels];
        int baseLevel = isolateNodes.isEmpty() ? 0 : 1;
        PriorityQueue[] levels = new PriorityQueue[noLevels];
        for (int i = 0; i < noLevels; ++i) {
            levels[i] = new PriorityQueue<V>(nodesPerLevel[i], this.nodeComparator);
        }
        for (Map.Entry<V, Integer> entry : nodeLevels.entrySet()) {
            levels[entry.getValue()].add(entry.getKey());
        }
        for (int i = 0; i < noLevels; ++i) {
            cellWidths[i] = (double)this.size.width / (double)nodesPerLevel[i];
            freePlaces[i] = new HashSet();
            for (int actCell = 0; actCell < nodesPerLevel[i]; ++actCell) {
                freePlaces[i].add(actCell);
            }
        }
        int noPlacedElems = 0;
        for (Object v : isolateNodes) {
            actHeight = cellHeight * INNER_NODE_POSITION_RATIO_Y;
            actXPos = cellWidths[0] * ((double)noPlacedElems++ + INNER_NODE_POSITION_RATIO_X);
            Point2D.Double p = new Point2D.Double(actXPos, actHeight);
            this.places.put((Point2D)v, p);
        }
        if (baseLevel >= noLevels && noPlacedElems != 0) {
            return;
        }
        noPlacedElems = 0;
        for (Object v : levels[baseLevel]) {
            actHeight = cellHeight * ((double)baseLevel + INNER_NODE_POSITION_RATIO_Y);
            actXPos = cellWidths[baseLevel] * ((double)noPlacedElems++ + INNER_NODE_POSITION_RATIO_X);
            this.places.put((Point2D)v, new Point2D.Double(actXPos, actHeight));
        }
        boolean badDistance = false;
        if (!this.distanceAlgorithm.equals(MAX_DISTANCE_ALGORITHM) && !this.distanceAlgorithm.equals(SUM_DISTANCE_ALGORITHM)) {
            this.errorHandler.reportBadSetting("Distance algorithm error", "Not existing distance algorithm is set, for details see the preference page\n (DistanceAlgorithm=" + this.distanceAlgorithm + ")", "Open preference page", "org.eclipse.titanium.preferences.pages.GraphPreferencePage");
            badDistance = true;
        }
        for (int actLevel = baseLevel + 1; actLevel < noLevels; ++actLevel) {
            actHeight = cellHeight * ((double)actLevel + INNER_NODE_POSITION_RATIO_Y);
            noPlacedElems = 0;
            for (Object v : levels[actLevel]) {
                if (!badDistance) {
                    this.places.put((Point2D)v, new Point2D.Double(this.getBestXPosition(v, freePlaces[actLevel], cellWidths[actLevel]), actHeight));
                    continue;
                }
                this.places.put((Point2D)v, new Point2D.Double(cellWidths[actLevel] * ((double)noPlacedElems++ + INNER_NODE_POSITION_RATIO_X), actHeight));
            }
        }
    }

    protected double getBestXPosition(V v, Set<Integer> freePlaces, double cellWidth) {
        double position = 0.0;
        double actDistance = 0.0;
        double minDistance = Double.POSITIVE_INFINITY;
        Integer givenCell = Integer.MAX_VALUE;
        Collection<V> neighbours = this.getNeighbours(v);
        for (int actCell : freePlaces) {
            double actPos = cellWidth * ((double)actCell + INNER_NODE_POSITION_RATIO_X);
            if (this.distanceAlgorithm.equals(SUM_DISTANCE_ALGORITHM)) {
                actDistance = this.getSumDistance(actPos, neighbours);
            } else if (this.distanceAlgorithm.equals(MAX_DISTANCE_ALGORITHM)) {
                actDistance = this.getMaxDistance(actPos, neighbours);
            }
            if (!(minDistance > actDistance)) continue;
            minDistance = actDistance;
            givenCell = actCell;
            position = actPos;
        }
        freePlaces.remove(givenCell);
        return position;
    }

    protected abstract Collection<V> getNeighbours(V var1);

    protected double getSumDistance(double pos, Collection<V> neighbours) {
        double distance = 0.0;
        for (V node : neighbours) {
            Point2D pn = this.places.get(node);
            if (pn == null) continue;
            distance += Math.abs(pn.getX() - pos);
        }
        return distance;
    }

    protected double getMaxDistance(double pos, Collection<V> neighbours) {
        double distance = Double.NEGATIVE_INFINITY;
        for (V v : neighbours) {
            double actDist;
            Point2D pv = this.places.get(v);
            if (pv == null || !((actDist = Math.abs(pv.getX() - pos)) > distance)) continue;
            distance = actDist;
        }
        return distance;
    }
}

